/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable;

import com.ssomar.score.SsomarDev;
import com.ssomar.score.commands.runnable.ActionInfo;
import com.ssomar.score.commands.runnable.CommandSetting;
import com.ssomar.score.commands.runnable.SCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

public class SCommandToExec {
    private SCommand sCommand;
    private Map<CommandSetting, Object> settingsValues;
    private List<String> otherArgs;
    private ActionInfo actionInfo;

    public SCommandToExec(SCommand sCommand) {
        this.sCommand = sCommand;
    }

    public SCommandToExec() {
        this.settingsValues = new HashMap<CommandSetting, Object>();
        this.otherArgs = new ArrayList<String>();
    }

    public void extractSettings(String entry) {
        for (String name : this.sCommand.getNames()) {
            if (!entry.startsWith(name)) continue;
            entry = entry.substring(name.length());
            break;
        }
        entry = entry.trim();
        SsomarDev.testMsg("entry: " + entry, true);
        if (entry.equals("")) {
            this.settingsValues = new HashMap<CommandSetting, Object>();
            this.otherArgs = new ArrayList<String>();
            for (CommandSetting setting : this.sCommand.getSettings()) {
                this.settingsValues.put(setting, setting.getValue(null));
            }
        } else {
            ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(entry.split(" ")));
            HashMap<CommandSetting, Object> settingObjectMap = new HashMap<CommandSetting, Object>();
            block4: for (CommandSetting setting : this.sCommand.getSettings()) {
                if (arguments.isEmpty()) continue;
                for (String name : setting.getNames()) {
                    Optional<String> value = arguments.stream().filter(arg -> arg.startsWith(name + ":")).findFirst();
                    if (!value.isPresent()) continue;
                    settingObjectMap.put(setting, setting.getValue(value.get().replace(name + ":", "")));
                    arguments.remove(value.get());
                    continue block4;
                }
            }
            ArrayList<Integer> indexToRemove = new ArrayList<Integer>();
            for (CommandSetting setting : this.sCommand.getSettings()) {
                if (settingObjectMap.containsKey(setting)) continue;
                if (setting.getOldSystemIndex() == -1) {
                    settingObjectMap.put(setting, setting.getValue(null));
                    continue;
                }
                if (arguments.size() > setting.getOldSystemIndex()) {
                    String value = (String)arguments.get(setting.getOldSystemIndex());
                    if (setting.isOldSystemOptional()) {
                        if (setting.getType() == Boolean.class && !value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
                            settingObjectMap.put(setting, setting.getValue(null));
                            continue;
                        }
                        if (setting.getType() == Double.class || setting.getType() == Integer.class) {
                            try {
                                Double.parseDouble(value);
                                settingObjectMap.put(setting, setting.getValue(value));
                                indexToRemove.add(setting.getOldSystemIndex());
                            }
                            catch (NumberFormatException e) {
                                settingObjectMap.put(setting, setting.getValue(null));
                            }
                            continue;
                        }
                        settingObjectMap.put(setting, setting.getValue(value));
                        indexToRemove.add(setting.getOldSystemIndex());
                        continue;
                    }
                    settingObjectMap.put(setting, setting.getValue((String)arguments.get(setting.getOldSystemIndex())));
                    indexToRemove.add(setting.getOldSystemIndex());
                    continue;
                }
                settingObjectMap.put(setting, setting.getValue(null));
            }
            Collections.sort(indexToRemove, Collections.reverseOrder());
            Iterator<CommandSetting> iterator = indexToRemove.iterator();
            while (iterator.hasNext()) {
                int index = (Integer)((Object)iterator.next());
                arguments.remove(index);
            }
            this.settingsValues = settingObjectMap;
            this.otherArgs = arguments;
        }
    }

    public Object getSettingValue(String setting) {
        for (CommandSetting s : this.sCommand.getSettings()) {
            for (String name : s.getNames()) {
                if (!name.equals(setting)) continue;
                return this.settingsValues.get(s);
            }
        }
        return null;
    }

    @Generated
    public SCommand getSCommand() {
        return this.sCommand;
    }

    @Generated
    public Map<CommandSetting, Object> getSettingsValues() {
        return this.settingsValues;
    }

    @Generated
    public List<String> getOtherArgs() {
        return this.otherArgs;
    }

    @Generated
    public ActionInfo getActionInfo() {
        return this.actionInfo;
    }

    @Generated
    public void setSCommand(SCommand sCommand) {
        this.sCommand = sCommand;
    }

    @Generated
    public void setSettingsValues(Map<CommandSetting, Object> settingsValues) {
        this.settingsValues = settingsValues;
    }

    @Generated
    public void setOtherArgs(List<String> otherArgs) {
        this.otherArgs = otherArgs;
    }

    @Generated
    public void setActionInfo(ActionInfo actionInfo) {
        this.actionInfo = actionInfo;
    }
}

