/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.mixed_player_entity.commands.addtempattribute;

import com.ssomar.score.SCore;
import com.ssomar.score.commands.runnable.CommandSetting;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.mixed_player_entity.MixedCommand;
import com.ssomar.score.data.Database;
import com.ssomar.score.data.TemporaryAttributeQuery;
import com.ssomar.score.utils.backward_compatibility.AttributeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class AddTemporaryAttribute
extends MixedCommand {
    public AddTemporaryAttribute() {
        CommandSetting attribute = new CommandSetting("attribute", 0, String.class, (Object)"SCALE");
        CommandSetting amount = new CommandSetting("amount", 1, Double.class, (Object)1);
        CommandSetting operation = new CommandSetting("operation", 2, String.class, (Object)"ADD_NUMBER");
        CommandSetting timeinticks = new CommandSetting("timeinticks", 3, Long.class, (Object)20);
        List<CommandSetting> settings = this.getSettings();
        settings.add(attribute);
        settings.add(amount);
        settings.add(operation);
        settings.add(timeinticks);
        this.setNewSettingsMode(true);
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("ADD_TEMPORARY_ATTRIBUTE");
        return names;
    }

    @Override
    public String getTemplate() {
        return "ADD_TEMPORARY_ATTRIBUTE {attribute} {amount} {operation} {time in ticks}";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }

    @Override
    public void run(Player p, final Entity entity, SCommandToExec sCommandToExec) {
        AttributeModifier.Operation operation;
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        Attribute attrType = AttributeUtils.getAttribute((String)sCommandToExec.getSettingValue("attribute"));
        String attrTypeID = "";
        double amount = 0.0;
        long expiry_time = 0L;
        if (attrType == null) {
            SCore.plugin.getLogger().info("[ADD_TEMPORARY_ATTRIBUTE] Invalid Attribute argument was provided for field attribute: " + sCommandToExec.getSettingValue("attribute"));
            return;
        }
        attrTypeID = (String)sCommandToExec.getSettingValue("attribute");
        try {
            amount = Double.parseDouble(sCommandToExec.getSettingValue("amount").toString());
        }
        catch (Exception e) {
            SCore.plugin.getLogger().info("[ADD_TEMPORARY_ATTRIBUTE] Invalid Attribute argument was provided for field attribute amount: " + sCommandToExec.getSettingValue("amount").toString());
            return;
        }
        switch (sCommandToExec.getSettingValue("operation").toString().toUpperCase()) {
            case "ADD_NUMBER": {
                operation = AttributeModifier.Operation.ADD_NUMBER;
                break;
            }
            case "ADD_SCALAR": {
                operation = AttributeModifier.Operation.ADD_SCALAR;
                break;
            }
            case "MULTIPLY_SCALAR_1": {
                operation = AttributeModifier.Operation.MULTIPLY_SCALAR_1;
                break;
            }
            default: {
                SCore.plugin.getLogger().info("[ADD_TEMPORARY_ATTRIBUTE] Invalid Attribute argument was provided for field attribute operation: " + sCommandToExec.getSettingValue("operation").toString().toUpperCase());
                return;
            }
        }
        try {
            expiry_time = System.currentTimeMillis() + Long.parseLong(sCommandToExec.getSettingValue("timeinticks").toString()) * 50L;
        }
        catch (Exception e) {
            SCore.plugin.getLogger().info("[ADD_TEMPORARY_ATTRIBUTE] Invalid Attribute argument was provided for field tick duration: " + sCommandToExec.getSettingValue("timeinticks").toString());
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        AttributeInstance attrInstance = livingEntity.getAttribute(attrType);
        final NamespacedKey attr_key = new NamespacedKey((Plugin)SCore.plugin, String.valueOf(UUID.randomUUID()));
        AttributeModifier tempModifier = new AttributeModifier(attr_key, Double.parseDouble(sCommandToExec.getSettingValue("amount").toString()), operation);
        assert (attrInstance != null);
        attrInstance.addModifier(tempModifier);
        if (entity instanceof Player) {
            TemporaryAttributeQuery.insertToRecords(Database.getInstance().connect(), String.valueOf(attr_key), attrTypeID, amount, String.valueOf(entity.getUniqueId()), expiry_time);
        }
        final String finalAttrTypeID1 = attrTypeID;
        Runnable runlater = new Runnable(){

            @Override
            public void run() {
                if (!entity.isDead() || entity instanceof Player && ((Player)entity).isOnline()) {
                    AttributeUtils.removeSpecificAttribute((LivingEntity)entity, finalAttrTypeID1, attr_key.toString());
                    if (entity instanceof Player) {
                        TemporaryAttributeQuery.removeFromRecords(Database.getInstance().connect(), attr_key.toString());
                    }
                }
            }
        };
        if (!(entity instanceof Player)) {
            SCore.schedulerHook.runEntityTask(runlater, null, entity, Long.parseLong(sCommandToExec.getSettingValue("timeinticks").toString()));
        } else {
            SCore.schedulerHook.runTask(runlater, Long.parseLong(sCommandToExec.getSettingValue("timeinticks").toString()));
        }
    }
}

