/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.player.commands;

import com.ssomar.score.SCore;
import com.ssomar.score.commands.runnable.CommandSetting;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.player.PlayerCommand;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class AddItemEnchantment
extends PlayerCommand {
    public AddItemEnchantment() {
        CommandSetting slot = new CommandSetting("slot", 0, Integer.class, (Object)0);
        slot.setSlot(true);
        CommandSetting enchantment = new CommandSetting("enchantment", 1, Enchantment.class, (Object)(SCore.is1v20v5Plus() ? Enchantment.EFFICIENCY : Enchantment.getByName((String)"DIG_SPEED")));
        CommandSetting level = new CommandSetting("level", 2, Integer.class, (Object)1);
        List<CommandSetting> settings = this.getSettings();
        settings.add(slot);
        settings.add(enchantment);
        settings.add(level);
        this.setNewSettingsMode(true);
    }

    @Override
    public void run(Player p, Player receiver, SCommandToExec sCommandToExec) {
        int slot = (Integer)sCommandToExec.getSettingValue("slot");
        Enchantment enchant = (Enchantment)sCommandToExec.getSettingValue("enchantment");
        int level = (Integer)sCommandToExec.getSettingValue("level");
        ItemStack item = slot == -1 ? receiver.getInventory().getItemInMainHand() : receiver.getInventory().getItem(slot);
        if (level <= 0 || enchant == null || item == null || item.getType() == Material.AIR) {
            return;
        }
        if (!item.hasItemMeta()) {
            item.setItemMeta(new ItemStack(item.getType()).getItemMeta());
        }
        ItemMeta itemMeta = item.getItemMeta();
        itemMeta.addEnchant(enchant, level, true);
        item.setItemMeta(itemMeta);
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("ADD_ITEM_ENCHANTMENT");
        names.add("ADD_ENCHANTMENT");
        names.add("ADDENCHANTMENT");
        return names;
    }

    @Override
    public String getTemplate() {
        return "ADD_ITEM_ENCHANTMENT slot:-1 enchantment:EFFICIENCY level:1";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }
}

