/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.data;

import com.ssomar.score.SCore;
import com.ssomar.score.commands.runnable.ActionInfo;
import com.ssomar.score.commands.runnable.ActionInfoSerializer;
import com.ssomar.score.commands.runnable.entity.EntityRunCommand;
import com.ssomar.score.data.Database;
import com.ssomar.score.utils.logging.Utils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class EntityCommandsQuery {
    private static final String TABLE_COMMANDS_ENTITY = "commands_entity";
    private static final String TABLE_COMMANDS_ENTITY_NAME = "Commands Entity";
    private static final String COL_UUID_LAUNCHER = "uuid_launcher";
    private static final String COL_UUID_ENTITY = "uuid_entity";
    private static final String COL_BRUT_COMMAND = "brut_command";
    private static final String COL_RUN_TIME = "run_time";
    private static final String COL_ACTION_INFO = "action_info";
    public static final String CREATE_TABLE = "CREATE TABLE IF NOT EXISTS commands_entity (uuid_launcher TEXT NOT NULL, uuid_entity TEXT NOT NULL, brut_command TEXT NOT NULL,run_time LONG NOT NULL, action_info TEXT NOT NULL);";

    public static void createNewTable(Connection conn) {
        if (Database.DEBUG) {
            Utils.sendConsoleMsg("EntityCommandsQuery createNewTable");
        }
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            Utils.sendConsoleMsg("&eSCore &7Creating table &6Commands Entity &7if not exists...");
            stmt.execute(CREATE_TABLE);
        }
        catch (SQLException e) {
            SCore.plugin.getLogger().severe("Error while creating table Commands Entity in database " + e.getMessage());
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertCommand(Connection conn, List<EntityRunCommand> commands) {
        if (Database.DEBUG) {
            Utils.sendConsoleMsg("EntityCommandsQuery insertCommand");
        }
        String sql = "INSERT INTO commands_entity (uuid_launcher,uuid_entity,brut_command,run_time,action_info) VALUES(?,?,?,?,?)";
        PreparedStatement pstmt = null;
        boolean i = false;
        try {
            pstmt = conn.prepareStatement(sql);
            for (EntityRunCommand command : commands) {
                pstmt.setString(1, command.getLauncherUUID().toString());
                pstmt.setString(2, command.getEntityUUID().toString());
                pstmt.setString(3, command.getBrutCommand());
                pstmt.setLong(4, command.getRunTime());
                pstmt.setString(5, ActionInfoSerializer.toString(command.getaInfo()));
                pstmt.addBatch();
                pstmt.executeBatch();
            }
        }
        catch (IOException | SQLException e) {
            System.out.println("&e[SCore] " + e.getMessage());
            e.printStackTrace();
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteEntityCommands(Connection conn) {
        if (Database.DEBUG) {
            Utils.sendConsoleMsg("EntityCommandsQuery deleteEntityCommands");
        }
        String sql = "DELETE FROM commands_entity";
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            System.out.println("&e[SCore] " + e.getMessage());
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<EntityRunCommand> selectEntityCommands(Connection conn) {
        if (Database.DEBUG) {
            Utils.sendConsoleMsg("EntityCommandsQuery selectEntityCommands");
        }
        String sql = "SELECT brut_command,run_time,action_info FROM commands_entity ORDER BY run_time";
        ArrayList<EntityRunCommand> list = new ArrayList<EntityRunCommand>();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = conn.prepareStatement(sql);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                ActionInfo aInfo;
                String brutCommand = rs.getString(COL_BRUT_COMMAND);
                long runTime = rs.getLong(COL_RUN_TIME);
                try {
                    aInfo = (ActionInfo)ActionInfoSerializer.fromString(rs.getString(COL_ACTION_INFO));
                }
                catch (Exception e) {
                    SCore.plugin.getLogger().severe("(NOT VERY SERIOUS) The delayed command " + brutCommand + " has been deleted because it was saved in an outdated version.");
                    continue;
                }
                EntityRunCommand pCommand = new EntityRunCommand(brutCommand, runTime, aInfo);
                list.add(pCommand);
            }
        }
        catch (SQLException e) {
            System.out.println("&e[SCore] " + e.getMessage());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return list;
    }
}

