/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.attributes.attribute;

import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.AttributeFeature;
import com.ssomar.score.features.types.ColoredStringFeature;
import com.ssomar.score.features.types.DoubleFeature;
import com.ssomar.score.features.types.OperationFeature;
import com.ssomar.score.features.types.SlotFeature;
import com.ssomar.score.features.types.UUIDFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.backward_compatibility.AttributeUtils;
import com.ssomar.score.utils.emums.AttributeSlot;
import com.ssomar.score.utils.placeholders.StringPlaceholder;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttributeFullOptionsFeature
extends FeatureWithHisOwnEditor<AttributeFullOptionsFeature, AttributeFullOptionsFeature, GenericFeatureParentEditor, GenericFeatureParentEditorManager> {
    private AttributeFeature attribute;
    private OperationFeature operation;
    private DoubleFeature amount;
    private SlotFeature slot;
    private ColoredStringFeature attributeName;
    private UUIDFeature uuid;
    private String id;

    public AttributeFullOptionsFeature(FeatureParentInterface parent, String id) {
        super(parent, FeatureSettingsSCore.attribute);
        this.id = id;
        this.reset();
    }

    @Override
    public void reset() {
        this.attribute = new AttributeFeature(this, Optional.of(AttributeUtils.getAttribute("GENERIC_ARMOR")), FeatureSettingsSCore.attribute);
        this.operation = new OperationFeature(this, Optional.of(AttributeModifier.Operation.ADD_NUMBER), FeatureSettingsSCore.operation);
        this.amount = new DoubleFeature(this, Optional.of(1.0), FeatureSettingsSCore.amount);
        this.slot = new SlotFeature(this, Optional.of(AttributeSlot.HAND), FeatureSettingsSCore.slot);
        this.attributeName = new ColoredStringFeature(this, Optional.of("&eDefault name"), FeatureSettingsSCore.name);
        this.uuid = new UUIDFeature(this, FeatureSettingsSCore.uuid);
    }

    public AttributeModifier getAttributeModifier() {
        String attributeName = ((Optional)this.attributeName.getValue()).orElse("Default name");
        double amount = this.amount.getValue(null, new StringPlaceholder()).orElse(1.0);
        AttributeModifier.Operation operation = ((Optional)this.operation.getValue()).orElse(AttributeModifier.Operation.ADD_NUMBER);
        EquipmentSlot equipmentSlot = null;
        if (!((Optional)this.slot.getValue()).orElse(AttributeSlot.HAND).equals((Object)AttributeSlot.ALL_SLOTS)) {
            equipmentSlot = this.slot.getEquipmentSlotValue().orElse(null);
        }
        return new AttributeModifier(this.uuid.getValue(), attributeName, amount, operation, equipmentSlot);
    }

    public AttributeModifier getAttributeModifier(UUID playerUUID, @Nullable StringPlaceholder sp) {
        String attributeName = ((Optional)this.attributeName.getValue()).orElse("Default name");
        if (sp == null) {
            sp = new StringPlaceholder();
        }
        double amount = this.amount.getValue(playerUUID, sp).orElse(1.0);
        AttributeModifier.Operation operation = ((Optional)this.operation.getValue()).orElse(AttributeModifier.Operation.ADD_NUMBER);
        EquipmentSlot equipmentSlot = null;
        if (!((Optional)this.slot.getValue()).orElse(AttributeSlot.HAND).equals((Object)AttributeSlot.ALL_SLOTS)) {
            equipmentSlot = this.slot.getEquipmentSlotValue().orElse(null);
        }
        return new AttributeModifier(this.uuid.getValue(), attributeName, amount, operation, equipmentSlot);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        if (config.isConfigurationSection(this.id)) {
            ConfigurationSection enchantmentConfig = config.getConfigurationSection(this.id);
            errors.addAll(this.attribute.load(plugin, enchantmentConfig, isPremiumLoading));
            errors.addAll(this.operation.load(plugin, enchantmentConfig, isPremiumLoading));
            errors.addAll(this.amount.load(plugin, enchantmentConfig, isPremiumLoading));
            errors.addAll(this.slot.load(plugin, enchantmentConfig, isPremiumLoading));
            errors.addAll(this.attributeName.load(plugin, enchantmentConfig, isPremiumLoading));
            errors.addAll(this.uuid.load(plugin, enchantmentConfig, isPremiumLoading));
        } else {
            errors.add("&cERROR, Couldn't load the Attribute with its options because there is not section with the good ID: " + this.id + " &7&o" + this.getParent().getParentInfo());
        }
        return errors;
    }

    @Override
    public boolean isTheFeatureClickedParentEditor(String featureClicked) {
        return featureClicked.contains(this.getEditorName()) && featureClicked.contains("(" + this.id + ")");
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.id, null);
        ConfigurationSection attributeConfig = config.createSection(this.id);
        this.attribute.save(attributeConfig);
        this.operation.save(attributeConfig);
        this.amount.save(attributeConfig);
        this.slot.save(attributeConfig);
        this.attributeName.save(attributeConfig);
        this.uuid.save(attributeConfig);
    }

    @Override
    public AttributeFullOptionsFeature getValue() {
        return this;
    }

    @Override
    public AttributeFullOptionsFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 6];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 6] = "&7Attribute: &e" + AttributeUtils.getAttributes().get(((Optional)this.attribute.getValue()).get());
        finalDescription[finalDescription.length - 5] = "&7Operation: &e" + ((Optional)this.operation.getValue()).get();
        finalDescription[finalDescription.length - 4] = "&7Amount: &e" + ((Optional)this.amount.getValue()).get();
        finalDescription[finalDescription.length - 3] = "&7Slot: &e" + ((AttributeSlot)((Object)((Optional)this.slot.getValue()).get())).name();
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = GUI.SHIFT_CLICK_TO_REMOVE;
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName() + " - (" + this.id + ")", false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public AttributeFullOptionsFeature clone(FeatureParentInterface newParent) {
        AttributeFullOptionsFeature eF = new AttributeFullOptionsFeature(newParent, this.id);
        eF.setAttribute(this.attribute.clone(eF));
        eF.setOperation(this.operation.clone(eF));
        eF.setAmount(this.amount.clone(eF));
        eF.setSlot(this.slot.clone(eF));
        eF.setAttributeName(this.attributeName.clone(eF));
        eF.setUuid(this.uuid.clone(eF));
        return eF;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        return new ArrayList<FeatureInterface>(Arrays.asList(this.attribute, this.operation, this.amount, this.slot, this.attributeName, this.uuid));
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        ConfigurationSection parentSection = this.getParent().getConfigurationSection();
        if (parentSection.isConfigurationSection(this.getId())) {
            return parentSection.getConfigurationSection(this.getId());
        }
        return parentSection.createSection(this.getId());
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            AttributeFullOptionsFeature aFOF;
            if (!(feature instanceof AttributeFullOptionsFeature) || !(aFOF = (AttributeFullOptionsFeature)feature).getId().equals(this.id)) continue;
            aFOF.setAttribute(this.attribute);
            aFOF.setOperation(this.operation);
            aFOF.setAmount(this.amount);
            aFOF.setSlot(this.slot);
            aFOF.setAttributeName(this.attributeName);
            aFOF.setUuid(this.uuid);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    @Generated
    public AttributeFeature getAttribute() {
        return this.attribute;
    }

    @Generated
    public OperationFeature getOperation() {
        return this.operation;
    }

    @Generated
    public DoubleFeature getAmount() {
        return this.amount;
    }

    @Generated
    public SlotFeature getSlot() {
        return this.slot;
    }

    @Generated
    public ColoredStringFeature getAttributeName() {
        return this.attributeName;
    }

    @Generated
    public UUIDFeature getUuid() {
        return this.uuid;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public void setAttribute(AttributeFeature attribute) {
        this.attribute = attribute;
    }

    @Generated
    public void setOperation(OperationFeature operation) {
        this.operation = operation;
    }

    @Generated
    public void setAmount(DoubleFeature amount) {
        this.amount = amount;
    }

    @Generated
    public void setSlot(SlotFeature slot) {
        this.slot = slot;
    }

    @Generated
    public void setAttributeName(ColoredStringFeature attributeName) {
        this.attributeName = attributeName;
    }

    @Generated
    public void setUuid(UUIDFeature uuid) {
        this.uuid = uuid;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }
}

