/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.conditions.custom.condition.confirmation;

import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.custom.conditions.custom.CustomConditionFeature;
import com.ssomar.score.features.custom.conditions.custom.CustomConditionRequest;
import com.ssomar.score.features.custom.conditions.custom.condition.confirmation.ConfirmationManager;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.utils.placeholders.StringPlaceholder;
import java.util.HashMap;
import org.bukkit.entity.Player;

public class IfNeedPlayerConfirmation
extends CustomConditionFeature<BooleanFeature, IfNeedPlayerConfirmation> {
    public IfNeedPlayerConfirmation(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.ifNeedPlayerConfirmation, true);
    }

    @Override
    public boolean verifCondition(CustomConditionRequest request) {
        Player p = request.getLauncher();
        StringPlaceholder sp = request.getSp();
        String id = sp.getId() + "-" + sp.getActivator_id();
        if (((BooleanFeature)this.getCondition()).getValue(request.getSp()).booleanValue()) {
            boolean needConfirmation = true;
            HashMap<Player, String> needConfirmationMap = ConfirmationManager.getInstance().getNeedConfirm();
            if (needConfirmationMap.containsKey(p) && id.equals(needConfirmationMap.get(p))) {
                needConfirmation = false;
                ConfirmationManager.getInstance().getNeedConfirm().remove(p);
            }
            if (needConfirmation) {
                ConfirmationManager.getInstance().getNeedConfirm().put(p, id);
                this.runInvalidCondition(request);
                return false;
            }
        }
        return true;
    }

    @Override
    public IfNeedPlayerConfirmation getValue() {
        return this;
    }

    @Override
    public void subReset() {
        this.setCondition(new BooleanFeature(this.getParent(), false, FeatureSettingsSCore.ifNeedPlayerConfirmation));
    }

    @Override
    public boolean hasCondition() {
        return ((BooleanFeature)this.getCondition()).isConfigured();
    }

    @Override
    public IfNeedPlayerConfirmation getNewInstance(FeatureParentInterface parent) {
        return new IfNeedPlayerConfirmation(parent);
    }
}

