/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.conditions.entity.condition;

import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.custom.conditions.entity.EntityConditionFeature;
import com.ssomar.score.features.custom.conditions.entity.EntityConditionRequest;
import com.ssomar.score.features.types.list.ListUncoloredStringFeature;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.Optional;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Sheep;

public class IfSheepColor
extends EntityConditionFeature<ListUncoloredStringFeature, IfSheepColor> {
    public IfSheepColor(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.ifSheepColor);
    }

    @Override
    public boolean verifCondition(EntityConditionRequest request) {
        if (this.hasCondition()) {
            Entity entity = request.getEntity();
            if (!(entity instanceof Sheep)) {
                this.runInvalidCondition(request);
                return false;
            }
            boolean notValid = true;
            for (String name : ((ListUncoloredStringFeature)this.getCondition()).getValue(request.getSp())) {
                if (!StringConverter.decoloredString(String.valueOf(((Sheep)entity).getColor())).equalsIgnoreCase(name)) continue;
                notValid = false;
                break;
            }
            if (notValid) {
                this.runInvalidCondition(request);
                return false;
            }
            return true;
        }
        return true;
    }

    @Override
    public void subReset() {
        this.setCondition(new ListUncoloredStringFeature(this.getParent(), new ArrayList<String>(), FeatureSettingsSCore.ifSheepColor, Optional.empty()));
    }

    @Override
    public boolean hasCondition() {
        return !((ListUncoloredStringFeature)this.getCondition()).getValue().isEmpty();
    }

    @Override
    public IfSheepColor getNewInstance(FeatureParentInterface newParent) {
        return new IfSheepColor(newParent);
    }

    @Override
    public IfSheepColor getValue() {
        return this;
    }
}

