/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types;

import com.ssomar.score.SCore;
import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureRequireOneMessageInEditor;
import com.ssomar.score.features.FeatureReturnCheckPremium;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.languages.messages.TM;
import com.ssomar.score.languages.messages.Text;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.strings.StringConverter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class ColoredStringFeature
extends FeatureAbstract<Optional<String>, ColoredStringFeature>
implements FeatureRequireOneMessageInEditor,
Serializable {
    private String value;
    private Optional<String> defaultValue;

    public ColoredStringFeature(FeatureParentInterface parent, Optional<String> defaultValue, FeatureSettingsInterface featureSettings) {
        super(parent, featureSettings);
        this.defaultValue = defaultValue;
        this.value = defaultValue.orElse(null);
        this.reset();
    }

    public static ColoredStringFeature buildNull() {
        return new ColoredStringFeature(null, Optional.empty(), null);
    }

    public static ColoredStringFeature buildNull(String value) {
        ColoredStringFeature c = new ColoredStringFeature(null, Optional.empty(), null);
        c.setValue(value);
        return c;
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        String valueStr = config.getString(this.getName(), "<<NULL>>");
        if (SCore.isMohist()) {
            valueStr = valueStr.replaceAll("\u00c3\u201a\u00c2", "");
        }
        if (valueStr.equals("<<NULL>>")) {
            if (this.defaultValue.isPresent()) {
                this.value = valueStr = this.defaultValue.get();
            } else {
                valueStr = "";
                this.value = null;
            }
        } else {
            this.value = valueStr;
        }
        FeatureReturnCheckPremium<String> checkPremium = this.checkPremium("Colored String", valueStr, this.defaultValue, isPremiumLoading);
        if (checkPremium.isHasError()) {
            this.value = checkPremium.getNewValue();
        }
        return errors;
    }

    @Override
    public void save(ConfigurationSection config) {
        Object value = this.getValue();
        if (((Optional)value).isPresent()) {
            if (this.isSavingOnlyIfDiffDefault() && this.defaultValue.isPresent() && ((String)((Optional)value).get()).equals(this.defaultValue.get())) {
                config.set(this.getName(), null);
                return;
            }
        } else {
            config.set(this.getName(), null);
            return;
        }
        config.set(this.getName(), ((Optional)value).get());
        if (GeneralConfig.getInstance().isEnableCommentsInConfig()) {
            config.setComments(this.getName(), StringConverter.decoloredString(Arrays.asList(this.getFeatureSettings().getEditorDescriptionBrut())));
        }
    }

    @Override
    public Optional<String> getValue() {
        if (this.value != null) {
            return Optional.of(this.value);
        }
        return this.defaultValue;
    }

    public Optional<String> getColoredValue() {
        if (((Optional)this.getValue()).isPresent()) {
            return Optional.of(StringConverter.coloredString((String)((Optional)this.getValue()).get()));
        }
        return Optional.empty();
    }

    @Override
    public ColoredStringFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = TM.g(Text.EDITOR_CURRENTLY_NAME);
        for (int i = 0; i < finalDescription.length; ++i) {
            String command = finalDescription[i];
            if (command.length() > 40) {
                command = command.substring(0, 39) + "...";
            }
            finalDescription[i] = command;
        }
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
        if (((Optional)this.getValue()).isPresent() && !StringConverter.decoloredString((String)((Optional)this.getValue()).get()).isEmpty()) {
            String str = (String)((Optional)this.getValue()).get();
            if (str.length() > 40) {
                str = str.substring(0, 39) + "...";
            }
            gui.updateCurrently(this.getEditorName(), str, true);
        } else {
            gui.updateCurrently(this.getEditorName(), "&cEMPTY STRING", true);
        }
    }

    @Override
    public ColoredStringFeature clone(FeatureParentInterface newParent) {
        ColoredStringFeature clone = new ColoredStringFeature(newParent, this.getDefaultValue(), this.getFeatureSettings());
        clone.setValue((String)((Optional)this.getValue()).orElse(null));
        return clone;
    }

    @Override
    public void reset() {
        this.value = this.defaultValue.orElse(null);
    }

    @Override
    public void askInEditor(Player editor, NewGUIManager manager) {
        manager.requestWriting.put(editor, this.getEditorName());
        editor.closeInventory();
        ColoredStringFeature.space(editor);
        TextComponent message = new TextComponent(StringConverter.coloredString("&a&l[Editor] &aEnter a string or &aedit &athe &aactual: "));
        TextComponent edit = new TextComponent(StringConverter.coloredString("&e&l[EDIT]"));
        String value = "";
        if (((Optional)this.getValue()).isPresent()) {
            value = (String)((Optional)this.getValue()).get();
        }
        edit.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, StringConverter.deconvertColor(value)));
        edit.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(StringConverter.coloredString("&eClick here to edit the current string")).create()));
        TextComponent newName = new TextComponent(StringConverter.coloredString("&a&l[NEW]"));
        newName.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "Type the new string here.."));
        newName.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(StringConverter.coloredString("&aClick here to set new string")).create()));
        TextComponent noValue = new TextComponent(StringConverter.coloredString("&c&l[NO VALUE / EXIT]"));
        noValue.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/score interact NO VALUE / EXIT"));
        noValue.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(StringConverter.coloredString("&cClick here to exit or don't set a value")).create()));
        message.addExtra((BaseComponent)new TextComponent(" "));
        message.addExtra((BaseComponent)edit);
        message.addExtra((BaseComponent)new TextComponent(" "));
        message.addExtra((BaseComponent)newName);
        message.addExtra((BaseComponent)new TextComponent(" "));
        message.addExtra((BaseComponent)noValue);
        editor.spigot().sendMessage((BaseComponent)message);
        ColoredStringFeature.space(editor);
    }

    @Override
    public Optional<String> verifyMessageReceived(String message) {
        return Optional.empty();
    }

    @Override
    public void finishEditInEditor(Player editor, NewGUIManager manager, String message) {
        this.value = message.contains("EMPTY STRING") ? "" : (message.isEmpty() ? null : message);
        manager.requestWriting.remove(editor);
        this.updateItemParentEditor((GUI)manager.getCache().get(editor));
    }

    @Override
    public void finishEditInEditorNoValue(Player editor, NewGUIManager manager) {
        this.value = "";
        manager.requestWriting.remove(editor);
        this.updateItemParentEditor((GUI)manager.getCache().get(editor));
    }

    @Generated
    public Optional<String> getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public void setValue(String value) {
        this.value = value;
    }

    @Generated
    public void setDefaultValue(Optional<String> defaultValue) {
        this.defaultValue = defaultValue;
    }
}

