/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types;

import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureRequireOnlyClicksInEditor;
import com.ssomar.score.features.FeatureReturnCheckPremium;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.languages.messages.TM;
import com.ssomar.score.languages.messages.Text;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.item.UpdateItemInGUI;
import com.ssomar.score.utils.strings.StringConverter;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import io.papermc.paper.registry.TypedKey;
import io.papermc.paper.registry.tag.TagKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import net.kyori.adventure.key.Key;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.damage.DamageType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class DamageTypeFeature
extends FeatureAbstract<Optional<DamageType>, DamageTypeFeature>
implements FeatureRequireOnlyClicksInEditor {
    private Optional<DamageType> value;
    private Optional<DamageType> defaultValue;

    public DamageTypeFeature(FeatureParentInterface parent, Optional<DamageType> defaultValue, FeatureSettingsInterface featureSettings) {
        super(parent, featureSettings);
        this.defaultValue = defaultValue;
        this.value = Optional.empty();
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors;
        block5: {
            errors = new ArrayList<String>();
            String colorStr = config.getString(this.getName(), "NULL").toUpperCase();
            if (colorStr.equals("NULL")) {
                if (this.defaultValue.isPresent()) {
                    this.value = this.defaultValue;
                }
                return errors;
            }
            try {
                TypedKey key = TypedKey.create((RegistryKey)RegistryKey.DAMAGE_TYPE, (String)colorStr);
                DamageType damageType = (DamageType)RegistryAccess.registryAccess().getRegistry(RegistryKey.DAMAGE_TYPE).get(key);
                this.value = Optional.ofNullable(damageType);
                FeatureReturnCheckPremium<DamageType> checkPremium = this.checkPremium("DamageType", damageType, this.defaultValue, isPremiumLoading);
                if (checkPremium.isHasError()) {
                    this.value = Optional.of(checkPremium.getNewValue());
                }
            }
            catch (Exception e) {
                errors.add("&cERROR, Couldn't load the DamageType value of " + this.getName() + " from config, value: " + colorStr + " &7&o" + this.getParent().getParentInfo() + " &6>> DamageType available: https://jd.papermc.io/paper/1.21.5/org/bukkit/damage/DamageType.html");
                if (!this.defaultValue.isPresent()) break block5;
                this.value = this.defaultValue;
            }
        }
        return errors;
    }

    public void setValue(TagKey<DamageType> value) {
        if (value == null) {
            this.value = Optional.empty();
            return;
        }
        this.value = Optional.ofNullable((DamageType)RegistryAccess.registryAccess().getRegistry(RegistryKey.DAMAGE_TYPE).get(value.key()));
    }

    public TagKey<DamageType> getValueTagKey() {
        if (this.value.isPresent()) {
            return TagKey.create((RegistryKey)RegistryKey.DAMAGE_TYPE, (Key)((DamageType)((Optional)this.getValue()).get()).getKey());
        }
        return null;
    }

    @Override
    public void save(ConfigurationSection config) {
        if (((Optional)this.getValue()).isPresent()) {
            if (this.defaultValue.isPresent() && this.isSavingOnlyIfDiffDefault() && ((DamageType)((Optional)this.getValue()).get()).equals((Object)this.defaultValue.get())) {
                config.set(this.getName(), null);
                return;
            }
            config.set(this.getName(), (Object)((DamageType)((Optional)this.getValue()).get()).getKey().toString());
        }
        if (GeneralConfig.getInstance().isEnableCommentsInConfig()) {
            config.setComments(this.getName(), StringConverter.decoloredString(Arrays.asList(this.getFeatureSettings().getEditorDescriptionBrut())));
        }
    }

    @Override
    public Optional<DamageType> getValue() {
        if (this.value.isPresent()) {
            return this.value;
        }
        return this.defaultValue;
    }

    @Override
    public DamageTypeFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = TM.g(Text.EDITOR_CURRENTLY_NAME);
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
        Object value = this.getValue();
        DamageType finalValue = ((Optional)value).orElse(DamageType.PLAYER_ATTACK);
        this.updateOperation(finalValue, gui);
    }

    @Override
    public DamageTypeFeature clone(FeatureParentInterface newParent) {
        DamageTypeFeature clone = new DamageTypeFeature(newParent, this.getDefaultValue(), this.getFeatureSettings());
        clone.value = this.value;
        return clone;
    }

    @Override
    public void reset() {
        this.value = this.defaultValue;
    }

    @Override
    public void clickParentEditor(Player editor, NewGUIManager manager) {
    }

    @Override
    public boolean noShiftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftLeftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftRightclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftLeftClicked(Player editor, NewGUIManager manager) {
        DamageType operation = this.getOperation((GUI)manager.getCache().get(editor));
        operation = this.nextOperation(operation);
        operation = this.nextOperation(operation);
        operation = this.nextOperation(operation);
        operation = this.nextOperation(operation);
        operation = this.nextOperation(operation);
        operation = this.nextOperation(operation);
        operation = this.nextOperation(operation);
        operation = this.nextOperation(operation);
        operation = this.nextOperation(operation);
        operation = this.nextOperation(operation);
        operation = this.nextOperation(operation);
        operation = this.nextOperation(operation);
        operation = this.nextOperation(operation);
        operation = this.nextOperation(operation);
        operation = this.nextOperation(operation);
        this.updateOperation(operation, (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean shiftRightClicked(Player editor, NewGUIManager manager) {
        DamageType operation = this.getOperation((GUI)manager.getCache().get(editor));
        operation = this.prevOperation(operation);
        operation = this.prevOperation(operation);
        operation = this.prevOperation(operation);
        operation = this.prevOperation(operation);
        operation = this.prevOperation(operation);
        operation = this.prevOperation(operation);
        operation = this.prevOperation(operation);
        operation = this.prevOperation(operation);
        operation = this.prevOperation(operation);
        operation = this.prevOperation(operation);
        operation = this.prevOperation(operation);
        operation = this.prevOperation(operation);
        operation = this.prevOperation(operation);
        operation = this.prevOperation(operation);
        operation = this.prevOperation(operation);
        this.updateOperation(operation, (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean leftClicked(Player editor, NewGUIManager manager) {
        this.updateOperation(this.nextOperation(this.getOperation((GUI)manager.getCache().get(editor))), (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean rightClicked(Player editor, NewGUIManager manager) {
        this.updateOperation(this.prevOperation(this.getOperation((GUI)manager.getCache().get(editor))), (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean doubleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean middleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    public DamageType nextOperation(DamageType sound) {
        boolean next = false;
        for (DamageType check : RegistryAccess.registryAccess().getRegistry(RegistryKey.DAMAGE_TYPE)) {
            if (check.equals((Object)sound)) {
                next = true;
                continue;
            }
            if (!next) continue;
            return check;
        }
        return (DamageType)RegistryAccess.registryAccess().getRegistry(RegistryKey.DAMAGE_TYPE).iterator().next();
    }

    public DamageType prevOperation(DamageType sound) {
        int i = -1;
        int cpt = 0;
        for (DamageType check : RegistryAccess.registryAccess().getRegistry(RegistryKey.DAMAGE_TYPE)) {
            if (check.equals((Object)sound)) {
                i = cpt;
                break;
            }
            ++cpt;
        }
        DamageType[] values = (DamageType[])RegistryAccess.registryAccess().getRegistry(RegistryKey.DAMAGE_TYPE).stream().toArray(DamageType[]::new);
        if (i == 0) {
            return values[values.length - 1];
        }
        return values[cpt - 1];
    }

    public void updateOperation(DamageType operation, GUI gui) {
        this.value = Optional.of(operation);
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        ItemMeta meta = item.getItemMeta();
        HashMap<DamageType, String> map = new HashMap<DamageType, String>();
        for (DamageType check : RegistryAccess.registryAccess().getRegistry(RegistryKey.DAMAGE_TYPE)) {
            map.put(check, check.getKey().toString());
        }
        List<String> lore = meta.getLore().subList(0, this.getEditorDescription().length + 2);
        int maxSize = lore.size();
        if ((maxSize += map.size()) > 17) {
            maxSize = 17;
        }
        boolean find = false;
        for (Object check : map.keySet()) {
            if (operation == check) {
                lore.add(StringConverter.coloredString("&2\u27a4 &a" + (String)map.get(operation)));
                find = true;
                continue;
            }
            if (!find) continue;
            if (lore.size() == maxSize) break;
            lore.add(StringConverter.coloredString("&6\u2726 &e" + (String)map.get(check)));
        }
        for (Object check : map.keySet()) {
            if (lore.size() == maxSize) break;
            lore.add(StringConverter.coloredString("&6\u2726 &e" + (String)map.get(check)));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        UpdateItemInGUI.updateItemInGUI(gui, this.getEditorName(), meta.getDisplayName(), lore, item.getType());
    }

    public DamageType getOperation(GUI gui) {
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        ItemMeta meta = item.getItemMeta();
        List lore = meta.getLore();
        for (String str : lore) {
            if (!str.contains("\u27a4 ")) continue;
            str = StringConverter.decoloredString(str).replaceAll(" Premium", "");
            String value = str.split("\u27a4 ")[1];
            return (DamageType)RegistryAccess.registryAccess().getRegistry(RegistryKey.DAMAGE_TYPE).get(TypedKey.create((RegistryKey)RegistryKey.DAMAGE_TYPE, (String)value));
        }
        return null;
    }

    @Generated
    public Optional<DamageType> getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public void setDefaultValue(Optional<DamageType> defaultValue) {
        this.defaultValue = defaultValue;
    }
}

