/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.menu.particles;

import com.ssomar.score.menu.GUI;
import com.ssomar.score.menu.GUIAbstract;
import com.ssomar.score.sparticles.SParticle;
import com.ssomar.score.sparticles.SParticles;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.emums.CustomColor;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class SParticlesGUI
extends GUIAbstract {
    static int index;
    private final SParticles sParticles;
    private final GUI guiFrom;

    public SParticlesGUI(Player p, SPlugin sPlugin, SParticles sParticles, GUI guiFrom) {
        super("&8&l" + sPlugin.getShortName() + " Editor - Particles - Page 1", 45, sPlugin);
        this.sParticles = sParticles;
        this.guiFrom = guiFrom;
        SParticlesGUI.setIndex(1);
        this.load();
    }

    public SParticlesGUI(int index, Player p, SPlugin sPlugin, SParticles sParticles, GUI guiFrom) {
        super("&8&l" + sPlugin.getShortName() + " Editor - Particles - Page " + index, 45, sPlugin);
        this.sParticles = sParticles;
        this.guiFrom = guiFrom;
        SParticlesGUI.setIndex(index);
        this.load();
    }

    public static int getIndex() {
        return index;
    }

    public static void setIndex(int index) {
        SParticlesGUI.index = index;
    }

    @Override
    public void reloadGUI() {
        this.load();
    }

    @Override
    public void load() {
        List<SParticle> particles = this.sParticles.getParticles();
        int i = 0;
        int total = 0;
        for (SParticle sParticle : particles) {
            if ((index - 1) * 27 <= total && total < index * 27) {
                ItemStack itemS = new ItemStack(Material.BOOK);
                ArrayList<String> desc = new ArrayList<String>();
                desc.add("");
                desc.add("&4(shift + left click to delete)");
                desc.add("&7(click to edit)");
                desc.add("&7\u2022 ID: &e" + sParticle.getId());
                desc.add("&7\u2022 Particle Type: &e" + sParticle.getParticlesType().name());
                desc.add("&7\u2022 Particle Amount: &e" + sParticle.getParticlesAmount());
                desc.add("&7\u2022 Particle OffSet: &e" + sParticle.getParticlesOffSet());
                desc.add("&7\u2022 Particle Speed: &e" + sParticle.getParticlesSpeed());
                desc.add("&7\u2022 Particle Delay: &e" + sParticle.getParticlesDelay());
                if (sParticle.canHaveRedstoneColor()) {
                    desc.add("&7\u2022 Redstone color: &e" + CustomColor.getName(sParticle.getRedstoneColor()));
                }
                if (sParticle.canHaveBlocktype()) {
                    desc.add("&7\u2022 Block type: &e" + sParticle.getBlockType().toString());
                }
                String[] descArray = new String[desc.size()];
                for (int j = 0; j < desc.size(); ++j) {
                    descArray[j] = ((String)desc.get(j)).length() > 40 ? ((String)desc.get(j)).substring(0, 39) + "..." : (String)desc.get(j);
                }
                this.createItem(itemS, 1, i, "&2&l\u2726 ID: &a" + sParticle.getId(), true, false, descArray);
                ++i;
            }
            ++total;
        }
        if (total > 27 && index * 27 < total) {
            this.createItem(PURPLE, 1, 44, "&5&l\u25b6 &dNext page ", false, false, new String[0]);
        }
        if (index > 1) {
            this.createItem(PURPLE, 1, 37, "&dPrevious page &5&l\u25c0", false, false, new String[0]);
        }
        this.createItem(RED, 1, 36, "&4&l\u25b6 &cBack", false, false, new String[0]);
        this.createItem(GREEN, 1, 40, "&2&l\u271a &aNew Particle", false, false, new String[0]);
    }

    @Generated
    public SParticles getSParticles() {
        return this.sParticles;
    }

    @Generated
    public GUI getGuiFrom() {
        return this.guiFrom;
    }
}

