/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.utils.safeopen;

import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.usedapi.BentoBoxAPI;
import com.ssomar.score.usedapi.ExcellentClaimsAPI;
import com.ssomar.score.usedapi.FactionsUUIDAPI;
import com.ssomar.score.usedapi.GriefPreventionAPI;
import com.ssomar.score.usedapi.IridiumSkyblockTool;
import com.ssomar.score.usedapi.LandsIntegrationAPI;
import com.ssomar.score.usedapi.ProtectionStonesAPI;
import com.ssomar.score.usedapi.ResidenceAPI;
import com.ssomar.score.usedapi.SuperiorSkyblockTool;
import com.ssomar.score.usedapi.WorldGuardAPI;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class SafeOpen {
    private static final boolean DEBUG = false;

    public static boolean verifSafeOpen(@NotNull UUID playerUUID, @NotNull Block block) {
        return SafeOpen.verifSafeOpen(playerUUID, block.getLocation());
    }

    public static boolean verifSafeOpen(@NotNull UUID playerUUID, @NotNull Location location) {
        if (Bukkit.getOfflinePlayer((UUID)playerUUID).isOp()) {
            return true;
        }
        SsomarDev.testMsg("DEBUG SAFE BREAK CDT 1", false);
        if (SCore.hasGriefPrevention && !GriefPreventionAPI.playerCanOpenClaimBlock(playerUUID, location)) {
            return false;
        }
        SsomarDev.testMsg("DEBUG SAFE BREAK CDT 2", false);
        if (SCore.hasIridiumSkyblock && !IridiumSkyblockTool.playerCanOpenIslandBlock(playerUUID, location)) {
            return false;
        }
        if (SCore.hasSuperiorSkyblock2 && !SuperiorSkyblockTool.playerCanOpenIslandBlock(playerUUID, location)) {
            return false;
        }
        if (SCore.hasBentoBox && !BentoBoxAPI.playerCanOpenIslandBlock(playerUUID, location)) {
            return false;
        }
        SsomarDev.testMsg("DEBUG SAFE BREAK CDT 3", false);
        if (SCore.hasLands && !new LandsIntegrationAPI((Plugin)SCore.plugin).playerCanOpenClaimBlock(playerUUID, location)) {
            return false;
        }
        if (SCore.hasFactionsUUID && !new FactionsUUIDAPI().playerCanOpenClaimBlock(playerUUID, location)) {
            return false;
        }
        SsomarDev.testMsg("DEBUG SAFE BREAK CDT 4", false);
        if (SCore.hasWorldGuard && !WorldGuardAPI.playerCanOpenInRegion(playerUUID, location)) {
            return false;
        }
        SsomarDev.testMsg("DEBUG SAFE BREAK CDT 5", false);
        if (SCore.hasResidence && !ResidenceAPI.playerCanOpenClaimBlock(playerUUID, location)) {
            return false;
        }
        SsomarDev.testMsg("DEBUG SAFE BREAK CDT 6", false);
        if (SCore.hasProtectionStones && !ProtectionStonesAPI.playerCanOpenClaimBlock(playerUUID, location)) {
            return false;
        }
        return !SCore.hasExcellentClaims || ExcellentClaimsAPI.playerCanOpenClaimBlock(playerUUID, location);
    }
}

