/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.sevents.events.player.equip.armor;

import com.ssomar.sevents.events.player.click.right.PlayerRightClickEvent;
import com.ssomar.sevents.events.player.equip.armor.ArmorType;
import com.ssomar.sevents.events.player.equip.armor.PlayerEquipArmorEvent;
import com.ssomar.sevents.version.Version;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Container;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class PlayerEquipArmorListener
implements Listener {
    private final List<String> blockedMaterials = new ArrayList<String>();

    public PlayerEquipArmorListener() {
        this.blockedMaterials.add("BEACON");
        this.blockedMaterials.add("CRAFTING_TABLE");
        this.blockedMaterials.add("ENCHANTMENT_TABLE");
        this.blockedMaterials.add("ENDER_CHEST");
        this.blockedMaterials.add("DIODE_BLOCK_OFF");
        this.blockedMaterials.add("DIODE_BLOCK_ON");
        this.blockedMaterials.add("REDSTONE_COMPARATOR_OFF");
        this.blockedMaterials.add("REDSTONE_COMPARATOR_ON");
        this.blockedMaterials.add("LEVER");
        this.blockedMaterials.add("DAYLIGHT_DETECTOR_INVERTED");
        this.blockedMaterials.add("DAYLIGHT_DETECTOR");
        this.blockedMaterials.add("CARTOGRAPHY_TABLE");
        this.blockedMaterials.add("ANVIL");
        this.blockedMaterials.add("CHIPPED_ANVIL");
        this.blockedMaterials.add("DAMAGED_ANVIL");
        this.blockedMaterials.add("GRINDSTONE");
        this.blockedMaterials.add("LOOM");
        this.blockedMaterials.add("STONECUTTER");
        this.blockedMaterials.add("BELL");
        this.blockedMaterials.add("SMITHING_TABLE");
    }

    @EventHandler(priority=EventPriority.HIGH)
    public final void inventoryClick(InventoryClickEvent e) {
        boolean shift = false;
        boolean numberkey = false;
        if (e.isCancelled()) {
            return;
        }
        if (e.getAction() == InventoryAction.NOTHING) {
            return;
        }
        if (e.getClick().equals((Object)ClickType.SHIFT_LEFT) || e.getClick().equals((Object)ClickType.SHIFT_RIGHT)) {
            shift = true;
        }
        if (e.getClick().equals((Object)ClickType.NUMBER_KEY)) {
            numberkey = true;
        }
        if (e.getSlotType() != InventoryType.SlotType.ARMOR && e.getSlotType() != InventoryType.SlotType.QUICKBAR && e.getSlotType() != InventoryType.SlotType.CONTAINER) {
            return;
        }
        if (e.getClickedInventory() != null && !e.getClickedInventory().getType().equals((Object)InventoryType.PLAYER)) {
            return;
        }
        if (!e.getInventory().getType().equals((Object)InventoryType.CRAFTING) && !e.getInventory().getType().equals((Object)InventoryType.PLAYER)) {
            return;
        }
        if (!(e.getWhoClicked() instanceof Player)) {
            return;
        }
        ArmorType newArmorType = ArmorType.matchType(shift ? e.getCurrentItem() : e.getCursor(), false);
        if (!shift && newArmorType != null && e.getRawSlot() != newArmorType.getSlot()) {
            return;
        }
        if (shift) {
            newArmorType = ArmorType.matchType(e.getCurrentItem(), false);
            if (newArmorType != null) {
                boolean equipping = e.getRawSlot() != newArmorType.getSlot();
                PlayerInventory inv = e.getWhoClicked().getInventory();
                if (newArmorType.equals((Object)ArmorType.HELMET) && equipping == PlayerEquipArmorListener.isAirOrNull(inv.getHelmet()) || newArmorType.equals((Object)ArmorType.CHESTPLATE) && equipping == PlayerEquipArmorListener.isAirOrNull(inv.getChestplate()) || newArmorType.equals((Object)ArmorType.LEGGINGS) && equipping == PlayerEquipArmorListener.isAirOrNull(inv.getLeggings()) || newArmorType.equals((Object)ArmorType.BOOTS) && equipping == PlayerEquipArmorListener.isAirOrNull(inv.getBoots())) {
                    PlayerEquipArmorEvent armorEquipEvent = new PlayerEquipArmorEvent((Player)e.getWhoClicked(), PlayerEquipArmorEvent.EquipMethod.SHIFT_CLICK, newArmorType, equipping ? null : e.getCurrentItem(), equipping ? e.getCurrentItem() : null);
                    armorEquipEvent.setCancelled(e.isCancelled());
                    Bukkit.getServer().getPluginManager().callEvent((Event)armorEquipEvent);
                    if (armorEquipEvent.isCancelled()) {
                        e.setCancelled(true);
                    }
                }
            }
        } else {
            ItemStack newArmorPiece = e.getCursor();
            ItemStack oldArmorPiece = e.getCurrentItem();
            if (numberkey) {
                if (e.getClickedInventory().getType().equals((Object)InventoryType.PLAYER)) {
                    ItemStack hotbarItem = e.getClickedInventory().getItem(e.getHotbarButton());
                    if (!PlayerEquipArmorListener.isAirOrNull(hotbarItem)) {
                        newArmorType = ArmorType.matchType(hotbarItem, false);
                        newArmorPiece = hotbarItem;
                        oldArmorPiece = e.getClickedInventory().getItem(e.getSlot());
                    } else {
                        newArmorType = ArmorType.matchType(!PlayerEquipArmorListener.isAirOrNull(e.getCurrentItem()) ? e.getCurrentItem() : e.getCursor(), false);
                    }
                }
            } else if (PlayerEquipArmorListener.isAirOrNull(e.getCursor()) && !PlayerEquipArmorListener.isAirOrNull(e.getCurrentItem())) {
                newArmorType = ArmorType.matchType(e.getCurrentItem(), false);
            }
            if (newArmorType != null && e.getRawSlot() == newArmorType.getSlot()) {
                PlayerEquipArmorEvent.EquipMethod method = PlayerEquipArmorEvent.EquipMethod.PICK_DROP;
                if (e.getAction().equals((Object)InventoryAction.HOTBAR_SWAP) || numberkey) {
                    method = PlayerEquipArmorEvent.EquipMethod.HOTBAR_SWAP;
                }
                PlayerEquipArmorEvent armorEquipEvent = new PlayerEquipArmorEvent((Player)e.getWhoClicked(), method, newArmorType, oldArmorPiece, newArmorPiece);
                armorEquipEvent.setCancelled(e.isCancelled());
                Bukkit.getServer().getPluginManager().callEvent((Event)armorEquipEvent);
                if (armorEquipEvent.isCancelled()) {
                    e.setCancelled(true);
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void playerRightClickEvent(PlayerRightClickEvent e) {
        ItemStack item;
        ArmorType newArmorType;
        Player player = e.getPlayer();
        if (e.hasBlock()) {
            Block block = e.getBlock();
            if (block.getState() != null && !Version.is1v11Less() && block.getState() instanceof Container) {
                return;
            }
            Material mat = block.getType();
            if (mat.toString().contains("SIGN") || mat.toString().contains("TRAPDOOR") || mat.toString().contains("DOOR") || mat.toString().contains("BUTTON") || mat.toString().contains("FENCE_GATE") || mat.toString().contains("BED") || mat.toString().contains("CANDLE_CAKES") || mat.toString().contains("BUTTONS") || mat.toString().contains("FLOWER_POT")) {
                return;
            }
            for (String s : this.blockedMaterials) {
                if (!mat.name().equalsIgnoreCase(s)) continue;
                return;
            }
        }
        if ((newArmorType = ArmorType.matchType(item = ((PlayerInteractEvent)e.getSourceEvent()).getItem(), true)) != null) {
            if (ArmorType.canReplaceUsingHotBar(item) && (newArmorType.equals((Object)ArmorType.HELMET) && PlayerEquipArmorListener.isAirOrNull(e.getPlayer().getInventory().getHelmet()) || newArmorType.equals((Object)ArmorType.CHESTPLATE) && PlayerEquipArmorListener.isAirOrNull(e.getPlayer().getInventory().getChestplate()) || newArmorType.equals((Object)ArmorType.LEGGINGS) && PlayerEquipArmorListener.isAirOrNull(e.getPlayer().getInventory().getLeggings()) || newArmorType.equals((Object)ArmorType.BOOTS) && PlayerEquipArmorListener.isAirOrNull(e.getPlayer().getInventory().getBoots()))) {
                PlayerEquipArmorEvent armorEquipEvent = new PlayerEquipArmorEvent(e.getPlayer(), PlayerEquipArmorEvent.EquipMethod.HOTBAR, ArmorType.matchType(item, true), null, item);
                armorEquipEvent.setCancelled(e.isCancelled());
                Bukkit.getServer().getPluginManager().callEvent((Event)armorEquipEvent);
                if (armorEquipEvent.isCancelled()) {
                    e.setCancelled(true);
                    player.updateInventory();
                }
            } else if (Version.is1v19v4Plus()) {
                ItemStack currentArmorPiece = null;
                if (newArmorType.equals((Object)ArmorType.HELMET) && !PlayerEquipArmorListener.isAirOrNull(e.getPlayer().getInventory().getHelmet())) {
                    currentArmorPiece = e.getPlayer().getInventory().getHelmet();
                } else if (newArmorType.equals((Object)ArmorType.CHESTPLATE) && !PlayerEquipArmorListener.isAirOrNull(e.getPlayer().getInventory().getChestplate())) {
                    currentArmorPiece = e.getPlayer().getInventory().getChestplate();
                } else if (newArmorType.equals((Object)ArmorType.LEGGINGS) && !PlayerEquipArmorListener.isAirOrNull(e.getPlayer().getInventory().getLeggings())) {
                    currentArmorPiece = e.getPlayer().getInventory().getLeggings();
                } else if (newArmorType.equals((Object)ArmorType.BOOTS) && !PlayerEquipArmorListener.isAirOrNull(e.getPlayer().getInventory().getBoots())) {
                    currentArmorPiece = e.getPlayer().getInventory().getBoots();
                }
                if (currentArmorPiece != null && ArmorType.canReplaceUsingHotBar(item)) {
                    PlayerEquipArmorEvent armorEquipEvent = new PlayerEquipArmorEvent(e.getPlayer(), PlayerEquipArmorEvent.EquipMethod.HOTBAR, ArmorType.matchType(item, true), currentArmorPiece, item);
                    armorEquipEvent.setCancelled(e.isCancelled());
                    Bukkit.getServer().getPluginManager().callEvent((Event)armorEquipEvent);
                    if (armorEquipEvent.isCancelled()) {
                        e.setCancelled(true);
                        player.updateInventory();
                    }
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void inventoryDrag(InventoryDragEvent event) {
        ArmorType type = ArmorType.matchType(event.getOldCursor(), false);
        if (event.getRawSlots().isEmpty()) {
            return;
        }
        if (type != null && type.getSlot() == event.getRawSlots().stream().findFirst().orElse(0).intValue()) {
            PlayerEquipArmorEvent armorEquipEvent = new PlayerEquipArmorEvent((Player)event.getWhoClicked(), PlayerEquipArmorEvent.EquipMethod.DRAG, type, null, event.getOldCursor());
            armorEquipEvent.setCancelled(event.isCancelled());
            Bukkit.getServer().getPluginManager().callEvent((Event)armorEquipEvent);
            if (armorEquipEvent.isCancelled()) {
                event.setResult(Event.Result.DENY);
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void itemBreakEvent(PlayerItemBreakEvent e) {
        ArmorType type = ArmorType.matchType(e.getBrokenItem(), false);
        if (type != null) {
            Player p = e.getPlayer();
            PlayerEquipArmorEvent armorEquipEvent = new PlayerEquipArmorEvent(p, PlayerEquipArmorEvent.EquipMethod.BROKE, type, e.getBrokenItem(), null);
            Bukkit.getServer().getPluginManager().callEvent((Event)armorEquipEvent);
            if (armorEquipEvent.isCancelled()) {
                ItemStack i = e.getBrokenItem().clone();
                i.setAmount(1);
                i.setDurability((short)(i.getDurability() - 1));
                if (type.equals((Object)ArmorType.HELMET)) {
                    p.getInventory().setHelmet(i);
                } else if (type.equals((Object)ArmorType.CHESTPLATE)) {
                    p.getInventory().setChestplate(i);
                } else if (type.equals((Object)ArmorType.LEGGINGS)) {
                    p.getInventory().setLeggings(i);
                } else if (type.equals((Object)ArmorType.BOOTS)) {
                    p.getInventory().setBoots(i);
                }
            }
        }
    }

    @EventHandler
    public void playerDeathEvent(PlayerDeathEvent e) {
        Player p = e.getEntity();
        if (e.getKeepInventory()) {
            return;
        }
        for (ItemStack i : p.getInventory().getArmorContents()) {
            if (PlayerEquipArmorListener.isAirOrNull(i)) continue;
            Bukkit.getServer().getPluginManager().callEvent((Event)new PlayerEquipArmorEvent(p, PlayerEquipArmorEvent.EquipMethod.DEATH, ArmorType.matchType(i, false), i, null));
        }
    }

    public static boolean isAirOrNull(ItemStack item) {
        return item == null || item.getType().equals((Object)Material.AIR);
    }
}

