/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.sevents.events.player.kill.entity.participate.entity;

import com.ssomar.sevents.events.player.kill.entity.participate.entity.EntityParticipateKillEntityEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDeathEvent;

public class EntityParticipateKillEntityListener
implements Listener {
    private final HashMap<UUID, List<UUID>> participations = new HashMap();

    @EventHandler
    public void onEntityDeathEvent(EntityDeathEvent e) {
        if (e.getEntity() instanceof Player) {
            return;
        }
        LivingEntity ent = e.getEntity();
        if (this.participations.containsKey(ent.getUniqueId())) {
            List<UUID> list = this.participations.get(ent.getUniqueId());
            for (UUID uuid : list) {
                Entity entity = Bukkit.getEntity((UUID)uuid);
                if (entity == null) continue;
                EntityParticipateKillEntityEvent playerKillPlayerEvent = new EntityParticipateKillEntityEvent(entity, (Entity)ent);
                Bukkit.getServer().getPluginManager().callEvent((Event)playerKillPlayerEvent);
            }
        }
        this.participations.remove(ent.getUniqueId());
    }

    @EventHandler
    public void onEntityDamagePlayerEvent(EntityDamageByEntityEvent e) {
        if (!(e.getDamager() instanceof Player) && !(e.getEntity() instanceof Player)) {
            Entity damager = e.getDamager();
            Entity damagee = e.getEntity();
            this.addParticipation(damager.getUniqueId(), damagee.getUniqueId());
        }
    }

    public void addParticipation(UUID damager, UUID damagee) {
        if (this.participations.containsKey(damagee)) {
            List<UUID> list = this.participations.get(damagee);
            if (list.contains(damager)) {
                return;
            }
            list.add(damager);
            this.participations.put(damagee, list);
        } else {
            ArrayList<UUID> list = new ArrayList<UUID>();
            list.add(damager);
            this.participations.put(damagee, list);
        }
    }
}

