/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.sevents.events.player.kill.player.participate.entity;

import com.ssomar.sevents.events.player.kill.player.participate.entity.EntityParticipateKillPlayerEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.PlayerDeathEvent;

public class EntityParticipateKillPlayerListener
implements Listener {
    private final HashMap<UUID, List<UUID>> participations = new HashMap();

    @EventHandler
    public void onPlayerDeathEvent(PlayerDeathEvent e) {
        Player p = e.getEntity();
        if (this.participations.containsKey(p.getUniqueId())) {
            List<UUID> list = this.participations.get(p.getUniqueId());
            for (UUID uuid : list) {
                Entity entity = Bukkit.getEntity((UUID)uuid);
                if (entity == null) continue;
                EntityParticipateKillPlayerEvent playerKillPlayerEvent = new EntityParticipateKillPlayerEvent(entity, p);
                Bukkit.getServer().getPluginManager().callEvent((Event)playerKillPlayerEvent);
            }
        }
        this.participations.remove(p.getUniqueId());
    }

    @EventHandler
    public void onEntityDamagePlayerEvent(EntityDamageByEntityEvent e) {
        if (!(e.getDamager() instanceof Player) && e.getEntity() instanceof Player) {
            Entity damager = e.getDamager();
            Player damagee = (Player)e.getEntity();
            this.addParticipation(damager.getUniqueId(), damagee.getUniqueId());
        }
    }

    public void addParticipation(UUID damager, UUID damagee) {
        if (this.participations.containsKey(damagee)) {
            List<UUID> list = this.participations.get(damagee);
            if (list.contains(damager)) {
                return;
            }
            list.add(damager);
            this.participations.put(damagee, list);
        } else {
            ArrayList<UUID> list = new ArrayList<UUID>();
            list.add(damager);
            this.participations.put(damagee, list);
        }
    }
}

