/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.guardvillagers.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.sterner.guardvillagers.GuardVillagers;
import dev.sterner.guardvillagers.GuardVillagersConfig;
import dev.sterner.guardvillagers.common.entity.GuardEntity;
import dev.sterner.guardvillagers.common.network.GuardFollowPacket;
import dev.sterner.guardvillagers.common.network.GuardPatrolPacket;
import dev.sterner.guardvillagers.common.screenhandler.GuardVillagerScreenHandler;
import java.util.Arrays;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_344;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_465;
import net.minecraft.class_490;
import net.minecraft.class_757;
import net.minecraft.class_8666;
import net.minecraft.class_8710;

public class GuardVillagerScreen
extends class_465<GuardVillagerScreenHandler> {
    private static final class_2960 GUARD_GUI_TEXTURES = GuardVillagers.id("textures/gui/inventory.png");
    private static final class_8666 GUARD_FOLLOWING_ICONS = new class_8666(GuardVillagers.id("following/following"), GuardVillagers.id("following/following_highlighted"));
    private static final class_8666 GUARD_NOT_FOLLOWING_ICONS = new class_8666(GuardVillagers.id("following/not_following"), GuardVillagers.id("following/not_following_highlighted"));
    private static final class_8666 GUARD_PATROLLING_ICONS = new class_8666(GuardVillagers.id("patrolling/patrolling1"), GuardVillagers.id("patrolling/patrolling2"));
    private static final class_8666 GUARD_NOT_PATROLLING_ICONS = new class_8666(GuardVillagers.id("patrolling/notpatrolling1"), GuardVillagers.id("patrolling/notpatrolling2"));
    private final class_1657 player;
    private final GuardEntity guardEntity;
    private float mousePosX;
    private float mousePosY;
    private boolean buttonPressed;
    private static final class_2960 ARMOR_EMPTY_TEXTURE = class_2960.method_60656((String)"hud/armor_empty");
    private static final class_2960 ARMOR_HALF_TEXTURE = class_2960.method_60656((String)"hud/armor_half");
    private static final class_2960 ARMOR_FULL_TEXTURE = class_2960.method_60656((String)"hud/armor_full");

    public GuardVillagerScreen(GuardVillagerScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, handler.guardEntity.method_5476());
        this.field_25267 = 80;
        this.field_25269 = 100;
        this.player = inventory.field_7546;
        this.guardEntity = handler.guardEntity;
    }

    protected void method_25426() {
        super.method_25426();
        if (!GuardVillagersConfig.followHero || this.player.method_6059(class_1294.field_18980)) {
            this.method_37063((class_364)new GuardGuiButton(this.field_2776 + 100, this.field_22790 / 2 - 40, 20, 18, GUARD_FOLLOWING_ICONS, GUARD_NOT_FOLLOWING_ICONS, true, button -> ClientPlayNetworking.send((class_8710)new GuardFollowPacket(this.guardEntity.method_5628()))));
        }
        if (!GuardVillagersConfig.setGuardPatrolHotv || this.player.method_6059(class_1294.field_18980)) {
            this.method_37063((class_364)new GuardGuiButton(this.field_2776 + 120, this.field_22790 / 2 - 40, 20, 18, GUARD_PATROLLING_ICONS, GUARD_NOT_PATROLLING_ICONS, false, button -> {
                this.buttonPressed = !this.buttonPressed;
                ClientPlayNetworking.send((class_8710)new GuardPatrolPacket(this.guardEntity.method_5628(), this.buttonPressed));
            }));
        }
    }

    protected void method_2389(class_332 ctx, float delta, int mouseX, int mouseY) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int i = (this.field_22789 - this.field_2792) / 2;
        int j = (this.field_22790 - this.field_2779) / 2;
        ctx.method_25302(GUARD_GUI_TEXTURES, i, j, 0, 0, this.field_2792, this.field_2779);
        class_490.method_2486((class_332)ctx, (int)(i + 51), (int)(j + 75), (int)(i + 51), (int)(j + 75 - 50), (int)30, (float)0.0625f, (float)this.mousePosX, (float)this.mousePosY, (class_1309)this.guardEntity);
    }

    private void drawHeart(class_332 context, HeartType type, int x, int y, boolean half) {
        RenderSystem.enableBlend();
        context.method_52706(type.getTexture(half), x, y, 9, 9);
        RenderSystem.disableBlend();
    }

    protected void method_2388(class_332 ctx, int x, int y) {
        int i;
        super.method_2388(ctx, x, y);
        int health = class_3532.method_15386((float)this.guardEntity.method_6032());
        int armor = this.guardEntity.method_6096();
        String rawHoly = this.guardEntity.getHolySkill();
        String pretty = "None";
        if (!"none".equals(rawHoly)) {
            String s = rawHoly.contains(":") ? rawHoly.split(":")[1] : rawHoly;
            s = s.replace("_channeling", "").replace("_", " ").trim();
            pretty = Arrays.stream(s.split(" ")).map(w -> w.isEmpty() ? w : Character.toUpperCase(w.charAt(0)) + w.substring(1)).reduce((a, b) -> a + " " + b).orElse(s);
        }
        ctx.method_51439(this.field_22793, class_2561.method_30163((String)("Holy Skill: " + pretty)), 0, -20, 16771235, false);
        String rawSkill = this.guardEntity.getBowSkill();
        if (!"none".equals(rawSkill)) {
            String skillName = rawSkill.contains(":") ? rawSkill.split(":")[1] : rawSkill;
            skillName = skillName.replace("_channeling", "").replace("_", " ").trim();
            skillName = Arrays.stream(skillName.split(" ")).map(word -> word.isEmpty() ? word : Character.toUpperCase(word.charAt(0)) + word.substring(1)).reduce((a, b) -> a + " " + b).orElse(skillName);
            ctx.method_51439(this.field_22793, class_2561.method_30163((String)("Bow Skill: " + skillName)), 0, -10, 0xFFFFFF, false);
        }
        boolean statusU = this.guardEntity.method_6059(class_1294.field_5899);
        boolean statusW = this.guardEntity.method_6059(class_1294.field_5920);
        HeartType heart = statusU ? HeartType.POISONED : (statusW ? HeartType.WITHERED : (this.guardEntity.method_32314() ? HeartType.FROZEN : HeartType.NORMAL));
        for (i = 0; i < 10; ++i) {
            this.drawHeart(ctx, HeartType.CONTAINER, i * 8 + 80, 20, false);
        }
        for (i = 0; i < health / 2; ++i) {
            if (health % 2 != 0 && health / 2 == i + 1) {
                this.drawHeart(ctx, HeartType.NORMAL, i * 8 + 80, 20, false);
                this.drawHeart(ctx, HeartType.NORMAL, (i + 1) * 8 + 80, 20, true);
                continue;
            }
            this.drawHeart(ctx, HeartType.NORMAL, i * 8 + 80, 20, false);
        }
        for (i = 0; i < 10; ++i) {
            ctx.method_52706(ARMOR_EMPTY_TEXTURE, i * 8 + 80, 30, 9, 9);
        }
        for (i = 0; i < armor / 2; ++i) {
            if (armor % 2 != 0 && armor / 2 == i + 1) {
                ctx.method_52706(ARMOR_FULL_TEXTURE, i * 8 + 80, 30, 9, 9);
                ctx.method_52706(ARMOR_HALF_TEXTURE, (i + 1) * 8 + 80, 30, 9, 9);
                continue;
            }
            ctx.method_52706(ARMOR_FULL_TEXTURE, i * 8 + 80, 30, 9, 9);
        }
    }

    public void method_25394(class_332 ctx, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(ctx, mouseX, mouseY, partialTicks);
        this.mousePosX = mouseX;
        this.mousePosY = mouseY;
        super.method_25394(ctx, mouseX, mouseY, partialTicks);
        this.method_2380(ctx, mouseX, mouseY);
    }

    class GuardGuiButton
    extends class_344 {
        private class_8666 texture;
        private class_8666 newTexture;
        private boolean isFollowButton;

        public GuardGuiButton(int xIn, int yIn, int widthIn, int heightIn, class_8666 resourceLocationIn, class_8666 newTexture, boolean isFollowButton, class_4185.class_4241 onPressIn) {
            super(xIn, yIn, widthIn, heightIn, resourceLocationIn, onPressIn);
            this.texture = resourceLocationIn;
            this.newTexture = newTexture;
            this.isFollowButton = isFollowButton;
        }

        public boolean requirementsForTexture() {
            boolean following = GuardVillagerScreen.this.guardEntity.isFollowing();
            boolean patrol = GuardVillagerScreen.this.guardEntity.isPatrolling();
            return this.isFollowButton ? following : patrol;
        }

        public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
            class_8666 icon = this.requirementsForTexture() ? this.texture : this.newTexture;
            class_2960 resourcelocation = icon.method_52729(this.method_25370(), this.method_25367());
            graphics.method_52706(resourcelocation, this.method_46426(), this.method_46427(), this.field_22758, this.field_22759);
        }
    }

    @Environment(value=EnvType.CLIENT)
    static enum HeartType {
        CONTAINER(class_2960.method_60656((String)"hud/heart/container"), class_2960.method_60656((String)"hud/heart/container")),
        NORMAL(class_2960.method_60656((String)"hud/heart/full"), class_2960.method_60656((String)"hud/heart/half")),
        POISONED(class_2960.method_60656((String)"hud/heart/poisoned_full"), class_2960.method_60656((String)"hud/heart/poisoned_half")),
        WITHERED(class_2960.method_60656((String)"hud/heart/withered_full"), class_2960.method_60656((String)"hud/heart/withered_half")),
        FROZEN(class_2960.method_60656((String)"hud/heart/frozen_full"), class_2960.method_60656((String)"hud/heart/frozen_half"));

        private final class_2960 fullTexture;
        private final class_2960 halfTexture;

        private HeartType(class_2960 fullTexture, class_2960 halfTexture) {
            this.fullTexture = fullTexture;
            this.halfTexture = halfTexture;
        }

        public class_2960 getTexture(boolean half) {
            if (half) {
                return this.halfTexture;
            }
            return this.fullTexture;
        }
    }
}

