/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.guardvillagers.common.ai;

import dev.sterner.guardvillagers.common.ai.HolyZoneHelper;
import dev.sterner.guardvillagers.common.entity.GuardEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_4050;
import net.minecraft.class_4802;
import net.minecraft.class_6019;
import net.minecraft.class_6335;

public final class CombatMovementHelper {
    private static final class_6019 PATHFINDING_DELAY_RANGE = class_4802.method_24505((int)1, (int)2);

    private CombatMovementHelper() {
    }

    public static MovementResult applyRangedCombatMovement(GuardEntity guard, class_1309 target, boolean canSee, int seeTime, int updatePathDelay, int cooldownTicks, boolean inAimPhase, boolean canRun) {
        boolean hasSeenRecently;
        class_6335 zone = HolyZoneHelper.findNearby(guard, 32.0);
        if (zone != null) {
            boolean hadSight;
            float r = HolyZoneHelper.radiusOf(zone, 5.0f);
            int s = seeTime;
            boolean bl = hadSight = s > 0;
            if (canSee != hadSight) {
                s = 0;
            }
            int n = s = canSee ? s + 1 : s - 1;
            if (!HolyZoneHelper.inside(guard, zone, r)) {
                HolyZoneHelper.steerTowardsIfOutside(guard, zone, r, canRun ? 1.15 : 0.8);
                guard.method_5951((class_1297)target, 30.0f, 30.0f);
                guard.method_5988().method_6226((class_1297)target, 30.0f, 30.0f);
                HolyZoneHelper.debugLog(guard, "applyRangedCombatMovement: RETURN to zone");
                return new MovementResult(s, updatePathDelay);
            }
            HolyZoneHelper.stopInside(guard, zone, r);
            HolyZoneHelper.softLeashInside(guard, zone, r);
            guard.method_5951((class_1297)target, 30.0f, 30.0f);
            guard.method_5988().method_6226((class_1297)target, 30.0f, 30.0f);
            HolyZoneHelper.debugLog(guard, "applyRangedCombatMovement: HOLD in zone");
            return new MovementResult(s, updatePathDelay);
        }
        int s = seeTime;
        boolean bl = hasSeenRecently = s > 0;
        if (canSee != hasSeenRecently) {
            s = 0;
        }
        s = canSee ? ++s : --s;
        double distanceSq = guard.method_5858((class_1297)target);
        float forward = 0.0f;
        float sideways = 0.0f;
        if (inAimPhase) {
            if (guard.method_59922().method_43048(10) == 0) {
                sideways = guard.method_59922().method_43056() ? 0.5f : -0.5f;
            }
            forward = guard.method_6115() ? -0.5f : -0.1f;
            guard.method_5962().method_6243(sideways, forward);
        }
        if (distanceSq <= 4.0) {
            guard.method_5962().method_6243(guard.method_6115() ? -0.5f : -3.0f, 0.0f);
        }
        if (guard.method_59922().method_43048(50) == 0) {
            guard.method_18380(guard.method_18376() == class_4050.field_18076 ? class_4050.field_18081 : class_4050.field_18076);
        }
        boolean needsToMove = (distanceSq > 256.0 || s < 5) && cooldownTicks == 0;
        int upd = updatePathDelay;
        if (needsToMove) {
            if (--upd <= 0) {
                guard.method_5942().method_6335((class_1297)target, canRun ? 1.0 : 0.5);
                upd = PATHFINDING_DELAY_RANGE.method_35008(guard.method_59922());
            }
        } else {
            upd = 0;
            guard.method_5942().method_6340();
        }
        guard.method_5951((class_1297)target, 30.0f, 30.0f);
        guard.method_5988().method_6226((class_1297)target, 30.0f, 30.0f);
        return new MovementResult(s, upd);
    }

    public static MovementResult applyRangedCombatMovement(class_1308 mob, class_1309 target, boolean canSee, int seeTime, int updatePathDelay, int cooldownTicks, boolean inAimPhase, boolean canRun, double speedModifier, float attackRadius) {
        boolean hadSight;
        GuardEntity guard;
        class_6335 zone;
        if (mob instanceof GuardEntity && (zone = HolyZoneHelper.findNearby(guard = (GuardEntity)mob, 32.0)) != null) {
            float r = HolyZoneHelper.radiusOf(zone, 5.0f);
            if (!HolyZoneHelper.inside(guard, zone, r)) {
                HolyZoneHelper.steerTowardsIfOutside(guard, zone, r, canRun ? speedModifier : speedModifier * 0.5);
                HolyZoneHelper.debugLog(guard, "applyRangedCombatMovement: RETURN to zone");
                return new MovementResult(seeTime, updatePathDelay);
            }
            HolyZoneHelper.stopInside(guard, zone, r);
            HolyZoneHelper.softLeashInside(guard, zone, r);
            HolyZoneHelper.debugLog(guard, "applyRangedCombatMovement: RETURN to zone");
            return new MovementResult(seeTime, updatePathDelay);
        }
        int s = seeTime;
        boolean bl = hadSight = s > 0;
        if (canSee != hadSight) {
            s = 0;
        }
        s = canSee ? ++s : --s;
        double distanceSq = mob.method_5858((class_1297)target);
        if (distanceSq <= 4.0) {
            mob.method_5962().method_6243(mob.method_6115() ? -0.5f : -3.0f, 0.0f);
        }
        if (mob.method_59922().method_43048(50) == 0) {
            mob.method_18380(mob.method_18376() == class_4050.field_18076 ? class_4050.field_18081 : class_4050.field_18076);
        }
        boolean needsToMove = (distanceSq > (double)(attackRadius * attackRadius) || s < 5) && cooldownTicks == 0;
        int upd = updatePathDelay;
        if (needsToMove) {
            if (--upd <= 0) {
                mob.method_5942().method_6335((class_1297)target, canRun ? speedModifier : speedModifier * 0.5);
                upd = PATHFINDING_DELAY_RANGE.method_35008(mob.method_59922());
            }
        } else {
            upd = 0;
            mob.method_5942().method_6340();
        }
        mob.method_5951((class_1297)target, 30.0f, 30.0f);
        mob.method_5988().method_6226((class_1297)target, 30.0f, 30.0f);
        return new MovementResult(s, upd);
    }

    public static BowMovementResult applyBowOrbitMovement(class_1308 actor, class_1309 target, double speed, float squaredRange, int targetSeeingTicker, int combatTicks, boolean movingToLeft, boolean backward) {
        boolean hasSeenRecently;
        GuardEntity guard;
        class_6335 zone;
        if (actor instanceof GuardEntity && (zone = HolyZoneHelper.findNearby(guard = (GuardEntity)actor, 32.0)) != null) {
            float r = HolyZoneHelper.radiusOf(zone, 5.0f);
            if (!HolyZoneHelper.inside(guard, zone, r)) {
                HolyZoneHelper.steerTowardsIfOutside(guard, zone, r, speed);
                HolyZoneHelper.debugLog(guard, "applyBowOrbitMovement: RETURN to zone");
                return new BowMovementResult(targetSeeingTicker, combatTicks, movingToLeft, backward);
            }
            HolyZoneHelper.stopInside(guard, zone, r);
            HolyZoneHelper.softLeashInside(guard, zone, r);
            HolyZoneHelper.debugLog(guard, "applyBowOrbitMovement: RETURN to zone");
            return new BowMovementResult(targetSeeingTicker, combatTicks, movingToLeft, backward);
        }
        int s = targetSeeingTicker;
        double distanceSq = actor.method_5858((class_1297)target);
        boolean canSee = actor.method_5985().method_6369((class_1297)target);
        boolean bl = hasSeenRecently = s > 0;
        if (canSee != hasSeenRecently) {
            s = 0;
        }
        int n = s = canSee ? s + 1 : s - 1;
        if (distanceSq > (double)squaredRange || s < 20) {
            actor.method_5942().method_6335((class_1297)target, speed);
            combatTicks = -1;
        } else {
            actor.method_5942().method_6340();
            ++combatTicks;
        }
        if (combatTicks >= 20) {
            if (actor.method_59922().method_43057() < 0.3f) {
                boolean bl2 = movingToLeft = !movingToLeft;
            }
            if (actor.method_59922().method_43057() < 0.3f) {
                backward = !backward;
            }
            combatTicks = 0;
        }
        if (combatTicks > -1) {
            if (distanceSq > (double)(squaredRange * 0.75f)) {
                backward = false;
            } else if (distanceSq < (double)(squaredRange * 0.25f)) {
                backward = true;
            }
            actor.method_5962().method_6243(backward ? -0.5f : 0.5f, movingToLeft ? 0.5f : -0.5f);
        }
        actor.method_5951((class_1297)target, 30.0f, 30.0f);
        actor.method_5988().method_6226((class_1297)target, 30.0f, 30.0f);
        return new BowMovementResult(s, combatTicks, movingToLeft, backward);
    }

    public record MovementResult(int seeTime, int updatePathDelay) {
    }

    public record BowMovementResult(int targetSeeingTicker, int combatTicks, boolean movingToLeft, boolean backward) {
    }
}

