/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.guardvillagers.common.entity;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import dev.sterner.guardvillagers.GuardVillagers;
import dev.sterner.guardvillagers.GuardVillagersConfig;
import dev.sterner.guardvillagers.common.entity.GuardEntityLootTables;
import dev.sterner.guardvillagers.common.entity.goal.ArmorerRepairGuardArmorGoal;
import dev.sterner.guardvillagers.common.entity.goal.FollowShieldGuards;
import dev.sterner.guardvillagers.common.entity.goal.GuardCastSpellGoal;
import dev.sterner.guardvillagers.common.entity.goal.GuardEatFoodGoal;
import dev.sterner.guardvillagers.common.entity.goal.GuardEntityMeleeGoal;
import dev.sterner.guardvillagers.common.entity.goal.GuardInteractDoorGoal;
import dev.sterner.guardvillagers.common.entity.goal.GuardLookAtAndStopMovingWhenBeingTheInteractionTarget;
import dev.sterner.guardvillagers.common.entity.goal.GuardRunToEatGoal;
import dev.sterner.guardvillagers.common.entity.goal.HeroHurtByTargetGoal;
import dev.sterner.guardvillagers.common.entity.goal.HeroHurtTargetGoal;
import dev.sterner.guardvillagers.common.entity.goal.HolyAreaAnchorGoal;
import dev.sterner.guardvillagers.common.entity.goal.KickGoal;
import dev.sterner.guardvillagers.common.entity.goal.MeleeRetreatForHealingGoal;
import dev.sterner.guardvillagers.common.entity.goal.PriestRangedHealerGoal;
import dev.sterner.guardvillagers.common.entity.goal.RaiseShieldGoal;
import dev.sterner.guardvillagers.common.entity.goal.RangedBowAttackPassiveGoal;
import dev.sterner.guardvillagers.common.entity.goal.RangedCrossbowAttackPassiveGoal;
import dev.sterner.guardvillagers.common.entity.goal.RunToClericGoal;
import dev.sterner.guardvillagers.common.entity.goal.WalkBackToCheckPointGoal;
import dev.sterner.guardvillagers.common.network.GuardData;
import dev.sterner.guardvillagers.common.screenhandler.GuardVillagerScreenHandler;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1338;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1368;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1405;
import net.minecraft.class_1409;
import net.minecraft.class_1439;
import net.minecraft.class_1456;
import net.minecraft.class_1538;
import net.minecraft.class_156;
import net.minecraft.class_1569;
import net.minecraft.class_1584;
import net.minecraft.class_1603;
import net.minecraft.class_1640;
import net.minecraft.class_1641;
import net.minecraft.class_1642;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1665;
import net.minecraft.class_1675;
import net.minecraft.class_1703;
import net.minecraft.class_1738;
import net.minecraft.class_1743;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1811;
import net.minecraft.class_1839;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2744;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3745;
import net.minecraft.class_3763;
import net.minecraft.class_3854;
import net.minecraft.class_3908;
import net.minecraft.class_3988;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4094;
import net.minecraft.class_4136;
import net.minecraft.class_4151;
import net.minecraft.class_4174;
import net.minecraft.class_4291;
import net.minecraft.class_4802;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_52;
import net.minecraft.class_5274;
import net.minecraft.class_5321;
import net.minecraft.class_5354;
import net.minecraft.class_5398;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6019;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8111;
import net.minecraft.class_8567;
import net.minecraft.class_9278;
import net.minecraft.class_9304;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9701;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.entity.SpellProjectile;
import net.spell_engine.internals.SpellHelper;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchool;
import org.jetbrains.annotations.Nullable;

public class GuardEntity
extends class_1314
implements class_3745,
class_1603,
class_5354,
class_1265,
class_4094 {
    protected static final class_2940<Optional<UUID>> OWNER_UNIQUE_ID = class_2945.method_12791(GuardEntity.class, (class_2941)class_2943.field_13313);
    private static final class_1322 USE_ITEM_SPEED_PENALTY = new class_1322(GuardVillagers.id("speed_penalty"), -0.25, class_1322.class_1323.field_6328);
    private static final class_2940<Optional<class_2338>> GUARD_POS = class_2945.method_12791(GuardEntity.class, (class_2941)class_2943.field_13315);
    private static final class_2940<Boolean> PATROLLING = class_2945.method_12791(GuardEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> GUARD_VARIANT = class_2945.method_12791(GuardEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> RUNNING_TO_EAT = class_2945.method_12791(GuardEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> DATA_CHARGING_STATE = class_2945.method_12791(GuardEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> KICKING = class_2945.method_12791(GuardEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> FOLLOWING = class_2945.method_12791(GuardEntity.class, (class_2941)class_2943.field_13323);
    private static final Map<class_4050, class_4048> SIZE_BY_POSE = ImmutableMap.builder().put((Object)class_4050.field_18076, (Object)class_4048.method_18384((float)0.6f, (float)1.95f)).put((Object)class_4050.field_18078, (Object)field_18072).put((Object)class_4050.field_18077, (Object)class_4048.method_18384((float)0.6f, (float)0.6f)).put((Object)class_4050.field_18079, (Object)class_4048.method_18384((float)0.6f, (float)0.6f)).put((Object)class_4050.field_18080, (Object)class_4048.method_18384((float)0.6f, (float)0.6f)).put((Object)class_4050.field_18081, (Object)class_4048.method_18384((float)0.6f, (float)1.75f)).put((Object)class_4050.field_18082, (Object)class_4048.method_18385((float)0.2f, (float)0.2f)).build();
    private static final class_6019 angerTime = class_4802.method_24505((int)20, (int)39);
    private static final class_2940<String> HOLY_SKILL = class_2945.method_12791(GuardEntity.class, (class_2941)class_2943.field_13326);
    private static final class_2940<String> BOW_SKILL = class_2945.method_12791(GuardEntity.class, (class_2941)class_2943.field_13326);
    public static final Map<class_1304, class_5321<class_52>> EQUIPMENT_SLOT_ITEMS = (Map)class_156.method_654((Object)Maps.newHashMap(), slotItems -> {
        slotItems.put(class_1304.field_6173, GuardEntityLootTables.GUARD_MAIN_HAND);
        slotItems.put(class_1304.field_6171, GuardEntityLootTables.GUARD_OFF_HAND);
        slotItems.put(class_1304.field_6169, GuardEntityLootTables.GUARD_HELMET);
        slotItems.put(class_1304.field_6174, GuardEntityLootTables.GUARD_CHEST);
        slotItems.put(class_1304.field_6172, GuardEntityLootTables.GUARD_LEGGINGS);
        slotItems.put(class_1304.field_6166, GuardEntityLootTables.GUARD_FEET);
    });
    private final class_4136 gossips = new class_4136();
    public long lastGossipTime;
    public long lastGossipDecayTime;
    public class_1277 guardInventory = new class_1277(6);
    public int kickTicks;
    public int shieldCoolDown;
    public int kickCoolDown;
    public boolean interacting;
    public boolean spawnWithArmor;
    private int remainingPersistentAngerTime;
    private UUID persistentAngerTarget;
    private boolean castingSpell = false;
    public Queue<Pair<Integer, Runnable>> delayedTasks = new LinkedList<Pair<Integer, Runnable>>();

    public boolean isCastingSpell() {
        return this.castingSpell;
    }

    public void setCastingSpell(boolean casting) {
        this.castingSpell = casting;
    }

    public GuardEntity(class_1299<? extends GuardEntity> type, class_1937 world) {
        super(type, world);
        this.guardInventory.method_5489((class_1265)this);
        this.method_5971();
        if (GuardVillagersConfig.guardEntitysOpenDoors) {
            ((class_1409)this.method_5942()).method_6363(true);
        }
    }

    public static int slotToInventoryIndex(class_1304 slot) {
        return switch (slot) {
            case class_1304.field_6174 -> 1;
            case class_1304.field_6166 -> 3;
            case class_1304.field_6172 -> 2;
            default -> 0;
        };
    }

    public static int getRandomTypeForBiome(class_1936 world, class_2338 pos) {
        class_3854 type = class_3854.method_16930((class_6880)world.method_23753(pos));
        if (type == class_3854.field_17075) {
            return 6;
        }
        if (type == class_3854.field_17077) {
            return 5;
        }
        if (type == class_3854.field_17072) {
            return 4;
        }
        if (type == class_3854.field_17076) {
            return 3;
        }
        if (type == class_3854.field_17074) {
            return 2;
        }
        if (type == class_3854.field_17071) {
            return 1;
        }
        return 0;
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, GuardVillagersConfig.healthModifier).method_26868(class_5134.field_23719, GuardVillagersConfig.speedModifier).method_26868(class_5134.field_23721, 1.0).method_26868(class_5134.field_23717, GuardVillagersConfig.followRangeModifier);
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        this.method_5971();
        int type = GuardEntity.getRandomTypeForBiome((class_1936)world, this.method_24515());
        if (entityData instanceof GuardEntityData) {
            type = ((GuardEntityData)entityData).variantData;
            entityData = new GuardEntityData(type);
        }
        if (this.getHolySkill().equals("none")) {
            ArrayList<String> holy = new ArrayList<String>();
            if (FabricLoader.getInstance().isModLoaded("paladins")) {
                holy.add("paladins:circle_of_healing");
                holy.add("paladins:barrier");
            }
            if (FabricLoader.getInstance().isModLoaded("lne_paladins")) {
                holy.add("lne_paladins:holy_prevention");
            }
            holy.add("none");
            this.setHolySkill((String)holy.get(world.method_8409().method_43048(holy.size())));
        }
        if (this.getBowSkill().equals("none")) {
            ArrayList<String> possibleSkills = new ArrayList<String>();
            if (FabricLoader.getInstance().isModLoaded("archers_expansion")) {
                possibleSkills.add("archers_expansion:fan_of_fire_channeling");
                possibleSkills.add("archers_expansion:enchanted_crystal_arrow_channeling");
                possibleSkills.add("archers_expansion:arctic_volley");
            }
            if (FabricLoader.getInstance().isModLoaded("archers")) {
                possibleSkills.add("archers:magic_arrow_channeling");
            }
            possibleSkills.add("none");
            this.setBowSkill((String)possibleSkills.get(world.method_8409().method_43048(possibleSkills.size())));
        }
        this.setGuardEntityVariant(type);
        class_5819 random = world.method_8409();
        this.method_5964(random, difficulty);
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    protected void method_6087(class_1297 entity) {
        if (entity instanceof class_1314) {
            boolean attackTargets;
            class_1314 living = (class_1314)entity;
            boolean bl = attackTargets = living.method_5968() instanceof class_1646 || living.method_5968() instanceof class_1439 || living.method_5968() instanceof GuardEntity;
            if (attackTargets) {
                this.method_5980((class_1309)living);
            }
        }
        super.method_6087(entity);
    }

    @Nullable
    public class_2338 getPatrolPos() {
        return ((Optional)this.field_6011.method_12789(GUARD_POS)).orElse(null);
    }

    @Nullable
    public void setPatrolPos(class_2338 position) {
        this.field_6011.method_12778(GUARD_POS, Optional.ofNullable(position));
    }

    protected class_3414 method_5994() {
        return GuardVillagers.GUARD_AMBIENT;
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        if (this.method_6039()) {
            return class_3417.field_15150;
        }
        return GuardVillagers.GUARD_HURT;
    }

    protected class_3414 method_6002() {
        return GuardVillagers.GUARD_DEATH;
    }

    protected void method_6099(class_3218 world, class_1282 source, boolean causedByPlayer) {
        for (int i = 0; i < this.guardInventory.method_5439(); ++i) {
            class_1799 itemstack = this.guardInventory.method_5438(i);
            class_5819 random = this.method_37908().method_8409();
            if (itemstack.method_7960() || class_1890.method_60142((class_1799)itemstack, (class_9331)class_9701.field_51655) || !(random.method_43057() < GuardVillagersConfig.chanceToDropEquipment)) continue;
            this.method_5775(itemstack);
        }
    }

    public void method_5749(class_2487 nbt) {
        UUID uuid;
        super.method_5749(nbt);
        UUID uUID = uuid = nbt.method_25928("Owner") ? nbt.method_25926("Owner") : null;
        if (uuid != null) {
            try {
                this.setOwnerId(uuid);
            }
            catch (Throwable throwable) {
                this.setOwnerId(null);
            }
        }
        this.setGuardEntityVariant(nbt.method_10550("Type"));
        this.kickTicks = nbt.method_10550("KickTicks");
        this.setFollowing(nbt.method_10577("Following"));
        this.interacting = nbt.method_10577("Interacting");
        this.setPatrolling(nbt.method_10577("Patrolling"));
        this.shieldCoolDown = nbt.method_10550("KickCooldown");
        this.kickCoolDown = nbt.method_10550("ShieldCooldown");
        this.lastGossipDecayTime = nbt.method_10537("LastGossipDecay");
        this.lastGossipTime = nbt.method_10537("LastGossipTime");
        this.spawnWithArmor = nbt.method_10577("SpawnWithArmor");
        if (nbt.method_10573("BowSkill", 8)) {
            this.setBowSkill(nbt.method_10558("BowSkill"));
        }
        if (nbt.method_10573("HolySkill", 8)) {
            this.setHolySkill(nbt.method_10558("HolySkill"));
        }
        if (nbt.method_10545("PatrolPosX")) {
            int x = nbt.method_10550("PatrolPosX");
            int y = nbt.method_10550("PatrolPosY");
            int z = nbt.method_10550("PatrolPosZ");
            this.field_6011.method_12778(GUARD_POS, Optional.ofNullable(new class_2338(x, y, z)));
        }
        class_2499 listtag = nbt.method_10554("Gossips", 10);
        this.gossips.method_19066(new Dynamic((DynamicOps)class_2509.field_11560, (Object)listtag));
        class_2499 listnbt = nbt.method_10554("Inventory", 9);
        for (int i = 0; i < listnbt.size(); ++i) {
            class_2487 nbtnbt = listnbt.method_10602(i);
            int j = nbtnbt.method_10571("Slot") & 0xFF;
            this.guardInventory.method_5447(j, (class_1799)class_1799.method_57360((class_7225.class_7874)this.method_56673(), (class_2520)nbtnbt).get());
        }
        if (nbt.method_10573("ArmorItems", 9)) {
            class_2499 armorItems = nbt.method_10554("ArmorItems", 10);
            for (int i = 0; i < this.field_6205.size(); ++i) {
                class_1799 stack = class_1799.method_57359((class_7225.class_7874)this.method_56673(), (class_2487)armorItems.method_10602(i));
                if (!stack.method_7960()) {
                    int index = GuardEntity.slotToInventoryIndex(this.method_32326(class_1799.method_57360((class_7225.class_7874)this.method_56673(), (class_2520)armorItems.method_10602(i)).orElse(class_1799.field_8037)));
                    this.guardInventory.method_5447(index, stack);
                    continue;
                }
                listtag.add((Object)new class_2487());
            }
        }
        if (nbt.method_10573("HandItems", 9)) {
            class_2499 handItems = nbt.method_10554("HandItems", 10);
            for (int i = 0; i < this.field_6195.size(); ++i) {
                int handSlot;
                int n = handSlot = i == 0 ? 5 : 4;
                if (!class_1799.method_57359((class_7225.class_7874)this.method_56673(), (class_2487)handItems.method_10602(i)).method_7960()) {
                    this.guardInventory.method_5447(handSlot, class_1799.method_57359((class_7225.class_7874)this.method_56673(), (class_2487)handItems.method_10602(i)));
                    continue;
                }
                listtag.add((Object)new class_2487());
            }
            if (!this.method_37908().field_9236) {
                this.method_29512(this.method_37908(), nbt);
            }
        }
    }

    public String getBowSkill() {
        return (String)this.field_6011.method_12789(BOW_SKILL);
    }

    public void setBowSkill(String skill) {
        this.field_6011.method_12778(BOW_SKILL, (Object)skill);
    }

    protected void method_6040() {
        if (this.method_6115()) {
            class_1268 hand = this.method_6058();
            if (!this.field_6277.equals(this.method_5998(hand))) {
                this.method_6075();
            } else if (!this.field_6277.method_7960() && this.method_6115()) {
                this.method_6098(this.field_6277, 16);
                class_1799 itemStack = this.field_6277.method_7910(this.method_37908(), (class_1309)this);
                if (itemStack != this.field_6277) {
                    this.method_6122(hand, itemStack);
                }
                if (this.field_6277.method_7976() != class_1839.field_8950) {
                    this.field_6277.method_7934(1);
                }
                this.method_6075();
            }
        }
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("Type", this.getGuardEntityVariant());
        nbt.method_10569("KickTicks", this.kickTicks);
        nbt.method_10569("ShieldCooldown", this.shieldCoolDown);
        nbt.method_10569("KickCooldown", this.kickCoolDown);
        nbt.method_10556("Following", this.isFollowing());
        nbt.method_10556("Interacting", this.interacting);
        nbt.method_10556("Patrolling", this.isPatrolling());
        nbt.method_10556("SpawnWithArmor", this.spawnWithArmor);
        nbt.method_10544("LastGossipTime", this.lastGossipTime);
        nbt.method_10544("LastGossipDecay", this.lastGossipDecayTime);
        nbt.method_10582("BowSkill", this.getBowSkill());
        nbt.method_10582("HolySkill", this.getHolySkill());
        if (this.getOwnerId() != null) {
            nbt.method_25927("Owner", this.getOwnerId());
        }
        class_2499 listnbt = new class_2499();
        for (int i = 0; i < this.guardInventory.method_5439(); ++i) {
            class_1799 itemstack = this.guardInventory.method_5438(i);
            if (itemstack.method_7960()) continue;
            class_2487 nbtnbt = new class_2487();
            nbtnbt.method_10567("Slot", (byte)i);
            listnbt.add((Object)itemstack.method_57376((class_7225.class_7874)this.method_56673(), (class_2520)nbtnbt));
        }
        nbt.method_10566("Inventory", (class_2520)listnbt);
        if (this.getPatrolPos() != null) {
            nbt.method_10569("PatrolPosX", this.getPatrolPos().method_10263());
            nbt.method_10569("PatrolPosY", this.getPatrolPos().method_10264());
            nbt.method_10569("PatrolPosZ", this.getPatrolPos().method_10260());
        }
        nbt.method_10566("Gossips", (class_2520)this.gossips.method_19067((DynamicOps)class_2509.field_11560));
        this.method_29517(nbt);
    }

    private void maybeDecayGossip() {
        long i = this.method_37908().method_8510();
        if (this.lastGossipDecayTime == 0L) {
            this.lastGossipDecayTime = i;
        } else if (i >= this.lastGossipDecayTime + 24000L) {
            this.gossips.method_20651();
            this.lastGossipDecayTime = i;
        }
    }

    public class_1799 method_6118(class_1304 slot) {
        switch (slot) {
            case field_6169: {
                return this.guardInventory.method_5438(0);
            }
            case field_6174: {
                return this.guardInventory.method_5438(1);
            }
            case field_6172: {
                return this.guardInventory.method_5438(2);
            }
            case field_6166: {
                return this.guardInventory.method_5438(3);
            }
            case field_6171: {
                return this.guardInventory.method_5438(4);
            }
            case field_6173: {
                return this.guardInventory.method_5438(5);
            }
        }
        return class_1799.field_8037;
    }

    public class_4136 getGossips() {
        return this.gossips;
    }

    public int getPlayerEntityReputation(class_1657 player) {
        return this.gossips.method_19073(player.method_5667(), gossipType -> true);
    }

    @Nullable
    public class_1309 getOwner() {
        try {
            UUID uuid = this.getOwnerId();
            boolean heroOfTheVillage = uuid != null && this.method_37908().method_18470(uuid) != null && this.method_37908().method_18470(uuid).method_6059(class_1294.field_18980);
            return uuid == null || this.method_37908().method_18470(uuid) != null && !heroOfTheVillage && GuardVillagersConfig.followHero || !GuardVillagersConfig.followHero && this.method_37908().method_18470(uuid) == null ? null : this.method_37908().method_18470(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    public boolean isOwner(class_1309 entityIn) {
        return entityIn == this.getOwner();
    }

    @Nullable
    public UUID getOwnerId() {
        return ((Optional)this.field_6011.method_12789(OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setOwnerId(@Nullable UUID p_184754_1_) {
        this.field_6011.method_12778(OWNER_UNIQUE_ID, Optional.ofNullable(p_184754_1_));
    }

    @Nullable
    private class_2960 getPassiveSpellIdForBlade() {
        String key = this.method_6047().method_7909().method_7876();
        if (key.contains("frost_blade")) {
            return class_2960.method_60655((String)"spellbladenext", (String)"frost_spellstrike");
        }
        if (key.contains("fire_blade")) {
            return class_2960.method_60655((String)"spellbladenext", (String)"fire_spellstrike");
        }
        if (key.contains("arcane_blade")) {
            return class_2960.method_60655((String)"spellbladenext", (String)"arcane_spellstrike");
        }
        if (key.contains("frost_claymore")) {
            return class_2960.method_60655((String)"spellbladenext", (String)"frost_burst");
        }
        if (key.contains("fire_claymore")) {
            return class_2960.method_60655((String)"spellbladenext", (String)"flame_burst_v2");
        }
        if (key.contains("arcane_claymore")) {
            return class_2960.method_60655((String)"spellbladenext", (String)"arcane_burst");
        }
        return null;
    }

    public boolean method_6121(class_1297 target) {
        class_2960 spellId;
        if (this.isKicking()) {
            if (target instanceof class_1309) {
                class_1309 livingTarget = (class_1309)target;
                livingTarget.method_6005(1.0, (double)class_3532.method_15374((float)(this.method_36454() * ((float)Math.PI / 180))), (double)(-class_3532.method_15362((float)(this.method_36454() * ((float)Math.PI / 180)))));
            }
            this.kickTicks = 10;
            this.method_37908().method_8421((class_1297)this, (byte)4);
            this.method_5951(target, 90.0f, 90.0f);
        }
        class_1799 hand = this.method_6047();
        hand.method_7970(1, (class_1309)this, class_1304.field_6173);
        boolean success = super.method_6121(target);
        if (success && target instanceof class_1309 && (spellId = this.getPassiveSpellIdForBlade()) != null) {
            SpellRegistry.from((class_1937)this.method_37908()).method_55841(spellId).ifPresent(spellEntry -> {
                Spell spell = (Spell)spellEntry.comp_349();
                SpellPower.Result power = SpellPower.getSpellPower((SpellSchool)spell.school, (class_1309)this);
                SpellHelper.ImpactContext context = new SpellHelper.ImpactContext().power(power).position(this.method_33571()).target(SpellHelper.focusMode((Spell)spell));
                if (spell.deliver != null && "PROJECTILE".equalsIgnoreCase(spell.deliver.type.toString())) {
                    class_2960 soundId;
                    double range = spell.range > 0.0f ? (double)spell.range : 6.0;
                    int cap = spell.target != null && spell.target.cap >= 0 ? spell.target.cap : 0;
                    class_243 spawnPos = this.method_33571();
                    class_1309 attackTarget = this.method_5968();
                    List targets = this.method_37908().method_8390(class_1309.class, this.method_5829().method_1014(range), e -> e != this && e.method_5805() && this.method_6057((class_1297)e) && this.method_18395((class_1309)e) && (!(e instanceof class_1657) || e == attackTarget));
                    int count = 0;
                    for (class_1309 e2 : targets) {
                        if (count++ >= cap) break;
                        class_243 direction = e2.method_33571().method_1020(spawnPos).method_1029().method_1021(1.25);
                        SpellProjectile projectile = new SpellProjectile(this.method_37908(), (class_1309)this, spawnPos.field_1352, spawnPos.field_1351, spawnPos.field_1350, SpellProjectile.Behaviour.FLY, (class_6880)spellEntry, context, spell.deliver.projectile.projectile.perks != null ? spell.deliver.projectile.projectile.perks.copy() : new Spell.ProjectileData.Perks());
                        projectile.method_18799(direction);
                        projectile.range = 64.0f;
                        this.method_37908().method_8649((class_1297)projectile);
                    }
                    if (spell.deliver.projectile.launch_properties != null && spell.deliver.projectile.launch_properties.sound != null && (soundId = class_2960.method_12829((String)spell.deliver.projectile.launch_properties.sound.id())) != null) {
                        class_3414 soundEvent = (class_3414)class_7923.field_41172.method_10223(soundId);
                        this.method_37908().method_8396(null, this.method_24515(), soundEvent, class_3419.field_15251, 1.0f, 1.0f);
                    }
                } else {
                    double radius = spell.range > 0.0f ? (double)spell.range : 5.0;
                    class_243 forward = this.method_5720();
                    float coneAngle = 45.0f;
                    double cosThreshold = Math.cos(Math.toRadians(coneAngle));
                    List nearby = this.method_37908().method_8390(class_1309.class, this.method_5829().method_1014(radius), e -> e != this && e.method_5805() && this.method_6057((class_1297)e));
                    List<SpellHelper.DeliveryTarget> targets = nearby.stream().filter(e -> forward.method_1026(e.method_19538().method_1020(this.method_19538()).method_1029()) > cosThreshold).map(e -> new SpellHelper.DeliveryTarget((class_1297)e, context)).toList();
                    for (SpellHelper.DeliveryTarget deliveryTarget : targets) {
                        SpellHelper.performImpacts((class_1937)this.method_37908(), (class_1309)this, (class_1297)this, (class_1297)deliveryTarget.entity(), (class_6880)spellEntry, (List)spell.impacts, (SpellHelper.ImpactContext)deliveryTarget.context());
                    }
                    this.method_37908().method_8396(null, this.method_24515(), class_3417.field_14858, class_3419.field_15248, 1.0f, 1.0f);
                }
            });
        }
        return success;
    }

    public void method_5711(byte status) {
        if (status == 4) {
            this.kickTicks = 10;
        } else {
            super.method_5711(status);
        }
    }

    public boolean method_6062() {
        return this.interacting || super.method_6062();
    }

    public void method_6078(class_1282 damageSource) {
        if ((this.method_37908().method_8407() == class_1267.field_5802 || this.method_37908().method_8407() == class_1267.field_5807) && damageSource.method_5529() instanceof class_1642) {
            class_1641 zombieguard = (class_1641)this.method_29243(class_1299.field_6054, true);
            if (this.method_37908().method_8407() != class_1267.field_5807 && this.field_5974.method_43056() || zombieguard == null) {
                return;
            }
            zombieguard.method_5943((class_5425)this.method_37908(), this.method_37908().method_8404(zombieguard.method_24515()), class_3730.field_16468, (class_1315)new class_1642.class_1644(false, true));
            if (!this.method_5701()) {
                this.method_37908().method_8444(null, 1026, this.method_24515(), 0);
            }
            this.method_31472();
        }
        super.method_6078(damageSource);
    }

    public class_3414 method_18869(class_1799 stack) {
        return super.method_18869(stack);
    }

    public class_1799 method_18866(class_1937 world, class_1799 stack, class_4174 food) {
        this.method_6025(food.comp_2491());
        world.method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_19149, class_3419.field_15248, 0.5f, world.field_9229.method_43057() * 0.1f + 0.9f);
        super.method_18866(world, stack, food);
        return stack;
    }

    public void method_6007() {
        class_1304[] class_1304Array;
        if (this.kickTicks > 0) {
            --this.kickTicks;
        }
        if (this.kickCoolDown > 0) {
            --this.kickCoolDown;
        }
        if (this.shieldCoolDown > 0) {
            --this.shieldCoolDown;
        }
        if (this.method_6032() < this.method_6063() && this.field_6012 % 200 == 0) {
            this.method_6025(GuardVillagersConfig.amountOfHealthRegenerated);
        }
        if (this.spawnWithArmor && (class_1304Array = this.method_37908()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_1304Array;
            for (class_1304 equipmentslottype : class_1304.values()) {
                for (class_1799 stack : this.getStacksFromLootTable(equipmentslottype, serverWorld)) {
                    this.method_5673(equipmentslottype, stack);
                }
            }
            this.applyRobesBasedOnWand();
            this.applyArmorBasedOnSpellblade();
            this.spawnWithArmor = false;
        }
        if (!this.method_37908().field_9236) {
            this.method_29510((class_3218)this.method_37908(), true);
        }
        this.method_6119();
        super.method_6007();
    }

    public void method_5773() {
        this.maybeDecayGossip();
        super.method_5773();
        if (!this.method_37908().field_9236) {
            this.delayedTasks = this.delayedTasks.stream().map(pair -> {
                int ticksLeft = (Integer)pair.getFirst() - 1;
                if (ticksLeft <= 0) {
                    ((Runnable)pair.getSecond()).run();
                    return null;
                }
                return new Pair((Object)ticksLeft, (Object)((Runnable)pair.getSecond()));
            }).filter(Objects::nonNull).collect(Collectors.toCollection(LinkedList::new));
        }
    }

    private void applyRobesBasedOnWand() {
        class_1937 class_19372;
        class_1792 wand = this.method_6047().method_7909();
        String prefix = null;
        if (wand.method_7876().contains("wand_fire")) {
            prefix = "wizards:fire_robe_";
        } else if (wand.method_7876().contains("wand_frost")) {
            prefix = "wizards:frost_robe_";
        } else if (wand.method_7876().contains("wand_arcane")) {
            prefix = "wizards:arcane_robe_";
        }
        if (prefix != null && (class_19372 = this.method_37908()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            this.equipRobes(prefix, serverWorld);
        }
    }

    private void applyArmorBasedOnSpellblade() {
        class_1937 class_19372;
        String key = this.method_6047().method_7909().method_7876();
        String prefix = null;
        if (key.contains("frost_blade") || key.contains("frost_claymore")) {
            prefix = "spellbladenext:runefrost_";
        } else if (key.contains("fire_blade") || key.contains("fire_claymore")) {
            prefix = "spellbladenext:runeblaze_";
        } else if (key.contains("arcane_blade") || key.contains("arcane_claymore")) {
            prefix = "spellbladenext:runegleam_";
        }
        if (prefix != null && (class_19372 = this.method_37908()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            this.equipRobes(prefix, serverWorld);
        }
    }

    private void equipRobes(String prefix, class_3218 serverWorld) {
        class_2378 itemRegistry = serverWorld.method_30349().method_30530(class_7924.field_41197);
        Map<class_1304, CallSite> armorSlots = Map.of(class_1304.field_6169, prefix + "head", class_1304.field_6174, prefix + "chest", class_1304.field_6172, prefix + "legs", class_1304.field_6166, prefix + "feet");
        for (Map.Entry<class_1304, CallSite> entry : armorSlots.entrySet()) {
            class_2960 robeId;
            int invIndex;
            class_1304 slot = entry.getKey();
            if ((invIndex = (switch (slot) {
                case class_1304.field_6169 -> 0;
                case class_1304.field_6174 -> 1;
                case class_1304.field_6172 -> 2;
                case class_1304.field_6166 -> 3;
                default -> -1;
            })) == -1 || this.guardInventory.method_5438(invIndex).method_7960() || (robeId = class_2960.method_12829((String)((String)((Object)entry.getValue())))) == null || !itemRegistry.method_10250(robeId)) continue;
            class_1799 robe = new class_1799((class_1935)itemRegistry.method_10223(robeId));
            this.method_5673(slot, robe);
            this.guardInventory.method_5447(invIndex, robe);
            if (this.method_37908().method_8608()) continue;
            ((class_3218)this.method_37908()).method_14178().method_18751((class_1297)this, (class_2596)new class_2744(this.method_5628(), List.of(new Pair((Object)slot, (Object)robe))));
        }
    }

    public boolean isWindingUpSpell() {
        return this.isCastingSpell() && this.method_6030().method_7960();
    }

    protected class_4048 method_55694(class_4050 pose) {
        return SIZE_BY_POSE.getOrDefault(pose, class_4048.method_18384((float)0.6f, (float)1.95f));
    }

    protected void method_6090(class_1309 entityIn) {
        super.method_6090(entityIn);
        if (entityIn.method_6047().method_7909() instanceof class_1743) {
            this.disableShield(true, entityIn.method_6047().method_7909());
        }
    }

    public void method_6056(float amount) {
        if (this.field_6277.method_7909() == class_1802.field_8255 && amount >= 3.0f) {
            int i = 1 + class_3532.method_15375((float)amount);
            class_1268 hand = this.method_6058();
            this.field_6277.method_7970(i, (class_1309)this, class_1304.field_6171);
            if (this.field_6277.method_7960()) {
                if (hand == class_1268.field_5808) {
                    this.method_5673(class_1304.field_6173, class_1799.field_8037);
                } else {
                    this.method_5673(class_1304.field_6171, class_1799.field_8037);
                }
                this.field_6277 = class_1799.field_8037;
                this.method_5783(class_3417.field_15239, 0.8f, 0.8f + this.method_37908().field_9229.method_43057() * 0.4f);
            }
        }
    }

    public void method_6019(class_1268 hand) {
        super.method_6019(hand);
        class_1799 itemstack = this.method_5998(hand);
        if (itemstack.method_7909() == class_1802.field_8255) {
            class_1324 modifiableattributeinstance = this.method_5996(class_5134.field_23719);
            modifiableattributeinstance.method_6202(USE_ITEM_SPEED_PENALTY);
            modifiableattributeinstance.method_26835(USE_ITEM_SPEED_PENALTY);
        }
    }

    public void method_6075() {
        super.method_6075();
        if (this.method_5996(class_5134.field_23719).method_6196(USE_ITEM_SPEED_PENALTY.comp_2447())) {
            this.method_5996(class_5134.field_23719).method_6202(USE_ITEM_SPEED_PENALTY);
        }
    }

    public void disableShield(boolean increase, class_1792 item) {
        float chance = 0.25f;
        if (increase) {
            chance = (float)((double)chance + 0.75);
        }
        if (this.field_5974.method_43057() < chance) {
            this.shieldCoolDown = 100;
            this.method_6075();
            this.method_37908().method_8421((class_1297)this, (byte)30);
        }
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(GUARD_VARIANT, (Object)0);
        builder.method_56912(DATA_CHARGING_STATE, (Object)false);
        builder.method_56912(KICKING, (Object)false);
        builder.method_56912(OWNER_UNIQUE_ID, Optional.empty());
        builder.method_56912(FOLLOWING, (Object)false);
        builder.method_56912(GUARD_POS, Optional.empty());
        builder.method_56912(PATROLLING, (Object)false);
        builder.method_56912(RUNNING_TO_EAT, (Object)false);
        builder.method_56912(BOW_SKILL, (Object)"none");
        builder.method_56912(HOLY_SKILL, (Object)"none");
        super.method_5693(builder);
    }

    public String getHolySkill() {
        return (String)this.field_6011.method_12789(HOLY_SKILL);
    }

    public void setHolySkill(String skill) {
        this.field_6011.method_12778(HOLY_SKILL, (Object)skill);
    }

    public boolean isCharging() {
        return (Boolean)this.field_6011.method_12789(DATA_CHARGING_STATE);
    }

    public void setChargingCrossbowGuard(boolean charging) {
        this.field_6011.method_12778(DATA_CHARGING_STATE, (Object)charging);
    }

    public boolean isKicking() {
        return (Boolean)this.field_6011.method_12789(KICKING);
    }

    public void setKicking(boolean kicking) {
        this.field_6011.method_12778(KICKING, (Object)kicking);
    }

    protected void method_5964(class_5819 random, class_1266 localDifficulty) {
        this.field_6187[class_1304.field_6173.method_5927()] = 100.0f;
        this.field_6187[class_1304.field_6171.method_5927()] = 100.0f;
        this.spawnWithArmor = true;
    }

    public List<class_1799> getStacksFromLootTable(class_1304 slot, class_3218 serverWorld) {
        if (EQUIPMENT_SLOT_ITEMS.containsKey(slot)) {
            class_52 loot = serverWorld.method_8503().method_58576().method_58295(EQUIPMENT_SLOT_ITEMS.get(slot));
            class_8567.class_8568 lootcontext$builder = new class_8567.class_8568((class_3218)this.method_37908()).method_51874(class_181.field_1226, (Object)this);
            return loot.method_51878(lootcontext$builder.method_51875(GuardEntityLootTables.SLOT));
        }
        return List.of();
    }

    public int getGuardEntityVariant() {
        return (Integer)this.field_6011.method_12789(GUARD_VARIANT);
    }

    public void setGuardEntityVariant(int typeId) {
        this.field_6011.method_12778(GUARD_VARIANT, (Object)typeId);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(0, (class_1352)new KickGoal(this));
        this.field_6201.method_6277(0, (class_1352)new GuardEatFoodGoal(this));
        this.field_6201.method_6277(0, (class_1352)new RaiseShieldGoal(this));
        this.field_6201.method_6277(1, (class_1352)new GuardRunToEatGoal(this));
        this.field_6201.method_6277(1, (class_1352)new MeleeRetreatForHealingGoal(this, 1.1));
        this.field_6201.method_6277(2, new RangedCrossbowAttackPassiveGoal<GuardEntity>(this, 1.0, 8.0f));
        this.field_6201.method_6277(2, (class_1352)new GuardCastSpellGoal(this));
        this.field_6201.method_6277(2, (class_1352)new PriestRangedHealerGoal(this));
        this.field_6201.method_6277(2, (class_1352)new RangedBowAttackPassiveGoal<GuardEntity>(this, 0.5, 20, 15.0f){

            @Override
            public boolean method_6264() {
                return GuardEntity.this.method_5968() != null && this.isBowInMainhand() && !GuardEntity.this.isEating() && !GuardEntity.this.method_6039();
            }

            protected boolean isBowInMainhand() {
                return GuardEntity.this.method_6047().method_7909() instanceof class_1753;
            }

            @Override
            public void method_6268() {
                super.method_6268();
                if (GuardEntity.this.isPatrolling()) {
                    GuardEntity.this.method_5942().method_6340();
                    GuardEntity.this.method_5962().method_6243(0.0f, 0.0f);
                }
            }

            @Override
            public boolean method_6266() {
                return (this.method_6264() || !GuardEntity.this.method_5942().method_6357()) && this.isBowInMainhand();
            }
        });
        this.field_6201.method_6277(2, (class_1352)new GuardEntityMeleeGoal(this, 0.8, true));
        this.field_6201.method_6277(3, (class_1352)new FollowHeroGoal(this));
        this.field_6201.method_6277(3, (class_1352)new HolyAreaAnchorGoal(this, 1.1, HolyAreaAnchorGoal.rangedOrCaster()));
        if (GuardVillagersConfig.guardEntitysRunFromPolarBears) {
            this.field_6201.method_6277(3, (class_1352)new class_1338((class_1314)this, class_1456.class, 12.0f, 1.0, 1.2));
        }
        this.field_6201.method_6277(3, (class_1352)new class_4291((class_1314)this, 0.5, false));
        this.field_6201.method_6277(3, (class_1352)new class_5274((class_1314)this, 0.5));
        this.field_6201.method_6277(3, (class_1352)new class_1368((class_1314)this, 0.5, false, 4, () -> false));
        if (GuardVillagersConfig.guardEntitysOpenDoors) {
            this.field_6201.method_6277(3, (class_1352)new GuardInteractDoorGoal(this, true));
        }
        if (GuardVillagersConfig.guardEntityFormation) {
            this.field_6201.method_6277(5, (class_1352)new FollowShieldGuards(this));
        }
        if (GuardVillagersConfig.clericHealing) {
            this.field_6201.method_6277(6, (class_1352)new RunToClericGoal(this));
        }
        if (GuardVillagersConfig.armorerRepairGuardEntityArmor) {
            this.field_6201.method_6277(6, (class_1352)new ArmorerRepairGuardArmorGoal(this));
        }
        this.field_6201.method_6277(4, (class_1352)new WalkBackToCheckPointGoal(this, 0.5));
        this.field_6201.method_6277(5, (class_1352)new class_1394((class_1314)this, 0.5));
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_3988.class, 8.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(8, (class_1352)new GuardLookAtAndStopMovingWhenBeingTheInteractionTarget(this));
        this.field_6185.method_6277(5, (class_1352)new DefendVillageGuardEntityGoal(this));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1584.class, true));
        this.field_6185.method_6277(2, (class_1352)new class_1399((class_1314)this, new Class[]{GuardEntity.class, class_1439.class}).method_6318(new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1640.class, true));
        this.field_6185.method_6277(3, (class_1352)new HeroHurtByTargetGoal(this));
        this.field_6185.method_6277(3, (class_1352)new HeroHurtTargetGoal(this));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_3763.class, true));
        if (GuardVillagersConfig.attackAllMobs) {
            this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1308.class, 5, true, true, mob -> mob instanceof class_1569 && !GuardVillagersConfig.mobBlackList.contains(mob.method_5653())));
        }
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1657.class, 10, true, false, arg_0 -> ((GuardEntity)this).method_29515(arg_0)));
        this.field_6185.method_6277(4, (class_1352)new class_1400((class_1308)this, class_1642.class, true));
        this.field_6185.method_6277(4, (class_1352)new class_5398((class_1308)this, false));
    }

    public boolean method_5931() {
        return false;
    }

    public void method_7105(class_1309 target, float pullProgress) {
        class_7225.class_7226 registry;
        int powerLevel;
        this.shieldCoolDown = 8;
        class_1792 class_17922 = this.method_6047().method_7909();
        if (class_17922 instanceof class_1764) {
            class_1764 crossbowItem = (class_1764)class_17922;
            class_1799 crossbow = this.method_6047();
            if (!class_1764.method_7781((class_1799)crossbow)) {
                class_1799 ammo = this.method_18808(crossbow);
                if (ammo.method_7960()) {
                    ammo = new class_1799((class_1935)class_1802.field_8107);
                }
                crossbow.method_57379(class_9334.field_49649, (Object)class_9278.method_57441(List.of(ammo.method_46651(1))));
            }
            crossbowItem.method_7777(this.method_37908(), (class_1309)this, class_1268.field_5808, crossbow, 3.15f, 1.0f, target);
            return;
        }
        if (!(this.method_6047().method_7909() instanceof class_1753)) {
            return;
        }
        class_1268 hand = null;
        class_1799 weapon = class_1799.field_8037;
        for (class_1268 h : class_1268.values()) {
            class_1799 stack = this.method_5998(h);
            if (!(stack.method_7909() instanceof class_1753)) continue;
            hand = h;
            weapon = stack;
            break;
        }
        if (hand == null || !(weapon.method_7909() instanceof class_1753)) {
            return;
        }
        class_1799 arrow = this.method_18808(weapon);
        if (arrow.method_7960()) {
            arrow = new class_1799((class_1935)class_1802.field_8107);
        }
        class_9304 enchantments = class_1890.method_57532((class_1799)weapon);
        class_1665 projectile = class_1675.method_18813((class_1309)this, (class_1799)arrow, (float)pullProgress, (class_1799)weapon);
        double rangedDamage = 0.0;
        Optional rangedAttrEntryOpt = class_7923.field_41190.method_55841(class_2960.method_60655((String)"ranged_weapon", (String)"damage"));
        if (rangedAttrEntryOpt.isPresent()) {
            class_6880 rangedAttrEntry = (class_6880)rangedAttrEntryOpt.get();
            if (this.method_6127().method_45331(rangedAttrEntry)) {
                rangedDamage = this.method_45325(rangedAttrEntry);
            }
        }
        if ((powerLevel = enchantments.method_57536((class_6880)(registry = this.method_56673().method_46762(class_7924.field_41265)).method_46747(class_1893.field_9103))) > 0) {
            projectile.method_7438(projectile.method_7448() + (double)powerLevel * 0.5 + 0.5);
        }
        projectile.method_7438(projectile.method_7448() + rangedDamage / 3.0);
        int punchLevel = enchantments.method_57536((class_6880)registry.method_46747(class_1893.field_9116));
        if (punchLevel > 0) {
            // empty if block
        }
        if (enchantments.method_57536((class_6880)registry.method_46747(class_1893.field_9126)) > 0) {
            projectile.method_20803(100);
        }
        double dx = target.method_23317() - this.method_23317();
        double dy = target.method_23323(0.3333333333333333) - projectile.method_23318();
        double dz = target.method_23321() - this.method_23321();
        double dist = Math.sqrt(dx * dx + dz * dz);
        projectile.method_7485(dx, dy + dist * 0.2, dz, 1.6f, (float)(14 - this.method_37908().method_8407().method_5461() * 4));
        this.method_5783(class_3417.field_14633, 1.0f, 1.0f / (this.method_59922().method_43057() * 0.4f + 0.8f));
        this.method_37908().method_8649((class_1297)projectile);
        weapon.method_7970(1, (class_1309)this, class_1304.field_6173);
    }

    public void method_5673(class_1304 slotIn, class_1799 stack) {
        super.method_5673(slotIn, stack);
        switch (slotIn) {
            case field_6174: {
                if (!this.guardInventory.method_5438(1).method_7960()) break;
                this.guardInventory.method_5447(1, (class_1799)this.field_6205.get(slotIn.method_5927()));
                break;
            }
            case field_6166: {
                if (!this.guardInventory.method_5438(3).method_7960()) break;
                this.guardInventory.method_5447(3, (class_1799)this.field_6205.get(slotIn.method_5927()));
                break;
            }
            case field_6169: {
                if (!this.guardInventory.method_5438(0).method_7960()) break;
                this.guardInventory.method_5447(0, (class_1799)this.field_6205.get(slotIn.method_5927()));
                break;
            }
            case field_6172: {
                if (!this.guardInventory.method_5438(2).method_7960()) break;
                this.guardInventory.method_5447(2, (class_1799)this.field_6205.get(slotIn.method_5927()));
                break;
            }
            case field_6173: {
                this.guardInventory.method_5447(5, (class_1799)this.field_6195.get(slotIn.method_5927()));
                break;
            }
            case field_6171: {
                this.guardInventory.method_5447(4, (class_1799)this.field_6195.get(slotIn.method_5927()));
            }
        }
    }

    public int getGuardVariant() {
        return (Integer)this.field_6011.method_12789(GUARD_VARIANT);
    }

    public class_1799 method_18808(class_1799 shootable) {
        if (shootable.method_7909() instanceof class_1811) {
            Predicate predicate = ((class_1811)shootable.method_7909()).method_20310();
            class_1799 itemstack = class_1811.method_18815((class_1309)this, (Predicate)predicate);
            return itemstack.method_7960() ? new class_1799((class_1935)class_1802.field_8107) : itemstack;
        }
        return class_1799.field_8037;
    }

    public int getKickTicks() {
        return this.kickTicks;
    }

    public boolean isFollowing() {
        return (Boolean)this.field_6011.method_12789(FOLLOWING);
    }

    public void setFollowing(boolean following) {
        this.field_6011.method_12778(FOLLOWING, (Object)following);
    }

    public boolean method_18395(class_1309 target) {
        return !GuardVillagersConfig.mobBlackList.contains(target.method_5653()) && !target.method_6059(class_1294.field_18980) && !this.isOwner(target) && !(target instanceof class_1646) && !(target instanceof class_1439) && !(target instanceof GuardEntity) && super.method_18395(target);
    }

    public void method_5842() {
        super.method_5842();
        class_1297 class_12972 = this.method_5854();
        if (class_12972 instanceof class_1314) {
            class_1314 creatureentity = (class_1314)class_12972;
            this.field_6283 = creatureentity.field_6283;
        }
    }

    public void method_24651() {
        this.field_6278 = 0;
    }

    public void method_5980(class_1309 entity) {
        if (entity instanceof GuardEntity || entity instanceof class_1646 || entity instanceof class_1439) {
            return;
        }
        super.method_5980(entity);
    }

    public void gossip(class_1646 villager, long gameTime) {
        if (!(gameTime >= this.lastGossipTime && gameTime < this.lastGossipTime + 1200L || gameTime >= villager.field_18535 && gameTime < villager.field_18535 + 1200L)) {
            this.gossips.method_19061(villager.method_21651(), this.field_5974, 10);
            this.lastGossipTime = gameTime;
            villager.field_18535 = gameTime;
        }
    }

    public void method_7110(boolean charging) {
        this.setChargingCrossbowGuard(charging);
    }

    public void method_6060(class_1309 entityIn) {
        if (this.isKicking()) {
            this.setKicking(false);
        }
        super.method_6060((class_1309)this);
    }

    protected class_1269 method_5992(class_1657 player, class_1268 hand) {
        boolean inventoryRequirements;
        boolean configValues = player.method_6059(class_1294.field_18980) && GuardVillagersConfig.giveGuardStuffHotv || player.method_6059(class_1294.field_18980) && GuardVillagersConfig.setGuardPatrolHotv || player.method_6059(class_1294.field_18980) && GuardVillagersConfig.giveGuardStuffHotv && GuardVillagersConfig.setGuardPatrolHotv || this.getPlayerEntityReputation(player) >= GuardVillagersConfig.reputationRequirement || player.method_6059(class_1294.field_18980) && !GuardVillagersConfig.giveGuardStuffHotv && !GuardVillagersConfig.setGuardPatrolHotv || this.getOwnerId() != null && this.getOwnerId().equals(player.method_5667());
        boolean bl = inventoryRequirements = !player.method_21823();
        if (inventoryRequirements) {
            if (this.method_5968() != player && this.method_6034() && configValues && player instanceof class_3222) {
                this.openGui((class_3222)player);
                return class_1269.field_5812;
            }
            return class_1269.field_21466;
        }
        return super.method_5992(player, hand);
    }

    public void method_18870(class_4151 interaction, class_1297 entity) {
    }

    public void method_5453(class_1263 sender) {
    }

    public void method_6105(class_1282 damageSource, float damage) {
        if (damage >= 0.0f) {
            if ((damage /= 4.0f) < 1.0f) {
                damage = 1.0f;
            }
            for (int i = 0; i < this.guardInventory.method_5439(); ++i) {
                class_1799 itemstack = this.guardInventory.method_5438(i);
                if (damageSource.method_49708(class_8111.field_42337) && itemstack.method_7909().method_57347().method_57832(class_9334.field_50076) || !(itemstack.method_7909() instanceof class_1738)) continue;
                int j = i;
                List<class_1304> list = Arrays.stream(class_1304.values()).filter(class_1304::method_46643).toList();
                itemstack.method_7970((int)damage, (class_1309)this, list.get(j));
            }
        }
    }

    public void method_5800(class_3218 world, class_1538 lightning) {
        if (world.method_8407() != class_1267.field_5801) {
            class_1640 witchentity = (class_1640)class_1299.field_6145.method_5883((class_1937)world);
            if (witchentity == null) {
                return;
            }
            witchentity.method_5719((class_1297)this);
            witchentity.method_5943((class_5425)world, world.method_8404(witchentity.method_24515()), class_3730.field_16468, null);
            witchentity.method_5977(this.method_5987());
            witchentity.method_5665(this.method_5797());
            witchentity.method_5880(this.method_5807());
            witchentity.method_5971();
            world.method_30736((class_1297)witchentity);
            this.method_31472();
        } else {
            super.method_5800(world, lightning);
        }
    }

    public UUID method_29508() {
        return this.persistentAngerTarget;
    }

    public void method_29513(UUID arg0) {
        this.persistentAngerTarget = arg0;
    }

    public int method_29507() {
        return this.remainingPersistentAngerTime;
    }

    public void method_29514(int arg0) {
        this.remainingPersistentAngerTime = arg0;
    }

    public void method_29509() {
        this.method_29514(angerTime.method_35008(this.field_5974));
    }

    public void openGui(class_3222 player) {
        this.setOwnerId(player.method_5667());
        if (player.field_7512 != player.field_7498) {
            player.method_7346();
        }
        this.interacting = true;
        if (!this.method_37908().method_8608()) {
            player.method_17355((class_3908)new GuardScreenHandlerFactory());
        }
    }

    public void setGuardVariant(int i) {
        this.field_6011.method_12778(GUARD_VARIANT, (Object)i);
    }

    public boolean isEating() {
        return GuardEatFoodGoal.isConsumable(this.method_6030()) && this.method_6115();
    }

    public boolean isPatrolling() {
        return (Boolean)this.field_6011.method_12789(PATROLLING);
    }

    public void setPatrolling(boolean patrolling) {
        this.field_6011.method_12778(PATROLLING, (Object)patrolling);
    }

    public boolean method_25938(class_1811 item) {
        return item instanceof class_1753 || item instanceof class_1764 || super.method_25938(item);
    }

    public boolean isHoldingHolyFocus() {
        class_1799 s = this.method_6047();
        if (s.method_7960()) {
            return false;
        }
        class_2960 id = class_7923.field_41178.method_10221((Object)s.method_7909());
        if (!"paladins".equals(id.method_12836())) {
            return false;
        }
        String p = id.method_12832();
        return p.equals("acolyte_wand") || p.equals("holy_wand") || p.equals("holy_staff") || p.endsWith("_holy_wand") || p.endsWith("_holy_staff");
    }

    public boolean isPriest() {
        return this.isHoldingHolyFocus();
    }

    public boolean hasFoodInOffhand() {
        class_1799 off = this.method_6079();
        if (off.method_7960()) {
            return false;
        }
        class_4174 food = (class_4174)off.method_57824(class_9334.field_50075);
        if (food != null) {
            return true;
        }
        return off.method_7976() == class_1839.field_8950;
    }

    public static class GuardEntityData
    implements class_1315 {
        public final int variantData;

        public GuardEntityData(int type) {
            this.variantData = type;
        }
    }

    public static class FollowHeroGoal
    extends class_1352 {
        public final GuardEntity guard;

        public FollowHeroGoal(GuardEntity mob) {
            this.guard = mob;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public void method_6268() {
            if (this.guard.getOwner() != null && (double)this.guard.getOwner().method_5739((class_1297)this.guard) > 3.0) {
                this.guard.method_5942().method_6335((class_1297)this.guard.getOwner(), 0.7);
                this.guard.method_5988().method_35111((class_1297)this.guard.getOwner());
            } else {
                this.guard.method_5942().method_6340();
            }
        }

        public boolean method_6266() {
            return this.method_6264();
        }

        public boolean method_6264() {
            return this.guard.isFollowing() && this.guard.getOwner() != null;
        }

        public void method_6270() {
            this.guard.method_5942().method_6340();
        }
    }

    public static class DefendVillageGuardEntityGoal
    extends class_1405 {
        private final GuardEntity guard;
        private class_1309 villageAggressorTarget;

        public DefendVillageGuardEntityGoal(GuardEntity guardIn) {
            super((class_1308)guardIn, false, true);
            this.guard = guardIn;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18408, class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            class_238 box = this.guard.method_5829().method_1009(10.0, 8.0, 10.0);
            List list = this.guard.method_37908().method_18467(class_1646.class, box);
            List list1 = this.guard.method_37908().method_18467(class_1657.class, box);
            for (class_1646 villager : list) {
                for (class_1657 player : list1) {
                    int i = villager.method_20594(player);
                    if (i > GuardVillagersConfig.reputationRequirementToBeAttacked) continue;
                    this.villageAggressorTarget = player;
                }
            }
            return this.villageAggressorTarget != null && !this.villageAggressorTarget.method_6059(class_1294.field_18980) && !this.villageAggressorTarget.method_7325() && !((class_1657)this.villageAggressorTarget).method_7337();
        }

        public void method_6269() {
            this.guard.method_5980(this.villageAggressorTarget);
            super.method_6269();
        }
    }

    private class GuardScreenHandlerFactory
    implements ExtendedScreenHandlerFactory {
        private GuardScreenHandlerFactory() {
        }

        private GuardEntity guard() {
            return GuardEntity.this;
        }

        public class_2561 method_5476() {
            return this.guard().method_5476();
        }

        public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
            class_1277 guardInv = this.guard().guardInventory;
            return new GuardVillagerScreenHandler(syncId, inv, (class_1263)guardInv, this.guard());
        }

        public Object getScreenOpeningData(class_3222 player) {
            return new GuardData(this.guard().method_5628());
        }
    }
}

