/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.guardvillagers.common.entity.goal;

import dev.sterner.guardvillagers.GuardVillagers;
import dev.sterner.guardvillagers.GuardVillagersConfig;
import dev.sterner.guardvillagers.common.ai.CombatMovementHelper;
import dev.sterner.guardvillagers.common.entity.GuardEntity;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_4802;
import net.minecraft.class_5532;
import net.minecraft.class_6019;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.fx.Sound;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.entity.SpellProjectile;
import net.spell_engine.internals.SpellHelper;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchool;

public class GuardCastSpellGoal
extends class_1352 {
    private static final class_6019 PATHFINDING_DELAY_RANGE = class_4802.method_24505((int)1, (int)2);
    private static final float ATTACK_RADIUS = 16.0f;
    private static final float ATTACK_RADIUS_SQR = 256.0f;
    private boolean isChanneled;
    private int channelTicksLeft;
    private final Map<class_2960, Integer> spellCooldowns = new HashMap<class_2960, Integer>();
    private int castingDelayTicks;
    private class_2960 currentSpellId;
    private class_6880<Spell> cachedSpellEntry;
    private boolean spellFired;
    private final GuardEntity guard;
    private int seeTime;
    private int updatePathDelay;
    private int windUpTicks;
    private int cooldownTicks;
    private SpellState spellState = SpellState.UNCHARGED;
    private double wantedX;
    private double wantedY;
    private double wantedZ;

    public GuardCastSpellGoal(GuardEntity guard) {
        this.guard = guard;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    private boolean isSpellOnCooldown(class_2960 spellId) {
        return this.spellCooldowns.getOrDefault(spellId, 0) > 0;
    }

    public boolean method_6264() {
        return this.isValidTarget() && this.isHoldingWand();
    }

    public boolean method_6266() {
        return this.isValidTarget() && (this.method_6264() || !this.guard.method_5942().method_6357()) && this.isHoldingWand();
    }

    public void method_6269() {
        this.guard.method_19540(true);
    }

    public void method_6270() {
        this.guard.method_19540(false);
        this.guard.setCastingSpell(false);
        this.guard.method_6075();
        this.guard.method_5942().method_6340();
        this.spellState = SpellState.UNCHARGED;
        this.seeTime = 0;
        this.cachedSpellEntry = null;
    }

    private float getCooldownMultiplier(class_2960 spellId) {
        String key = this.guard.method_6047().method_7909().method_7876();
        if (key.contains("staff_ruby_fire") && spellId.method_12832().equals("twin_fireball") || key.contains("staff_smaragdant_frost") && spellId.method_12832().equals("twin_frostshard") || key.contains("staff_crystal_arcane") && spellId.method_12832().equals("twin_arcanebolt")) {
            return 0.33f;
        }
        return 1.0f;
    }

    public void method_6268() {
        class_1309 target = this.guard.method_5968();
        if (target == null || !target.method_5805()) {
            return;
        }
        this.spellCooldowns.replaceAll((id, time) -> Math.max(time - 1, 0));
        boolean hasSeenRecently = this.seeTime > 0;
        boolean canSee = this.guard.method_5985().method_6369((class_1297)target);
        CombatMovementHelper.MovementResult mv = CombatMovementHelper.applyRangedCombatMovement(this.guard, target, canSee, this.seeTime, this.updatePathDelay, this.cooldownTicks, this.spellState == SpellState.CHARGING || this.spellState == SpellState.CHARGED || this.spellState == SpellState.COOLDOWN, this.canRun());
        this.seeTime = mv.seeTime();
        this.updatePathDelay = mv.updatePathDelay();
        if (this.friendlyInLineOfSight() && GuardVillagersConfig.friendlyFire) {
            this.spellState = SpellState.FIND_NEW_POSITION;
        }
        switch (this.spellState.ordinal()) {
            case 5: {
                this.guard.method_6075();
                this.guard.setCastingSpell(false);
                if (this.findPosition()) {
                    this.guard.method_5942().method_6337(this.wantedX, this.wantedY, this.wantedZ, this.guard.method_5715() ? 0.5 : 1.2);
                }
                this.spellState = SpellState.UNCHARGED;
                break;
            }
            case 0: {
                if (!hasSeenRecently) break;
                class_2960 spellId = this.getPrimarySpellId();
                if (spellId == null || this.isSpellOnCooldown(spellId)) {
                    return;
                }
                this.cachedSpellEntry = SpellRegistry.from((class_1937)this.guard.method_37908()).method_55841(spellId).orElse(null);
                if (this.cachedSpellEntry == null) {
                    return;
                }
                Spell spell = (Spell)this.cachedSpellEntry.comp_349();
                this.windUpTicks = this.getWindUpTicks(spell);
                this.currentSpellId = spellId;
                this.guard.method_6019(class_1268.field_5808);
                this.guard.setCastingSpell(true);
                this.spellState = SpellState.CHARGING;
                break;
            }
            case 1: {
                if (!this.guard.method_6115()) {
                    this.guard.method_6019(class_1268.field_5808);
                }
                --this.windUpTicks;
                if (this.windUpTicks > 0) break;
                this.spellState = SpellState.CHARGED;
                break;
            }
            case 2: {
                class_2960 spellId = this.getPrimarySpellId();
                if (spellId == null || this.isSpellOnCooldown(spellId)) {
                    return;
                }
                if (this.cachedSpellEntry == null) {
                    return;
                }
                Spell spell = (Spell)this.cachedSpellEntry.comp_349();
                this.currentSpellId = spellId;
                this.isChanneled = this.isSpellChanneled(spell);
                this.channelTicksLeft = this.getChannelDuration(spell);
                this.castingDelayTicks = 0;
                this.spellFired = false;
                this.spellState = SpellState.CASTING;
                break;
            }
            case 3: {
                class_2960 spellId = this.currentSpellId;
                if (this.currentSpellId == null || this.cachedSpellEntry == null) {
                    return;
                }
                Spell spell = (Spell)this.cachedSpellEntry.comp_349();
                if (this.isChanneled) {
                    if (this.channelTicksLeft > 0) {
                        if (this.channelTicksLeft == this.getChannelDuration(spell)) {
                            this.castSpellByWandType(spell, this.cachedSpellEntry, target);
                            this.castingDelayTicks = this.getChannelFireInterval(spell);
                            --this.channelTicksLeft;
                            break;
                        }
                        if (--this.castingDelayTicks <= 0) {
                            this.castSpellByWandType(spell, this.cachedSpellEntry, target);
                            this.castingDelayTicks = this.getChannelFireInterval(spell);
                        }
                        --this.channelTicksLeft;
                        break;
                    }
                    this.guard.method_6075();
                    int baseCooldown = this.getCooldownTicks(spell);
                    int modifiedCooldown = Math.max(1, (int)((float)baseCooldown * this.getCooldownMultiplier(spellId)));
                    this.spellCooldowns.put(spellId, modifiedCooldown);
                    this.spellState = SpellState.UNCHARGED;
                    this.guard.setCastingSpell(false);
                    break;
                }
                if (!this.spellFired) {
                    this.castSpellByWandType(spell, this.cachedSpellEntry, target);
                    this.spellFired = true;
                    break;
                }
                this.guard.method_6075();
                int baseCooldown = this.getCooldownTicks(spell);
                int modifiedCooldown = Math.max(1, (int)((float)baseCooldown * this.getCooldownMultiplier(spellId)));
                this.spellCooldowns.put(spellId, modifiedCooldown);
                this.spellState = SpellState.UNCHARGED;
                this.guard.setCastingSpell(false);
            }
        }
    }

    private int getWindUpTicks(Spell spell) {
        if (spell.active != null && spell.active.cast != null) {
            return (int)(spell.active.cast.duration * 20.0f);
        }
        return 20;
    }

    private boolean isSpellChanneled(Spell spell) {
        return spell.active != null && spell.active.cast != null && spell.active.cast.channel_ticks > 0;
    }

    private void castSpellByWandType(Spell spell, class_6880<Spell> spellEntry, class_1309 target) {
        String type = String.valueOf(spell.deliver.type).toUpperCase();
        if ("PROJECTILE".equals(type) && spell.deliver.projectile != null && spell.deliver.projectile.projectile != null) {
            SpellHelper.ImpactContext context = new SpellHelper.ImpactContext().power(SpellPower.getSpellPower((SpellSchool)spell.school, (class_1309)this.guard)).channeled(this.isChanneled ? 1.0f : 0.0f).position(this.guard.method_33571()).target(SpellHelper.focusMode((Spell)spell)).distance(1.0f);
            SpellHelper.shootProjectile((class_1937)this.guard.method_37908(), (class_1309)this.guard, (class_1297)target, spellEntry, (SpellHelper.ImpactContext)context, (int)(this.isChanneled ? (this.getChannelDuration(spell) - this.channelTicksLeft) / spell.active.cast.channel_ticks : 0));
            this.guard.method_23667(class_1268.field_5808, true);
        } else if ("METEOR".equals(type) || "AREA".equals(type)) {
            this.castAdvancedSpell(spell, spellEntry, target);
            this.guard.method_23667(class_1268.field_5808, true);
        } else if ("DIRECT".equals(type)) {
            class_2960 soundId;
            SpellHelper.ImpactContext context = new SpellHelper.ImpactContext().power(SpellPower.getSpellPower((SpellSchool)spell.school, (class_1309)this.guard)).channeled(this.isChanneled ? 1.0f : 0.0f).position(this.guard.method_33571()).target(SpellHelper.focusMode((Spell)spell)).distance(1.0f);
            SpellHelper.performImpacts((class_1937)this.guard.method_37908(), (class_1309)this.guard, (class_1297)target, (class_1297)this.guard, spellEntry, (List)spell.impacts, (SpellHelper.ImpactContext)context);
            this.guard.method_23667(class_1268.field_5808, true);
            if (spell.release != null && spell.release.sound != null && (soundId = class_2960.method_12829((String)spell.release.sound.id())) != null) {
                class_3414 soundEvent = (class_3414)class_7923.field_41172.method_10223(soundId);
                this.guard.method_37908().method_8396(null, this.guard.method_24515(), soundEvent, class_3419.field_15251, 1.0f, 1.0f);
            }
        } else {
            this.castBasicProjectile(target);
        }
    }

    private int getChannelDuration(Spell spell) {
        if (spell.active != null && spell.active.cast != null) {
            return (int)(spell.active.cast.duration * 20.0f);
        }
        return 0;
    }

    private boolean isValidTarget() {
        class_1309 target = this.guard.method_5968();
        return target != null && target.method_5805();
    }

    private boolean isHoldingWand() {
        String key = this.guard.method_6047().method_7909().method_7876();
        return key.contains("wand_") || key.contains("staff_") || key.contains("blade_");
    }

    private class_2960 getSpellIdForWand() {
        String key = this.guard.method_6047().method_7909().method_7876();
        if (key.contains("wand_fire") || key.contains("staff_fire")) {
            return class_2960.method_60655((String)"wizards", (String)"twin_fireball");
        }
        if (key.contains("wand_frost") || key.contains("staff_frost")) {
            return class_2960.method_60655((String)"wizards", (String)"twin_frostshard");
        }
        if (key.contains("wand_arcane") || key.contains("staff_arcane")) {
            return class_2960.method_60655((String)"wizards", (String)"twin_arcanebolt");
        }
        if (key.contains("wand_aqua") || key.contains("staff_aqua")) {
            return class_2960.method_60655((String)"elemental_wizards_rpg", (String)"twin_whip");
        }
        if (key.contains("wand_terra") || key.contains("staff_terra")) {
            return class_2960.method_60655((String)"elemental_wizards_rpg", (String)"twin_spear");
        }
        if (key.contains("wand_wind") || key.contains("staff_wind")) {
            return class_2960.method_60655((String)"elemental_wizards_rpg", (String)"twin_cutter");
        }
        if (key.contains("wand_netherite_fire") || key.contains("staff_netherite_fire") || key.contains("staff_ruby_fire")) {
            return class_2960.method_60655((String)"wizards", (String)"fire_meteor");
        }
        if (key.contains("wand_netherite_frost") || key.contains("staff_netherite_frost") || key.contains("staff_smaragdant_frost")) {
            return class_2960.method_60655((String)"wizards", (String)"frost_blizzard");
        }
        if (key.contains("wand_netherite_arcane") || key.contains("staff_netherite_arcane") || key.contains("staff_crystal_arcane")) {
            return class_2960.method_60655((String)"wizards", (String)"arcane_missile");
        }
        if (key.contains("wand_netherite_aqua") || key.contains("staff_netherite_aqua") || key.contains("staff_crystal_aqua")) {
            return class_2960.method_60655((String)"elemental_wizards_rpg", (String)"aqua_explosive_bubbles_channeling");
        }
        if (key.contains("wand_netherite_terra") || key.contains("staff_netherite_terra") || key.contains("staff_ruby_terra")) {
            return class_2960.method_60655((String)"elemental_wizards_rpg", (String)"terra_shattering_stone_channeling");
        }
        if (key.contains("wand_netherite_wind") || key.contains("staff_netherite_wind") || key.contains("staff_aeternium_wind")) {
            return class_2960.method_60655((String)"elemental_wizards_rpg", (String)"wind_aeroburst_channeling");
        }
        return null;
    }

    private class_2960[] getAdvancedAndBasicSpellIds() {
        boolean advancedAllowed;
        String key = this.guard.method_6047().method_7909().method_7876();
        boolean bl = advancedAllowed = key.contains("netherite") || key.contains("staff_ruby_fire") || key.contains("staff_smaragdant_frost") || key.contains("staff_crystal_arcane") || key.contains("staff_crystal_aqua") || key.contains("staff_ruby_terra") || key.contains("staff_aeternium_wind");
        if (key.contains("fire")) {
            return new class_2960[]{advancedAllowed ? class_2960.method_60655((String)"wizards", (String)"fire_meteor") : null, class_2960.method_60655((String)"wizards", (String)"twin_fireball")};
        }
        if (key.contains("frost")) {
            return new class_2960[]{advancedAllowed ? class_2960.method_60655((String)"wizards", (String)"frost_blizzard") : null, class_2960.method_60655((String)"wizards", (String)"twin_frostshard")};
        }
        if (key.contains("arcane")) {
            return new class_2960[]{advancedAllowed ? class_2960.method_60655((String)"wizards", (String)"arcane_missile") : null, class_2960.method_60655((String)"wizards", (String)"twin_arcanebolt")};
        }
        if (key.contains("aqua")) {
            return new class_2960[]{advancedAllowed ? class_2960.method_60655((String)"elemental_wizards_rpg", (String)"aqua_explosive_bubbles_channeling") : null, class_2960.method_60655((String)"elemental_wizards_rpg", (String)"twin_whip")};
        }
        if (key.contains("terra")) {
            return new class_2960[]{advancedAllowed ? class_2960.method_60655((String)"elemental_wizards_rpg", (String)"terra_shattering_stone_channeling") : null, class_2960.method_60655((String)"elemental_wizards_rpg", (String)"twin_spear")};
        }
        if (key.contains("wind")) {
            return new class_2960[]{advancedAllowed ? class_2960.method_60655((String)"elemental_wizards_rpg", (String)"wind_aeroburst_channeling") : null, class_2960.method_60655((String)"elemental_wizards_rpg", (String)"twin_cutter")};
        }
        return new class_2960[]{null, null};
    }

    private class_2960 getPrimarySpellId() {
        class_2960[] spellIds = this.getAdvancedAndBasicSpellIds();
        class_2960 advanced = spellIds[0];
        class_2960 basic = spellIds[1];
        if (advanced != null && !this.isSpellOnCooldown(advanced)) {
            return advanced;
        }
        if (basic != null && !this.isSpellOnCooldown(basic)) {
            return basic;
        }
        return null;
    }

    private int getChannelFireInterval(Spell spell) {
        if (spell.active != null && spell.active.cast != null && spell.active.cast.channel_ticks > 0) {
            return spell.active.cast.channel_ticks;
        }
        return 6;
    }

    private void castBasicProjectile(class_1309 target) {
        class_2960 soundId;
        class_2960 spellId = this.currentSpellId;
        if (spellId == null) {
            return;
        }
        class_1937 world = this.guard.method_37908();
        class_6880 spellEntry = SpellRegistry.from((class_1937)world).method_55841(spellId).orElse(null);
        if (spellEntry == null) {
            return;
        }
        Spell spell = (Spell)spellEntry.comp_349();
        Spell.Delivery deliver = spell.deliver;
        if (deliver == null || deliver.projectile == null || deliver.projectile.projectile == null) {
            return;
        }
        Spell.ProjectileData.Perks perks = deliver.projectile.projectile.perks != null ? deliver.projectile.projectile.perks.copy() : new Spell.ProjectileData.Perks();
        SpellHelper.ImpactContext context = new SpellHelper.ImpactContext().power(SpellPower.getSpellPower((SpellSchool)spell.school, (class_1309)this.guard));
        class_243 spawnPos = this.guard.method_33571();
        class_243 direction = target.method_33571().method_1020(spawnPos).method_1029().method_1021(1.25);
        SpellProjectile projectile = new SpellProjectile(world, (class_1309)this.guard, spawnPos.field_1352, spawnPos.field_1351, spawnPos.field_1350, SpellProjectile.Behaviour.FLY, spellEntry, context, perks);
        projectile.method_18799(direction);
        projectile.range = 64.0f;
        world.method_8649((class_1297)projectile);
        Sound sound = deliver.projectile.launch_properties.sound;
        if (sound != null && (soundId = class_2960.method_12829((String)sound.id())) != null) {
            class_3414 soundEvent = (class_3414)class_7923.field_41172.method_10223(soundId);
            world.method_8396(null, this.guard.method_24515(), soundEvent, class_3419.field_15251, 1.0f, 1.0f);
        }
    }

    private void castAdvancedSpell(Spell spell, class_6880<Spell> spellEntry, class_1309 target) {
        class_2960 soundId;
        SpellHelper.ImpactContext context = new SpellHelper.ImpactContext().power(SpellPower.getSpellPower((SpellSchool)spell.school, (class_1309)this.guard));
        Spell.Delivery deliver = spell.deliver;
        if (deliver == null) {
            return;
        }
        if ("METEOR".equalsIgnoreCase(String.valueOf(deliver.type))) {
            class_243 targetPos = target.method_19538();
            SpellHelper.fallProjectile((class_1937)this.guard.method_37908(), (class_1309)this.guard, (class_1297)target, (class_243)targetPos, spellEntry, (SpellHelper.ImpactContext)context);
        } else if ("PROJECTILE".equalsIgnoreCase(String.valueOf(deliver.type))) {
            this.castBasicProjectile(target);
        }
        if (spell.release != null && spell.release.sound != null && (soundId = class_2960.method_12829((String)spell.release.sound.id())) != null) {
            class_3414 soundEvent = (class_3414)class_7923.field_41172.method_10223(soundId);
            this.guard.method_37908().method_8396(null, this.guard.method_24515(), soundEvent, class_3419.field_15251, 1.0f, 1.0f);
        }
    }

    private int getCooldownTicks(Spell spell) {
        if (spell.cost != null && spell.cost.cooldown != null) {
            return (int)(spell.cost.cooldown.duration * 20.0f);
        }
        if (spell.active != null && spell.active.cast != null) {
            return (int)(spell.active.cast.duration * 20.0f);
        }
        return 20;
    }

    private boolean friendlyInLineOfSight() {
        List nearby = this.guard.method_37908().method_8335((class_1297)this.guard, this.guard.method_5829().method_1014(5.0));
        for (class_1297 entity : nearby) {
            boolean isFriendly;
            if (entity == this.guard.method_5968() || !(isFriendly = entity.method_5864() == class_1299.field_6077 || entity.method_5864() == GuardVillagers.GUARD_VILLAGER || entity.method_5864() == class_1299.field_6147 || entity == this.guard.getOwner()) || !this.guard.method_6057(entity) || !((double)this.guard.method_5739(entity) <= 4.0)) continue;
            class_243 toFriend = entity.method_19538().method_1020(this.guard.method_19538()).method_1029();
            class_243 facing = this.guard.method_5720();
            if (!(facing.method_1026(toFriend) > 0.9)) continue;
            return true;
        }
        return false;
    }

    private boolean findPosition() {
        class_243 pos = this.getPosition();
        if (pos != null) {
            this.wantedX = pos.field_1352;
            this.wantedY = pos.field_1351;
            this.wantedZ = pos.field_1350;
            return true;
        }
        return false;
    }

    private class_243 getPosition() {
        return this.isValidTarget() ? class_5532.method_31511((class_1314)this.guard, (int)16, (int)7, (class_243)this.guard.method_5968().method_19538()) : class_5532.method_31510((class_1314)this.guard, (int)16, (int)7);
    }

    private boolean canRun() {
        return this.spellState == SpellState.UNCHARGED;
    }

    private static enum SpellState {
        UNCHARGED,
        CHARGING,
        CHARGED,
        CASTING,
        COOLDOWN,
        FIND_NEW_POSITION;

    }
}

