/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.guardvillagers.common.entity.goal;

import dev.sterner.guardvillagers.common.ai.HolyZoneHelper;
import dev.sterner.guardvillagers.common.entity.GuardEntity;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_4802;
import net.minecraft.class_6019;
import net.minecraft.class_6335;

public class HolyAreaAnchorGoal
extends class_1352 {
    private static final double DEFAULT_SEARCH_RANGE = 32.0;
    private static final class_6019 PATH_DELAY = class_4802.method_24505((int)1, (int)2);
    private final GuardEntity guard;
    private final double speed;
    private final double searchRange;
    private final Predicate<GuardEntity> shouldRun;
    private class_6335 zoneRef;
    private float zoneRadius;
    private UUID zoneId;
    private boolean anchoredForThisZone;
    private boolean computedAnchor;
    private class_243 anchorPos;
    private int updatePathDelay;
    private int stuckTicks;
    private int lastProgressCheckTick;
    private class_243 lastProgressPos;

    public HolyAreaAnchorGoal(GuardEntity guard, double speed, double searchRange, Predicate<GuardEntity> shouldRun) {
        this.guard = guard;
        this.speed = speed;
        this.searchRange = searchRange;
        this.shouldRun = shouldRun;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public HolyAreaAnchorGoal(GuardEntity guard, double speed, Predicate<GuardEntity> shouldRun) {
        this(guard, speed, 32.0, shouldRun);
    }

    public boolean method_6264() {
        if (this.guard.method_31481() || !this.guard.method_5805()) {
            return false;
        }
        if (this.shouldRun != null && !this.shouldRun.test(this.guard)) {
            return false;
        }
        class_6335 zone = HolyZoneHelper.findNearby(this.guard, this.searchRange);
        if (zone == null) {
            return false;
        }
        UUID id = zone.method_5667();
        if (this.zoneId != null && Objects.equals(this.zoneId, id) && this.anchoredForThisZone) {
            return false;
        }
        this.zoneRef = zone;
        this.zoneRadius = HolyZoneHelper.radiusOf(zone, 5.0f);
        this.zoneId = id;
        return true;
    }

    public boolean method_6266() {
        if (this.guard.method_31481() || !this.guard.method_5805()) {
            return false;
        }
        if (this.zoneRef == null || !this.zoneRef.method_5805()) {
            return false;
        }
        return !this.anchoredForThisZone;
    }

    public void method_6269() {
        this.updatePathDelay = 0;
        this.stuckTicks = 0;
        this.computedAnchor = false;
        this.anchorPos = null;
        this.lastProgressCheckTick = 0;
        this.lastProgressPos = this.guard.method_19538();
    }

    public void method_6270() {
        this.guard.method_5942().method_6340();
    }

    public void method_6268() {
        if (this.zoneRef == null || !this.zoneRef.method_5805()) {
            this.anchoredForThisZone = true;
            return;
        }
        boolean inside = HolyZoneHelper.inside(this.guard, this.zoneRef, this.zoneRadius);
        if (!inside) {
            class_1309 tgt;
            if (--this.updatePathDelay <= 0) {
                HolyZoneHelper.steerTowardsIfOutside(this.guard, this.zoneRef, this.zoneRadius, this.speed);
                this.updatePathDelay = PATH_DELAY.method_35008(this.guard.method_59922());
            }
            if ((tgt = this.guard.method_5968()) != null) {
                this.guard.method_5951((class_1297)tgt, 30.0f, 30.0f);
            } else {
                class_243 c = this.zoneRef.method_19538();
                this.guard.method_5988().method_20248(c.field_1352, c.field_1351, c.field_1350);
            }
            this.progressWatchdog();
            return;
        }
        if (!this.computedAnchor) {
            this.anchorPos = this.computeBestAnchor(this.zoneRef, this.zoneRadius);
            this.computedAnchor = true;
            if (this.anchorPos != null) {
                this.guard.method_5942().method_6337(this.anchorPos.field_1352, this.anchorPos.field_1351, this.anchorPos.field_1350, this.speed);
            } else {
                this.anchoredForThisZone = true;
                this.guard.method_5942().method_6340();
                return;
            }
        }
        if (this.anchorPos != null) {
            double dist2 = this.guard.method_19538().method_1025(this.anchorPos);
            if (dist2 <= 1.0) {
                this.anchoredForThisZone = true;
                this.guard.method_5942().method_6340();
                return;
            }
            if (--this.updatePathDelay <= 0) {
                this.guard.method_5942().method_6337(this.anchorPos.field_1352, this.anchorPos.field_1351, this.anchorPos.field_1350, this.speed);
                this.updatePathDelay = PATH_DELAY.method_35008(this.guard.method_59922());
            }
            this.progressWatchdog();
        }
    }

    private void progressWatchdog() {
        int age = this.guard.field_6012;
        if (this.lastProgressCheckTick == 0) {
            this.lastProgressCheckTick = age;
            this.lastProgressPos = this.guard.method_19538();
            return;
        }
        if (age - this.lastProgressCheckTick >= 20) {
            double moved2 = this.guard.method_19538().method_1025(this.lastProgressPos);
            this.stuckTicks = moved2 < 0.05 ? (this.stuckTicks += 20) : Math.max(0, this.stuckTicks - 10);
            this.lastProgressCheckTick = age;
            this.lastProgressPos = this.guard.method_19538();
        }
        if (this.stuckTicks > 80) {
            this.anchoredForThisZone = true;
            this.guard.method_5942().method_6340();
        }
    }

    private class_243 computeBestAnchor(class_6335 zone, float radius) {
        class_243 center = zone.method_19538();
        double anchorY = this.guard.method_23318();
        double margin = 0.75;
        class_243[] seeds = new class_243[]{new class_243(center.field_1352, anchorY, center.field_1350), new class_243(center.field_1352 + 0.75, anchorY, center.field_1350), new class_243(center.field_1352 - 0.75, anchorY, center.field_1350), new class_243(center.field_1352, anchorY, center.field_1350 + 0.75), new class_243(center.field_1352, anchorY, center.field_1350 - 0.75), new class_243(center.field_1352 + 1.25, anchorY, center.field_1350 + 0.25), new class_243(center.field_1352 - 1.25, anchorY, center.field_1350 - 0.25), new class_243(center.field_1352 + 0.25, anchorY, center.field_1350 - 1.25), new class_243(center.field_1352 - 0.25, anchorY, center.field_1350 + 1.25)};
        double maxR2 = Math.max(0.0, ((double)radius - margin) * ((double)radius - margin));
        class_243 best = null;
        double bestD2 = Double.MAX_VALUE;
        for (class_243 p : seeds) {
            double d2;
            if (center.method_1025(p) > maxR2 || !this.isSpotFree(p) || !((d2 = center.method_1025(p)) < bestD2)) continue;
            bestD2 = d2;
            best = p;
        }
        if (best != null) {
            return best;
        }
        for (int ring = 1; ring <= 3; ++ring) {
            double step = 0.75;
            for (int dx = -ring; dx <= ring; ++dx) {
                for (int dz = -ring; dz <= ring; ++dz) {
                    double d2;
                    class_243 p;
                    if (Math.abs(dx) != ring && Math.abs(dz) != ring || center.method_1025(p = new class_243(center.field_1352 + (double)dx * step, anchorY, center.field_1350 + (double)dz * step)) > maxR2 || !this.isSpotFree(p) || !((d2 = center.method_1025(p)) < bestD2)) continue;
                    bestD2 = d2;
                    best = p;
                }
            }
            if (best != null) break;
        }
        return best;
    }

    private boolean isSpotFree(class_243 pos) {
        double w = this.guard.method_17681();
        double h = this.guard.method_17682();
        class_238 box = new class_238(pos.field_1352 - w * 0.5, pos.field_1351, pos.field_1350 - w * 0.5, pos.field_1352 + w * 0.5, pos.field_1351 + h, pos.field_1350 + w * 0.5);
        if (!this.guard.method_37908().method_18026(box)) {
            return false;
        }
        List others = this.guard.method_37908().method_8390(class_1309.class, box.method_1009(0.15, 0.0, 0.15), e -> e.method_5805() && e != this.guard);
        return others.isEmpty();
    }

    public static Predicate<GuardEntity> rangedOrCaster() {
        return g -> {
            String key = g.method_6047().method_7909().method_7876();
            boolean bowLike = key.contains("bow") || key.contains("crossbow");
            boolean wandLike = key.contains("wand_") || key.contains("staff_");
            boolean hasHoly = g.isHoldingHolyFocus();
            return bowLike || wandLike || hasHoly;
        };
    }
}

