/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.guardvillagers.common.entity.goal;

import dev.sterner.guardvillagers.common.ai.HolyZoneHelper;
import dev.sterner.guardvillagers.common.entity.GuardEntity;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_4050;
import net.minecraft.class_4802;
import net.minecraft.class_5532;
import net.minecraft.class_6019;
import net.minecraft.class_6335;
import net.minecraft.class_9334;

public class MeleeRetreatForHealingGoal
extends class_1352 {
    private int shieldHoldTicks = 0;
    private static final float TRIGGER_HP_FRACTION = 0.4f;
    private static final float RELEASE_HP_FRACTION = 0.7f;
    private static final double PRIEST_SEARCH_RANGE = 24.0;
    private static final double ZONE_SEARCH_RANGE = 32.0;
    private static final class_6019 PATH_DELAY = class_4802.method_24505((int)1, (int)2);
    private final GuardEntity guard;
    private final double speed;
    private int updatePathDelay;
    private int poseToggleDelay;
    private int progressCheckTick;
    private class_243 progressPos;
    private int stuckTicks;
    private class_6335 zoneRef;
    private float zoneRadius;
    private UUID zoneId;
    private class_243 zoneAnchor;

    public MeleeRetreatForHealingGoal(GuardEntity guard, double speed) {
        this.guard = guard;
        this.speed = speed;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        if (this.guard.method_31481() || !this.guard.method_5805()) {
            return false;
        }
        if (this.guard.isCastingSpell() || this.guard.isEating()) {
            return false;
        }
        if (this.hasFoodInOffhand()) {
            return false;
        }
        float hpFrac = this.guard.method_6032() / this.guard.method_6063();
        if (hpFrac > 0.4f) {
            return false;
        }
        return this.findNearestPriest(24.0) != null;
    }

    public boolean method_6266() {
        if (this.guard.method_31481() || !this.guard.method_5805()) {
            return false;
        }
        if (this.guard.isCastingSpell()) {
            return false;
        }
        float hpFrac = this.guard.method_6032() / this.guard.method_6063();
        if (hpFrac >= 0.7f) {
            return false;
        }
        return this.findNearestPriest(24.0) != null;
    }

    public void method_6269() {
        this.updatePathDelay = 0;
        this.poseToggleDelay = 0;
        this.stuckTicks = 0;
        this.progressCheckTick = 0;
        this.progressPos = this.guard.method_19538();
        this.zoneRef = null;
        this.zoneAnchor = null;
        this.zoneId = null;
        this.shieldHoldTicks = 0;
    }

    public void method_6270() {
        this.guard.method_5942().method_6340();
        this.guard.method_6075();
        if (this.guard.method_18376() == class_4050.field_18081) {
            this.guard.method_18380(class_4050.field_18076);
        }
    }

    public void method_6268() {
        class_243 pos;
        this.togglePoseOccasionally();
        boolean handledByZone = this.retreatIntoHolyZone();
        if (handledByZone) {
            boolean movingToZone = this.zoneRef != null && !HolyZoneHelper.inside(this.guard, this.zoneRef, this.zoneRadius);
            boolean notAnchored = this.zoneRef != null && !movingToZone && (this.zoneAnchor == null || this.guard.method_19538().method_1025(this.zoneAnchor) > 1.5);
            boolean enemyThreat = false;
            class_1309 enemy = this.guard.method_5968();
            if (enemy != null && enemy.method_5805()) {
                enemyThreat = this.guard.method_5985().method_6369((class_1297)enemy) && this.guard.method_5858((class_1297)enemy) < 144.0;
            }
            boolean shouldRaise = movingToZone || notAnchored || enemyThreat;
            this.updateShield(shouldRaise);
            this.watchdogProgress();
            return;
        }
        GuardEntity priest = this.findNearestPriest(24.0);
        if (priest != null) {
            if (--this.updatePathDelay <= 0) {
                this.guard.method_5942().method_6335((class_1297)priest, this.speed);
                this.updatePathDelay = PATH_DELAY.method_35008(this.guard.method_59922());
            }
            this.guard.method_5951((class_1297)priest, 30.0f, 30.0f);
            boolean enemyThreat = false;
            class_1309 enemy = this.guard.method_5968();
            if (enemy != null && enemy.method_5805()) {
                enemyThreat = this.guard.method_5985().method_6369((class_1297)enemy) && this.guard.method_5858((class_1297)enemy) < 144.0;
            }
            this.updateShield(true);
            this.watchdogProgress();
            return;
        }
        class_1309 enemy = this.guard.method_5968();
        class_243 class_2432 = pos = enemy != null ? class_5532.method_31511((class_1314)this.guard, (int)16, (int)7, (class_243)enemy.method_19538()) : class_5532.method_31510((class_1314)this.guard, (int)16, (int)7);
        if (pos != null) {
            if (--this.updatePathDelay <= 0) {
                this.guard.method_5942().method_6337(pos.field_1352, pos.field_1351, pos.field_1350, this.speed);
                this.updatePathDelay = PATH_DELAY.method_35008(this.guard.method_59922());
            }
            this.updateShield(true);
        } else {
            this.guard.method_5942().method_6340();
            this.updateShield(false);
        }
        if (enemy != null) {
            this.guard.method_5951((class_1297)enemy, 30.0f, 30.0f);
        }
        this.watchdogProgress();
    }

    private boolean retreatIntoHolyZone() {
        double d2;
        boolean inside;
        if (this.zoneRef == null || !this.zoneRef.method_5805()) {
            class_6335 z = HolyZoneHelper.findNearby(this.guard, 32.0);
            if (z == null) {
                return false;
            }
            this.zoneRef = z;
            this.zoneRadius = HolyZoneHelper.radiusOf(z, 5.0f);
            this.zoneId = z.method_5667();
            this.zoneAnchor = null;
        }
        if (!(inside = HolyZoneHelper.inside(this.guard, this.zoneRef, this.zoneRadius))) {
            if (--this.updatePathDelay <= 0) {
                HolyZoneHelper.steerTowardsIfOutside(this.guard, this.zoneRef, this.zoneRadius, this.speed);
                this.updatePathDelay = PATH_DELAY.method_35008(this.guard.method_59922());
            }
            return true;
        }
        if (this.zoneAnchor == null) {
            this.zoneAnchor = this.computeBestAnchor(this.zoneRef, this.zoneRadius);
            if (this.zoneAnchor == null) {
                return true;
            }
        }
        if ((d2 = this.guard.method_19538().method_1025(this.zoneAnchor)) > 1.0) {
            if (--this.updatePathDelay <= 0) {
                this.guard.method_5942().method_6337(this.zoneAnchor.field_1352, this.zoneAnchor.field_1351, this.zoneAnchor.field_1350, this.speed);
                this.updatePathDelay = PATH_DELAY.method_35008(this.guard.method_59922());
            }
        } else {
            this.guard.method_5942().method_6340();
        }
        return true;
    }

    private void updateShield(boolean raise) {
        class_1799 off = this.guard.method_6079();
        if (!off.method_31574(class_1802.field_8255)) {
            return;
        }
        if (raise) {
            if (this.guard.isCastingSpell()) {
                this.guard.setCastingSpell(false);
            }
            if (!this.guard.method_6115() || this.guard.method_6058() != class_1268.field_5810) {
                this.guard.method_6019(class_1268.field_5810);
            }
        } else if (this.guard.method_6115() && this.guard.method_6058() == class_1268.field_5810) {
            this.guard.method_6075();
        }
    }

    private void togglePoseOccasionally() {
        if (--this.poseToggleDelay <= 0) {
            this.poseToggleDelay = 50 + this.guard.method_59922().method_43048(20);
            this.guard.method_18380(this.guard.method_18376() == class_4050.field_18076 ? class_4050.field_18081 : class_4050.field_18076);
        }
    }

    private GuardEntity findNearestPriest(double range) {
        class_238 box = this.guard.method_5829().method_1014(range);
        List guards = this.guard.method_37908().method_8390(GuardEntity.class, box, g -> g != this.guard && g.method_5805() && this.isHealer((GuardEntity)((Object)g)));
        if (guards.isEmpty()) {
            return null;
        }
        return guards.stream().min(Comparator.comparingDouble(g -> g.method_5858((class_1297)this.guard))).orElse(null);
    }

    private boolean isHealer(GuardEntity g) {
        if (g.isHoldingHolyFocus()) {
            return true;
        }
        String skill = g.getHolySkill();
        return skill != null && !skill.isEmpty() && (skill.contains("heal") || skill.contains("barrier") || skill.contains("circle"));
    }

    private boolean hasFoodInOffhand() {
        class_1799 off = this.guard.method_6079();
        return off.method_57824(class_9334.field_50075) != null;
    }

    private void watchdogProgress() {
        int age = this.guard.field_6012;
        if (this.progressCheckTick == 0) {
            this.progressCheckTick = age;
            this.progressPos = this.guard.method_19538();
            return;
        }
        if (age - this.progressCheckTick >= 20) {
            double moved2 = this.guard.method_19538().method_1025(this.progressPos);
            this.stuckTicks = moved2 < 0.05 ? (this.stuckTicks += 20) : Math.max(0, this.stuckTicks - 10);
            this.progressCheckTick = age;
            this.progressPos = this.guard.method_19538();
        }
        if (this.stuckTicks > 80) {
            this.guard.method_5942().method_6340();
        }
    }

    private class_243 computeBestAnchor(class_6335 zone, float radius) {
        class_243 center = zone.method_19538();
        double anchorY = this.guard.method_23318();
        double margin = 0.75;
        class_243[] seeds = new class_243[]{new class_243(center.field_1352, anchorY, center.field_1350), new class_243(center.field_1352 + 0.75, anchorY, center.field_1350), new class_243(center.field_1352 - 0.75, anchorY, center.field_1350), new class_243(center.field_1352, anchorY, center.field_1350 + 0.75), new class_243(center.field_1352, anchorY, center.field_1350 - 0.75)};
        double maxR2 = Math.max(0.0, ((double)radius - margin) * ((double)radius - margin));
        class_243 best = null;
        double bestD2 = Double.MAX_VALUE;
        for (class_243 p : seeds) {
            double d2;
            if (center.method_1025(p) > maxR2 || !this.isSpotFree(p) || !((d2 = center.method_1025(p)) < bestD2)) continue;
            bestD2 = d2;
            best = p;
        }
        return best;
    }

    private boolean isSpotFree(class_243 pos) {
        double w = this.guard.method_17681();
        double h = this.guard.method_17682();
        class_238 box = new class_238(pos.field_1352 - w * 0.5, pos.field_1351, pos.field_1350 - w * 0.5, pos.field_1352 + w * 0.5, pos.field_1351 + h, pos.field_1350 + w * 0.5);
        if (!this.guard.method_37908().method_18026(box)) {
            return false;
        }
        List others = this.guard.method_37908().method_8390(class_1309.class, box.method_1009(0.15, 0.0, 0.15), e -> e.method_5805() && e != this.guard);
        return others.isEmpty();
    }
}

