/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.guardvillagers.common.entity.goal;

import com.mojang.datafixers.util.Pair;
import dev.sterner.guardvillagers.common.ai.CombatMovementHelper;
import dev.sterner.guardvillagers.common.ai.HolyZoneHelper;
import dev.sterner.guardvillagers.common.entity.GuardEntity;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1439;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_4802;
import net.minecraft.class_6019;
import net.minecraft.class_6335;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.internals.SpellHelper;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchool;

public class PriestRangedHealerGoal
extends class_1352 {
    private static final float HEAL_CLUSTER_RADIUS = 6.0f;
    private static final float HEAL_CAP_IN_COMBAT = 0.8f;
    private static final float HEAL_CAP_OOC = 1.0f;
    private static final float SEEK_RADIUS = 16.0f;
    private static final float CLUSTER_SEARCH_RADIUS = 12.0f;
    private static final class_6019 PATH_DELAY = class_4802.method_24505((int)1, (int)2);
    private static final class_2960 ID_CIRCLE = class_2960.method_60655((String)"paladins", (String)"circle_of_healing");
    private static final class_2960 ID_HEAL = class_2960.method_60655((String)"paladins", (String)"heal");
    private static final class_2960 ID_HSHOCK = class_2960.method_60655((String)"paladins", (String)"holy_shock");
    private static final class_2960 ID_BARRIER = class_2960.method_60655((String)"paladins", (String)"barrier");
    private static final int COOLDOWN_BARRIER = 400;
    private static final int TTL_BARRIER_MARKER = 200;
    private static final float DEFAULT_BARRIER_RADIUS = 5.0f;
    private static final float HSHOCK_MAX_RANGE = 6.0f;
    private static final float HSHOCK_MAX_RANGE_SQR = 36.0f;
    private final GuardEntity guard;
    private int seeTime = 0;
    private int updatePathDelay = 0;
    private int pathDelay = 0;
    private Runnable pendingCast = null;
    private int windupTicks = 0;
    private final Map<class_2960, Integer> spellCooldowns = new HashMap<class_2960, Integer>();
    private PendingSpell pendingType = PendingSpell.NONE;

    public PriestRangedHealerGoal(GuardEntity guard) {
        this.guard = guard;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        class_1309 tgt = this.guard.method_5968();
        boolean hasEnemy = tgt != null && tgt.method_5805();
        boolean selfHurt = this.guard.method_6032() < this.guard.method_6063();
        boolean allyHurt = this.hasHurtAllyNearby(16.0f);
        return this.guard.isHoldingHolyFocus() && (hasEnemy || selfHurt || allyHurt);
    }

    public boolean method_6266() {
        class_1309 tgt = this.guard.method_5968();
        boolean hasEnemy = tgt != null && tgt.method_5805();
        boolean selfHurt = this.guard.method_6032() < this.guard.method_6063();
        boolean allyHurt = this.hasHurtAllyNearby(16.0f);
        return this.guard.isHoldingHolyFocus() && (this.pendingCast != null || hasEnemy || selfHurt || allyHurt);
    }

    public void method_6270() {
        this.guard.method_6075();
        this.guard.setCastingSpell(false);
        this.guard.method_5942().method_6340();
        this.seeTime = 0;
        this.updatePathDelay = 0;
        this.pathDelay = 0;
        this.pendingCast = null;
        this.windupTicks = 0;
        this.pendingType = PendingSpell.NONE;
    }

    public void method_6268() {
        class_1309 enemy = this.guard.method_5968();
        this.spellCooldowns.replaceAll((id, t) -> Math.max(0, t - 1));
        if (this.pendingCast != null) {
            if (!this.guard.method_6115()) {
                this.guard.method_6019(class_1268.field_5808);
                this.guard.setCastingSpell(true);
            }
            if (--this.windupTicks <= 0) {
                this.guard.method_6075();
                this.guard.setCastingSpell(false);
                Runnable cast = this.pendingCast;
                this.pendingCast = null;
                PendingSpell executed = this.pendingType;
                this.pendingType = PendingSpell.NONE;
                cast.run();
            }
        }
        if (this.pendingCast != null && this.pendingType == PendingSpell.BARRIER) {
            this.guard.method_5942().method_6340();
            this.guard.method_5962().method_6243(0.0f, 0.0f);
            this.guard.method_18799(this.guard.method_18798().method_1021(0.2));
            if (enemy != null) {
                this.guard.method_5951((class_1297)enemy, 30.0f, 30.0f);
                this.guard.method_5988().method_6226((class_1297)enemy, 30.0f, 30.0f);
            }
            return;
        }
        class_6335 zone = HolyZoneHelper.findNearby(this.guard, 32.0);
        if (zone != null) {
            float zr = HolyZoneHelper.radiusOf(zone, 5.0f);
            if (!HolyZoneHelper.inside(this.guard, zone, zr)) {
                if (--this.pathDelay <= 0) {
                    HolyZoneHelper.steerTowardsIfOutside(this.guard, zone, zr, 1.1);
                    this.pathDelay = PATH_DELAY.method_35008(this.guard.method_59922());
                }
                return;
            }
            HolyZoneHelper.softLeashInside(this.guard, zone, zr);
        }
        if (enemy == null || !enemy.method_5805()) {
            this.guard.method_5942().method_6340();
            if (this.tryHealSingle(1.0f, 16.0f)) {
                return;
            }
            if (this.tryCircleForCluster(12.0f)) {
                return;
            }
            return;
        }
        boolean canSee = this.guard.method_5985().method_6369((class_1297)enemy);
        boolean inAimPhase = this.guard.method_6115() || this.pendingCast != null;
        boolean canRun = this.pendingCast == null;
        CombatMovementHelper.MovementResult mv = CombatMovementHelper.applyRangedCombatMovement((class_1308)this.guard, enemy, canSee, this.seeTime, this.updatePathDelay, 0, inAimPhase, canRun, 1.15, 6.0f);
        this.seeTime = mv.seeTime();
        this.updatePathDelay = mv.updatePathDelay();
        if (enemy instanceof class_1657) {
            if (this.tryHealSingleGuardOnly(0.8f, 16.0f)) {
                return;
            }
            if (this.tryCircleForGuardCluster(12.0f)) {
                return;
            }
            if (this.isBarrierPriest() && this.tryBarrier()) {
                return;
            }
            return;
        }
        if (this.tryHealSingle(0.8f, 16.0f)) {
            return;
        }
        if (this.tryCircleForCluster(12.0f)) {
            return;
        }
        if (this.isBarrierPriest() && this.tryBarrier()) {
            return;
        }
        this.tryHolyShock(enemy);
    }

    private boolean isBarrierPriest() {
        String skill = this.guard.getHolySkill();
        return "paladins:barrier".equals(skill);
    }

    private boolean tryHealSingle(float capFrac, float radius) {
        float zr;
        if (this.pendingCast != null) {
            return false;
        }
        if (this.onCooldown(ID_HEAL)) {
            return false;
        }
        class_6880<Spell> entry = this.spellEntry(ID_HEAL);
        if (entry == null) {
            return false;
        }
        class_1309 target = this.findBestHealableAlly(radius, capFrac);
        if (target == null) {
            return false;
        }
        class_6335 zone = HolyZoneHelper.findNearby(this.guard, 32.0);
        if (zone != null && !HolyZoneHelper.inside(this.guard, zone, zr = HolyZoneHelper.radiusOf(zone, 5.0f))) {
            return false;
        }
        if (this.guard.method_5739((class_1297)target) > 6.0f) {
            if (--this.pathDelay <= 0) {
                this.guard.method_5942().method_6335((class_1297)target, 1.1);
                this.pathDelay = PATH_DELAY.method_35008(this.guard.method_59922());
            }
        } else {
            this.beginWindup(PendingSpell.HEAL_SINGLE, () -> {
                this.castAtTarget(entry, target);
                this.spellCooldowns.put(ID_HEAL, this.getSpellCooldownTicks((Spell)entry.comp_349(), 40));
            });
            return true;
        }
        return false;
    }

    private boolean tryCircleForCluster(float searchRadius) {
        float zr;
        if (this.pendingCast != null) {
            return false;
        }
        if (this.onCooldown(ID_CIRCLE)) {
            return false;
        }
        class_6880<Spell> entry = this.spellEntry(ID_CIRCLE);
        if (entry == null) {
            return false;
        }
        Cluster cluster = this.findHurtAllyCluster(searchRadius);
        if (!cluster.valid) {
            return false;
        }
        class_6335 zone = HolyZoneHelper.findNearby(this.guard, 32.0);
        if (zone != null && !HolyZoneHelper.inside(this.guard, zone, zr = HolyZoneHelper.radiusOf(zone, 5.0f))) {
            return false;
        }
        if (this.guard.method_19538().method_1025(cluster.center) > 9.0) {
            if (--this.pathDelay <= 0) {
                this.guard.method_5942().method_6337(cluster.center.field_1352, cluster.center.field_1351, cluster.center.field_1350, 1.1);
                this.pathDelay = PATH_DELAY.method_35008(this.guard.method_59922());
            }
            return false;
        }
        this.beginWindup(PendingSpell.CIRCLE, () -> {
            this.castSelfArea(entry);
            this.spellCooldowns.put(ID_CIRCLE, this.getSpellCooldownTicks((Spell)entry.comp_349(), 200));
        });
        return true;
    }

    private boolean tryHealSingleGuardOnly(float capFrac, float radius) {
        float zr;
        if (this.pendingCast != null) {
            return false;
        }
        if (this.onCooldown(ID_HEAL)) {
            return false;
        }
        class_6880<Spell> entry = this.spellEntry(ID_HEAL);
        if (entry == null) {
            return false;
        }
        class_1309 target = this.findBestHealableGuardAlly(radius, capFrac);
        if (target == null) {
            return false;
        }
        class_6335 zone = HolyZoneHelper.findNearby(this.guard, 32.0);
        if (zone != null && !HolyZoneHelper.inside(this.guard, zone, zr = HolyZoneHelper.radiusOf(zone, 5.0f))) {
            return false;
        }
        if (this.guard.method_5739((class_1297)target) > 6.0f) {
            if (--this.pathDelay <= 0) {
                this.guard.method_5942().method_6335((class_1297)target, 1.1);
                this.pathDelay = PATH_DELAY.method_35008(this.guard.method_59922());
            }
        } else {
            this.beginWindup(PendingSpell.HEAL_SINGLE, () -> {
                this.castAtTarget(entry, target);
                this.spellCooldowns.put(ID_HEAL, this.getSpellCooldownTicks((Spell)entry.comp_349(), 40));
            });
            return true;
        }
        return false;
    }

    private boolean tryCircleForGuardCluster(float searchRadius) {
        float zr;
        if (this.pendingCast != null) {
            return false;
        }
        if (this.onCooldown(ID_CIRCLE)) {
            return false;
        }
        class_6880<Spell> entry = this.spellEntry(ID_CIRCLE);
        if (entry == null) {
            return false;
        }
        Cluster cluster = this.findHurtGuardCluster(searchRadius);
        if (!cluster.valid) {
            return false;
        }
        class_6335 zone = HolyZoneHelper.findNearby(this.guard, 32.0);
        if (zone != null && !HolyZoneHelper.inside(this.guard, zone, zr = HolyZoneHelper.radiusOf(zone, 5.0f))) {
            return false;
        }
        if (this.guard.method_19538().method_1025(cluster.center) > 9.0) {
            if (--this.pathDelay <= 0) {
                this.guard.method_5942().method_6337(cluster.center.field_1352, cluster.center.field_1351, cluster.center.field_1350, 1.1);
                this.pathDelay = PATH_DELAY.method_35008(this.guard.method_59922());
            }
            return false;
        }
        this.beginWindup(PendingSpell.CIRCLE, () -> {
            this.castSelfArea(entry);
            this.spellCooldowns.put(ID_CIRCLE, this.getSpellCooldownTicks((Spell)entry.comp_349(), 200));
        });
        return true;
    }

    private boolean tryBarrier() {
        if (this.pendingCast != null) {
            return false;
        }
        if (this.onCooldown(ID_BARRIER)) {
            return false;
        }
        class_6880<Spell> entry = this.spellEntry(ID_BARRIER);
        if (entry == null) {
            return false;
        }
        this.beginWindup(PendingSpell.BARRIER, () -> {
            class_243 pos = this.guard.method_19538();
            this.castBarrierAtPosition(entry, pos);
            this.spellCooldowns.put(ID_BARRIER, 400);
        });
        return true;
    }

    private void castBarrierAtPosition(class_6880<Spell> entry, class_243 pos) {
        this.castAtPosition(entry, pos);
        this.spawnZoneMarker("barrier", pos, 5.0f, 200);
        HolyZoneHelper.debugLog(this.guard, "Spawned BARRIER at " + String.valueOf(pos));
    }

    private boolean tryHolyShock(class_1309 enemy) {
        if (this.pendingCast != null) {
            return false;
        }
        if (enemy == null || !enemy.method_5805()) {
            return false;
        }
        if (enemy instanceof class_1657) {
            return false;
        }
        if (this.onCooldown(ID_HSHOCK)) {
            return false;
        }
        class_6880<Spell> entry = this.spellEntry(ID_HSHOCK);
        if (entry == null) {
            return false;
        }
        if (this.guard.method_5858((class_1297)enemy) > 36.0) {
            return false;
        }
        this.beginWindup(PendingSpell.HOLY_SHOCK, () -> {
            this.castAtTarget(entry, enemy);
            this.spellCooldowns.put(ID_HSHOCK, this.getSpellCooldownTicks((Spell)entry.comp_349(), 40));
        });
        return true;
    }

    private void beginWindup(PendingSpell type, Runnable onCast) {
        this.pendingType = type;
        this.pendingCast = onCast;
        this.windupTicks = 20;
    }

    private void castSelfArea(class_6880<Spell> spellEntry) {
        Spell spell = (Spell)spellEntry.comp_349();
        SpellHelper.ImpactContext ctx = new SpellHelper.ImpactContext().power(SpellPower.getSpellPower((SpellSchool)spell.school, (class_1309)this.guard)).position(this.guard.method_19538());
        SpellHelper.performImpacts((class_1937)this.guard.method_37908(), (class_1309)this.guard, (class_1297)this.guard, (class_1297)this.guard, spellEntry, (List)spell.impacts, (SpellHelper.ImpactContext)ctx);
        this.playReleaseSound(spell);
        this.guard.method_23667(class_1268.field_5808, true);
    }

    private void castAtTarget(class_6880<Spell> spellEntry, class_1309 target) {
        String type;
        if (target == null || !target.method_5805()) {
            return;
        }
        Spell spell = (Spell)spellEntry.comp_349();
        SpellHelper.ImpactContext ctx = new SpellHelper.ImpactContext().power(SpellPower.getSpellPower((SpellSchool)spell.school, (class_1309)this.guard)).position(this.guard.method_33571()).target(SpellHelper.focusMode((Spell)spell));
        switch (type = String.valueOf(spell.deliver.type).toUpperCase()) {
            case "PROJECTILE": {
                SpellHelper.shootProjectile((class_1937)this.guard.method_37908(), (class_1309)this.guard, (class_1297)target, spellEntry, (SpellHelper.ImpactContext)ctx, (int)0);
                break;
            }
            case "DIRECT": {
                SpellHelper.performImpacts((class_1937)this.guard.method_37908(), (class_1309)this.guard, (class_1297)target, (class_1297)this.guard, spellEntry, (List)spell.impacts, (SpellHelper.ImpactContext)ctx);
                break;
            }
            case "AREA": 
            case "METEOR": {
                this.castAtPosition(spellEntry, target.method_19538());
                break;
            }
            default: {
                SpellHelper.performImpacts((class_1937)this.guard.method_37908(), (class_1309)this.guard, (class_1297)target, (class_1297)this.guard, spellEntry, (List)spell.impacts, (SpellHelper.ImpactContext)ctx);
            }
        }
        this.playReleaseSound(spell);
        this.guard.method_23667(class_1268.field_5808, true);
    }

    private void castAtPosition(class_6880<Spell> spellEntry, class_243 pos) {
        Spell spell = (Spell)spellEntry.comp_349();
        SpellHelper.ImpactContext ctx = new SpellHelper.ImpactContext().power(SpellPower.getSpellPower((SpellSchool)spell.school, (class_1309)this.guard)).position(pos);
        String type = String.valueOf(spell.deliver.type).toUpperCase();
        if ("METEOR".equals(type)) {
            class_1309 tgt = this.guard.method_5968();
            SpellHelper.fallProjectile((class_1937)this.guard.method_37908(), (class_1309)this.guard, (class_1297)tgt, (class_243)pos, spellEntry, (SpellHelper.ImpactContext)ctx);
        } else {
            SpellHelper.performImpacts((class_1937)this.guard.method_37908(), (class_1309)this.guard, (class_1297)this.guard, (class_1297)this.guard, spellEntry, (List)spell.impacts, (SpellHelper.ImpactContext)ctx);
        }
        this.playReleaseSound(spell);
        this.guard.method_23667(class_1268.field_5808, true);
    }

    private void playReleaseSound(Spell spell) {
        class_3414 se;
        class_2960 sid;
        if (spell.release != null && spell.release.sound != null && (sid = class_2960.method_12829((String)spell.release.sound.id())) != null && (se = (class_3414)class_7923.field_41172.method_10223(sid)) != null) {
            this.guard.method_37908().method_8396(null, this.guard.method_24515(), se, class_3419.field_15248, 1.0f, 1.0f);
        }
    }

    private class_1309 findBestHealableAlly(float radius, float capFrac) {
        class_238 box = this.guard.method_5829().method_1014((double)radius);
        List allies = this.guard.method_37908().method_8390(class_1309.class, box, e -> PriestRangedHealerGoal.isAlly(this.guard, e) && e.method_6032() / e.method_6063() < capFrac);
        if (this.guard.method_6032() / this.guard.method_6063() < capFrac) {
            allies.add(this.guard);
        }
        if (allies.isEmpty()) {
            return null;
        }
        return allies.stream().min(Comparator.comparingDouble(a -> a.method_6032() / a.method_6063())).orElse(null);
    }

    private class_1309 findBestHealableGuardAlly(float radius, float capFrac) {
        class_238 box = this.guard.method_5829().method_1014((double)radius);
        List guards = this.guard.method_37908().method_8390(GuardEntity.class, box, g -> g.method_5805() && g != this.guard && g.method_6032() / g.method_6063() < capFrac);
        if (this.guard.method_6032() / this.guard.method_6063() < capFrac) {
            guards.add(this.guard);
        }
        if (guards.isEmpty()) {
            return null;
        }
        return guards.stream().min(Comparator.comparingDouble(a -> a.method_6032() / a.method_6063())).orElse(null);
    }

    private Cluster findHurtAllyCluster(float searchRadius) {
        class_238 box = this.guard.method_5829().method_1014((double)searchRadius);
        List hurtAllies = this.guard.method_37908().method_8390(class_1309.class, box, e -> PriestRangedHealerGoal.isAlly(this.guard, e) && e.method_6032() < e.method_6063());
        if (hurtAllies.isEmpty()) {
            return Cluster.invalid();
        }
        class_1309 seed = hurtAllies.stream().min(Comparator.comparingDouble(a -> a.method_6032() / a.method_6063())).orElse(null);
        if (seed == null) {
            return Cluster.invalid();
        }
        class_243 sum = class_243.field_1353;
        int count = 0;
        for (class_1309 a2 : hurtAllies) {
            if (!(a2.method_5858((class_1297)seed) <= 36.0)) continue;
            sum = sum.method_1019(a2.method_19538());
            ++count;
        }
        if (count == 0) {
            return Cluster.invalid();
        }
        return new Cluster(true, sum.method_1021(1.0 / (double)count), count);
    }

    private Cluster findHurtGuardCluster(float searchRadius) {
        class_238 box = this.guard.method_5829().method_1014((double)searchRadius);
        List hurtGuards = this.guard.method_37908().method_8390(GuardEntity.class, box, g -> g.method_5805() && g.method_6032() < g.method_6063());
        if (this.guard.method_6032() < this.guard.method_6063() && !hurtGuards.contains((Object)this.guard)) {
            hurtGuards.add(this.guard);
        }
        if (hurtGuards.isEmpty()) {
            return Cluster.invalid();
        }
        GuardEntity seed = hurtGuards.stream().min(Comparator.comparingDouble(a -> a.method_6032() / a.method_6063())).orElse(null);
        if (seed == null) {
            return Cluster.invalid();
        }
        class_243 sum = class_243.field_1353;
        int count = 0;
        for (GuardEntity a2 : hurtGuards) {
            if (!(a2.method_5858((class_1297)seed) <= 36.0)) continue;
            sum = sum.method_1019(a2.method_19538());
            ++count;
        }
        if (count == 0) {
            return Cluster.invalid();
        }
        return new Cluster(true, sum.method_1021(1.0 / (double)count), count);
    }

    private boolean hasHurtAllyNearby(float radius) {
        class_238 box = this.guard.method_5829().method_1014((double)radius);
        if (this.guard.method_6032() < this.guard.method_6063()) {
            return true;
        }
        return !this.guard.method_37908().method_8390(class_1309.class, box, e -> PriestRangedHealerGoal.isAlly(this.guard, e) && e.method_6032() < e.method_6063()).isEmpty();
    }

    private static boolean isAlly(GuardEntity self, class_1309 e) {
        if (e == null || !e.method_5805()) {
            return false;
        }
        if (e == self) {
            return false;
        }
        return e instanceof class_1646 || e instanceof GuardEntity || e instanceof class_1439;
    }

    private boolean onCooldown(class_2960 id) {
        return this.spellCooldowns.getOrDefault(id, 0) > 0;
    }

    private int getSpellCooldownTicks(Spell spell, int fallback) {
        if (spell.cost != null && spell.cost.cooldown != null) {
            return (int)(spell.cost.cooldown.duration * 20.0f);
        }
        return fallback;
    }

    private class_6880<Spell> spellEntry(class_2960 id) {
        return SpellRegistry.from((class_1937)this.guard.method_37908()).method_55841(id).orElse(null);
    }

    private void spawnZoneMarker(String type, class_243 pos, float radius, int durationTicks) {
        class_1937 w = this.guard.method_37908();
        if (w.method_8608() || !(w instanceof class_3218)) {
            return;
        }
        class_3218 sw = (class_3218)w;
        class_6335 marker = (class_6335)class_1299.field_33456.method_5883((class_1937)sw);
        if (marker == null) {
            return;
        }
        marker.method_5808(pos.field_1352, pos.field_1351, pos.field_1350, 0.0f, 0.0f);
        marker.method_5648(true);
        marker.method_5875(true);
        marker.method_5684(true);
        marker.method_5780("guard_priest_zone");
        marker.method_5780("zone:barrier");
        marker.method_5780("r:" + radius);
        sw.method_8649((class_1297)marker);
        this.guard.delayedTasks.add((Pair<Integer, Runnable>)new Pair((Object)durationTicks, () -> {
            if (marker.method_5805()) {
                marker.method_31472();
            }
        }));
    }

    private static enum PendingSpell {
        NONE,
        HEAL_SINGLE,
        CIRCLE,
        HOLY_SHOCK,
        BARRIER;

    }

    private static final class Cluster {
        final boolean valid;
        final class_243 center;
        final int size;

        Cluster(boolean v, class_243 c, int s) {
            this.valid = v;
            this.center = c;
            this.size = s;
        }

        static Cluster invalid() {
            return new Cluster(false, class_243.field_1353, 0);
        }
    }
}

