/*
 * Decompiled with CFR 0.152.
 */
package dev.sterner.guardvillagers.common.entity.goal;

import dev.sterner.guardvillagers.GuardVillagers;
import dev.sterner.guardvillagers.GuardVillagersConfig;
import dev.sterner.guardvillagers.common.ai.CombatMovementHelper;
import dev.sterner.guardvillagers.common.entity.GuardEntity;
import dev.sterner.guardvillagers.mixin.accessor.CrossbowItemAccessor;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1665;
import net.minecraft.class_1675;
import net.minecraft.class_1764;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3745;
import net.minecraft.class_4050;
import net.minecraft.class_4802;
import net.minecraft.class_5532;
import net.minecraft.class_6019;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9278;
import net.minecraft.class_9334;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.registry.SpellRegistry;
import net.spell_engine.entity.SpellProjectile;
import net.spell_engine.internals.SpellHelper;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchool;
import org.jetbrains.annotations.Nullable;

public class RangedCrossbowAttackPassiveGoal<T extends class_1314 & class_3745>
extends class_1352 {
    public static final class_6019 PATHFINDING_DELAY_RANGE = class_4802.method_24505((int)1, (int)2);
    private final T mob;
    private int chargingTime = 0;
    private final double speedModifier;
    private final float attackRadiusSqr;
    protected double wantedX;
    protected double wantedY;
    protected double wantedZ;
    private CrossbowState crossbowState = CrossbowState.UNCHARGED;
    private int seeTime;
    private int attackDelay;
    private int updatePathDelay;
    private final Map<class_2960, Integer> spellCooldowns = new HashMap<class_2960, Integer>();
    private class_2960 currentSpellId;
    private class_6880<Spell> cachedSpellEntry;

    public RangedCrossbowAttackPassiveGoal(T mob, double speedModifier, float attackRadius) {
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.attackRadiusSqr = attackRadius * attackRadius;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        return this.isValidTarget() && this.isHoldingCrossbow();
    }

    private boolean isHoldingCrossbow() {
        return this.mob.method_24520(is -> is.method_7909() instanceof class_1764);
    }

    public boolean method_6266() {
        return this.isValidTarget() && (this.method_6264() || !this.mob.method_5942().method_6357()) && this.isHoldingCrossbow();
    }

    private boolean isValidTarget() {
        return this.mob.method_5968() != null && this.mob.method_5968().method_5805();
    }

    public void method_6270() {
        super.method_6270();
        this.mob.method_19540(false);
        this.mob.method_5980(null);
        this.seeTime = 0;
        if (this.mob.method_6115()) {
            this.mob.method_6075();
            ((class_3745)this.mob).method_7110(false);
        }
        this.mob.method_18380(class_4050.field_18076);
    }

    public boolean method_38846() {
        return true;
    }

    public void method_6269() {
        this.mob.method_19540(true);
    }

    public void method_6268() {
        class_1309 target = this.mob.method_5968();
        if (target != null) {
            boolean canSee = this.mob.method_5985().method_6369((class_1297)target);
            boolean hasSeenRecently = this.seeTime > 0;
            CombatMovementHelper.MovementResult mv = CombatMovementHelper.applyRangedCombatMovement(this.mob, target, canSee, this.seeTime, this.updatePathDelay, this.attackDelay, this.mob.method_6115(), this.canRun(), this.speedModifier, (float)Math.sqrt(this.attackRadiusSqr));
            this.seeTime = mv.seeTime();
            this.updatePathDelay = mv.updatePathDelay();
            this.spellCooldowns.replaceAll((id, t) -> Math.max(t - 1, 0));
            if (this.friendlyInLineOfSight() && GuardVillagersConfig.friendlyFire) {
                this.crossbowState = CrossbowState.FIND_NEW_POSITION;
            }
            switch (this.crossbowState.ordinal()) {
                case 4: {
                    this.mob.method_6075();
                    ((class_3745)this.mob).method_7110(false);
                    if (this.findPosition()) {
                        this.mob.method_5942().method_6337(this.wantedX, this.wantedY, this.wantedZ, this.mob.method_5715() ? 0.5 : 1.2);
                    }
                    this.crossbowState = CrossbowState.UNCHARGED;
                    break;
                }
                case 0: {
                    if (!hasSeenRecently) break;
                    this.mob.method_6019(GuardVillagers.getHandWith(this.mob, item -> item instanceof class_1764));
                    ((class_3745)this.mob).method_7110(true);
                    this.crossbowState = CrossbowState.CHARGING;
                    break;
                }
                case 1: {
                    ++this.chargingTime;
                    int requiredPullTime = 25;
                    int useTime = this.mob.method_6048();
                    class_1799 itemStack = this.mob.method_6030();
                    if (useTime < requiredPullTime && !class_1764.method_7781((class_1799)itemStack) && this.chargingTime <= 60) break;
                    this.mob.method_6075();
                    ((class_3745)this.mob).method_7110(false);
                    this.attackDelay = 10 + this.mob.method_59922().method_43048(5);
                    this.crossbowState = CrossbowState.CHARGED;
                    this.chargingTime = 0;
                    break;
                }
                case 2: {
                    if (--this.attackDelay > 0) break;
                    this.crossbowState = CrossbowState.READY_TO_ATTACK;
                    break;
                }
                case 3: {
                    Optional optSpell;
                    if (!canSee) {
                        return;
                    }
                    class_2960 spellId = this.getCrossbowSpellId();
                    if (spellId != null && !this.isSpellOnCooldown(spellId) && this.mob.method_59922().method_43057() < 0.15f && (optSpell = SpellRegistry.from((class_1937)this.mob.method_37908()).method_55841(spellId)).isPresent()) {
                        this.cachedSpellEntry = (class_6880)optSpell.get();
                        Spell spell = (Spell)this.cachedSpellEntry.comp_349();
                        this.castCrossbowSpell(target, spell, this.cachedSpellEntry);
                        this.spellCooldowns.put(spellId, 60);
                        this.crossbowState = CrossbowState.UNCHARGED;
                        return;
                    }
                    class_1799 crossbowStack = this.mob.method_5998(GuardVillagers.getHandWith(this.mob, item -> item instanceof class_1764));
                    class_1268 hand = GuardVillagers.getHandWith(this.mob, item -> item instanceof class_1764);
                    class_1764 crossbowItem = (class_1764)crossbowStack.method_7909();
                    if (!class_1764.method_7781((class_1799)crossbowStack)) {
                        class_1799 ammo = this.mob.method_18808(crossbowStack);
                        if (ammo.method_7960()) {
                            ammo = new class_1799((class_1935)class_1802.field_8107);
                        }
                        crossbowStack.method_57379(class_9334.field_49649, (Object)class_9278.method_57441(List.of(ammo.method_46651(1))));
                    }
                    ((CrossbowItemAccessor)crossbowItem).callShootAll(this.mob.method_37908(), (class_1309)this.mob, hand, crossbowStack, 2.0f, 1.0f, target);
                    ((class_3745)this.mob).method_7110(false);
                    this.crossbowState = CrossbowState.UNCHARGED;
                }
            }
        }
    }

    private class_2960 getCrossbowSpellId() {
        T t = this.mob;
        if (t instanceof GuardEntity) {
            GuardEntity guard = (GuardEntity)((Object)t);
            String raw = guard.getBowSkill();
            return raw != null && !raw.equals("none") ? class_2960.method_12829((String)raw) : null;
        }
        return null;
    }

    private boolean isSpellOnCooldown(class_2960 spellId) {
        return this.spellCooldowns.getOrDefault(spellId, 0) > 0;
    }

    private void castCrossbowSpell(class_1309 target, Spell spell, class_6880<Spell> spellEntry) {
        SpellHelper.ImpactContext context = new SpellHelper.ImpactContext().power(SpellPower.getSpellPower((SpellSchool)spell.school, this.mob)).position(this.mob.method_33571()).target(SpellHelper.focusMode((Spell)spell)).distance(1.0f);
        switch (String.valueOf(spell.deliver.type).toUpperCase()) {
            case "PROJECTILE": {
                Spell.ProjectileData.Perks perks = spell.deliver.projectile.projectile.perks != null ? spell.deliver.projectile.projectile.perks.copy() : new Spell.ProjectileData.Perks();
                class_243 launchPos = SpellHelper.launchPoint(this.mob);
                class_243 direction = target.method_33571().method_1020(launchPos).method_1029();
                float velocity = spell.deliver.projectile.launch_properties.velocity;
                float divergence = spell.deliver.projectile.projectile.divergence;
                SpellProjectile projectile = new SpellProjectile(this.mob.method_37908(), this.mob, launchPos.field_1352, launchPos.field_1351, launchPos.field_1350, SpellProjectile.Behaviour.FLY, spellEntry, context, perks);
                projectile.method_7485(direction.field_1352, direction.field_1351, direction.field_1350, velocity, divergence);
                projectile.range = spell.range;
                this.mob.method_37908().method_8649((class_1297)projectile);
                this.playSpellSound(spell);
                break;
            }
            case "METEOR": {
                SpellHelper.fallProjectile((class_1937)this.mob.method_37908(), this.mob, (class_1297)target, (class_243)target.method_19538(), spellEntry, (SpellHelper.ImpactContext)context);
                this.playSpellSound(spell);
                break;
            }
            case "DIRECT": {
                SpellHelper.performImpacts((class_1937)this.mob.method_37908(), this.mob, (class_1297)target, this.mob, spellEntry, (List)spell.impacts, (SpellHelper.ImpactContext)context);
                this.playSpellSound(spell);
            }
        }
        class_1799 crossbow = this.mob.method_5998(GuardVillagers.getHandWith(this.mob, item -> item instanceof class_1764));
        if (!crossbow.method_7960()) {
            crossbow.method_57381(class_9334.field_49649);
        }
    }

    private void shootCrossbowProjectileWithScaling(class_1309 target, class_1799 crossbowStack, class_1268 hand) {
        class_1799 arrowStack = this.mob.method_18808(crossbowStack);
        if (arrowStack.method_7960()) {
            arrowStack = new class_1799((class_1935)class_1802.field_8107);
        }
        class_1665 projectile = class_1675.method_18813(this.mob, (class_1799)arrowStack, (float)1.0f, (class_1799)crossbowStack);
        double[] rangedDamage = new double[]{0.0};
        class_2960 attrId = class_2960.method_60655((String)"ranged_weapon", (String)"damage");
        class_7923.field_41190.method_55841(attrId).ifPresent(attr -> {
            if (this.mob.method_6127().method_45331((class_6880)attr)) {
                rangedDamage[0] = this.mob.method_45325((class_6880)attr);
            }
        });
        projectile.method_7438(projectile.method_7448() + rangedDamage[0] / 2.0);
        class_243 targetPos = target.method_33571();
        double dx = targetPos.field_1352 - this.mob.method_23317();
        double dy = targetPos.field_1351 - projectile.method_23318();
        double dz = targetPos.field_1350 - this.mob.method_23321();
        double dist = Math.sqrt(dx * dx + dz * dz);
        projectile.method_7485(dx, dy + dist * 0.2, dz, 2.0f, 1.0f);
        this.mob.method_37908().method_8649((class_1297)projectile);
        crossbowStack.method_57381(class_9334.field_49649);
        this.mob.method_5783(class_3417.field_15187, 1.0f, 1.0f);
    }

    private void playSpellSound(Spell spell) {
        class_2960 soundId;
        if (spell.release != null && spell.release.sound != null && (soundId = class_2960.method_12829((String)spell.release.sound.id())) != null) {
            class_3414 sound = (class_3414)class_7923.field_41172.method_10223(soundId);
            this.mob.method_37908().method_8396(null, this.mob.method_24515(), sound, class_3419.field_15251, 1.0f, 1.0f);
        }
    }

    private boolean friendlyInLineOfSight() {
        List list = this.mob.method_37908().method_8335(this.mob, this.mob.method_5829().method_1014(5.0));
        for (class_1297 guard : list) {
            boolean isVillager;
            if (guard == this.mob.method_5968() || !(isVillager = ((GuardEntity)((Object)this.mob)).getOwner() == guard || guard.method_5864() == class_1299.field_6077 || guard.method_5864() == GuardVillagers.GUARD_VILLAGER || guard.method_5864() == class_1299.field_6147)) continue;
            class_243 direction = this.mob.method_5720();
            class_243 toEntity = guard.method_19538().method_1035(this.mob.method_19538()).method_1029();
            if (!(toEntity.method_1026(direction) < 1.0) || !this.mob.method_6057(guard) || !((double)guard.method_5739(this.mob) <= 4.0)) continue;
            return true;
        }
        return false;
    }

    public boolean findPosition() {
        class_243 pos = this.getPosition();
        if (pos == null) {
            return false;
        }
        this.wantedX = pos.field_1352;
        this.wantedY = pos.field_1351;
        this.wantedZ = pos.field_1350;
        return true;
    }

    @Nullable
    protected class_243 getPosition() {
        if (this.isValidTarget()) {
            return class_5532.method_31511(this.mob, (int)16, (int)7, (class_243)this.mob.method_5968().method_19538());
        }
        return class_5532.method_31510(this.mob, (int)16, (int)7);
    }

    private boolean canRun() {
        return this.crossbowState == CrossbowState.UNCHARGED;
    }

    public static enum CrossbowState {
        UNCHARGED,
        CHARGING,
        CHARGED,
        READY_TO_ATTACK,
        FIND_NEW_POSITION;

    }
}

