/*
 * Decompiled with CFR 0.152.
 */
package com.bogdan3000.dintegrate;

import com.bogdan3000.dintegrate.KeyHandler;
import com.bogdan3000.dintegrate.NetworkHandler;
import com.bogdan3000.dintegrate.command.DPICommand;
import com.bogdan3000.dintegrate.config.Action;
import com.bogdan3000.dintegrate.config.ConfigHandler;
import com.bogdan3000.dintegrate.donation.DonatePayProvider;
import com.bogdan3000.dintegrate.donation.DonationProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.ICommand;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="dintegrate", name="DonateIntegrate", version="2.0.8", clientSideOnly=true, acceptedMinecraftVersions="[1.12.2]")
@SideOnly(value=Side.CLIENT)
public class DonateIntegrate {
    public static final String MOD_ID = "dintegrate";
    public static final String NAME = "DonateIntegrate";
    public static final Logger LOGGER = LogManager.getLogger((String)"dintegrate");
    private static final long COMMAND_COOLDOWN_MS = 150L;
    private static DonationProvider donationProvider;
    private static DonateIntegrate instance;
    private static volatile boolean isConnectedToServer;
    private static final BlockingQueue<DonationProvider.DonationEvent> incomingDonations;
    private static final ScheduledExecutorService scheduler;
    private static final Map<Integer, Boolean> activeDonations;
    private static final Set<Integer> processedDonations;
    private static boolean providerStarted;

    public static DonateIntegrate getInstance() {
        return instance;
    }

    public DonationProvider getDonationProvider() {
        return donationProvider;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        instance = this;
        ConfigHandler.register(event.getSuggestedConfigurationFile());
        ClientRegistry.registerKeyBinding((KeyBinding)KeyHandler.KEY_OPEN_GUI);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new KeyHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
        this.initializeDonationProvider();
        NetworkHandler.init();
        ClientCommandHandler.instance.func_71560_a((ICommand)new DPICommand());
    }

    private void initializeDonationProvider() {
        donationProvider = new DonatePayProvider();
        donationProvider.onDonation(event -> {
            LOGGER.info("\ud83c\udf81 \u041d\u043e\u0432\u044b\u0439 \u0434\u043e\u043d\u0430\u0442 \u043e\u0442 {}: {} RUB | msg: {} | id: {}", (Object)event.username(), (Object)Float.valueOf(event.amount()), (Object)event.message(), (Object)event.id());
            incomingDonations.offer((DonationProvider.DonationEvent)event);
        });
        new Thread(DonateIntegrate::processDonationsQueue, "DonationQueueProcessor").start();
    }

    private static void processDonationsQueue() {
        while (true) {
            try {
                while (true) {
                    DonationProvider.DonationEvent event = incomingDonations.take();
                    DonateIntegrate.processDonation(event);
                }
            }
            catch (InterruptedException e) {
                LOGGER.warn("Donation queue processor interrupted");
            }
            catch (Exception e) {
                LOGGER.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0435 \u0434\u043e\u043d\u0430\u0442\u0430: {}", (Object)e.getMessage(), (Object)e);
                continue;
            }
            break;
        }
    }

    private static void processDonation(DonationProvider.DonationEvent event) {
        int id = event.id();
        if (!processedDonations.add(id)) {
            LOGGER.warn("\u0414\u043e\u043d\u0430\u0442 #{} \u0443\u0436\u0435 \u0431\u044b\u043b \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d \u2014 \u043f\u0440\u043e\u043f\u0443\u0441\u043a", (Object)id);
            return;
        }
        if (activeDonations.containsKey(id)) {
            LOGGER.warn("\u0414\u043e\u043d\u0430\u0442 #{} \u0443\u0436\u0435 \u043e\u0431\u0440\u0430\u0431\u0430\u0442\u044b\u0432\u0430\u0435\u0442\u0441\u044f, \u043f\u0440\u043e\u043f\u0443\u0441\u043a", (Object)id);
            return;
        }
        activeDonations.put(id, true);
        new Thread(() -> {
            try {
                ConfigHandler.getConfig().getActions().stream().filter(a -> (double)Math.abs(a.getSum() - event.amount()) < 0.001 && a.isEnabled()).findFirst().ifPresent(action -> {
                    ArrayList<String> cmds = action.getExecutionMode() == Action.ExecutionMode.ALL ? new ArrayList<String>(action.getCommands()) : Collections.singletonList(action.getCommands().get(new Random().nextInt(action.getCommands().size())));
                    DonateIntegrate.executeDonationCommands(id, event, cmds);
                });
            }
            catch (Exception e) {
                LOGGER.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0438 \u0434\u043e\u043d\u0430\u0442\u0430 #{}: {}", (Object)id, (Object)e.getMessage(), (Object)e);
            }
            finally {
                activeDonations.remove(id);
                LOGGER.info("\u2705 \u0414\u043e\u043d\u0430\u0442 #{} \u0437\u0430\u0432\u0435\u0440\u0448\u0451\u043d", (Object)id);
            }
        }, "DonationExec-" + id).start();
    }

    private static void executeDonationCommands(final int donationId, final DonationProvider.DonationEvent event, List<String> commands) {
        final Iterator<String> iterator = commands.iterator();
        Runnable chain = new Runnable(){

            @Override
            public void run() {
                if (!iterator.hasNext()) {
                    return;
                }
                String raw = (String)iterator.next();
                if (raw == null || raw.trim().isEmpty()) {
                    scheduler.schedule(this, 150L, TimeUnit.MILLISECONDS);
                    return;
                }
                String cmd = raw.replace("{username}", event.username()).replace("{message}", event.message()).replace("{amount}", String.valueOf(event.amount())).trim();
                if (cmd.toLowerCase().startsWith("/delay")) {
                    try {
                        int seconds = Integer.parseInt(cmd.split(" ")[1]);
                        LOGGER.info("[\u0414\u043e\u043d\u0430\u0442 #{}] \u23f1 \u0417\u0430\u0434\u0435\u0440\u0436\u043a\u0430 {} \u0441\u0435\u043a", (Object)donationId, (Object)seconds);
                        scheduler.schedule(this, (long)seconds, TimeUnit.SECONDS);
                    }
                    catch (Exception e) {
                        LOGGER.error("[\u0414\u043e\u043d\u0430\u0442 #{}] \u041e\u0448\u0438\u0431\u043a\u0430 \u0432 /delay: {}", (Object)donationId, (Object)e.getMessage());
                        scheduler.schedule(this, 150L, TimeUnit.MILLISECONDS);
                    }
                    return;
                }
                Minecraft mc = Minecraft.func_71410_x();
                if (mc.field_71439_g != null && isConnectedToServer) {
                    mc.func_152344_a(() -> mc.field_71439_g.func_71165_d(cmd));
                    LOGGER.info("[\u0414\u043e\u043d\u0430\u0442 #{}] \u0412\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0430 \u043a\u043e\u043c\u0430\u043d\u0434\u0430: {}", (Object)donationId, (Object)cmd);
                }
                scheduler.schedule(this, 150L, TimeUnit.MILLISECONDS);
            }
        };
        scheduler.schedule(chain, 0L, TimeUnit.MILLISECONDS);
    }

    public static void addCommand(CommandToExecute cmd) {
        DonationProvider.DonationEvent fake = new DonationProvider.DonationEvent(cmd.playerName, cmd.priority, cmd.command, (int)(System.currentTimeMillis() % Integer.MAX_VALUE));
        incomingDonations.offer(fake);
    }

    public static void addCommand(String username, float amount, String message) {
        int fakeId = (int)(System.currentTimeMillis() % Integer.MAX_VALUE);
        DonationProvider.DonationEvent fake = new DonationProvider.DonationEvent(username, amount, message, fakeId);
        incomingDonations.offer(fake);
    }

    public static synchronized void startDonationProvider() {
        if (providerStarted) {
            LOGGER.debug("\u23e9 \u041f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440 \u0443\u0436\u0435 \u0437\u0430\u043f\u0443\u0449\u0435\u043d, \u043f\u043e\u0432\u0442\u043e\u0440\u043d\u044b\u0439 \u0441\u0442\u0430\u0440\u0442 \u043f\u0440\u043e\u043f\u0443\u0449\u0435\u043d");
            return;
        }
        try {
            if (ConfigHandler.getConfig().isEnabled()) {
                DonateIntegrate.stopDonationProvider();
                donationProvider.connect();
                providerStarted = true;
                LOGGER.info("\ud83d\udd0c Donation provider \u0437\u0430\u043f\u0443\u0449\u0435\u043d");
            }
        }
        catch (Exception e) {
            LOGGER.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0443\u0441\u043a\u0430 \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440\u0430: {}", (Object)e.getMessage());
        }
    }

    public static void stopDonationProvider() {
        try {
            if (donationProvider != null) {
                donationProvider.disconnect();
            }
        }
        catch (Exception e) {
            LOGGER.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440\u0430: {}", (Object)e.getMessage());
        }
        finally {
            providerStarted = false;
        }
    }

    static {
        isConnectedToServer = false;
        incomingDonations = new LinkedBlockingQueue<DonationProvider.DonationEvent>();
        scheduler = Executors.newScheduledThreadPool(8);
        activeDonations = new ConcurrentHashMap<Integer, Boolean>();
        processedDonations = ConcurrentHashMap.newKeySet();
        providerStarted = false;
    }

    @SideOnly(value=Side.CLIENT)
    public static class ClientEventHandler {
        private int ticks = 0;
        private boolean providerStartedOnce = false;

        @SubscribeEvent
        public void onClientTick(TickEvent.ClientTickEvent e) {
            if (e.phase != TickEvent.Phase.END || !isConnectedToServer) {
                return;
            }
            ++this.ticks;
            if (this.ticks % 6000 == 0) {
                try {
                    if (!ConfigHandler.getConfig().isEnabled()) {
                        DonateIntegrate.stopDonationProvider();
                        this.providerStartedOnce = false;
                    } else if (!donationProvider.isConnected() && !this.providerStartedOnce) {
                        DonateIntegrate.startDonationProvider();
                        this.providerStartedOnce = true;
                        LOGGER.info("\ud83d\udd01 \u041f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440 \u043f\u0435\u0440\u0435\u0437\u0430\u043f\u0443\u0449\u0435\u043d \u0447\u0435\u0440\u0435\u0437 \u0442\u0438\u043a-\u0447\u0435\u043a");
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0435 \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440\u0430: {}", (Object)ex.getMessage());
                }
            }
        }

        @SubscribeEvent
        public void onClientConnectedToServer(FMLNetworkEvent.ClientConnectedToServerEvent e) {
            if (!this.providerStartedOnce) {
                isConnectedToServer = true;
                DonateIntegrate.startDonationProvider();
                this.providerStartedOnce = true;
                LOGGER.debug("\u041f\u0435\u0440\u0432\u043e\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u043a\u043b\u0438\u0435\u043d\u0442\u0430 \u2014 \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440 \u0437\u0430\u043f\u0443\u0449\u0435\u043d");
            } else {
                LOGGER.debug("\u041f\u043e\u0432\u0442\u043e\u0440\u043d\u043e\u0435 \u0441\u043e\u0431\u044b\u0442\u0438\u0435 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u043f\u0440\u043e\u0438\u0433\u043d\u043e\u0440\u0438\u0440\u043e\u0432\u0430\u043d\u043e");
            }
        }

        @SubscribeEvent
        public void onClientDisconnectionFromServer(FMLNetworkEvent.ClientDisconnectionFromServerEvent e) {
            isConnectedToServer = false;
            DonateIntegrate.stopDonationProvider();
            activeDonations.clear();
            processedDonations.clear();
            this.providerStartedOnce = false;
            LOGGER.debug("\u041a\u043b\u0438\u0435\u043d\u0442 \u043e\u0442\u043a\u043b\u044e\u0447\u0451\u043d \u2014 \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440 \u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d");
        }
    }

    public static class CommandToExecute {
        public final String command;
        public final String playerName;
        public final int priority;

        public CommandToExecute(String command, String playerName, int priority) {
            this.command = command.trim();
            this.playerName = playerName;
            this.priority = priority;
        }
    }
}

