/*
 * Decompiled with CFR 0.152.
 */
package com.bogdan3000.dintegrate.command;

import com.bogdan3000.dintegrate.DonateIntegrate;
import com.bogdan3000.dintegrate.NetworkHandler;
import com.bogdan3000.dintegrate.config.Action;
import com.bogdan3000.dintegrate.config.ConfigHandler;
import com.bogdan3000.dintegrate.config.ModConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class DPICommand
extends CommandBase {
    @Nonnull
    public String func_71517_b() {
        return "dpi";
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender sender) {
        return I18n.func_135052_a((String)"dintegrate.command.usage", (Object[])new Object[0]);
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
        if (server != null && server.func_71262_S()) {
            return;
        }
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        if (!Minecraft.func_71410_x().field_71439_g.func_70005_c_().equals(sender.func_70005_c_())) {
            return;
        }
        if (args.length == 0) {
            this.showHelp(sender);
            return;
        }
        String subCommand = args[0].toLowerCase();
        ModConfig config = ConfigHandler.getConfig();
        try {
            switch (subCommand) {
                case "gui": {
                    if (!(sender instanceof EntityPlayerMP)) {
                        throw new CommandException(I18n.func_135052_a((String)"dintegrate.command.error.player_only", (Object[])new Object[0]), new Object[0]);
                    }
                    EntityPlayerMP player = (EntityPlayerMP)sender;
                    NetworkHandler.INSTANCE.sendTo((IMessage)new NetworkHandler.OpenGuiMessage(), player);
                    sender.func_145747_a(new TextComponentTranslation("dintegrate.command.gui_open", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
                    break;
                }
                case "set_token": {
                    if (args.length < 2) {
                        throw new CommandException(I18n.func_135052_a((String)"dintegrate.command.error.token_usage", (Object[])new Object[0]), new Object[0]);
                    }
                    String token = args[1];
                    if (token.length() < 10) {
                        throw new CommandException(I18n.func_135052_a((String)"dintegrate.command.error.token_short", (Object[])new Object[0]), new Object[0]);
                    }
                    config.setDonpayToken(token);
                    ConfigHandler.save();
                    sender.func_145747_a(new TextComponentTranslation("dintegrate.command.token_updated", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
                    DonateIntegrate.LOGGER.info("Token updated by {}", (Object)sender.func_70005_c_());
                    DonateIntegrate.startDonationProvider();
                    break;
                }
                case "set_userid": {
                    if (args.length < 2) {
                        throw new CommandException(I18n.func_135052_a((String)"dintegrate.command.error.userid_usage", (Object[])new Object[0]), new Object[0]);
                    }
                    String userId = args[1];
                    if (!userId.matches("\\d+")) {
                        throw new CommandException(I18n.func_135052_a((String)"dintegrate.command.error.userid_numeric", (Object[])new Object[0]), new Object[0]);
                    }
                    config.setUserId(userId);
                    ConfigHandler.save();
                    sender.func_145747_a(new TextComponentTranslation("dintegrate.command.userid_set", new Object[]{userId}).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
                    DonateIntegrate.LOGGER.info("User ID set to {} by {}", (Object)userId, (Object)sender.func_70005_c_());
                    DonateIntegrate.startDonationProvider();
                    break;
                }
                case "enable": {
                    config.setEnabled(true);
                    ConfigHandler.save();
                    sender.func_145747_a(new TextComponentTranslation("dintegrate.command.enabled", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
                    DonateIntegrate.startDonationProvider();
                    break;
                }
                case "disable": {
                    config.setEnabled(false);
                    ConfigHandler.save();
                    sender.func_145747_a(new TextComponentTranslation("dintegrate.command.disabled", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
                    DonateIntegrate.stopDonationProvider();
                    break;
                }
                case "status": {
                    this.showStatus(sender, config);
                    break;
                }
                case "reload": {
                    DonateIntegrate.startDonationProvider();
                    sender.func_145747_a(new TextComponentTranslation("dintegrate.command.reloaded", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
                    break;
                }
                case "reload_config": {
                    ConfigHandler.load();
                    sender.func_145747_a(new TextComponentTranslation("dintegrate.command.config_reloaded", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
                    DonateIntegrate.LOGGER.info("Configuration reloaded by {}", (Object)sender.func_70005_c_());
                    break;
                }
                case "test": {
                    float amount;
                    if (args.length < 3) {
                        throw new CommandException(I18n.func_135052_a((String)"dintegrate.command.error.test_usage", (Object[])new Object[0]), new Object[0]);
                    }
                    String username = args[1];
                    try {
                        amount = Float.parseFloat(args[2]);
                    }
                    catch (NumberFormatException e) {
                        throw new CommandException(I18n.func_135052_a((String)"dintegrate.command.error.amount_numeric", (Object[])new Object[0]), new Object[0]);
                    }
                    if (amount <= 0.0f) {
                        throw new CommandException(I18n.func_135052_a((String)"dintegrate.command.error.amount_positive", (Object[])new Object[0]), new Object[0]);
                    }
                    String message = args.length > 3 ? String.join((CharSequence)" ", Arrays.copyOfRange(args, 3, args.length)) : "";
                    this.testDonation(sender, username, amount, message);
                    break;
                }
                default: {
                    this.showHelp(sender);
                    break;
                }
            }
        }
        catch (CommandException e) {
            throw e;
        }
        catch (Exception e) {
            DonateIntegrate.LOGGER.error("Error executing /dpi {}: {}", (Object)subCommand, (Object)e.getMessage());
            throw new CommandException(I18n.func_135052_a((String)"dintegrate.command.error.internal", (Object[])new Object[]{e.getMessage()}), new Object[0]);
        }
    }

    private void showHelp(@Nonnull ICommandSender sender) {
        sender.func_145747_a(new TextComponentTranslation("dintegrate.command.help.title", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("dintegrate.command.help.gui", new Object[0]));
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("dintegrate.command.help.set_token", new Object[0]));
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("dintegrate.command.help.set_userid", new Object[0]));
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("dintegrate.command.help.enable", new Object[0]));
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("dintegrate.command.help.disable", new Object[0]));
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("dintegrate.command.help.status", new Object[0]));
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("dintegrate.command.help.reload", new Object[0]));
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("dintegrate.command.help.reload_config", new Object[0]));
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("dintegrate.command.help.test", new Object[0]));
    }

    private void showStatus(@Nonnull ICommandSender sender, @Nonnull ModConfig config) {
        sender.func_145747_a(new TextComponentTranslation("dintegrate.command.status.title", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
        sender.func_145747_a(new TextComponentTranslation("dintegrate.command.status.enabled", new Object[]{config.isEnabled() ? I18n.func_135052_a((String)"dintegrate.gui.value.yes", (Object[])new Object[0]) : I18n.func_135052_a((String)"dintegrate.gui.value.no", (Object[])new Object[0])}).func_150255_a(new Style().func_150238_a(config.isEnabled() ? TextFormatting.GREEN : TextFormatting.RED)));
        String token = config.getDonpayToken();
        sender.func_145747_a(new TextComponentTranslation("dintegrate.command.status.token", new Object[]{token.isEmpty() ? I18n.func_135052_a((String)"dintegrate.gui.value.not_set", (Object[])new Object[0]) : I18n.func_135052_a((String)"dintegrate.gui.value.set", (Object[])new Object[]{this.maskToken(token)})}).func_150255_a(new Style().func_150238_a(token.isEmpty() ? TextFormatting.RED : TextFormatting.GREEN)));
        String userId = config.getUserId();
        sender.func_145747_a(new TextComponentTranslation("dintegrate.command.status.user_id", new Object[]{userId.isEmpty() ? I18n.func_135052_a((String)"dintegrate.gui.value.not_set", (Object[])new Object[0]) : userId}).func_150255_a(new Style().func_150238_a(userId.isEmpty() ? TextFormatting.RED : TextFormatting.GREEN)));
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("dintegrate.command.status.last_donation", new Object[]{config.getLastDonate()}));
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("dintegrate.command.status.actions", new Object[]{config.getActions().size()}));
        for (Action action : config.getActions()) {
            sender.func_145747_a(new TextComponentTranslation("dintegrate.command.status.action", new Object[]{Float.valueOf(action.getSum()), action.isEnabled() ? I18n.func_135052_a((String)"dintegrate.gui.value.yes", (Object[])new Object[0]) : I18n.func_135052_a((String)"dintegrate.gui.value.no", (Object[])new Object[0]), action.getPriority(), I18n.func_135052_a((String)("dintegrate.gui.value.mode." + action.getExecutionMode().name().toLowerCase()), (Object[])new Object[0]), action.getCommands().size()}).func_150255_a(new Style().func_150238_a(TextFormatting.WHITE)));
        }
    }

    @Nonnull
    private String maskToken(@Nonnull String token) {
        if (token.isEmpty()) {
            return I18n.func_135052_a((String)"dintegrate.gui.value.empty", (Object[])new Object[0]);
        }
        if (token.length() <= 10) {
            return token;
        }
        return token.substring(0, 4) + "..." + token.substring(token.length() - 4);
    }

    private void testDonation(@Nonnull ICommandSender sender, @Nonnull String username, float amount, @Nonnull String message) {
        ModConfig config = ConfigHandler.getConfig();
        boolean actionFound = false;
        Random random = new Random();
        for (Action action : config.getActions()) {
            if (!((double)Math.abs(action.getSum() - amount) < 0.001) || !action.isEnabled()) continue;
            ArrayList<String> commandsToExecute = new ArrayList<String>();
            List<String> availableCommands = action.getCommands();
            if (availableCommands.isEmpty()) {
                sender.func_145747_a(new TextComponentTranslation("dintegrate.command.error.no_commands", new Object[]{Float.valueOf(amount)}).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                return;
            }
            switch (action.getExecutionMode()) {
                case ALL: {
                    commandsToExecute.addAll(availableCommands);
                    break;
                }
                case RANDOM_ONE: {
                    commandsToExecute.add(availableCommands.get(random.nextInt(availableCommands.size())));
                }
            }
            for (String cmd : commandsToExecute) {
                String command = cmd.replace("{username}", username).replace("{message}", message).replace("{amount}", String.valueOf(amount));
                DonateIntegrate.addCommand(username, amount, message);
            }
            sender.func_145747_a(new TextComponentTranslation("dintegrate.command.test_success", new Object[]{username, Float.valueOf(amount), message, commandsToExecute.size()}).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
            actionFound = true;
            break;
        }
        if (!actionFound) {
            sender.func_145747_a(new TextComponentTranslation("dintegrate.command.error.no_action", new Object[]{Float.valueOf(amount)}).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
        }
    }

    public int func_82362_a() {
        return 4;
    }
}

