/*
 * Decompiled with CFR 0.152.
 */
package com.bogdan3000.dintegrate.config;

import com.bogdan3000.dintegrate.DonateIntegrate;
import com.bogdan3000.dintegrate.config.Action;
import com.bogdan3000.dintegrate.config.ModConfig;
import com.bogdan3000.dintegrate.snakeyaml.Yaml;
import com.bogdan3000.dintegrate.snakeyaml.constructor.Constructor;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.List;

public class ConfigHandler {
    private static File configFile;
    private static ModConfig cachedConfig;
    private static long lastModified;
    private static final Yaml YAML;

    public static void register(File file) {
        configFile = new File(file.getParentFile(), "dintegrate.yml");
        if (!configFile.exists()) {
            cachedConfig = new ModConfig();
            ConfigHandler.save();
        } else {
            ConfigHandler.load();
        }
        lastModified = configFile.lastModified();
    }

    public static void load() {
        try (BufferedReader reader = new BufferedReader(new FileReader(configFile));){
            ModConfig config = YAML.loadAs(reader, ModConfig.class);
            if (config == null || !ConfigHandler.isValid(config)) {
                DonateIntegrate.LOGGER.warn("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u0430\u044f \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f, \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u043e\u0439");
                config = new ModConfig();
            }
            cachedConfig = config;
            lastModified = configFile.lastModified();
            DonateIntegrate.LOGGER.debug("\u0417\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u0430 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f: token={}, userId={}", (Object)ConfigHandler.maskToken(config.getDonpayToken()), (Object)config.getUserId());
        }
        catch (Exception e) {
            DonateIntegrate.LOGGER.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438: {}", (Object)e.getMessage());
            cachedConfig = new ModConfig();
            ConfigHandler.save();
        }
    }

    public static void save() {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(configFile));){
            YAML.dump(cachedConfig, writer);
            lastModified = configFile.lastModified();
            DonateIntegrate.LOGGER.debug("\u0421\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0430 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f: token={}, userId={}", (Object)ConfigHandler.maskToken(cachedConfig.getDonpayToken()), (Object)cachedConfig.getUserId());
        }
        catch (Exception e) {
            DonateIntegrate.LOGGER.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438: {}", (Object)e.getMessage());
        }
    }

    public static void checkAndReloadConfig() {
        try {
            if (configFile.lastModified() > lastModified) {
                DonateIntegrate.LOGGER.info("\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0430, \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0430...");
                ConfigHandler.load();
            }
        }
        catch (Exception e) {
            DonateIntegrate.LOGGER.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438: {}", (Object)e.getMessage());
        }
    }

    public static ModConfig getConfig() {
        if (cachedConfig == null) {
            ConfigHandler.load();
        }
        return cachedConfig;
    }

    private static boolean isValid(ModConfig config) {
        try {
            List<Action> actions = config.getActions();
            if (actions == null || actions.isEmpty()) {
                DonateIntegrate.LOGGER.warn("\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u044b");
                return false;
            }
            for (Action action : actions) {
                if (action.getSum() <= 0.0f) {
                    DonateIntegrate.LOGGER.warn("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430: {}", (Object)Float.valueOf(action.getSum()));
                    return false;
                }
                if (action.getCommands().isEmpty()) {
                    DonateIntegrate.LOGGER.warn("\u041d\u0435\u0442 \u043a\u043e\u043c\u0430\u043d\u0434 \u0434\u043b\u044f \u0441\u0443\u043c\u043c\u044b: {}", (Object)Float.valueOf(action.getSum()));
                    return false;
                }
                for (String command : action.getCommands()) {
                    if (command != null && !command.trim().isEmpty()) continue;
                    DonateIntegrate.LOGGER.warn("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u0430\u044f \u043a\u043e\u043c\u0430\u043d\u0434\u0430 \u0434\u043b\u044f \u0441\u0443\u043c\u043c\u044b: {}", (Object)Float.valueOf(action.getSum()));
                    return false;
                }
                if (action.getPriority() >= 0) continue;
                DonateIntegrate.LOGGER.warn("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u043f\u0440\u0438\u043e\u0440\u0438\u0442\u0435\u0442 \u0434\u043b\u044f \u0441\u0443\u043c\u043c\u044b: {}", (Object)Float.valueOf(action.getSum()));
                return false;
            }
            if (config.getDonpayToken() == null || config.getDonpayToken().isEmpty()) {
                DonateIntegrate.LOGGER.warn("\u0422\u043e\u043a\u0435\u043d DonatePay \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d");
                return false;
            }
            if (config.getUserId() == null || config.getUserId().isEmpty()) {
                DonateIntegrate.LOGGER.warn("User ID \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            DonateIntegrate.LOGGER.error("\u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u0430\u043b\u0438\u0434\u0430\u0446\u0438\u0438 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438: {}", (Object)e.getMessage());
            return false;
        }
    }

    private static String maskToken(String token) {
        if (token == null || token.length() <= 10) {
            return token != null ? token : "<null>";
        }
        return token.substring(0, 4) + "..." + token.substring(token.length() - 4);
    }

    static {
        YAML = new Yaml(new Constructor(ModConfig.class));
    }
}

