/*
 * Decompiled with CFR 0.152.
 */
package com.bogdan3000.dintegrate.donation;

import com.bogdan3000.dintegrate.DonateIntegrate;
import com.bogdan3000.dintegrate.config.ConfigHandler;
import com.bogdan3000.dintegrate.donation.DonationProvider;
import com.bogdan3000.dintegrate.gson.Gson;
import com.bogdan3000.dintegrate.gson.JsonArray;
import com.bogdan3000.dintegrate.gson.JsonObject;
import com.bogdan3000.dintegrate.java_websocket.client.WebSocketClient;
import com.bogdan3000.dintegrate.java_websocket.handshake.ServerHandshake;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public class DonatePayProvider
implements DonationProvider {
    private static final Gson GSON = new Gson();
    private WebSocketClient socket;
    private Consumer<DonationProvider.DonationEvent> donationHandler;
    private volatile boolean isConnected;
    private String clientId;
    private final AtomicInteger messageId = new AtomicInteger(3);
    private ScheduledExecutorService pingScheduler;

    @Override
    public void connect() {
        try {
            if (this.isConnected && this.socket != null && this.socket.isOpen()) {
                DonateIntegrate.LOGGER.info("WebSocket already connected, skipping reconnect");
                return;
            }
            this.disconnect();
            String token = ConfigHandler.getConfig().getDonpayToken();
            String userId = ConfigHandler.getConfig().getUserId();
            if (token == null || token.trim().isEmpty() || userId == null || !userId.matches("\\d+")) {
                DonateIntegrate.LOGGER.error("Invalid token or User ID");
                this.isConnected = false;
                return;
            }
            String connectionToken = this.getConnectionToken(token);
            if (connectionToken == null) {
                DonateIntegrate.LOGGER.error("Failed to obtain connection token");
                this.isConnected = false;
                return;
            }
            URI serverUri = new URI(ConfigHandler.getConfig().getDonpayWebSocketUrl());
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("User-Agent", "Minecraft-DonateIntegrate/2.1.3");
            this.socket = new DonatePayWebSocket(serverUri, token, connectionToken, headers);
            this.socket.setConnectionLostTimeout(30);
            this.socket.connect();
            for (int connectionTimeout = 0; !this.socket.isOpen() && connectionTimeout < 30; ++connectionTimeout) {
                Thread.sleep(1000L);
            }
            if (!this.socket.isOpen()) {
                DonateIntegrate.LOGGER.error("WebSocket connection timeout");
                this.isConnected = false;
                return;
            }
            this.isConnected = true;
            this.startPingScheduler();
            DonateIntegrate.LOGGER.info("Connected to DonatePay WebSocket");
        }
        catch (Exception e) {
            this.isConnected = false;
            DonateIntegrate.LOGGER.error("Error connecting to DonatePay: {}", (Object)e.getMessage());
        }
    }

    @Override
    public void disconnect() {
        try {
            this.isConnected = false;
            if (this.pingScheduler != null) {
                this.pingScheduler.shutdownNow();
                this.pingScheduler = null;
            }
            if (this.socket != null) {
                if (this.socket.isOpen()) {
                    this.socket.close();
                }
                this.socket = null;
                DonateIntegrate.LOGGER.info("Disconnected from DonatePay");
            }
        }
        catch (Exception e) {
            DonateIntegrate.LOGGER.error("Error disconnecting from DonatePay: {}", (Object)e.getMessage());
        }
    }

    @Override
    public boolean isConnected() {
        return this.isConnected && this.socket != null && this.socket.isOpen();
    }

    @Override
    public void onDonation(Consumer<DonationProvider.DonationEvent> handler) {
        this.donationHandler = handler;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getConnectionToken(String accessToken) {
        try {
            URL url = new URL(ConfigHandler.getConfig().getDonpayApiUrl() + "?access_token=" + accessToken);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("Accept", "application/json");
            conn.setRequestProperty("User-Agent", "Minecraft-DonateIntegrate/2.1.3");
            conn.setDoOutput(true);
            JsonObject payload = new JsonObject();
            payload.addProperty("client", "java");
            try (OutputStream os = conn.getOutputStream();){
                byte[] input = GSON.toJson(payload).getBytes(StandardCharsets.UTF_8);
                os.write(input, 0, input.length);
            }
            if (conn.getResponseCode() != 200) {
                DonateIntegrate.LOGGER.error("Failed to get token, HTTP code: {}", (Object)conn.getResponseCode());
                return null;
            }
            throwable = null;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                StringBuilder response = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    response.append(line);
                }
                JsonObject jsonResponse = GSON.fromJson(response.toString(), JsonObject.class);
                String string = jsonResponse.get("token").getAsString();
                return string;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (Exception e) {
            DonateIntegrate.LOGGER.error("Error getting connection token: {}", (Object)e.getMessage());
            return null;
        }
    }

    private void startPingScheduler() {
        this.pingScheduler = Executors.newScheduledThreadPool(1);
        this.pingScheduler.scheduleAtFixedRate(() -> {
            try {
                if (this.socket != null && this.socket.isOpen()) {
                    JsonObject pingMsg = new JsonObject();
                    pingMsg.addProperty("id", this.messageId.getAndIncrement());
                    pingMsg.addProperty("method", 7);
                    this.socket.send(GSON.toJson(pingMsg));
                    DonateIntegrate.LOGGER.debug("Sent ping: {}", (Object)pingMsg);
                    if (!this.isValidConnection()) {
                        this.isConnected = false;
                        DonateIntegrate.LOGGER.warn("Connection validation failed");
                    }
                } else {
                    this.isConnected = false;
                }
            }
            catch (Exception e) {
                this.isConnected = false;
                DonateIntegrate.LOGGER.error("Error sending ping: {}", (Object)e.getMessage());
            }
        }, 0L, 15L, TimeUnit.SECONDS);
    }

    private boolean isValidConnection() {
        try {
            if (this.socket == null || !this.socket.isOpen()) {
                return false;
            }
            String token = ConfigHandler.getConfig().getDonpayToken();
            String userId = ConfigHandler.getConfig().getUserId();
            return token != null && !token.trim().isEmpty() && userId != null && userId.matches("\\d+");
        }
        catch (Exception e) {
            return false;
        }
    }

    private class DonatePayWebSocket
    extends WebSocketClient {
        private final String accessToken;
        private final String connectionToken;

        public DonatePayWebSocket(URI serverUri, String accessToken, String connectionToken, Map<String, String> headers) {
            super(serverUri, headers);
            this.accessToken = accessToken;
            this.connectionToken = connectionToken;
        }

        @Override
        public void onOpen(ServerHandshake handshake) {
            DonateIntegrate.LOGGER.info("WebSocket connection opened");
            this.sendHandshake();
        }

        @Override
        public void onMessage(String message) {
            try {
                JsonObject jsonMsg = GSON.fromJson(message, JsonObject.class);
                this.handleMessage(jsonMsg);
            }
            catch (Exception e) {
                DonateIntegrate.LOGGER.error("Error processing message: {}", (Object)e.getMessage());
            }
        }

        @Override
        public void onClose(int code, String reason, boolean remote) {
            DonatePayProvider.this.isConnected = false;
            DonateIntegrate.LOGGER.warn("WebSocket closed: {} (code: {})", (Object)reason, (Object)code);
        }

        @Override
        public void onError(Exception ex) {
            DonatePayProvider.this.isConnected = false;
            DonateIntegrate.LOGGER.error("WebSocket error: {}", (Object)ex.getMessage());
        }

        private void sendHandshake() {
            try {
                JsonObject handshakeMsg = new JsonObject();
                JsonObject params = new JsonObject();
                params.addProperty("token", this.connectionToken);
                params.addProperty("name", "java");
                handshakeMsg.add("params", params);
                handshakeMsg.addProperty("id", 1);
                this.send(GSON.toJson(handshakeMsg));
                DonateIntegrate.LOGGER.debug("Sent handshake: {}", (Object)handshakeMsg);
            }
            catch (Exception e) {
                DonatePayProvider.this.isConnected = false;
                DonateIntegrate.LOGGER.error("Error sending handshake: {}", (Object)e.getMessage());
            }
        }

        private void handleMessage(JsonObject jsonMsg) {
            try {
                if (jsonMsg.has("error")) {
                    DonatePayProvider.this.isConnected = false;
                    DonateIntegrate.LOGGER.error("Server error: {}", (Object)jsonMsg.get("error"));
                    return;
                }
                if (jsonMsg.has("id") && jsonMsg.get("id").getAsInt() == 1) {
                    this.handleHandshakeResponse(jsonMsg);
                } else if (jsonMsg.has("id") && jsonMsg.get("id").getAsInt() == 2) {
                    this.handleSubscriptionResponse(jsonMsg);
                } else if (jsonMsg.has("id") && jsonMsg.get("id").getAsInt() >= 3) {
                    this.handlePingResponse(jsonMsg);
                } else if (jsonMsg.has("result")) {
                    this.handlePushNotification(jsonMsg);
                }
            }
            catch (Exception e) {
                DonatePayProvider.this.isConnected = false;
                DonateIntegrate.LOGGER.error("Error processing message: {}", (Object)e.getMessage());
            }
        }

        private void handleHandshakeResponse(JsonObject jsonMsg) {
            try {
                if (!jsonMsg.has("result")) {
                    DonatePayProvider.this.isConnected = false;
                    DonateIntegrate.LOGGER.error("Handshake failed: {}", (Object)jsonMsg);
                    return;
                }
                JsonObject result = jsonMsg.getAsJsonObject("result");
                if (!result.has("client")) {
                    DonatePayProvider.this.isConnected = false;
                    DonateIntegrate.LOGGER.error("No client ID: {}", (Object)jsonMsg);
                    return;
                }
                DonatePayProvider.this.clientId = result.get("client").getAsString();
                DonateIntegrate.LOGGER.info("Received client ID: {}", (Object)DonatePayProvider.this.clientId);
                String channel = "$public:" + ConfigHandler.getConfig().getUserId();
                String channelToken = this.getChannelToken(this.accessToken, DonatePayProvider.this.clientId, channel);
                if (channelToken == null) {
                    DonatePayProvider.this.isConnected = false;
                    DonateIntegrate.LOGGER.error("Failed to obtain channel token");
                    return;
                }
                JsonObject subscribeMsg = new JsonObject();
                subscribeMsg.addProperty("id", 2);
                subscribeMsg.addProperty("method", 1);
                JsonObject params = new JsonObject();
                params.addProperty("channel", channel);
                params.addProperty("token", channelToken);
                subscribeMsg.add("params", params);
                this.send(GSON.toJson(subscribeMsg));
                DonateIntegrate.LOGGER.debug("Sent subscription: {}", (Object)subscribeMsg);
            }
            catch (Exception e) {
                DonatePayProvider.this.isConnected = false;
                DonateIntegrate.LOGGER.error("Error processing handshake: {}", (Object)e.getMessage());
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private String getChannelToken(String accessToken, String clientId, String channel) {
            try {
                JsonObject payload = new JsonObject();
                payload.addProperty("client", clientId);
                JsonArray channels = new JsonArray();
                channels.add(channel);
                payload.add("channels", channels);
                URL url = new URL(ConfigHandler.getConfig().getDonpayApiUrl() + "?access_token=" + accessToken);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Content-Type", "application/json");
                conn.setRequestProperty("Accept", "application/json");
                conn.setRequestProperty("User-Agent", "Minecraft-DonateIntegrate/2.1.3");
                conn.setDoOutput(true);
                try (OutputStream os = conn.getOutputStream();){
                    byte[] input = GSON.toJson(payload).getBytes(StandardCharsets.UTF_8);
                    os.write(input, 0, input.length);
                }
                if (conn.getResponseCode() != 200) {
                    DonatePayProvider.this.isConnected = false;
                    DonateIntegrate.LOGGER.error("Failed to get channel token, HTTP code: {}", (Object)conn.getResponseCode());
                    return null;
                }
                var9_10 = null;
                try (BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
                    String line;
                    StringBuilder response = new StringBuilder();
                    while ((line = br.readLine()) != null) {
                        response.append(line);
                    }
                    JsonObject jsonResponse = GSON.fromJson(response.toString(), JsonObject.class);
                    JsonArray channelsArray = jsonResponse.getAsJsonArray("channels");
                    for (int i = 0; i < channelsArray.size(); ++i) {
                        JsonObject channelObj = channelsArray.get(i).getAsJsonObject();
                        if (!channelObj.get("channel").getAsString().equals(channel)) continue;
                        String string = channelObj.get("token").getAsString();
                        return string;
                    }
                    String string = null;
                    return string;
                }
                catch (Throwable throwable) {
                    var9_10 = throwable;
                    throw throwable;
                }
            }
            catch (Exception e) {
                DonatePayProvider.this.isConnected = false;
                DonateIntegrate.LOGGER.error("Error getting channel token: {}", (Object)e.getMessage());
                return null;
            }
        }

        private void handleSubscriptionResponse(JsonObject jsonMsg) {
            try {
                if (jsonMsg.has("result")) {
                    DonatePayProvider.this.isConnected = true;
                    DonateIntegrate.LOGGER.info("Successfully subscribed to donation channel");
                } else if (jsonMsg.has("error")) {
                    DonatePayProvider.this.isConnected = false;
                    DonateIntegrate.LOGGER.error("Subscription error: {}", (Object)jsonMsg.get("error"));
                }
            }
            catch (Exception e) {
                DonatePayProvider.this.isConnected = false;
                DonateIntegrate.LOGGER.error("Error processing subscription response: {}", (Object)e.getMessage());
            }
        }

        private void handlePingResponse(JsonObject jsonMsg) {
            try {
                if (jsonMsg.has("result")) {
                    DonateIntegrate.LOGGER.debug("Received ping response: {}", (Object)jsonMsg);
                } else if (jsonMsg.has("error")) {
                    DonatePayProvider.this.isConnected = false;
                    DonateIntegrate.LOGGER.error("Ping error: {}", (Object)jsonMsg.get("error"));
                }
            }
            catch (Exception e) {
                DonatePayProvider.this.isConnected = false;
                DonateIntegrate.LOGGER.error("Error processing ping: {}", (Object)e.getMessage());
            }
        }

        private void handlePushNotification(JsonObject jsonMsg) {
            try {
                String comment;
                JsonObject result = jsonMsg.getAsJsonObject("result");
                if (!result.has("channel") || !result.has("data")) {
                    DonateIntegrate.LOGGER.warn("Invalid notification format: {}", (Object)result);
                    return;
                }
                JsonObject data = result.getAsJsonObject("data");
                if (!data.has("data") || !data.getAsJsonObject("data").has("notification")) {
                    DonateIntegrate.LOGGER.warn("Missing notification: {}", (Object)data);
                    return;
                }
                JsonObject notification = data.getAsJsonObject("data").getAsJsonObject("notification");
                if (!notification.has("id") || !notification.has("vars")) {
                    DonateIntegrate.LOGGER.warn("Invalid notification: {}", (Object)notification);
                    return;
                }
                JsonObject vars = notification.getAsJsonObject("vars");
                if (!vars.has("sum") || !vars.has("name")) {
                    DonateIntegrate.LOGGER.warn("Missing donation variables: {}", (Object)vars);
                    return;
                }
                int id = notification.get("id").getAsInt();
                float sum = vars.get("sum").getAsFloat();
                String username = vars.get("name").getAsString();
                String string = comment = vars.has("comment") ? vars.get("comment").getAsString() : "";
                if (id <= ConfigHandler.getConfig().getLastDonate()) {
                    DonateIntegrate.LOGGER.info("Skipped processed donation #{}", (Object)id);
                    return;
                }
                if (DonatePayProvider.this.donationHandler != null) {
                    DonatePayProvider.this.donationHandler.accept(new DonationProvider.DonationEvent(username, sum, comment, id));
                }
            }
            catch (Exception e) {
                DonateIntegrate.LOGGER.error("Error processing notification: {}", (Object)e.getMessage());
            }
        }
    }
}

