/*
 * Decompiled with CFR 0.152.
 */
package com.bogdan3000.dintegrate.gui;

import com.bogdan3000.dintegrate.config.Action;
import com.bogdan3000.dintegrate.config.ConfigHandler;
import com.bogdan3000.dintegrate.gui.CommandEditGui;
import com.bogdan3000.dintegrate.gui.GuiRenderUtils;
import com.bogdan3000.dintegrate.gui.MessageGui;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class ActionEditGui
extends GuiScreen {
    private static final int CONTENT_MARGIN = 12;
    private static final int FIELD_HEIGHT = 20;
    private static final int DEFAULT_FIELD_WIDTH = 200;
    private static final int BUTTON_WIDTH = 24;
    private static final int EXPAND_BUTTON_WIDTH = 20;
    private static final int BUTTON_SPACING = 10;
    private static final int COMMAND_ITEM_HEIGHT = 28;
    private static final int COMMAND_ITEM_SPACING = 8;
    private int windowLeft;
    private int windowTop;
    private int windowWidth;
    private int windowHeight;
    private float fadeAnimation = 0.0f;
    private float scrollOffset = 0.0f;
    private boolean isDraggingScrollbar = false;
    private final GuiScreen parent;
    private final Action editingAction;
    private GuiTextField sumField;
    private GuiTextField priorityField;
    protected List<CommandEntry> commandEntries = new ArrayList<CommandEntry>();
    private CustomButton executionModeButton;
    private CustomButton enabledButton;
    private CustomButton saveButton;
    private CustomButton cancelButton;

    public ActionEditGui(GuiScreen parent, Action editingAction) {
        this.parent = parent;
        this.editingAction = editingAction;
    }

    public void func_73866_w_() {
        List<Object> initialCommands;
        this.field_146292_n.clear();
        this.commandEntries.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        this.fadeAnimation = 0.0f;
        this.scrollOffset = 0.0f;
        this.windowWidth = this.field_146294_l - 24;
        this.windowHeight = this.field_146295_m - 24;
        this.windowLeft = 12;
        this.windowTop = 12;
        int contentLeft = this.windowLeft + 12;
        int contentTop = this.windowTop + 40 + 12;
        int contentWidth = this.windowWidth - 24;
        int contentHeight = this.windowHeight - 40 - 12;
        int leftWidth = (int)((double)contentWidth * 0.3);
        int leftX = contentLeft;
        int fieldY = contentTop;
        this.sumField = new GuiTextField(0, this.field_146289_q, leftX, fieldY, 200, 20);
        this.sumField.func_146203_f(10);
        this.sumField.func_146180_a(this.editingAction != null ? String.format("%.2f", Float.valueOf(this.editingAction.getSum())) : "1.00");
        this.priorityField = new GuiTextField(1, this.field_146289_q, leftX, fieldY + 40 + 12, 200, 20);
        this.priorityField.func_146203_f(5);
        this.priorityField.func_146180_a(this.editingAction != null ? String.valueOf(this.editingAction.getPriority()) : "1");
        int buttonY = fieldY + 80 + 12;
        this.executionModeButton = new CustomButton(2, leftX, buttonY, 200, 24, I18n.func_135052_a((String)"dintegrate.gui.label.mode", (Object[])new Object[0]) + ": " + (this.editingAction != null ? this.editingAction.getExecutionMode().name() : "ALL"));
        this.enabledButton = new CustomButton(3, leftX, buttonY + 34, 200, 24, this.editingAction != null ? (this.editingAction.isEnabled() ? I18n.func_135052_a((String)"dintegrate.gui.value.enabled", (Object[])new Object[0]) : I18n.func_135052_a((String)"dintegrate.gui.value.disabled", (Object[])new Object[0])) : I18n.func_135052_a((String)"dintegrate.gui.value.enabled", (Object[])new Object[0]));
        this.saveButton = new CustomButton(4, leftX, buttonY + 68, 200, 24, I18n.func_135052_a((String)"dintegrate.gui.button.save", (Object[])new Object[0]));
        this.cancelButton = new CustomButton(5, leftX, buttonY + 102, 200, 24, I18n.func_135052_a((String)"dintegrate.gui.button.cancel", (Object[])new Object[0]));
        this.field_146292_n.add(this.executionModeButton);
        this.field_146292_n.add(this.enabledButton);
        this.field_146292_n.add(this.saveButton);
        this.field_146292_n.add(this.cancelButton);
        int rightWidth = contentWidth - leftWidth - 12;
        int rightX = leftX + leftWidth + 12;
        List<Object> list = initialCommands = this.editingAction != null ? this.editingAction.getCommands() : new ArrayList();
        if (initialCommands.isEmpty()) {
            initialCommands.add("");
        }
        for (int i = 0; i < initialCommands.size(); ++i) {
            this.addCommandEntry(i, (String)initialCommands.get(i), rightX, rightWidth);
        }
        this.updateRemoveButtons();
    }

    private void addCommandEntry(int index, String commandText, int rightX, int rightWidth) {
        int commandFieldWidth = rightWidth - 20 - 48 - 30;
        int y = this.windowTop + 60 + 12 + index * 36;
        GuiTextField commandField = new GuiTextField(100 + index, this.field_146289_q, rightX + 20 + 10, y + 4, commandFieldWidth, 20);
        commandField.func_146203_f(200);
        commandField.func_146180_a(commandText);
        CustomButton addButton = new CustomButton(200 + index, rightX + commandFieldWidth + 20 + 20, y + 2, 24, 24, "+");
        CustomButton removeButton = new CustomButton(300 + index, rightX + commandFieldWidth + 20 + 30 + 24, y + 2, 24, 24, "\u2212");
        CustomButton expandButton = new CustomButton(400 + index, rightX, y + 4, 20, 20, ">>");
        this.commandEntries.add(index, new CommandEntry(commandField, addButton, removeButton, expandButton));
        this.field_146292_n.add(addButton);
        this.field_146292_n.add(removeButton);
        this.field_146292_n.add(expandButton);
    }

    private void updateRemoveButtons() {
        for (CommandEntry entry : this.commandEntries) {
            entry.removeButton.field_146124_l = this.commandEntries.size() > 1;
        }
    }

    private void updateButtonPositions() {
        int contentLeft = this.windowLeft + 12;
        int contentTop = this.windowTop + 40 + 12;
        int contentWidth = this.windowWidth - 24;
        int leftWidth = (int)((double)contentWidth * 0.3);
        int rightWidth = contentWidth - leftWidth - 12;
        int rightX = contentLeft + leftWidth + 12;
        for (int i = 0; i < this.commandEntries.size(); ++i) {
            CommandEntry entry = this.commandEntries.get(i);
            int y = contentTop + i * 36;
            int commandFieldWidth = rightWidth - 20 - 48 - 30;
            entry.commandField.field_146210_g = y + 4;
            entry.commandField.field_146209_f = rightX + 20 + 10;
            entry.commandField.field_146218_h = commandFieldWidth;
            entry.addButton.field_146127_k = 200 + i;
            entry.addButton.field_146129_i = y + 2;
            entry.addButton.field_146128_h = rightX + commandFieldWidth + 20 + 20;
            entry.removeButton.field_146127_k = 300 + i;
            entry.removeButton.field_146129_i = y + 2;
            entry.removeButton.field_146128_h = rightX + commandFieldWidth + 20 + 30 + 24;
            entry.expandButton.field_146127_k = 400 + i;
            entry.expandButton.field_146129_i = y + 4;
            entry.expandButton.field_146128_h = rightX;
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button.field_146127_k >= 200 && button.field_146127_k < 300) {
            int index = button.field_146127_k - 200;
            int contentLeft = this.windowLeft + 12;
            int contentTop = this.windowTop + 40 + 12;
            int contentWidth = this.windowWidth - 24;
            int leftWidth = (int)((double)contentWidth * 0.3);
            int rightWidth = contentWidth - leftWidth - 12;
            int rightX = contentLeft + leftWidth + 12;
            this.addCommandEntry(index + 1, "", rightX, rightWidth);
            this.updateButtonPositions();
            this.updateRemoveButtons();
        } else if (button.field_146127_k >= 300 && button.field_146127_k < 400) {
            int index = button.field_146127_k - 300;
            if (this.commandEntries.size() > 1) {
                CommandEntry entry = this.commandEntries.remove(index);
                this.field_146292_n.remove((Object)entry.addButton);
                this.field_146292_n.remove((Object)entry.removeButton);
                this.field_146292_n.remove((Object)entry.expandButton);
                this.updateButtonPositions();
                this.updateRemoveButtons();
            }
        } else if (button.field_146127_k >= 400 && button.field_146127_k < 500) {
            int index = button.field_146127_k - 400;
            CommandEntry entry = this.commandEntries.get(index);
            this.field_146297_k.func_147108_a((GuiScreen)new CommandEditGui(this, index, entry.commandField.func_146179_b()));
        } else if (button.field_146127_k == 2) {
            Action.ExecutionMode currentMode = this.executionModeButton.getDisplayString().contains("ALL") ? Action.ExecutionMode.ALL : Action.ExecutionMode.RANDOM_ONE;
            Action.ExecutionMode newMode = currentMode == Action.ExecutionMode.ALL ? Action.ExecutionMode.RANDOM_ONE : Action.ExecutionMode.ALL;
            this.executionModeButton.field_146126_j = I18n.func_135052_a((String)"dintegrate.gui.label.mode", (Object[])new Object[0]) + ": " + newMode.name();
        } else if (button.field_146127_k == 3) {
            this.enabledButton.field_146126_j = this.enabledButton.getDisplayString().contains(I18n.func_135052_a((String)"dintegrate.gui.value.enabled", (Object[])new Object[0])) ? I18n.func_135052_a((String)"dintegrate.gui.value.disabled", (Object[])new Object[0]) : I18n.func_135052_a((String)"dintegrate.gui.value.enabled", (Object[])new Object[0]);
        } else if (button.field_146127_k == 4) {
            try {
                float sum = Float.parseFloat(this.sumField.func_146179_b().trim());
                int priority = Integer.parseInt(this.priorityField.func_146179_b().trim());
                ArrayList<String> commands = new ArrayList<String>();
                for (CommandEntry entry : this.commandEntries) {
                    String cmd = entry.commandField.func_146179_b().trim();
                    if (cmd.isEmpty()) continue;
                    if (!cmd.startsWith("/")) {
                        this.field_146297_k.func_147108_a((GuiScreen)new MessageGui(this, I18n.func_135052_a((String)"dintegrate.gui.message.invalid_command", (Object[])new Object[0]), false));
                        return;
                    }
                    commands.add(cmd);
                }
                Action.ExecutionMode mode = this.executionModeButton.getDisplayString().contains("ALL") ? Action.ExecutionMode.ALL : Action.ExecutionMode.RANDOM_ONE;
                boolean enabled = this.enabledButton.getDisplayString().contains(I18n.func_135052_a((String)"dintegrate.gui.value.enabled", (Object[])new Object[0]));
                if (sum <= 0.0f) {
                    this.field_146297_k.func_147108_a((GuiScreen)new MessageGui(this, I18n.func_135052_a((String)"dintegrate.gui.message.positive_sum", (Object[])new Object[0]), false));
                    return;
                }
                if (priority < 0) {
                    this.field_146297_k.func_147108_a((GuiScreen)new MessageGui(this, I18n.func_135052_a((String)"dintegrate.gui.message.negative_priority", (Object[])new Object[0]), false));
                    return;
                }
                if (commands.isEmpty()) {
                    this.field_146297_k.func_147108_a((GuiScreen)new MessageGui(this, I18n.func_135052_a((String)"dintegrate.gui.message.no_commands", (Object[])new Object[0]), false));
                    return;
                }
                Action newAction = new Action(sum, enabled, priority, commands, mode);
                if (this.editingAction != null) {
                    int index = ConfigHandler.getConfig().getActions().indexOf(this.editingAction);
                    if (index >= 0) {
                        ConfigHandler.getConfig().getActions().set(index, newAction);
                    }
                } else {
                    ConfigHandler.getConfig().getActions().add(newAction);
                }
                ConfigHandler.save();
                this.field_146297_k.func_147108_a((GuiScreen)new MessageGui(this.parent, I18n.func_135052_a((String)(this.editingAction != null ? "dintegrate.gui.message.action_updated" : "dintegrate.gui.message.action_added"), (Object[])new Object[0]), true));
            }
            catch (NumberFormatException e) {
                this.field_146297_k.func_147108_a((GuiScreen)new MessageGui(this, I18n.func_135052_a((String)"dintegrate.gui.message.invalid_number", (Object[])new Object[0]), false));
            }
        } else if (button.field_146127_k == 5) {
            this.field_146297_k.func_147108_a(this.parent);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(this.fadeAnimation * 0.8f));
        GuiRenderUtils.drawOverlay(this.field_146294_l, this.field_146295_m);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)this.fadeAnimation);
        GuiRenderUtils.drawRoundedRect(this.windowLeft, this.windowTop, this.windowWidth, this.windowHeight, 8.0f, -14273992);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)(this.editingAction != null ? "dintegrate.gui.title.edit_action" : "dintegrate.gui.title.add_action"), (Object[])new Object[0]), this.windowLeft + this.windowWidth / 2, this.windowTop + 12, -1);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"dintegrate.gui.label.commands", (Object[])new Object[0]), this.windowLeft + this.windowWidth / 2, this.windowTop + 40, -1);
        int contentLeft = this.windowLeft + 12;
        int contentTop = this.windowTop + 40 + 12;
        int contentWidth = this.windowWidth - 24;
        int leftWidth = (int)((double)contentWidth * 0.3);
        int leftX = contentLeft;
        int fieldY = contentTop;
        this.field_146289_q.func_175063_a(I18n.func_135052_a((String)"dintegrate.gui.label.sum", (Object[])new Object[0]), (float)leftX, (float)(fieldY - 12), -1);
        GuiRenderUtils.drawRoundedRect(leftX, fieldY, 200.0f, 20.0f, 2.0f, -13154481);
        GuiRenderUtils.drawRoundedRect(leftX, fieldY, 200.0f, 20.0f, 2.0f, this.sumField.func_146206_l() ? -16611119 : -7297874);
        this.sumField.func_146194_f();
        this.field_146289_q.func_175063_a(I18n.func_135052_a((String)"dintegrate.gui.label.priority", (Object[])new Object[0]), (float)leftX, (float)(fieldY + 28 + 12), -1);
        GuiRenderUtils.drawRoundedRect(leftX, fieldY + 40 + 12, 200.0f, 20.0f, 2.0f, -13154481);
        GuiRenderUtils.drawRoundedRect(leftX, fieldY + 40 + 12, 200.0f, 20.0f, 2.0f, this.priorityField.func_146206_l() ? -16611119 : -7297874);
        this.priorityField.func_146194_f();
        int rightWidth = contentWidth - leftWidth - 12;
        int rightX = leftX + leftWidth + 12;
        int rightHeight = this.windowHeight - (contentTop - this.windowTop) - 12;
        GuiRenderUtils.drawRoundedRect(rightX, contentTop, rightWidth, rightHeight, 4.0f, -13154481);
        int listTop = contentTop;
        int listHeight = rightHeight;
        GL11.glEnable((int)3089);
        int scaleFactor = new ScaledResolution(this.field_146297_k).func_78325_e();
        GL11.glScissor((int)(rightX * scaleFactor), (int)((this.field_146295_m - listTop - listHeight) * scaleFactor), (int)(rightWidth * scaleFactor), (int)(listHeight * scaleFactor));
        for (int i = 0; i < this.commandEntries.size(); ++i) {
            CommandEntry entry = this.commandEntries.get(i);
            int y = listTop + i * 36 - (int)this.scrollOffset;
            if (y + 28 < listTop || y > listTop + listHeight) continue;
            int commandFieldWidth = rightWidth - 20 - 48 - 30;
            entry.commandField.field_146210_g = y + 4;
            entry.commandField.field_146209_f = rightX + 20 + 10;
            entry.commandField.field_146218_h = commandFieldWidth;
            GuiRenderUtils.drawRoundedRect(rightX, y, rightWidth, 28.0f, 2.0f, -12232092);
            GuiRenderUtils.drawRoundedRect(entry.commandField.field_146209_f, y + 4, commandFieldWidth, 20.0f, 2.0f, entry.commandField.func_146206_l() ? -16611119 : -7297874);
            entry.commandField.func_146194_f();
            entry.expandButton.field_146129_i = y + 4;
            entry.expandButton.field_146128_h = rightX;
            entry.addButton.field_146129_i = y + 2;
            entry.addButton.field_146128_h = rightX + commandFieldWidth + 20 + 20;
            entry.removeButton.field_146129_i = y + 2;
            entry.removeButton.field_146128_h = rightX + commandFieldWidth + 20 + 30 + 24;
        }
        GL11.glDisable((int)3089);
        if (this.commandEntries.size() > listHeight / 36) {
            int maxItems = listHeight / 36;
            int maxScroll = (this.commandEntries.size() - maxItems) * 36;
            float scrollRatio = this.scrollOffset / (float)(maxScroll > 0 ? maxScroll : 1);
            int scrollbarHeight = Math.max(20, listHeight * maxItems / this.commandEntries.size());
            int scrollbarTop = listTop + (int)((float)(listHeight - scrollbarHeight) * scrollRatio);
            GuiRenderUtils.drawRoundedRect(rightX + rightWidth - 10, scrollbarTop, 10.0f, scrollbarHeight, 4.0f, -11243910);
        }
        for (GuiButton button : this.field_146292_n) {
            if (!(button instanceof CustomButton)) continue;
            CustomButton customButton = (CustomButton)button;
            boolean hovered = mouseX >= customButton.field_146128_h && mouseY >= customButton.field_146129_i && mouseX < customButton.field_146128_h + customButton.field_146120_f && mouseY < customButton.field_146129_i + customButton.field_146121_g;
            GlStateManager.func_179094_E();
            if (hovered) {
                GlStateManager.func_179109_b((float)((float)customButton.field_146128_h + (float)customButton.field_146120_f / 2.0f), (float)((float)customButton.field_146129_i + (float)customButton.field_146121_g / 2.0f), (float)0.0f);
                GlStateManager.func_179152_a((float)1.05f, (float)1.05f, (float)1.0f);
                GlStateManager.func_179109_b((float)((float)(-customButton.field_146128_h) - (float)customButton.field_146120_f / 2.0f), (float)((float)(-customButton.field_146129_i) - (float)customButton.field_146121_g / 2.0f), (float)0.0f);
            }
            customButton.func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        int contentLeft = this.windowLeft + 12;
        int contentTop = this.windowTop + 40 + 12;
        int contentWidth = this.windowWidth - 24;
        int leftWidth = (int)((double)contentWidth * 0.3);
        int rightWidth = contentWidth - leftWidth - 12;
        int rightX = contentLeft + leftWidth + 12;
        int listTop = contentTop;
        int listHeight = this.windowHeight - (contentTop - this.windowTop) - 12;
        if (this.commandEntries.size() > listHeight / 36) {
            int wheel = Mouse.getEventDWheel();
            if (wheel != 0 && mouseX >= rightX && mouseX <= rightX + rightWidth && mouseY >= listTop && mouseY <= listTop + listHeight) {
                int maxItems = listHeight / 36;
                int maxScroll = (this.commandEntries.size() - maxItems) * 36;
                this.scrollOffset -= wheel > 0 ? 20.0f : -20.0f;
                this.scrollOffset = Math.max(0.0f, Math.min(this.scrollOffset, (float)maxScroll));
            }
            if (Mouse.isButtonDown((int)0)) {
                int scrollbarLeft = rightX + rightWidth - 10;
                int scrollbarTop = listTop + (int)((float)(listHeight - Math.max(20, listHeight * (listHeight / 36) / this.commandEntries.size())) * (this.scrollOffset / (float)((this.commandEntries.size() - listHeight / 36) * 36)));
                if (!this.isDraggingScrollbar && mouseX >= scrollbarLeft && mouseX <= scrollbarLeft + 10 && mouseY >= scrollbarTop && mouseY <= scrollbarTop + Math.max(20, listHeight * (listHeight / 36) / this.commandEntries.size())) {
                    this.isDraggingScrollbar = true;
                }
            } else {
                this.isDraggingScrollbar = false;
            }
            if (this.isDraggingScrollbar) {
                int maxScroll = (this.commandEntries.size() - listHeight / 36) * 36;
                float scrollRatio = ((float)(mouseY - listTop) - (float)Math.max(20, listHeight * (listHeight / 36) / this.commandEntries.size()) / 2.0f) / (float)(listHeight - Math.max(20, listHeight * (listHeight / 36) / this.commandEntries.size()));
                this.scrollOffset = scrollRatio * (float)maxScroll;
                this.scrollOffset = Math.max(0.0f, Math.min(this.scrollOffset, (float)maxScroll));
            }
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.sumField.func_146192_a(mouseX, mouseY, mouseButton);
        this.priorityField.func_146192_a(mouseX, mouseY, mouseButton);
        for (CommandEntry entry : this.commandEntries) {
            entry.commandField.func_146192_a(mouseX, mouseY, mouseButton);
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        this.sumField.func_146201_a(typedChar, keyCode);
        this.priorityField.func_146201_a(typedChar, keyCode);
        for (CommandEntry entry : this.commandEntries) {
            entry.commandField.func_146201_a(typedChar, keyCode);
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.sumField.func_146178_a();
        this.priorityField.func_146178_a();
        for (CommandEntry entry : this.commandEntries) {
            entry.commandField.func_146178_a();
        }
        if (this.fadeAnimation < 1.0f) {
            this.fadeAnimation = Math.min(1.0f, this.fadeAnimation + 0.05f);
        }
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public GuiScreen getParent() {
        return this.parent;
    }

    public GuiTextField getSumField() {
        return this.sumField;
    }

    public GuiTextField getPriorityField() {
        return this.priorityField;
    }

    public CustomButton getExecutionModeButton() {
        return this.executionModeButton;
    }

    public CustomButton getEnabledButton() {
        return this.enabledButton;
    }

    public Action getEditingAction() {
        return this.editingAction;
    }

    public static class CustomButton
    extends GuiButton {
        private float hoverAnimation = 0.0f;
        private boolean wasHovered = false;

        public CustomButton(int buttonId, int x, int y, int width, int height, String buttonText) {
            super(buttonId, x, y, width, height, buttonText);
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (!this.field_146125_m) {
                return;
            }
            boolean hovered = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            this.hoverAnimation = hovered ? Math.min(1.0f, this.hoverAnimation + partialTicks * 0.3f) : Math.max(0.0f, this.hoverAnimation - partialTicks * 0.3f);
            this.wasHovered = hovered;
            GuiRenderUtils.drawButton(this.field_146128_h, this.field_146129_i, this.field_146120_f, this.field_146121_g, hovered, this.field_146124_l, this.hoverAnimation);
            GuiRenderUtils.drawRoundedRect(this.field_146128_h, this.field_146129_i, this.field_146120_f, this.field_146121_g, 2.0f, hovered ? -16611119 : -7297874);
            this.func_73732_a(mc.field_71466_p, this.field_146126_j, this.field_146128_h + this.field_146120_f / 2, this.field_146129_i + (this.field_146121_g - 8) / 2, this.field_146124_l ? -1 : -10066330);
        }

        public String getDisplayString() {
            return this.field_146126_j;
        }
    }

    public static class CommandEntry {
        public GuiTextField commandField;
        public CustomButton addButton;
        public CustomButton removeButton;
        public CustomButton expandButton;

        public CommandEntry(GuiTextField commandField, CustomButton addButton, CustomButton removeButton, CustomButton expandButton) {
            this.commandField = commandField;
            this.addButton = addButton;
            this.removeButton = removeButton;
            this.expandButton = expandButton;
        }
    }
}

