/*
 * Decompiled with CFR 0.152.
 */
package com.bogdan3000.dintegrate.gui;

import com.bogdan3000.dintegrate.config.Action;
import com.bogdan3000.dintegrate.config.ConfigHandler;
import com.bogdan3000.dintegrate.gui.ActionEditGui;
import com.bogdan3000.dintegrate.gui.GuiRenderUtils;
import com.bogdan3000.dintegrate.gui.MessageGui;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;

public class CommandEditGui
extends GuiScreen {
    private static final int CONTENT_MARGIN = 12;
    private static final int FIELD_HEIGHT = 20;
    private final GuiScreen parent;
    private final int commandIndex;
    private final String initialCommand;
    private GuiTextField commandField;
    private GuiButton saveButton;
    private GuiButton exitButton;
    private int windowLeft;
    private int windowTop;
    private int windowWidth;
    private int windowHeight;

    public CommandEditGui(GuiScreen parent, int commandIndex, String initialCommand) {
        this.parent = parent;
        this.commandIndex = commandIndex;
        this.initialCommand = initialCommand;
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        this.windowWidth = this.field_146294_l - 24;
        this.windowHeight = this.field_146295_m - 24;
        this.windowLeft = 12;
        this.windowTop = 12;
        int contentLeft = this.windowLeft + 12;
        int contentTop = this.windowTop + 12 + 20;
        int contentWidth = this.windowWidth - 24;
        int contentHeight = this.windowHeight - 24 - 40 - 20;
        this.commandField = new GuiTextField(0, this.field_146289_q, contentLeft, contentTop, contentWidth, 20);
        this.commandField.func_146203_f(200);
        this.commandField.func_146180_a(this.initialCommand);
        int buttonWidth = contentWidth / 2 - 12;
        int buttonY = contentTop + 20 + 12;
        this.saveButton = new ActionEditGui.CustomButton(1, contentLeft, buttonY, buttonWidth, 24, I18n.func_135052_a((String)"dintegrate.gui.button.save", (Object[])new Object[0]));
        this.exitButton = new ActionEditGui.CustomButton(2, contentLeft + buttonWidth + 12, buttonY, buttonWidth, 24, I18n.func_135052_a((String)"dintegrate.gui.button.exit", (Object[])new Object[0]));
        this.field_146292_n.add(this.saveButton);
        this.field_146292_n.add(this.exitButton);
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 1) {
            ActionEditGui parentGui = (ActionEditGui)this.parent;
            if (parentGui.commandEntries.size() > this.commandIndex) {
                ActionEditGui.CommandEntry entry = parentGui.commandEntries.get(this.commandIndex);
                String newCommand = this.commandField.func_146179_b().trim();
                if (!newCommand.isEmpty()) {
                    entry.commandField.func_146180_a(newCommand);
                    try {
                        int updatedIndex;
                        float sum = Float.parseFloat(parentGui.getSumField().func_146179_b().trim());
                        int priority = Integer.parseInt(parentGui.getPriorityField().func_146179_b().trim());
                        ArrayList<String> commands = new ArrayList<String>();
                        for (ActionEditGui.CommandEntry cmdEntry : parentGui.commandEntries) {
                            String cmd = cmdEntry.commandField.func_146179_b().trim();
                            if (cmd.isEmpty()) continue;
                            if (!cmd.startsWith("/")) {
                                this.field_146297_k.func_147108_a((GuiScreen)new MessageGui(this, I18n.func_135052_a((String)"dintegrate.gui.message.invalid_command", (Object[])new Object[0]), false));
                                return;
                            }
                            commands.add(cmd);
                        }
                        Action.ExecutionMode mode = parentGui.getExecutionModeButton().getDisplayString().contains("ALL") ? Action.ExecutionMode.ALL : Action.ExecutionMode.RANDOM_ONE;
                        boolean enabled = parentGui.getEnabledButton().getDisplayString().contains(I18n.func_135052_a((String)"dintegrate.gui.value.enabled", (Object[])new Object[0]));
                        if (sum <= 0.0f) {
                            this.field_146297_k.func_147108_a((GuiScreen)new MessageGui(this, I18n.func_135052_a((String)"dintegrate.gui.message.positive_sum", (Object[])new Object[0]), false));
                            return;
                        }
                        if (priority < 0) {
                            this.field_146297_k.func_147108_a((GuiScreen)new MessageGui(this, I18n.func_135052_a((String)"dintegrate.gui.message.negative_priority", (Object[])new Object[0]), false));
                            return;
                        }
                        if (commands.isEmpty()) {
                            this.field_146297_k.func_147108_a((GuiScreen)new MessageGui(this, I18n.func_135052_a((String)"dintegrate.gui.message.no_commands", (Object[])new Object[0]), false));
                            return;
                        }
                        Action newAction = new Action(sum, enabled, priority, commands, mode);
                        if (parentGui.getEditingAction() != null) {
                            int index = ConfigHandler.getConfig().getActions().indexOf(parentGui.getEditingAction());
                            if (index >= 0) {
                                ConfigHandler.getConfig().getActions().set(index, newAction);
                            } else {
                                ConfigHandler.getConfig().getActions().add(newAction);
                            }
                        } else {
                            ConfigHandler.getConfig().getActions().add(newAction);
                        }
                        ConfigHandler.save();
                        Action updatedAction = null;
                        if (parentGui.getEditingAction() != null && (updatedIndex = ConfigHandler.getConfig().getActions().indexOf(newAction)) >= 0) {
                            updatedAction = ConfigHandler.getConfig().getActions().get(updatedIndex);
                        }
                        ActionEditGui newParentGui = new ActionEditGui(parentGui.getParent(), updatedAction);
                        this.field_146297_k.func_147108_a((GuiScreen)newParentGui);
                    }
                    catch (NumberFormatException e) {
                        this.field_146297_k.func_147108_a((GuiScreen)new MessageGui(this, I18n.func_135052_a((String)"dintegrate.gui.message.invalid_number", (Object[])new Object[0]), false));
                    }
                }
            }
        } else if (button.field_146127_k == 2) {
            this.field_146297_k.func_147108_a(this.parent);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
        GuiRenderUtils.drawOverlay(this.field_146294_l, this.field_146295_m);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiRenderUtils.drawRoundedRect(this.windowLeft, this.windowTop, this.windowWidth, this.windowHeight, 8.0f, -14273992);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"dintegrate.gui.title.edit_command", (Object[])new Object[0]), this.windowLeft + this.windowWidth / 2, this.windowTop + 12, -1);
        int contentLeft = this.windowLeft + 12;
        int contentTop = this.windowTop + 12 + 20;
        int contentWidth = this.windowWidth - 24;
        int contentHeight = this.windowHeight - 24 - 40 - 20;
        GuiRenderUtils.drawRoundedRect(contentLeft, contentTop, contentWidth, 20.0f, 2.0f, -13154481);
        GuiRenderUtils.drawRoundedRect(contentLeft, contentTop, contentWidth, 20.0f, 2.0f, this.commandField.func_146206_l() ? -16611119 : -7297874);
        this.commandField.func_146194_f();
        int buttonY = contentTop + 20 + 12;
        for (GuiButton button : this.field_146292_n) {
            if (!(button instanceof ActionEditGui.CustomButton)) continue;
            ActionEditGui.CustomButton customButton = (ActionEditGui.CustomButton)button;
            boolean hovered = mouseX >= customButton.field_146128_h && mouseY >= customButton.field_146129_i && mouseX < customButton.field_146128_h + customButton.field_146120_f && mouseY < customButton.field_146129_i + customButton.field_146121_g;
            GlStateManager.func_179094_E();
            if (hovered) {
                GlStateManager.func_179109_b((float)((float)customButton.field_146128_h + (float)customButton.field_146120_f / 2.0f), (float)((float)customButton.field_146129_i + (float)customButton.field_146121_g / 2.0f), (float)0.0f);
                GlStateManager.func_179152_a((float)1.05f, (float)1.05f, (float)1.0f);
                GlStateManager.func_179109_b((float)((float)(-customButton.field_146128_h) - (float)customButton.field_146120_f / 2.0f), (float)((float)(-customButton.field_146129_i) - (float)customButton.field_146121_g / 2.0f), (float)0.0f);
            }
            customButton.func_191745_a(this.field_146297_k, mouseX, mouseY, partialTicks);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.commandField.func_146192_a(mouseX, mouseY, mouseButton);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        this.commandField.func_146201_a(typedChar, keyCode);
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.commandField.func_146178_a();
    }

    public void func_146281_b() {
    }
}

