/*
 * Decompiled with CFR 0.152.
 */
package com.bogdan3000.dintegrate.gui;

import com.bogdan3000.dintegrate.DonateIntegrate;
import com.bogdan3000.dintegrate.config.Action;
import com.bogdan3000.dintegrate.config.ConfigHandler;
import com.bogdan3000.dintegrate.gui.ActionEditGui;
import com.bogdan3000.dintegrate.gui.GuiRenderUtils;
import com.bogdan3000.dintegrate.gui.MessageGui;
import com.bogdan3000.dintegrate.gui.ObfuscatedTextField;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class DonateIntegrateGui
extends GuiScreen {
    private static final int TAB_WIDTH = 100;
    private static final int TAB_HEIGHT = 30;
    private static final int TAB_SPACING = 4;
    private static final int CONTENT_MARGIN = 10;
    private static final int ACTION_ITEM_HEIGHT = 50;
    private int windowLeft;
    private int windowTop;
    private int windowWidth;
    private int windowHeight;
    private int currentTab = 1;
    private float fadeAnimation = 0.0f;
    private final List<TabButton> tabButtons = new ArrayList<TabButton>();
    private ObfuscatedTextField tokenField;
    private GuiTextField userIdField;
    private CustomButton saveSettingsButton;
    private CustomButton clearSettingsButton;
    private CustomButton addActionButton;
    private CustomButton editActionButton;
    private CustomButton deleteActionButton;
    private CustomButton reconnectButton;
    private CustomButton enableToggleButton;
    private int selectedActionIndex = -1;
    private float scrollOffset = 0.0f;
    private boolean isDraggingScrollbar = false;

    public void func_73866_w_() {
        this.field_146292_n.clear();
        this.tabButtons.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        this.fadeAnimation = 0.0f;
        this.selectedActionIndex = -1;
        this.scrollOffset = 0.0f;
        ScaledResolution scaled = new ScaledResolution(this.field_146297_k);
        this.windowWidth = (int)((double)this.field_146294_l * 0.75);
        this.windowHeight = this.field_146295_m - 40;
        this.windowLeft = 110;
        this.windowTop = 20;
        String[] tabNames = new String[]{"settings", "actions", "status", "history"};
        for (int i = 0; i < tabNames.length; ++i) {
            TabButton tabButton = new TabButton(i, 10, 20 + i * 34, 100, 30, I18n.func_135052_a((String)("dintegrate.gui.tab." + tabNames[i]), (Object[])new Object[0]));
            this.field_146292_n.add(tabButton);
            this.tabButtons.add(tabButton);
        }
        this.tokenField = new ObfuscatedTextField(100, this.field_146289_q, this.windowLeft + 10, this.windowTop + 50, this.windowWidth - 20, 20);
        this.tokenField.func_146203_f(100);
        this.tokenField.func_146180_a(ConfigHandler.getConfig().getDonpayToken());
        this.userIdField = new GuiTextField(101, this.field_146289_q, this.windowLeft + 10, this.windowTop + 100, this.windowWidth - 20, 20);
        this.userIdField.func_146203_f(20);
        this.userIdField.func_146180_a(ConfigHandler.getConfig().getUserId());
        this.saveSettingsButton = new CustomButton(102, this.windowLeft + 10, this.windowTop + this.windowHeight - 40, 100, 24, I18n.func_135052_a((String)"dintegrate.gui.button.save", (Object[])new Object[0]));
        this.clearSettingsButton = new CustomButton(103, this.windowLeft + this.windowWidth - 10 - 100, this.windowTop + this.windowHeight - 40, 100, 24, I18n.func_135052_a((String)"dintegrate.gui.button.clear", (Object[])new Object[0]));
        this.field_146292_n.add(this.saveSettingsButton);
        this.field_146292_n.add(this.clearSettingsButton);
        this.addActionButton = new CustomButton(104, this.windowLeft + 10, this.windowTop + this.windowHeight - 40, 80, 24, I18n.func_135052_a((String)"dintegrate.gui.button.add", (Object[])new Object[0]));
        this.editActionButton = new CustomButton(105, this.windowLeft + 10 + 90, this.windowTop + this.windowHeight - 40, 80, 24, I18n.func_135052_a((String)"dintegrate.gui.button.edit", (Object[])new Object[0]));
        this.editActionButton.field_146124_l = false;
        this.deleteActionButton = new CustomButton(106, this.windowLeft + 10 + 180, this.windowTop + this.windowHeight - 40, 80, 24, I18n.func_135052_a((String)"dintegrate.gui.button.delete", (Object[])new Object[0]));
        this.deleteActionButton.field_146124_l = false;
        this.field_146292_n.add(this.addActionButton);
        this.field_146292_n.add(this.editActionButton);
        this.field_146292_n.add(this.deleteActionButton);
        this.reconnectButton = new CustomButton(107, this.windowLeft + 10, this.windowTop + this.windowHeight - 40, 100, 24, I18n.func_135052_a((String)"dintegrate.gui.button.reconnect", (Object[])new Object[0]));
        this.enableToggleButton = new CustomButton(108, this.windowLeft + this.windowWidth - 10 - 100, this.windowTop + this.windowHeight - 40, 100, 24, ConfigHandler.getConfig().isEnabled() ? I18n.func_135052_a((String)"dintegrate.gui.button.disable", (Object[])new Object[0]) : I18n.func_135052_a((String)"dintegrate.gui.button.enable", (Object[])new Object[0]));
        this.field_146292_n.add(this.reconnectButton);
        this.field_146292_n.add(this.enableToggleButton);
        this.updateTabVisibility();
    }

    private void updateTabVisibility() {
        this.tokenField.func_146189_e(this.currentTab == 0);
        this.userIdField.func_146189_e(this.currentTab == 0);
        this.saveSettingsButton.field_146125_m = this.currentTab == 0;
        this.clearSettingsButton.field_146125_m = this.currentTab == 0;
        this.addActionButton.field_146125_m = this.currentTab == 1;
        this.editActionButton.field_146125_m = this.currentTab == 1;
        this.deleteActionButton.field_146125_m = this.currentTab == 1;
        this.reconnectButton.field_146125_m = this.currentTab == 2;
        this.enableToggleButton.field_146125_m = this.currentTab == 2;
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button instanceof TabButton) {
            this.currentTab = button.field_146127_k;
            this.selectedActionIndex = -1;
            this.editActionButton.field_146124_l = false;
            this.deleteActionButton.field_146124_l = false;
            this.scrollOffset = 0.0f;
            this.updateTabVisibility();
            return;
        }
        switch (button.field_146127_k) {
            case 102: {
                String token = this.tokenField.func_146179_b().trim();
                String userId = this.userIdField.func_146179_b().trim();
                if (token.isEmpty() || userId.isEmpty()) {
                    this.field_146297_k.func_147108_a((GuiScreen)new MessageGui(this, I18n.func_135052_a((String)"dintegrate.gui.message.empty_credentials", (Object[])new Object[0]), false));
                    return;
                }
                ConfigHandler.getConfig().setDonpayToken(token);
                ConfigHandler.getConfig().setUserId(userId);
                ConfigHandler.save();
                DonateIntegrate.startDonationProvider();
                this.field_146297_k.func_147108_a((GuiScreen)new MessageGui(this, I18n.func_135052_a((String)"dintegrate.gui.message.settings_saved", (Object[])new Object[0]), true));
                break;
            }
            case 103: {
                this.tokenField.func_146180_a("");
                this.userIdField.func_146180_a("");
                break;
            }
            case 104: {
                this.field_146297_k.func_147108_a((GuiScreen)new ActionEditGui(this, null));
                break;
            }
            case 105: {
                if (this.selectedActionIndex < 0 || this.selectedActionIndex >= ConfigHandler.getConfig().getActions().size()) break;
                Action action = ConfigHandler.getConfig().getActions().get(this.selectedActionIndex);
                this.field_146297_k.func_147108_a((GuiScreen)new ActionEditGui(this, action));
                break;
            }
            case 106: {
                if (this.selectedActionIndex < 0 || this.selectedActionIndex >= ConfigHandler.getConfig().getActions().size()) break;
                ConfigHandler.getConfig().getActions().remove(this.selectedActionIndex);
                ConfigHandler.save();
                this.selectedActionIndex = -1;
                this.editActionButton.field_146124_l = false;
                this.deleteActionButton.field_146124_l = false;
                this.field_146297_k.func_147108_a((GuiScreen)new MessageGui(this, I18n.func_135052_a((String)"dintegrate.gui.message.action_deleted", (Object[])new Object[0]), true));
                break;
            }
            case 107: {
                DonateIntegrate.startDonationProvider();
                this.field_146297_k.func_147108_a((GuiScreen)new MessageGui(this, I18n.func_135052_a((String)"dintegrate.gui.message.reconnection_initiated", (Object[])new Object[0]), true));
                break;
            }
            case 108: {
                ConfigHandler.getConfig().setEnabled(!ConfigHandler.getConfig().isEnabled());
                ConfigHandler.save();
                String string = this.enableToggleButton.field_146126_j = ConfigHandler.getConfig().isEnabled() ? I18n.func_135052_a((String)"dintegrate.gui.button.disable", (Object[])new Object[0]) : I18n.func_135052_a((String)"dintegrate.gui.button.enable", (Object[])new Object[0]);
                if (ConfigHandler.getConfig().isEnabled()) {
                    DonateIntegrate.startDonationProvider();
                } else {
                    DonateIntegrate.stopDonationProvider();
                }
                this.field_146297_k.func_147108_a((GuiScreen)new MessageGui(this, I18n.func_135052_a((String)(ConfigHandler.getConfig().isEnabled() ? "dintegrate.gui.message.enabled" : "dintegrate.gui.message.disabled"), (Object[])new Object[0]), true));
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)this.fadeAnimation);
        GuiRenderUtils.drawOverlay(this.field_146294_l, this.field_146295_m);
        GuiRenderUtils.drawRoundedRect(this.windowLeft, this.windowTop, this.windowWidth, this.windowHeight, 8.0f, -14273992);
        switch (this.currentTab) {
            case 0: {
                this.drawSettingsTab();
                break;
            }
            case 1: {
                this.drawActionsTab(mouseX, mouseY, partialTicks);
                break;
            }
            case 2: {
                this.drawStatusTab();
                break;
            }
            case 3: {
                this.drawHistoryTab();
            }
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void drawSettingsTab() {
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"dintegrate.gui.label.token", (Object[])new Object[0]), this.windowLeft + 10, this.windowTop + 40, GuiRenderUtils.getTextColor());
        this.tokenField.func_146194_f();
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"dintegrate.gui.label.user_id", (Object[])new Object[0]), this.windowLeft + 10, this.windowTop + 90, GuiRenderUtils.getTextColor());
        this.userIdField.func_146194_f();
    }

    private void drawActionsTab(int mouseX, int mouseY, float partialTicks) {
        List<Action> actions = ConfigHandler.getConfig().getActions();
        int listTop = this.windowTop + 10;
        int listLeft = this.windowLeft + 10;
        int listWidth = this.windowWidth - 20;
        int listHeight = this.windowHeight - 60;
        int totalHeight = 0;
        for (Action a : actions) {
            totalHeight += 28 + a.getCommands().size() * 22;
        }
        GuiRenderUtils.drawRoundedRect(listLeft, listTop, listWidth, listHeight, 4.0f, -13154481);
        GL11.glEnable((int)3089);
        int scaleFactor = new ScaledResolution(this.field_146297_k).func_78325_e();
        GL11.glScissor((int)(listLeft * scaleFactor), (int)((this.field_146295_m - listTop - listHeight) * scaleFactor), (int)(listWidth * scaleFactor), (int)(listHeight * scaleFactor));
        int yPos = listTop;
        for (int i = 0; i < actions.size(); ++i) {
            int backgroundColor;
            int y = yPos - (int)this.scrollOffset;
            Action action = actions.get(i);
            int commandCount = action.getCommands().size();
            int itemHeight = 28 + commandCount * 22;
            if (y + itemHeight < listTop || y > listTop + listHeight) {
                yPos += itemHeight;
                continue;
            }
            boolean hovered = mouseX >= listLeft && mouseX <= listLeft + listWidth && mouseY >= y && mouseY <= y + itemHeight;
            boolean selected = i == this.selectedActionIndex;
            int baseColor = -13154481;
            int n = selected ? -16611119 : (backgroundColor = hovered ? -11243910 : baseColor);
            int commandBackgroundColor = selected ? -16611119 : (hovered ? -8875876 : -12232092);
            GuiRenderUtils.drawRoundedRect(listLeft + 1, y + 1, listWidth - 2, itemHeight - 2, 4.0f, -14273992);
            GuiRenderUtils.drawRoundedRect(listLeft + 2, y + 2, listWidth - 4, itemHeight - 4, 4.0f, backgroundColor);
            String text = String.format("%s: %.2f, %s: %d, %s, %s: %d", I18n.func_135052_a((String)"dintegrate.gui.label.sum", (Object[])new Object[0]), Float.valueOf(action.getSum()), I18n.func_135052_a((String)"dintegrate.gui.label.commands", (Object[])new Object[0]), commandCount, action.isEnabled() ? I18n.func_135052_a((String)"dintegrate.gui.value.enabled", (Object[])new Object[0]) : I18n.func_135052_a((String)"dintegrate.gui.value.disabled", (Object[])new Object[0]), I18n.func_135052_a((String)"dintegrate.gui.label.priority", (Object[])new Object[0]), action.getPriority());
            this.field_146289_q.func_78276_b(text, listLeft + 8, y + 8, GuiRenderUtils.getTextColor());
            int commandY = y + 28;
            for (String command : action.getCommands()) {
                String cmd = command.length() > 50 ? command.substring(0, 47) + "..." : command;
                GuiRenderUtils.drawRoundedRect(listLeft + 8, commandY, listWidth - 16, 20.0f, 2.0f, commandBackgroundColor);
                GuiRenderUtils.drawRoundedRect(listLeft + 8, commandY, listWidth - 16, 20.0f, 2.0f, -8875876);
                this.field_146289_q.func_78276_b(cmd, listLeft + 12, commandY + 4, GuiRenderUtils.getTextColor());
                commandY += 22;
            }
            yPos += itemHeight;
        }
        GL11.glDisable((int)3089);
        if (totalHeight > listHeight) {
            int maxScroll = totalHeight - listHeight;
            float scrollRatio = this.scrollOffset / (float)maxScroll;
            int scrollbarHeight = Math.max(20, listHeight * listHeight / totalHeight);
            int scrollbarTop = listTop + (int)((float)(listHeight - scrollbarHeight) * scrollRatio);
            GuiRenderUtils.drawRoundedRect(this.windowLeft + this.windowWidth - 10 - 10, scrollbarTop, 10.0f, scrollbarHeight, 4.0f, -11243910);
        }
    }

    private void drawStatusTab() {
        int y = this.windowTop + 10;
        int x = this.windowLeft + 10;
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"dintegrate.gui.label.enabled", (Object[])new Object[0]) + ": " + (ConfigHandler.getConfig().isEnabled() ? I18n.func_135052_a((String)"dintegrate.gui.value.yes", (Object[])new Object[0]) : I18n.func_135052_a((String)"dintegrate.gui.value.no", (Object[])new Object[0])), x, y, ConfigHandler.getConfig().isEnabled() ? -11751600 : GuiRenderUtils.getErrorColor());
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"dintegrate.gui.label.connected", (Object[])new Object[0]) + ": " + (DonateIntegrate.getInstance().getDonationProvider().isConnected() ? I18n.func_135052_a((String)"dintegrate.gui.value.yes", (Object[])new Object[0]) : I18n.func_135052_a((String)"dintegrate.gui.value.no", (Object[])new Object[0])), x, y += 20, DonateIntegrate.getInstance().getDonationProvider().isConnected() ? -11751600 : GuiRenderUtils.getErrorColor());
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"dintegrate.gui.label.last_donation_id", (Object[])new Object[0]) + ": " + ConfigHandler.getConfig().getLastDonate(), x, y += 20, GuiRenderUtils.getTextColor());
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"dintegrate.gui.label.token", (Object[])new Object[0]) + ": " + (ConfigHandler.getConfig().getDonpayToken().isEmpty() ? I18n.func_135052_a((String)"dintegrate.gui.value.not_set", (Object[])new Object[0]) : I18n.func_135052_a((String)"dintegrate.gui.value.set", (Object[])new Object[0])), x, y += 20, ConfigHandler.getConfig().getDonpayToken().isEmpty() ? GuiRenderUtils.getErrorColor() : -11751600);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"dintegrate.gui.label.user_id", (Object[])new Object[0]) + ": " + (ConfigHandler.getConfig().getUserId().isEmpty() ? I18n.func_135052_a((String)"dintegrate.gui.value.not_set", (Object[])new Object[0]) : ConfigHandler.getConfig().getUserId()), x, y += 20, ConfigHandler.getConfig().getUserId().isEmpty() ? GuiRenderUtils.getErrorColor() : GuiRenderUtils.getTextColor());
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"dintegrate.gui.label.actions_configured", (Object[])new Object[0]) + ": " + ConfigHandler.getConfig().getActions().size(), x, y += 20, GuiRenderUtils.getTextColor());
    }

    private void drawHistoryTab() {
        this.field_146289_q.func_78276_b("History not implemented yet", this.windowLeft + 10, this.windowTop + 10, GuiRenderUtils.getTextColor());
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.tokenField.func_146192_a(mouseX, mouseY, mouseButton);
        this.userIdField.func_146192_a(mouseX, mouseY, mouseButton);
        if (this.currentTab == 1 && mouseButton == 0) {
            int listTop = this.windowTop + 10;
            int listLeft = this.windowLeft + 10;
            int listWidth = this.windowWidth - 20;
            int listHeight = this.windowHeight - 60;
            if (mouseX >= listLeft && mouseX <= listLeft + listWidth && mouseY >= listTop && mouseY <= listTop + listHeight) {
                List<Action> actions = ConfigHandler.getConfig().getActions();
                int relativeY = mouseY - listTop + (int)this.scrollOffset;
                int currentY = 0;
                this.selectedActionIndex = -1;
                this.editActionButton.field_146124_l = false;
                this.deleteActionButton.field_146124_l = false;
                for (int i = 0; i < actions.size(); ++i) {
                    int actionHeight = 28 + actions.get(i).getCommands().size() * 22;
                    if (relativeY >= currentY && relativeY < currentY + actionHeight) {
                        this.selectedActionIndex = i;
                        this.editActionButton.field_146124_l = true;
                        this.deleteActionButton.field_146124_l = true;
                        break;
                    }
                    currentY += actionHeight;
                }
            } else {
                this.selectedActionIndex = -1;
                this.editActionButton.field_146124_l = false;
                this.deleteActionButton.field_146124_l = false;
            }
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        this.tokenField.func_146201_a(typedChar, keyCode);
        this.userIdField.func_146201_a(typedChar, keyCode);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        int mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        if (this.currentTab == 1 && ConfigHandler.getConfig().getActions().size() > (this.windowHeight - 60) / 50) {
            int maxScroll;
            int listTop = this.windowTop + 10;
            int listLeft = this.windowLeft + 10;
            int listWidth = this.windowWidth - 20;
            int listHeight = this.windowHeight - 60;
            int maxItems = listHeight / 50;
            int wheel = Mouse.getEventDWheel();
            if (wheel != 0 && mouseX >= listLeft && mouseX <= listLeft + listWidth && mouseY >= listTop && mouseY <= listTop + listHeight) {
                maxScroll = (ConfigHandler.getConfig().getActions().size() - maxItems) * 50;
                this.scrollOffset -= wheel > 0 ? 20.0f : -20.0f;
                this.scrollOffset = Math.max(0.0f, Math.min(this.scrollOffset, (float)maxScroll));
            }
            if (Mouse.isButtonDown((int)0)) {
                int scrollbarLeft = this.windowLeft + this.windowWidth - 10 - 10;
                int scrollbarTop = listTop + (int)((float)(listHeight - Math.max(20, listHeight * maxItems / ConfigHandler.getConfig().getActions().size())) * (this.scrollOffset / (float)((ConfigHandler.getConfig().getActions().size() - maxItems) * 50)));
                if (!this.isDraggingScrollbar && mouseX >= scrollbarLeft && mouseX <= scrollbarLeft + 10 && mouseY >= scrollbarTop && mouseY <= scrollbarTop + Math.max(20, listHeight * maxItems / ConfigHandler.getConfig().getActions().size())) {
                    this.isDraggingScrollbar = true;
                }
            } else {
                this.isDraggingScrollbar = false;
            }
            if (this.isDraggingScrollbar) {
                maxScroll = (ConfigHandler.getConfig().getActions().size() - maxItems) * 50;
                float scrollRatio = ((float)(mouseY - listTop) - (float)Math.max(20, listHeight * maxItems / ConfigHandler.getConfig().getActions().size()) / 2.0f) / (float)(listHeight - Math.max(20, listHeight * maxItems / ConfigHandler.getConfig().getActions().size()));
                this.scrollOffset = scrollRatio * (float)maxScroll;
                this.scrollOffset = Math.max(0.0f, Math.min(this.scrollOffset, (float)maxScroll));
            }
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.tokenField.func_146178_a();
        this.userIdField.func_146178_a();
        if (this.fadeAnimation < 1.0f) {
            this.fadeAnimation = Math.min(1.0f, this.fadeAnimation + 0.05f);
        }
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    private static class CustomButton
    extends GuiButton {
        private float hoverAnimation = 0.0f;
        private boolean wasHovered = false;

        public CustomButton(int buttonId, int x, int y, int width, int height, String buttonText) {
            super(buttonId, x, y, width, height, buttonText);
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (!this.field_146125_m) {
                return;
            }
            boolean hovered = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            this.hoverAnimation = hovered ? Math.min(1.0f, this.hoverAnimation + partialTicks * 0.2f) : Math.max(0.0f, this.hoverAnimation - partialTicks * 0.2f);
            this.wasHovered = hovered;
            GuiRenderUtils.drawButton(this.field_146128_h, this.field_146129_i, this.field_146120_f, this.field_146121_g, hovered, this.field_146124_l, this.hoverAnimation);
            this.func_73732_a(mc.field_71466_p, this.field_146126_j, this.field_146128_h + this.field_146120_f / 2, this.field_146129_i + (this.field_146121_g - 8) / 2, GuiRenderUtils.getTextColor());
        }
    }

    private static class TabButton
    extends GuiButton {
        private float hoverAnimation = 0.0f;
        private boolean wasHovered = false;

        public TabButton(int buttonId, int x, int y, int width, int height, String buttonText) {
            super(buttonId, x, y, width, height, buttonText);
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            if (!this.field_146125_m) {
                return;
            }
            boolean hovered = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            this.hoverAnimation = hovered ? Math.min(1.0f, this.hoverAnimation + partialTicks * 0.2f) : Math.max(0.0f, this.hoverAnimation - partialTicks * 0.2f);
            this.wasHovered = hovered;
            GuiRenderUtils.drawTabButton(this.field_146128_h, this.field_146129_i, this.field_146120_f, this.field_146121_g, hovered, this.field_146127_k == ((DonateIntegrateGui)mc.field_71462_r).currentTab, this.hoverAnimation);
            this.func_73732_a(mc.field_71466_p, this.field_146126_j, this.field_146128_h + this.field_146120_f / 2, this.field_146129_i + (this.field_146121_g - 8) / 2, GuiRenderUtils.getTextColor());
        }
    }
}

