/*
 * Decompiled with CFR 0.152.
 */
package com.bogdan3000.dintegrate.gui;

import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public class GuiRenderUtils {
    private static final int COLOR_BACKGROUND = -803461850;
    private static final int COLOR_ACCENT = -11549705;
    private static final int COLOR_HOVER = -8268550;
    private static final int COLOR_TEXT = -1;
    private static final int COLOR_ERROR = -44462;
    private static final int COLOR_SELECTED = -16611119;

    public static void drawRoundedRect(float x, float y, float width, float height, float radius, int color) {
        if (width <= 0.0f || height <= 0.0f) {
            return;
        }
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        GuiRenderUtils.drawRect(buffer, x + radius, y + radius, x + width - radius, y + height - radius, red, green, blue, alpha);
        GuiRenderUtils.drawRect(buffer, x + radius, y, x + width - radius, y + radius, red, green, blue, alpha);
        GuiRenderUtils.drawRect(buffer, x + radius, y + height - radius, x + width - radius, y + height, red, green, blue, alpha);
        GuiRenderUtils.drawRect(buffer, x, y + radius, x + radius, y + height - radius, red, green, blue, alpha);
        GuiRenderUtils.drawRect(buffer, x + width - radius, y + radius, x + width, y + height - radius, red, green, blue, alpha);
        for (int i = 0; i < 4; ++i) {
            float cx = i % 2 == 0 ? x + radius : x + width - radius;
            float cy = i < 2 ? y + radius : y + height - radius;
            GuiRenderUtils.drawCircleQuadrant(buffer, cx, cy, radius, i, red, green, blue, alpha);
        }
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    private static void drawRect(BufferBuilder buffer, float x1, float y1, float x2, float y2, float r, float g, float b, float a) {
        buffer.func_181662_b((double)x1, (double)y2, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)x2, (double)y2, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)x2, (double)y1, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        buffer.func_181662_b((double)x1, (double)y1, 0.0).func_181666_a(r, g, b, a).func_181675_d();
    }

    private static void drawCircleQuadrant(BufferBuilder buffer, float cx, float cy, float radius, int quadrant, float r, float g, float b, float a) {
        int segments = 16;
        float angleStep = (float)(1.5707963267948966 / (double)segments);
        for (int i = 0; i < segments; ++i) {
            float angle1 = (float)quadrant * 1.5707964f + (float)i * angleStep;
            float angle2 = angle1 + angleStep;
            float x1 = cx + radius * (float)Math.cos(angle1);
            float y1 = cy + radius * (float)Math.sin(angle1);
            float x2 = cx + radius * (float)Math.cos(angle2);
            float y2 = cy + radius * (float)Math.sin(angle2);
            buffer.func_181662_b((double)cx, (double)cy, 0.0).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)x1, (double)y1, 0.0).func_181666_a(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)x2, (double)y2, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        }
    }

    public static void drawButton(float x, float y, float width, float height, boolean hovered, boolean enabled, float animationProgress) {
        int baseColor = enabled ? -11549705 : -10066330;
        int color = hovered ? GuiRenderUtils.mixColors(baseColor, -8268550, animationProgress) : baseColor;
        GuiRenderUtils.drawRoundedRect(x, y, width, height, 4.0f, color);
    }

    public static void drawTabButton(float x, float y, float width, float height, boolean hovered, boolean selected, float animationProgress) {
        int baseColor = selected ? -16611119 : -13154481;
        int color = hovered ? GuiRenderUtils.mixColors(baseColor, -8268550, animationProgress) : baseColor;
        GuiRenderUtils.drawRoundedRect(x, y, width, height, 4.0f, color);
        if (selected) {
            GuiRenderUtils.drawRoundedRect(x + width - 4.0f, y, 4.0f, height, 2.0f, -11549705);
        }
    }

    public static int mixColors(int color1, int color2, float progress) {
        float p = Math.max(0.0f, Math.min(1.0f, progress));
        int a1 = color1 >> 24 & 0xFF;
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int a2 = color2 >> 24 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int a = (int)((float)a1 + (float)(a2 - a1) * p);
        int r = (int)((float)r1 + (float)(r2 - r1) * p);
        int g = (int)((float)g1 + (float)(g2 - g1) * p);
        int b = (int)((float)b1 + (float)(b2 - b1) * p);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static void drawOverlay(int width, int height) {
        GuiRenderUtils.drawRoundedRect(0.0f, 0.0f, width, height, 0.0f, -803461850);
    }

    public static int getTextColor() {
        return -1;
    }

    public static int getErrorColor() {
        return -44462;
    }

    public static int getBackgroundColor() {
        return -803461850;
    }
}

