/*
 * Decompiled with CFR 0.152.
 */
package com.bogdan3000.dintegrate;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.mojang.logging.LogUtils;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class Config {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Path CONFIG_PATH = Paths.get("config", "dintegrate.json");
    public String token = "YOUR_DONATEPAY_TOKEN";
    public int user_id = 0;
    public String token_url = "https://donatepay.ru/api/v2/socket/token";
    public String socket_url = "wss://centrifugo.donatepay.ru/connection/websocket?format=json";
    public List<DonationRule> rules = new ArrayList<DonationRule>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public void load() throws IOException {
        if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
            LOGGER.warn("[DIntegrate] JSON config not found \u2014 creating default one");
            this.saveDefault();
        }
        try (FileReader reader = new FileReader(CONFIG_PATH.toFile());){
            Config loaded = (Config)GSON.fromJson((Reader)reader, Config.class);
            if (loaded != null) {
                this.token = loaded.token;
                this.user_id = loaded.user_id;
                this.token_url = loaded.token_url;
                this.socket_url = loaded.socket_url;
                this.rules = loaded.rules != null ? loaded.rules : new ArrayList<DonationRule>();
            }
            LOGGER.info("[DIntegrate] JSON config loaded \u2014 rules: {}", (Object)this.rules.size());
            for (DonationRule r : this.rules) {
                LOGGER.info("[DIntegrate] Rule {}\u20bd \u2192 {} commands (mode={})", new Object[]{r.amount, r.commands.size(), r.mode});
            }
        }
        catch (JsonSyntaxException e) {
            LOGGER.error("[DIntegrate] Failed to parse JSON config: {}", (Object)e.toString());
            throw new IOException("Invalid JSON syntax in dintegrate.json", e);
        }
    }

    private void saveDefault() throws IOException {
        Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
        Config def = new Config();
        DonationRule rule = new DonationRule();
        rule.amount = 10.0;
        rule.mode = "all";
        rule.commands = List.of("/say {name} \u043f\u043e\u0436\u0435\u0440\u0442\u0432\u043e\u0432\u0430\u043b {sum}\u20bd!", "/delay 1", "/say \u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435: {message}", "/randomdelay 1-10", "/give @p minecraft:diamond 1");
        def.rules = List.of(rule);
        String header = "/*\n * === DonateIntegrate Configuration ===\n *\n *  token, user_id \u2014 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u044f DonatePay\n *  token_url \u0438 socket_url \u2014 \u043d\u0435 \u0442\u0440\u043e\u0433\u0430\u0439, \u0435\u0441\u043b\u0438 \u043d\u0435 \u0437\u043d\u0430\u0435\u0448\u044c \u0437\u0430\u0447\u0435\u043c\n *\n * === Donation Rules ===\n *  \u041f\u043e\u043b\u0435 \"rules\" \u2014 \u0441\u043f\u0438\u0441\u043e\u043a \u043f\u0440\u0430\u0432\u0438\u043b. \u041a\u0430\u0436\u0434\u043e\u0435 \u043f\u0440\u0430\u0432\u0438\u043b\u043e \u0438\u043c\u0435\u0435\u0442:\n *    amount \u2014 \u0441\u0443\u043c\u043c\u0430 \u0434\u043e\u043d\u0430\u0442\u0430\n *    mode \u2014 \u0440\u0435\u0436\u0438\u043c \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043a\u043e\u043c\u0430\u043d\u0434:\n *        \"all\"         \u2014 \u0432\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442 \u0432\u0441\u0435 \u043a\u043e\u043c\u0430\u043d\u0434\u044b \u043f\u043e \u043f\u043e\u0440\u044f\u0434\u043a\u0443\n *        \"random\"      \u2014 \u0432\u044b\u0431\u0438\u0440\u0430\u0435\u0442 \u043e\u0434\u043d\u0443 \u0441\u043b\u0443\u0447\u0430\u0439\u043d\u0443\u044e \u043a\u043e\u043c\u0430\u043d\u0434\u0443\n *        \"random_all\"  \u2014 \u0432\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442 \u0432\u0441\u0435 \u043a\u043e\u043c\u0430\u043d\u0434\u044b, \u043d\u043e \u0432 \u0441\u043b\u0443\u0447\u0430\u0439\u043d\u043e\u043c \u043f\u043e\u0440\u044f\u0434\u043a\u0435\n *        \"randomN\"     \u2014 \u0432\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442 N \u0441\u043b\u0443\u0447\u0430\u0439\u043d\u044b\u0445 \u043a\u043e\u043c\u0430\u043d\u0434 (\u043f\u0440\u0438\u043c\u0435\u0440: \"random3\")\n *\n * === \u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u043a\u043e\u043c\u0430\u043d\u0434\u044b ===\n *    delay X           \u2014 \u0437\u0430\u0434\u0435\u0440\u0436\u043a\u0430 X \u0441\u0435\u043a\u0443\u043d\u0434 (\u043f\u0440\u0438\u043c\u0435\u0440: \"delay 1\")\n *    randomdelay A-B   \u2014 \u0441\u043b\u0443\u0447\u0430\u0439\u043d\u0430\u044f \u0437\u0430\u0434\u0435\u0440\u0436\u043a\u0430 \u043e\u0442 A \u0434\u043e B \u0441\u0435\u043a\u0443\u043d\u0434 (\u043f\u0440\u0438\u043c\u0435\u0440: \"randomdelay 1-3\")\n *\n * === \u041f\u043b\u0435\u0439\u0441\u0445\u043e\u043b\u0434\u0435\u0440\u044b ===\n *    {name}      \u2014 \u0438\u043c\u044f \u0434\u043e\u043d\u0430\u0442\u0435\u0440\u0430\n *    {sum}       \u2014 \u0441\u0443\u043c\u043c\u0430 \u0434\u043e\u043d\u0430\u0442\u0430\n *    {message}   \u2014 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u0434\u043e\u043d\u0430\u0442\u0435\u0440\u0430\n */\n";
        String json = GSON.toJson((Object)def);
        Files.writeString(CONFIG_PATH, (CharSequence)(header + "\n" + json), new OpenOption[0]);
        LOGGER.info("[DIntegrate] Default JSON config with documentation created at {}", (Object)CONFIG_PATH.toAbsolutePath());
    }

    public Map<Double, DonationRule> getRules() {
        HashMap<Double, DonationRule> map = new HashMap<Double, DonationRule>();
        for (DonationRule r : this.rules) {
            map.put(r.amount, r);
        }
        return map;
    }

    public String getToken() {
        return this.token;
    }

    public int getUserId() {
        return this.user_id;
    }

    public String getTokenUrl() {
        return this.token_url;
    }

    public String getSocketUrl() {
        return this.socket_url;
    }

    public static class DonationRule {
        public double amount;
        public String mode;
        public List<String> commands = new ArrayList<String>();
    }
}

