/*
 * Decompiled with CFR 0.152.
 */
package com.bogdan3000.dintegrate;

import com.bogdan3000.dintegrate.Config;
import com.bogdan3000.dintegrate.donation.DonatePayProvider;
import com.bogdan3000.dintegrate.logic.ActionHandler;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.logging.LogUtils;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import org.slf4j.Logger;

@Mod(value="dintegrate")
@Mod.EventBusSubscriber(modid="dintegrate", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class DonateIntegrate {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static Config config;
    private static DonatePayProvider donateProvider;

    public DonateIntegrate() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        LOGGER.info("[DIntegrate] Client initialized");
        try {
            config = new Config();
            config.load();
        }
        catch (IOException e) {
            LOGGER.error("[DIntegrate] Failed to load config", (Throwable)e);
        }
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterClientCommandsEvent event) {
        CommandDispatcher d = event.getDispatcher();
        d.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"dpi").then(Commands.m_82127_((String)"token").then(Commands.m_82129_((String)"value", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            String v = StringArgumentType.getString((CommandContext)ctx, (String)"value");
            DonateIntegrate.saveToJsonConfig("token", v);
            DonateIntegrate.reloadConfig(true);
            DonateIntegrate.sendClientMessage("\u00a7aToken updated and reconnected!");
            return 1;
        })))).then(Commands.m_82127_((String)"user").then(Commands.m_82129_((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> {
            int id = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"value");
            DonateIntegrate.saveToJsonConfig("user_id", String.valueOf(id));
            DonateIntegrate.reloadConfig(true);
            DonateIntegrate.sendClientMessage("\u00a7aUser ID updated and reconnected!");
            return 1;
        })))).then(Commands.m_82127_((String)"reload").executes(ctx -> {
            DonateIntegrate.reloadConfig(false);
            DonateIntegrate.sendClientMessage("\u00a7bConfig reloaded (no reconnect).");
            return 1;
        }))).then(Commands.m_82127_((String)"start").executes(ctx -> {
            DonateIntegrate.startConnection();
            DonateIntegrate.sendClientMessage("\u00a7aConnection started!");
            return 1;
        }))).then(Commands.m_82127_((String)"stop").executes(ctx -> {
            DonateIntegrate.stopConnection();
            DonateIntegrate.sendClientMessage("\u00a7cConnection stopped.");
            return 1;
        }))).then(Commands.m_82127_((String)"restart").executes(ctx -> {
            DonateIntegrate.restartConnection();
            DonateIntegrate.sendClientMessage("\u00a7bConnection restarted!");
            return 1;
        }))).then(Commands.m_82127_((String)"test").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"sum", (ArgumentType)DoubleArgumentType.doubleArg((double)0.01)).then(Commands.m_82129_((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            double sum = DoubleArgumentType.getDouble((CommandContext)ctx, (String)"sum");
            String msg = StringArgumentType.getString((CommandContext)ctx, (String)"message");
            Config.DonationRule rule = config.getRules().entrySet().stream().filter(e -> Math.abs((Double)e.getKey() - sum) < 1.0E-4).map(e -> (Config.DonationRule)e.getValue()).findFirst().orElse(null);
            if (rule == null) {
                DonateIntegrate.sendClientMessage("\u00a7c[DIntegrate] No rule found for this amount (" + sum + ")");
                return 0;
            }
            DonateIntegrate.sendClientMessage("\u00a7d[DIntegrate] Simulating donation " + sum + "\u20bd (" + rule.mode + ")");
            new ActionHandler(config).execute(sum, name, msg);
            return 1;
        }))))));
    }

    private static void reloadConfig(boolean restart) {
        try {
            config.load();
            int count = config.getRules().size();
            if (restart) {
                DonateIntegrate.restartConnection();
                DonateIntegrate.sendClientMessage("\u00a7b[DIntegrate] Config reloaded (" + count + " rules) and reconnected.");
            } else {
                DonateIntegrate.sendClientMessage("\u00a7b[DIntegrate] Config reloaded (" + count + " rules).");
            }
            LOGGER.info("[DIntegrate] Config reloaded successfully ({} rules). Restart = {}", (Object)count, (Object)restart);
        }
        catch (IOException e) {
            LOGGER.error("[DIntegrate] Reload failed", (Throwable)e);
            DonateIntegrate.sendClientMessage("\u00a7c[DIntegrate] Failed to reload config. Check logs.");
        }
    }

    public static void saveToJsonConfig(String key, String value) {
        try {
            JsonObject json;
            Path path = Paths.get("config", "dintegrate.json");
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.writeString(path, (CharSequence)"{}", new OpenOption[0]);
            }
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            try (FileReader reader = new FileReader(path.toFile());){
                json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            }
            json.addProperty(key, value);
            try (FileWriter writer = new FileWriter(path.toFile());){
                gson.toJson((JsonElement)json, (Appendable)writer);
            }
            LOGGER.info("[DIntegrate] Updated {} in JSON config: {}", (Object)key, (Object)value);
        }
        catch (Exception e) {
            LOGGER.error("[DIntegrate] Failed to update JSON config", (Throwable)e);
        }
    }

    public static DonatePayProvider getDonateProvider() {
        return donateProvider;
    }

    public static Config getConfig() {
        return config;
    }

    public static void startConnection() {
        if (donateProvider != null && donateProvider.isConnected()) {
            return;
        }
        donateProvider = new DonatePayProvider(config.getToken(), config.getUserId(), config.getTokenUrl(), config.getSocketUrl(), don -> new ActionHandler(config).execute(don.getAmount(), don.getUsername(), don.getMessage()));
        donateProvider.connect();
    }

    public static void stopConnection() {
        if (donateProvider != null) {
            donateProvider.disconnect();
            donateProvider = null;
        }
    }

    public static void restartConnection() {
        DonateIntegrate.stopConnection();
        DonateIntegrate.startConnection();
    }

    public static void sendClientMessage(String text) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ != null) {
            mc.f_91074_.m_213846_((Component)Component.m_237113_((String)text));
        }
    }
}

