/*
 * Decompiled with CFR 0.152.
 */
package com.bogdan3000.dintegrate.client.gui;

import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;

public class MultilineEditBox
extends EditBox {
    private final Font localFont;
    private int scrollOffset = 0;
    private long lastBlink = 0L;
    private boolean caretVisible = true;

    public MultilineEditBox(Font font, int x, int y, int width, int height, Component title) {
        super(font, x, y, width, height, title);
        this.localFont = font;
        this.m_94199_(10000);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 257 || keyCode == 335) {
            int cursor = this.m_94207_();
            String current = this.m_94155_();
            String newValue = current.substring(0, cursor) + "\n" + current.substring(cursor);
            this.m_94144_(newValue);
            this.m_94196_(cursor + 1);
            this.ensureCursorVisible();
            return true;
        }
        if (keyCode == 265) {
            this.setScrollOffset(this.scrollOffset - 1);
            return true;
        }
        if (keyCode == 264) {
            this.setScrollOffset(this.scrollOffset + 1);
            return true;
        }
        boolean handled = super.m_7933_(keyCode, scanCode, modifiers);
        if (handled) {
            this.ensureCursorVisible();
        }
        return handled;
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (codePoint == '\n' || codePoint == '\r') {
            int cursor = this.m_94207_();
            String current = this.m_94155_();
            String newValue = current.substring(0, cursor) + "\n" + current.substring(cursor);
            this.m_94144_(newValue);
            this.m_94196_(cursor + 1);
            this.ensureCursorVisible();
            return true;
        }
        boolean handled = super.m_5534_(codePoint, modifiers);
        if (handled) {
            this.ensureCursorVisible();
        }
        return handled;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (!this.isInside(mouseX, mouseY)) {
            return false;
        }
        this.setScrollOffset(this.scrollOffset - (delta > 0.0 ? 1 : -1));
        return true;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean inside = this.isInside(mouseX, mouseY);
        this.m_93692_(inside);
        if (!inside) {
            return false;
        }
        String[] lines = this.getLines();
        Objects.requireNonNull(this.localFont);
        int lineH = 9 + 2;
        int relY = (int)mouseY - (this.m_252907_() + 4);
        int visIdx = Math.max(0, Math.min(relY / lineH, Math.max(0, this.getVisibleLines() - 1)));
        int lineIdx = Math.max(0, Math.min(this.scrollOffset + visIdx, lines.length - 1));
        String line = lines[lineIdx];
        int relX = (int)mouseX - (this.m_252754_() + 4);
        int col = 0;
        int px = 0;
        for (int i = 0; i < line.length(); ++i) {
            int w = this.localFont.m_92895_(String.valueOf(line.charAt(i)));
            if (px + w / 2 >= relX) {
                col = i;
                break;
            }
            px += w;
            col = i + 1;
        }
        int cursor = 0;
        for (int i = 0; i < lineIdx; ++i) {
            cursor += lines[i].length() + 1;
        }
        this.m_94196_(cursor += Math.max(0, Math.min(col, line.length())));
        this.ensureCursorVisible();
        return true;
    }

    private boolean isInside(double mouseX, double mouseY) {
        return mouseX >= (double)this.m_252754_() && mouseX < (double)(this.m_252754_() + this.f_93618_) && mouseY >= (double)this.m_252907_() && mouseY < (double)(this.m_252907_() + this.f_93619_);
    }

    public void m_87963_(GuiGraphics gfx, int mouseX, int mouseY, float partialTicks) {
        gfx.m_280509_(this.m_252754_() - 1, this.m_252907_() - 1, this.m_252754_() + this.f_93618_ + 1, this.m_252907_() + this.f_93619_ + 1, -8355712);
        gfx.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, -16777216);
        String[] lines = this.getLines();
        Objects.requireNonNull(this.localFont);
        int lineH = 9 + 2;
        int visibleLines = this.getVisibleLines();
        int maxStart = Math.max(0, lines.length - visibleLines);
        int start = Math.min(this.scrollOffset, maxStart);
        int end = Math.min(lines.length, start + visibleLines);
        int lineY = this.m_252907_() + 4;
        for (int i = start; i < end; ++i) {
            gfx.m_280056_(this.localFont, lines[i], this.m_252754_() + 4, lineY, 0xFFFFFF, false);
            lineY += lineH;
        }
        this.drawCaret(gfx, lines, start, end, lineH);
        if (lines.length > visibleLines) {
            int barHeight = Math.max(10, (int)((float)visibleLines / (float)lines.length * (float)(this.f_93619_ - 4)));
            int available = this.f_93619_ - 4 - barHeight;
            int barY = this.m_252907_() + 2 + (available <= 0 ? 0 : (int)((float)start / (float)(lines.length - visibleLines) * (float)available));
            gfx.m_280509_(this.m_252754_() + this.f_93618_ - 3, barY, this.m_252754_() + this.f_93618_ - 1, barY + barHeight, -5592406);
        }
    }

    private void drawCaret(GuiGraphics gfx, String[] lines, int start, int end, int lineH) {
        if (!this.m_93696_()) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now - this.lastBlink > 500L) {
            this.caretVisible = !this.caretVisible;
            this.lastBlink = now;
        }
        if (!this.caretVisible) {
            return;
        }
        int cursor = this.m_94207_();
        int charCount = 0;
        int lineIdx = 0;
        int col = 0;
        for (int i = 0; i < lines.length; ++i) {
            int len = lines[i].length();
            if (cursor <= charCount + len) {
                lineIdx = i;
                col = cursor - charCount;
                break;
            }
            charCount += len + 1;
            if (i != lines.length - 1) continue;
            lineIdx = i;
            col = len;
        }
        if (lineIdx < start || lineIdx >= end) {
            return;
        }
        int x = this.m_252754_() + 4 + this.localFont.m_92895_(lines[lineIdx].substring(0, Math.max(0, Math.min(col, lines[lineIdx].length()))));
        int y = this.m_252907_() + 4 + (lineIdx - start) * lineH;
        Objects.requireNonNull(this.localFont);
        gfx.m_280509_(x, y - 1, x + 1, y + 9 + 1, -1);
    }

    private String[] getLines() {
        return this.m_94155_().split("\n", -1);
    }

    private int getVisibleLines() {
        Objects.requireNonNull(this.localFont);
        int lineH = 9 + 2;
        return Math.max(1, this.f_93619_ / lineH);
    }

    private void setScrollOffset(int newOffset) {
        int maxOffset = Math.max(0, this.getLines().length - this.getVisibleLines());
        this.scrollOffset = Math.max(0, Math.min(newOffset, maxOffset));
    }

    private void ensureCursorVisible() {
        String[] lines = this.getLines();
        int cursorIndex = this.m_94207_();
        int lineIdx = 0;
        int charCount = 0;
        for (int i = 0; i < lines.length; ++i) {
            int len = lines[i].length();
            if (cursorIndex <= charCount + len) {
                lineIdx = i;
                break;
            }
            charCount += len + 1;
            lineIdx = i + 1;
        }
        int visible = this.getVisibleLines();
        if (lineIdx < this.scrollOffset) {
            this.scrollOffset = lineIdx;
        } else if (lineIdx >= this.scrollOffset + visible) {
            this.scrollOffset = lineIdx - visible + 1;
        }
        this.setScrollOffset(this.scrollOffset);
    }
}

