/*
 * Decompiled with CFR 0.152.
 */
package com.bogdan3000.dintegrate.client.gui;

import com.bogdan3000.dintegrate.Config;
import com.bogdan3000.dintegrate.DonateIntegrate;
import com.bogdan3000.dintegrate.client.gui.DonateIntegrateScreen;
import com.bogdan3000.dintegrate.client.gui.LabelWidget;
import com.bogdan3000.dintegrate.client.gui.MultilineEditBox;
import com.bogdan3000.dintegrate.client.gui.TabBase;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class TabCommands
extends TabBase {
    private final Config config;
    private boolean inEditMode = false;
    private final List<Button> ruleButtons = new ArrayList<Button>();
    private Button addRuleButton;
    private Config.DonationRule currentRule;
    private EditBox amountBox;
    private CycleButton<String> modeDropdown;
    private EditBox randomNBox;
    private MultilineEditBox commandsBox;
    private Button saveButton;
    private Button deleteButton;
    private Button backButton;
    private final Minecraft mc = Minecraft.m_91087_();
    private static final List<String> MODES = List.of("all", "random", "random_all", "randomN");
    private double scrollOffset = 0.0;
    private double maxScroll = 0.0;

    public TabCommands(Config config) {
        super("Commands");
        this.config = config;
    }

    @Override
    public void init(Minecraft mc, int width, int height) {
        super.init(mc, width, height);
        if (this.inEditMode) {
            this.initEditor(width, height);
            this.setListVisible(false);
        } else {
            this.initScrollableList(width, height);
        }
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof DonateIntegrateScreen) {
            DonateIntegrateScreen s = (DonateIntegrateScreen)screen;
            s.setTabButtonsVisible(!this.inEditMode);
            s.rebuildForCurrentTab();
        }
    }

    private void initScrollableList(int width, int height) {
        this.widgets.clear();
        this.ruleButtons.clear();
        int cx = width / 2;
        int baseY = Math.max(70, height / 6);
        this.addRuleButton = Button.m_253074_((Component)Component.m_237113_((String)"+ Add new rule"), b -> this.createNewRule()).m_252987_(cx - 100, baseY - 30, 200, 20).m_253136_();
        this.addWidget((AbstractWidget)this.addRuleButton);
        int colCount = width > 720 ? 2 : 1;
        int colWidth = width / colCount - 60;
        int spacing = 30;
        int i = 0;
        for (Config.DonationRule rule : this.config.rules) {
            int col = i % colCount;
            int row = i / colCount;
            int x = 40 + col * (colWidth + 40);
            int yPos = baseY + row * spacing;
            String title = rule.amount + "\u20bd \u2192 " + rule.commands.size() + " cmds [" + rule.mode + "]";
            Button btn = Button.m_253074_((Component)Component.m_237113_((String)title), b -> this.openEditor(rule)).m_252987_(x, yPos, colWidth, 20).m_253136_();
            this.ruleButtons.add(btn);
            this.addWidget((AbstractWidget)btn);
            ++i;
        }
        int totalRows = (int)Math.ceil((double)this.config.rules.size() / (double)colCount);
        int totalHeight = totalRows * spacing;
        int viewportHeight = height - baseY - 80;
        this.maxScroll = Math.max(0, totalHeight - viewportHeight);
        this.updateScrollPositions();
        this.setListVisible(true);
    }

    private void setListVisible(boolean visible) {
        for (Button b : this.ruleButtons) {
            b.f_93624_ = visible;
            b.f_93623_ = visible;
        }
        if (this.addRuleButton != null) {
            this.addRuleButton.f_93624_ = visible;
            this.addRuleButton.f_93623_ = visible;
        }
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        if (!this.inEditMode) {
            this.scrollOffset -= delta * 20.0;
            if (this.scrollOffset < 0.0) {
                this.scrollOffset = 0.0;
            }
            if (this.scrollOffset > this.maxScroll) {
                this.scrollOffset = this.maxScroll;
            }
            this.updateScrollPositions();
            return true;
        }
        return false;
    }

    private void updateScrollPositions() {
        int baseY = Math.max(70, this.height / 6);
        int colCount = this.width > 720 ? 2 : 1;
        int colWidth = this.width / colCount - 60;
        int spacing = 30;
        for (int i = 0; i < this.ruleButtons.size(); ++i) {
            Button btn = this.ruleButtons.get(i);
            int col = i % colCount;
            int row = i / colCount;
            int x = 40 + col * (colWidth + 40);
            int y = (int)((double)(baseY + row * spacing) - this.scrollOffset);
            btn.m_252865_(x);
            btn.m_253211_(y);
            btn.f_93624_ = y + 20 > 50 && y < this.height - 50;
        }
    }

    private void initEditor(int width, int height) {
        this.widgets.clear();
        Font font = this.mc.f_91062_;
        int cx = width / 2;
        int y = Math.max(25, height / 10);
        this.addWidget(new LabelWidget(cx, y, "Editing Rule (" + this.currentRule.amount + "\u20bd)"));
        int boxWidth = (int)((double)width * 0.7);
        int boxHeight = (int)((double)height * 0.45);
        this.commandsBox = new MultilineEditBox(font, cx - boxWidth / 2, y += 25, boxWidth, boxHeight, (Component)Component.m_237113_((String)"Commands"));
        this.commandsBox.m_94144_(String.join((CharSequence)"\n", this.currentRule.commands));
        this.addWidget((AbstractWidget)this.commandsBox);
        this.amountBox = new EditBox(font, cx - 120, y += boxHeight + 15, 240, 20, (Component)Component.m_237113_((String)"Amount"));
        this.amountBox.m_94144_(String.valueOf(this.currentRule.amount));
        this.addWidget((AbstractWidget)this.amountBox);
        String initialMode = this.normalizeMode(this.currentRule.mode);
        this.modeDropdown = CycleButton.m_168894_(s -> Component.m_237113_((String)s)).m_232502_(MODES).m_168948_((Object)initialMode).m_168929_().m_168936_(cx - 120, y += 30, 240, 20, (Component)Component.m_237113_((String)"Mode"), (btn, val) -> this.onModeChanged((String)val));
        this.addWidget((AbstractWidget)this.modeDropdown);
        this.randomNBox = new EditBox(font, cx - 120, y += 28, 240, 20, (Component)Component.m_237113_((String)"N for randomN"));
        int initialN = this.parseRandomN(this.currentRule.mode);
        if (initialN > 0) {
            this.randomNBox.m_94144_(String.valueOf(initialN));
        }
        this.addWidget((AbstractWidget)this.randomNBox);
        this.saveButton = Button.m_253074_((Component)Component.m_237113_((String)"\ud83d\udcbe Save"), b -> this.saveCurrentRule()).m_252987_(cx - 120, y += 40, 70, 20).m_253136_();
        this.deleteButton = Button.m_253074_((Component)Component.m_237113_((String)"\u2716 Delete"), b -> this.deleteCurrentRule()).m_252987_(cx - 35, y, 70, 20).m_253136_();
        this.backButton = Button.m_253074_((Component)Component.m_237113_((String)"\u2190 Back"), b -> this.exitEditor()).m_252987_(cx + 50, y, 70, 20).m_253136_();
        this.addWidget((AbstractWidget)this.saveButton);
        this.addWidget((AbstractWidget)this.deleteButton);
        this.addWidget((AbstractWidget)this.backButton);
        this.updateRandomNVisibility();
    }

    private void openEditor(Config.DonationRule rule) {
        this.currentRule = rule;
        this.inEditMode = true;
        this.init(this.mc, this.width, this.height);
    }

    private void createNewRule() {
        Config.DonationRule rule = new Config.DonationRule();
        rule.amount = 0.0;
        rule.mode = "all";
        rule.commands = new ArrayList<String>();
        this.config.rules.add(rule);
        this.openEditor(rule);
    }

    private void saveCurrentRule() {
        try {
            this.currentRule.amount = Double.parseDouble(this.amountBox.m_94155_().trim());
        }
        catch (Exception e) {
            DonateIntegrate.sendClientMessage("\u00a7cInvalid amount format!");
            return;
        }
        String selectedMode = (String)this.modeDropdown.m_168883_();
        if ("randomN".equals(selectedMode)) {
            int n = this.parseIntSafe(this.randomNBox.m_94155_().trim(), 1);
            this.currentRule.mode = "random" + n;
        } else {
            this.currentRule.mode = selectedMode;
        }
        String[] lines = this.commandsBox.m_94155_().split("\\R+");
        this.currentRule.commands = new ArrayList<String>();
        for (String line : lines) {
            if (line.isBlank()) continue;
            this.currentRule.commands.add(line.trim());
        }
        DonateIntegrate.sendClientMessage("\u00a7aRule " + this.currentRule.amount + "\u20bd saved!");
        this.saveRulesToJson();
        this.exitEditor();
    }

    private void deleteCurrentRule() {
        this.config.rules.remove(this.currentRule);
        DonateIntegrate.sendClientMessage("\u00a7cRule deleted.");
        this.saveRulesToJson();
        this.exitEditor();
    }

    private void exitEditor() {
        this.inEditMode = false;
        this.currentRule = null;
        this.init(this.mc, this.width, this.height);
    }

    private void onModeChanged(String newVal) {
        this.updateRandomNVisibility();
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof DonateIntegrateScreen) {
            DonateIntegrateScreen s = (DonateIntegrateScreen)screen;
            s.rebuildForCurrentTab();
        }
    }

    private void updateRandomNVisibility() {
        boolean show;
        this.randomNBox.f_93624_ = show = "randomN".equals(this.modeDropdown.m_168883_());
        this.randomNBox.f_93623_ = show;
    }

    private int parseRandomN(String mode) {
        if (mode == null) {
            return 0;
        }
        if ((mode = mode.toLowerCase(Locale.ROOT).trim()).startsWith("random") && mode.length() > 6) {
            try {
                return Integer.parseInt(mode.substring(6));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    private int parseIntSafe(String s, int def) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return def;
        }
    }

    private String normalizeMode(String mode) {
        if (mode == null) {
            return "all";
        }
        if ((mode = mode.toLowerCase(Locale.ROOT).trim()).equals("all") || mode.equals("random") || mode.equals("random_all")) {
            return mode;
        }
        if (mode.startsWith("random") && mode.length() > 6) {
            return "randomN";
        }
        return "all";
    }

    private void saveRulesToJson() {
        try {
            Path path = Paths.get("config", "dintegrate.json");
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            FileReader reader = new FileReader(path.toFile());
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            reader.close();
            json.add("rules", gson.toJsonTree(this.config.rules));
            FileWriter writer = new FileWriter(path.toFile());
            gson.toJson((JsonElement)json, (Appendable)writer);
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void render(GuiGraphics gfx, int mouseX, int mouseY, float partialTicks) {
        gfx.m_280509_(0, 0, this.width, this.height, -1442840576);
        super.render(gfx, mouseX, mouseY, partialTicks);
        if (!this.inEditMode && this.maxScroll > 1.0) {
            int baseY;
            int top = baseY = Math.max(70, this.height / 6);
            int bottom = this.height - 50;
            int trackLeft = this.width - 14;
            int trackRight = this.width - 10;
            gfx.m_280509_(trackLeft, top, trackRight, bottom, 0x33000000);
            int trackHeight = bottom - top;
            int colCount = this.width > 720 ? 2 : 1;
            int spacing = 30;
            int totalRows = (int)Math.ceil((double)this.config.rules.size() / (double)colCount);
            int totalHeight = totalRows * spacing;
            int thumbHeight = Math.max(12, (int)((double)trackHeight * (double)trackHeight / (double)Math.max(trackHeight, totalHeight)));
            int maxThumbTravel = trackHeight - thumbHeight;
            int thumbY = top + (int)((double)maxThumbTravel * (this.scrollOffset / this.maxScroll));
            gfx.m_280509_(trackLeft + 1, thumbY, trackRight - 1, thumbY + thumbHeight, -5592406);
        }
    }
}

