/*
 * Decompiled with CFR 0.152.
 */
package com.bogdan3000.dintegrate.client.gui;

import com.bogdan3000.dintegrate.Config;
import com.bogdan3000.dintegrate.DonateIntegrate;
import com.bogdan3000.dintegrate.client.gui.TabBase;
import com.bogdan3000.dintegrate.donation.DonatePayProvider;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;

public class TabConfig
extends TabBase {
    private EditBox tokenBox;
    private EditBox userIdBox;
    private Button saveButton;
    private Button startButton;
    private Button stopButton;
    private Button restartButton;
    private Button toggleTokenButton;
    private boolean tokenVisible = false;
    private String connectionStatus = "Unknown";
    private int connectionColor = -22016;
    private int connectionY;
    private final Config config;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();

    public TabConfig(Config config) {
        super("Config");
        this.config = config;
    }

    @Override
    public void init(Minecraft mc, int width, int height) {
        super.init(mc, width, height);
        Font font = mc.f_91062_;
        int cx = width / 2;
        int y = Math.max(40, height / 6);
        this.tokenBox = new EditBox(font, cx - 120, y, 190, 20, (Component)Component.m_237113_((String)"Token"));
        this.tokenBox.m_94199_(2048);
        this.tokenBox.m_94144_(this.obfuscateToken(this.config.getToken()));
        this.tokenBox.m_94186_(false);
        this.addWidget((AbstractWidget)this.tokenBox);
        this.toggleTokenButton = Button.m_253074_((Component)Component.m_237113_((String)"Edit"), b -> this.toggleTokenVisibility()).m_252987_(cx + 75, y, 60, 20).m_253136_();
        this.addWidget((AbstractWidget)this.toggleTokenButton);
        this.userIdBox = new EditBox(font, cx - 120, y += 35, 240, 20, (Component)Component.m_237113_((String)"User ID"));
        this.userIdBox.m_94199_(16);
        this.userIdBox.m_94144_(String.valueOf(this.config.getUserId()));
        this.addWidget((AbstractWidget)this.userIdBox);
        this.saveButton = Button.m_253074_((Component)Component.m_237113_((String)"Save Changes"), b -> this.saveConfig()).m_252987_(cx - 80, y += 35, 160, 20).m_253136_();
        this.addWidget((AbstractWidget)this.saveButton);
        this.connectionY = y += 25;
        int bw = 90;
        this.startButton = Button.m_253074_((Component)Component.m_237113_((String)"Start"), b -> this.handleStart()).m_252987_(cx - bw - 60, y += 25, bw, 20).m_253136_();
        this.stopButton = Button.m_253074_((Component)Component.m_237113_((String)"Stop"), b -> this.handleStop()).m_252987_(cx - bw / 2, y, bw, 20).m_253136_();
        this.restartButton = Button.m_253074_((Component)Component.m_237113_((String)"Restart"), b -> this.handleRestart()).m_252987_(cx + bw / 2 + 20, y, bw, 20).m_253136_();
        this.addWidget((AbstractWidget)this.startButton);
        this.addWidget((AbstractWidget)this.stopButton);
        this.addWidget((AbstractWidget)this.restartButton);
        this.updateConnectionStatus();
    }

    @Override
    public void tick() {
        super.tick();
        this.updateConnectionStatus();
    }

    @Override
    public void render(GuiGraphics gfx, int mouseX, int mouseY, float partialTicks) {
        gfx.m_280509_(0, 0, this.width, this.height, -1442840576);
        Minecraft mc = Minecraft.m_91087_();
        Font font = mc.f_91062_;
        gfx.m_280137_(font, "Connection: " + this.connectionStatus, this.centerX(), this.connectionY, this.connectionColor);
        super.render(gfx, mouseX, mouseY, partialTicks);
    }

    private void updateConnectionStatus() {
        DonatePayProvider provider = DonateIntegrate.getDonateProvider();
        if (provider == null) {
            this.connectionStatus = "Disconnected";
            this.connectionColor = -43691;
            return;
        }
        if (provider.isConnected()) {
            this.connectionStatus = "Connected";
            this.connectionColor = -16711936;
        } else {
            this.connectionStatus = "Disconnected";
            this.connectionColor = -43691;
        }
    }

    private void handleStart() {
        this.connectionStatus = "Connecting...";
        this.connectionColor = -22016;
        DonateIntegrate.sendClientMessage("\u00a7eConnecting...");
        DonateIntegrate.startConnection();
        this.scheduler.schedule(() -> Minecraft.m_91087_().execute(this::updateConnectionStatus), 1L, TimeUnit.SECONDS);
    }

    private void handleStop() {
        DonateIntegrate.stopConnection();
        DonateIntegrate.sendClientMessage("\u00a7cConnection stopped.");
        this.updateConnectionStatus();
    }

    private void handleRestart() {
        this.connectionStatus = "Connecting...";
        this.connectionColor = -22016;
        DonateIntegrate.sendClientMessage("\u00a7eReconnecting...");
        DonateIntegrate.restartConnection();
        this.scheduler.schedule(() -> Minecraft.m_91087_().execute(this::updateConnectionStatus), 1L, TimeUnit.SECONDS);
    }

    private void toggleTokenVisibility() {
        boolean bl = this.tokenVisible = !this.tokenVisible;
        if (this.tokenVisible) {
            this.tokenBox.m_94186_(true);
            this.tokenBox.m_94144_(this.config.getToken());
            this.tokenBox.m_94196_(this.tokenBox.m_94155_().length());
            this.toggleTokenButton.m_93666_((Component)Component.m_237113_((String)"Hide"));
        } else {
            this.tokenBox.m_94186_(false);
            this.tokenBox.m_94144_(this.obfuscateToken(this.config.getToken()));
            this.toggleTokenButton.m_93666_((Component)Component.m_237113_((String)"Edit"));
        }
    }

    private void saveConfig() {
        String tokenInput = this.tokenVisible ? this.tokenBox.m_94155_().trim() : this.config.getToken();
        String userStr = this.userIdBox.m_94155_().trim();
        if (tokenInput == null || tokenInput.isEmpty()) {
            DonateIntegrate.sendClientMessage("\u00a7cToken cannot be empty!");
            return;
        }
        try {
            int userId = Integer.parseInt(userStr);
            DonateIntegrate.saveToJsonConfig("token", tokenInput);
            DonateIntegrate.saveToJsonConfig("user_id", String.valueOf(userId));
            this.config.token = tokenInput;
            this.config.user_id = userId;
            if (this.tokenVisible) {
                this.toggleTokenVisibility();
            }
            DonateIntegrate.sendClientMessage("\u00a7aConfig saved and connection restarted!");
            this.connectionStatus = "Connecting...";
            this.connectionColor = -22016;
            DonateIntegrate.restartConnection();
            this.scheduler.schedule(() -> Minecraft.m_91087_().execute(this::updateConnectionStatus), 1L, TimeUnit.SECONDS);
        }
        catch (NumberFormatException e) {
            DonateIntegrate.sendClientMessage("\u00a7cInvalid User ID format!");
        }
    }

    private String obfuscateToken(String token) {
        if (token == null || token.isBlank()) {
            return "";
        }
        if (token.length() <= 4) {
            return "*".repeat(token.length());
        }
        return token.substring(0, 2) + "*".repeat(token.length() - 4) + token.substring(token.length() - 2);
    }
}

