/*
 * Decompiled with CFR 0.152.
 */
package com.bogdan3000.dintegrate.client.gui;

import com.bogdan3000.dintegrate.Config;
import com.bogdan3000.dintegrate.DonateIntegrate;
import com.bogdan3000.dintegrate.client.gui.TabBase;
import com.bogdan3000.dintegrate.logic.ActionHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;

public class TabMisc
extends TabBase {
    private final Config config;
    private final List<Button> ruleButtons = new ArrayList<Button>();
    private int baseY = 40;
    private int rowHeight = 24;
    private int cols = 2;
    private int colWidth = 220;
    private int colPad = 10;
    private double scrollOffset = 0.0;
    private int contentHeight = 0;

    public TabMisc() {
        super("Misc");
        this.config = DonateIntegrate.getConfig();
    }

    @Override
    public void init(Minecraft mc, int width, int height) {
        super.init(mc, width, height);
        int usable = Math.max(1, width - 40);
        this.cols = Math.max(1, Math.min(usable / 240, 3));
        if (this.cols == 0) {
            this.cols = 1;
        }
        this.colWidth = (usable - this.colPad * (this.cols - 1)) / this.cols;
        if (this.colWidth < 160) {
            this.cols = 1;
            this.colWidth = usable;
        }
        this.buildButtons();
        this.updateLayout();
    }

    private void buildButtons() {
        for (Button button : this.ruleButtons) {
            this.widgets.remove(button);
        }
        this.ruleButtons.clear();
        int i = 0;
        for (Config.DonationRule rule : this.config.rules) {
            String label = rule.amount + "\u20bd \u2014 " + (rule.mode != null ? rule.mode.toUpperCase() : "ALL") + " (" + (rule.commands != null ? rule.commands.size() : 0) + " cmds)";
            double amt = rule.amount;
            Button btn = Button.m_253074_((Component)Component.m_237113_((String)label), b -> this.testDonation(amt)).m_252987_(0, 0, this.colWidth, 20).m_253136_();
            this.ruleButtons.add(btn);
            this.addWidget((AbstractWidget)btn);
            ++i;
        }
        if (this.ruleButtons.isEmpty()) {
            Button button = Button.m_253074_((Component)Component.m_237113_((String)"\u00a7c\u041d\u0435\u0442 \u043f\u0440\u0430\u0432\u0438\u043b \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0435!"), b -> {}).m_252987_(this.centerX() - 100, this.baseY + 10, 200, 20).m_253136_();
            this.ruleButtons.add(button);
            this.addWidget((AbstractWidget)button);
        }
    }

    private void updateLayout() {
        int rows = (int)Math.ceil((double)this.ruleButtons.size() / (double)this.cols);
        this.contentHeight = rows * this.rowHeight;
        int left = 20;
        int visibleTop = this.baseY;
        int visibleBottom = this.height - 12;
        for (int i = 0; i < this.ruleButtons.size(); ++i) {
            boolean visible;
            Button btn = this.ruleButtons.get(i);
            int row = i / this.cols;
            int col = i % this.cols;
            int x = left + col * (this.colWidth + this.colPad);
            int y = this.baseY + row * this.rowHeight - (int)this.scrollOffset;
            btn.m_252865_(x);
            btn.m_253211_(y);
            btn.m_93674_(this.colWidth);
            btn.f_93624_ = visible = y + 20 >= visibleTop && y <= visibleBottom;
        }
        int maxScroll = Math.max(0, this.contentHeight - (visibleBottom - visibleTop));
        if (this.scrollOffset < 0.0) {
            this.scrollOffset = 0.0;
        }
        if (this.scrollOffset > (double)maxScroll) {
            this.scrollOffset = maxScroll;
        }
    }

    private void testDonation(double amount) {
        Map<Double, Config.DonationRule> rules = this.config.getRules();
        Config.DonationRule rule = rules.get(amount);
        if (rule == null) {
            DonateIntegrate.sendClientMessage("\u00a7c[DIntegrate] \u041f\u0440\u0430\u0432\u0438\u043b\u043e \u0434\u043b\u044f " + amount + "\u20bd \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e.");
            return;
        }
        String name = "TestUser";
        String msg = "Test Message";
        DonateIntegrate.sendClientMessage("\u00a7d[DIntegrate] \u0421\u0438\u043c\u0443\u043b\u044f\u0446\u0438\u044f \u0434\u043e\u043d\u0430\u0442\u0430 " + amount + "\u20bd (" + rule.mode + ")");
        new ActionHandler(this.config).execute(amount, name, msg);
    }

    @Override
    public void tick() {
        super.tick();
        this.updateLayout();
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        this.scrollOffset -= delta * 20.0;
        this.updateLayout();
        return true;
    }

    @Override
    public void render(GuiGraphics gfx, int mouseX, int mouseY, float partialTicks) {
        super.render(gfx, mouseX, mouseY, partialTicks);
        int visibleTop = this.baseY;
        int visibleBottom = this.height - 12;
        int viewportH = Math.max(1, visibleBottom - visibleTop);
        if (this.contentHeight > viewportH) {
            int barH = Math.max(20, (int)((float)viewportH * ((float)viewportH / (float)this.contentHeight)));
            int maxScroll = this.contentHeight - viewportH;
            int barY = visibleTop + (int)(this.scrollOffset / (double)maxScroll * (double)(viewportH - barH));
            int barX = this.width - 8;
            gfx.m_280509_(barX, visibleTop, barX + 3, visibleBottom, 0x33000000);
            gfx.m_280509_(barX, barY, barX + 3, barY + barH, -1711276033);
        }
    }
}

