/*
 * Decompiled with CFR 0.152.
 */
package com.bogdan3000.dintegrate.donation;

import com.bogdan3000.dintegrate.donation.DonationProvider;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.mojang.logging.LogUtils;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.WebSocket;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;

public class DonatePayProvider
implements DonationProvider,
WebSocket.Listener {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final String accessToken;
    private final int userId;
    private final String tokenUrl;
    private final String socketUrl;
    private final Consumer<DonationProvider.DonationEvent> donationHandler;
    private final HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread t = new Thread(r);
        t.setDaemon(true);
        t.setName("DonatePayScheduler");
        return t;
    });
    private WebSocket socket;
    private ScheduledFuture<?> pingTask;
    private String connectToken;
    private String clientId;
    private String subscriptionToken;
    private int msgCounter = 2;
    private volatile boolean connecting = false;
    private volatile boolean connected = false;
    private volatile boolean subscribed = false;
    private long lastConnectAttempt = 0L;
    private static final long COOLDOWN_MS = 8000L;

    public DonatePayProvider(String accessToken, int userId, String tokenUrl, String socketUrl, Consumer<DonationProvider.DonationEvent> handler) {
        this.accessToken = accessToken;
        this.userId = userId;
        this.tokenUrl = tokenUrl;
        this.socketUrl = socketUrl;
        this.donationHandler = handler;
    }

    @Override
    public synchronized void connect() {
        long now = System.currentTimeMillis();
        if (now - this.lastConnectAttempt < 8000L) {
            LOGGER.warn("[DIntegrate] Connection attempt blocked \u2014 cooldown active ({} ms left)", (Object)(8000L - (now - this.lastConnectAttempt)));
            return;
        }
        this.lastConnectAttempt = now;
        if (this.connected || this.connecting) {
            LOGGER.warn("[DIntegrate] Connection already active \u2014 skipping connect()");
            return;
        }
        if (this.accessToken == null || this.accessToken.isBlank() || this.userId <= 0) {
            LOGGER.error("[DIntegrate] Invalid token or user_id in config!");
            return;
        }
        this.connecting = true;
        this.subscribed = false;
        LOGGER.info("[DIntegrate] Requesting connection token from {}", (Object)this.tokenUrl);
        this.getConnectionToken().thenAccept(token -> {
            if (token == null || token.isEmpty()) {
                LOGGER.error("[DIntegrate] Failed to get connection token. (Maybe wrong token?)");
                this.connecting = false;
                return;
            }
            this.connectToken = token;
            LOGGER.info("[DIntegrate] Got connection token, connecting to WebSocket...");
            ((CompletableFuture)this.httpClient.newWebSocketBuilder().connectTimeout(Duration.ofSeconds(10L)).buildAsync(URI.create(this.socketUrl), this).thenAccept(ws -> {
                this.socket = ws;
                this.startPing((WebSocket)ws);
                this.scheduler.schedule(() -> this.sendHandshake((WebSocket)ws), 500L, TimeUnit.MILLISECONDS);
            })).exceptionally(ex -> {
                LOGGER.error("[DIntegrate] WebSocket connection failed: {}", (Object)ex.getMessage());
                this.connecting = false;
                return null;
            });
        });
    }

    private void sendHandshake(WebSocket ws) {
        try {
            JsonObject root = new JsonObject();
            root.addProperty("id", (Number)1);
            JsonObject params = new JsonObject();
            params.addProperty("token", this.connectToken);
            params.addProperty("name", "js");
            root.add("params", (JsonElement)params);
            ws.sendText(root.toString(), true);
            LOGGER.info("[DIntegrate] Sent handshake (step 1)");
        }
        catch (Exception e) {
            LOGGER.error("[DIntegrate] Error sending handshake", (Throwable)e);
        }
    }

    private void sendSubscribe(WebSocket ws) {
        try {
            String channel = "$public:" + this.userId;
            JsonObject root = new JsonObject();
            root.addProperty("method", (Number)1);
            root.addProperty("id", (Number)2);
            JsonObject params = new JsonObject();
            params.addProperty("channel", channel);
            params.addProperty("token", this.subscriptionToken);
            root.add("params", (JsonElement)params);
            ws.sendText(root.toString(), true);
            LOGGER.info("[DIntegrate] Sent subscribe (step 2)");
        }
        catch (Exception e) {
            LOGGER.error("[DIntegrate] Error sending subscribe", (Throwable)e);
        }
    }

    private CompletableFuture<String> getConnectionToken() {
        try {
            String body = "{\"access_token\":\"" + this.accessToken + "\"}";
            HttpRequest req = HttpRequest.newBuilder().uri(URI.create(this.tokenUrl)).timeout(Duration.ofSeconds(10L)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(body, StandardCharsets.UTF_8)).build();
            return this.httpClient.sendAsync(req, HttpResponse.BodyHandlers.ofString()).thenApply(resp -> {
                if (resp.statusCode() != 200) {
                    LOGGER.error("[DIntegrate] HTTP error {} from DonatePay token API", (Object)resp.statusCode());
                    return null;
                }
                try {
                    JsonReader reader = new JsonReader((Reader)new StringReader((String)resp.body()));
                    reader.setLenient(true);
                    JsonObject json = JsonParser.parseReader((JsonReader)reader).getAsJsonObject();
                    return json.has("token") ? json.get("token").getAsString() : null;
                }
                catch (Exception e) {
                    LOGGER.error("[DIntegrate] Token parse error", (Throwable)e);
                    return null;
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("[DIntegrate] HTTP error", (Throwable)e);
            return CompletableFuture.completedFuture(null);
        }
    }

    private CompletableFuture<String> getSubscriptionToken(String clientId) {
        try {
            JsonObject body = new JsonObject();
            body.addProperty("client", clientId);
            body.add("channels", JsonParser.parseString((String)("[\"$public:" + this.userId + "\"]")));
            String url = this.tokenUrl + "?access_token=" + this.accessToken;
            HttpRequest req = HttpRequest.newBuilder().uri(URI.create(url)).timeout(Duration.ofSeconds(10L)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(body.toString(), StandardCharsets.UTF_8)).build();
            return this.httpClient.sendAsync(req, HttpResponse.BodyHandlers.ofString()).thenApply(resp -> {
                if (resp.statusCode() != 200) {
                    LOGGER.error("[DIntegrate] Subscription token HTTP error {}", (Object)resp.statusCode());
                    return null;
                }
                try {
                    JsonReader reader = new JsonReader((Reader)new StringReader((String)resp.body()));
                    reader.setLenient(true);
                    JsonObject json = JsonParser.parseReader((JsonReader)reader).getAsJsonObject();
                    if (json.has("channels")) {
                        JsonObject chan = json.getAsJsonArray("channels").get(0).getAsJsonObject();
                        return chan.get("token").getAsString();
                    }
                }
                catch (Exception e) {
                    LOGGER.error("[DIntegrate] Subscription token parse error", (Throwable)e);
                }
                return null;
            });
        }
        catch (Exception e) {
            LOGGER.error("[DIntegrate] Subscription token HTTP error", (Throwable)e);
            return CompletableFuture.completedFuture(null);
        }
    }

    @Override
    public void onOpen(WebSocket webSocket) {
        this.connected = true;
        this.connecting = false;
        LOGGER.info("[DIntegrate] WebSocket opened.");
        webSocket.request(1L);
    }

    @Override
    public CompletionStage<?> onText(WebSocket webSocket, CharSequence message, boolean last) {
        try {
            String msg = message.toString();
            JsonObject json = JsonParser.parseString((String)msg).getAsJsonObject();
            if (json.has("id") && json.get("id").getAsInt() == 1 && json.has("result")) {
                this.clientId = json.getAsJsonObject("result").get("client").getAsString();
                this.getSubscriptionToken(this.clientId).thenAccept(subToken -> {
                    if (subToken != null) {
                        this.subscriptionToken = subToken;
                        this.sendSubscribe(webSocket);
                    } else {
                        LOGGER.error("[DIntegrate] Failed to get subscription token.");
                    }
                });
            } else if (json.has("id") && json.get("id").getAsInt() == 2 && json.has("result")) {
                this.subscribed = true;
                LOGGER.info("[DIntegrate] Successfully subscribed to $public:{}.", (Object)this.userId);
            } else if (json.has("result") && json.getAsJsonObject("result").has("data")) {
                JsonObject vars = json.getAsJsonObject("result").getAsJsonObject("data").getAsJsonObject("data").getAsJsonObject("notification").getAsJsonObject("vars");
                this.handleDonation(vars);
            }
        }
        catch (Exception e) {
            LOGGER.error("[DIntegrate] WS parse error", (Throwable)e);
        }
        webSocket.request(1L);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletionStage<?> onClose(WebSocket webSocket, int code, String reason) {
        this.connected = false;
        this.subscribed = false;
        this.connecting = false;
        LOGGER.warn("[DIntegrate] WebSocket closed ({}): {}", (Object)code, (Object)reason);
        this.stopPing();
        this.socket = null;
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public void onError(WebSocket webSocket, Throwable error) {
        LOGGER.error("[DIntegrate] WebSocket error", error);
        this.connected = false;
        this.subscribed = false;
        this.connecting = false;
        this.stopPing();
    }

    private void startPing(WebSocket ws) {
        this.stopPing();
        this.pingTask = this.scheduler.scheduleAtFixedRate(() -> {
            try {
                if (ws != null && !ws.isOutputClosed()) {
                    ++this.msgCounter;
                    ws.sendText("{\"method\":7,\"id\":" + this.msgCounter + "}", true);
                }
            }
            catch (Exception e) {
                LOGGER.error("[DIntegrate] Ping send error", (Throwable)e);
            }
        }, 25L, 25L, TimeUnit.SECONDS);
    }

    private void stopPing() {
        if (this.pingTask != null) {
            this.pingTask.cancel(true);
            this.pingTask = null;
        }
    }

    @Override
    public boolean isConnected() {
        return this.connected && this.subscribed && this.socket != null && !this.socket.isOutputClosed();
    }

    @Override
    public void onDonation(Consumer<DonationProvider.DonationEvent> handler) {
    }

    @Override
    public synchronized void disconnect() {
        if (!this.connected && !this.connecting) {
            LOGGER.warn("[DIntegrate] Already disconnected \u2014 skipping.");
            return;
        }
        LOGGER.info("[DIntegrate] Disconnecting WebSocket...");
        this.connected = false;
        this.subscribed = false;
        this.connecting = false;
        this.stopPing();
        if (this.socket != null) {
            try {
                this.socket.sendClose(1000, "Manual disconnect");
            }
            catch (Exception e) {
                LOGGER.warn("[DIntegrate] Socket close error: {}", (Object)e.getMessage());
            }
            finally {
                this.socket = null;
            }
        }
    }

    private void handleDonation(JsonObject vars) {
        try {
            String name = vars.has("name") ? vars.get("name").getAsString() : "Unknown";
            double sum = vars.has("sum") ? vars.get("sum").getAsDouble() : 0.0;
            String msg = vars.has("comment") ? vars.get("comment").getAsString() : "";
            this.donationHandler.accept(new DonationProvider.DonationEvent(name, sum, msg, -1));
        }
        catch (Exception e) {
            LOGGER.error("[DIntegrate] Donation parse error", (Throwable)e);
        }
    }
}

