/*
 * Decompiled with CFR 0.152.
 */
package com.bogdan3000.dintegrate.logic;

import com.bogdan3000.dintegrate.Config;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import org.slf4j.Logger;

public class ActionHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Config config;

    public ActionHandler(Config config) {
        this.config = config;
    }

    public void execute(double amount, String donorName, String donorMessage) {
        Config.DonationRule rule = null;
        for (Map.Entry<Double, Config.DonationRule> entry : this.config.getRules().entrySet()) {
            if (!(Math.abs(entry.getKey() - amount) < 1.0E-4)) continue;
            rule = entry.getValue();
            break;
        }
        if (rule == null) {
            LOGGER.warn("[DIntegrate] No rule found for amount {} ({} rules in config)", (Object)amount, (Object)this.config.getRules().size());
            return;
        }
        Config.DonationRule ruleFinal = rule;
        List<String> plan = this.buildPlan(ruleFinal);
        if (plan.isEmpty()) {
            LOGGER.warn("[DIntegrate] Rule {} has empty command list", (Object)amount);
            return;
        }
        String name = donorName != null ? donorName : "Player";
        String msg = donorMessage != null ? donorMessage : "";
        String sum = this.formatSum(amount);
        Thread worker = new Thread(() -> {
            LOGGER.info("[DIntegrate] Executing rule for amount {} ({} commands, mode={})", new Object[]{amount, plan.size(), ruleFinal.mode});
            for (String raw : plan) {
                String cmd = raw.replace("{name}", name).replace("{message}", msg).replace("{sum}", sum).trim();
                if (cmd.isEmpty() || this.handleDelay(cmd)) continue;
                LOGGER.info("[DIntegrate] Executing: {}", (Object)cmd);
                this.runOnMainThread(cmd);
            }
        }, "DIntegrate-ActionWorker");
        worker.setDaemon(true);
        worker.start();
    }

    private List<String> buildPlan(Config.DonationRule rule) {
        String mode;
        ArrayList<String> base = new ArrayList<String>(rule.commands);
        return switch (mode = rule.mode != null ? rule.mode.toLowerCase(Locale.ROOT) : "all") {
            case "random" -> Collections.singletonList((String)base.get(ThreadLocalRandom.current().nextInt(base.size())));
            case "random_all" -> {
                Collections.shuffle(base);
                yield base;
            }
            default -> {
                if (mode.startsWith("random")) {
                    int n = this.parseInt(mode.replaceAll("\\D", ""), 1);
                    Collections.shuffle(base);
                    yield base.subList(0, Math.min(n, base.size()));
                }
                yield base;
            }
        };
    }

    private int parseInt(String s, int def) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return def;
        }
    }

    private boolean handleDelay(String line) {
        try {
            if (line.startsWith("/delay ")) {
                double seconds = Double.parseDouble(line.substring(7).trim());
                LOGGER.info("[DIntegrate] Waiting {} seconds", (Object)seconds);
                Thread.sleep((long)(seconds * 1000.0));
                return true;
            }
            if (line.startsWith("/randomdelay ")) {
                String[] parts = line.substring(13).trim().split("-");
                double a = Double.parseDouble(parts[0]);
                double b = Double.parseDouble(parts[1]);
                double sec = a + ThreadLocalRandom.current().nextDouble() * (b - a);
                LOGGER.info("[DIntegrate] Waiting randomly between {}\u2013{} seconds (actual: {})", new Object[]{a, b, String.format("%.2f", sec)});
                Thread.sleep((long)(sec * 1000.0));
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.warn("[DIntegrate] Delay parse error: {}", (Object)e.toString());
        }
        return false;
    }

    private void runOnMainThread(String line) {
        Minecraft mc = Minecraft.m_91087_();
        mc.execute(() -> {
            LocalPlayer player = mc.f_91074_;
            if (player == null || player.f_108617_ == null) {
                LOGGER.warn("[DIntegrate] No player connection available for: {}", (Object)line);
                return;
            }
            try {
                if (line.startsWith("/")) {
                    String command = line.substring(1);
                    player.f_108617_.m_246623_(command);
                } else if (line.startsWith("\u00a7")) {
                    player.m_213846_((Component)Component.m_237113_((String)line));
                } else {
                    player.f_108617_.m_246175_(line);
                }
            }
            catch (Exception e) {
                LOGGER.error("[DIntegrate] Failed to execute command '{}'", (Object)line, (Object)e);
            }
        });
    }

    private String formatSum(double a) {
        String s = Double.toString(a);
        return s.endsWith(".0") ? s.substring(0, s.length() - 2) : s;
    }
}

