/*
 * Decompiled with CFR 0.152.
 */
package io.github.kidofcubes.screenshotfeatures;

import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.GuiListBase;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.interfaces.ISelectionListener;
import fi.dy.masa.malilib.gui.widgets.WidgetListBase;
import fi.dy.masa.malilib.gui.widgets.WidgetListEntryBase;
import fi.dy.masa.malilib.util.StringUtils;
import io.github.kidofcubes.screenshotfeatures.ScreenshotFeatures;
import io.github.kidofcubes.screenshotfeatures.config.ConfigsGui;
import io.github.kidofcubes.screenshotfeatures.util.PNGMetadataManipulator;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public class GuiScreenshotViewer
extends GuiListBase<MetadataEntry, MetadataEntryWidget, WidgetListBase<MetadataEntry, MetadataEntryWidget>>
implements ISelectionListener<MetadataEntry> {
    private final List<MetadataEntry> metadata = new ArrayList<MetadataEntry>();

    public GuiScreenshotViewer() {
        this(10, 88);
    }

    public GuiScreenshotViewer(int listX, int listY) {
        super(listX, listY);
    }

    public void initGui() {
        ConfigsGui.tab = ConfigsGui.ConfigGuiTab.SCREENSHOTVIEWER;
        super.initGui();
        this.title = StringUtils.translate((String)"screenshotfeatures.gui.title.screenshotviewer", (Object[])new Object[0]);
        this.clearWidgets();
        this.clearButtons();
        this.createTabButtons();
        this.getListWidget().refreshEntries();
        this.addLabel(18, 53, -1, 14, -1, new String[]{StringUtils.translate((String)"screenshotfeatures.gui.description.screenshotviewer0", (Object[])new Object[0])});
        this.addLabel(18, 68, -1, 14, -1, new String[]{StringUtils.translate((String)"screenshotfeatures.gui.description.screenshotviewer1", (Object[])new Object[0])});
    }

    public void method_29638(List<Path> paths) {
        Path path = paths.get(0);
        if (!path.getFileName().toString().endsWith(".png")) {
            return;
        }
        Map<String, String> map = PNGMetadataManipulator.getMetadata(path.toFile());
        this.metadata.clear();
        map.forEach((key, val) -> this.metadata.add(new MetadataEntry((String)key, (String)val)));
        this.getListWidget().refreshEntries();
    }

    private void createTabButtons() {
        int x = 10;
        int y = 26;
        int rows = 1;
        for (ConfigsGui.ConfigGuiTab tab : ConfigsGui.ConfigGuiTab.values()) {
            int width = this.getStringWidth(tab.getDisplayName()) + 10;
            if (x >= this.field_22789 - width - 10) {
                x = 10;
                y += 22;
                ++rows;
            }
            x += this.createTabButton(x, y, width, tab);
        }
    }

    protected int createTabButton(int x, int y, int width, final ConfigsGui.ConfigGuiTab tab) {
        ButtonGeneric button = new ButtonGeneric(x, y, width, 20, tab.getDisplayName(), new String[0]);
        button.setEnabled(ConfigsGui.tab != tab);
        this.addButton((ButtonBase)button, new IButtonActionListener(){

            public void actionPerformedWithButton(ButtonBase buttonBase, int i) {
                ConfigsGui.tab = tab;
                GuiBase.openGui((class_437)new ConfigsGui());
            }
        });
        return button.getWidth() + 2;
    }

    protected WidgetListBase<MetadataEntry, MetadataEntryWidget> createListWidget(int listX, int listY) {
        return new MetaDataEntryWidgetList(this, listX, listY, this.getBrowserWidth(), this.getBrowserHeight(), this){};
    }

    protected int getBrowserWidth() {
        return this.field_22789 - 20;
    }

    protected int getBrowserHeight() {
        return this.field_22790 - this.getListY() - 6;
    }

    public void onSelectionChange(@Nullable MetadataEntry metadataEntry) {
    }

    public record MetadataEntry(String key, String value) {
    }

    public static class MetadataEntryWidget
    extends WidgetListEntryBase<MetadataEntry> {
        public MetadataEntryWidget(int x, int y, int width, int height, final @Nullable MetadataEntry entry, int listIndex) {
            super(x, y, width, height, (Object)entry, listIndex);
            ButtonGeneric button = new ButtonGeneric(x, y, -1, 20, entry.key, new String[]{entry.value});
            this.addButton((ButtonBase)button, new IButtonActionListener(){

                public void actionPerformedWithButton(ButtonBase buttonBase, int i) {
                    ScreenshotFeatures.client.field_1774.method_1455(entry.value);
                }
            });
            this.addLabel(x + button.getWidth() + 1, y, -1, 20, -1, new String[]{entry.value});
        }
    }

    public class MetaDataEntryWidgetList
    extends WidgetListBase<MetadataEntry, MetadataEntryWidget> {
        public MetaDataEntryWidgetList(int x, int y, int width, @Nullable int height, ISelectionListener<MetadataEntry> selectionListener) {
            super(x, y, width, height, selectionListener);
            this.browserEntryHeight = 20;
        }

        protected Collection<MetadataEntry> getAllEntries() {
            return GuiScreenshotViewer.this.metadata;
        }

        protected MetadataEntryWidget createListEntryWidget(int x, int y, int listIndex, boolean isOdd, MetadataEntry entry) {
            return new MetadataEntryWidget(x, y, this.browserEntryWidth, this.getBrowserEntryHeightFor(entry), entry, listIndex);
        }
    }
}

