/*
 * Decompiled with CFR 0.152.
 */
package io.github.kidofcubes.screenshotfeatures.mixin;

import io.github.kidofcubes.screenshotfeatures.ScreenshotFeatures;
import io.github.kidofcubes.screenshotfeatures.config.Configs;
import io.github.kidofcubes.screenshotfeatures.util.FileNameTemplateProcessor;
import io.github.kidofcubes.screenshotfeatures.util.PNGMetadataManipulator;
import io.github.kidofcubes.screenshotfeatures.util.getters.GameMeta;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.Consumer;
import net.minecraft.class_1011;
import net.minecraft.class_2561;
import net.minecraft.class_318;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_318.class})
public class ScreenshotMixin {
    @ModifyVariable(method={"method_68157(Ljava/io/File;Ljava/lang/String;Ljava/util/function/Consumer;Lnet/minecraft/client/texture/NativeImage;)V"}, at=@At(value="STORE"), index=4)
    private static File directoryInject(File f) {
        Object location = !Configs.ScreenshotSaving.USE_CUSTOM_SCREENSHOT_DIRECTORY.getBooleanValue() ? "./screenshots/" : Configs.ScreenshotSaving.SCREENSHOT_DIRECTORY.getStringValue() + "/";
        try {
            return new File((String)location);
        }
        catch (Exception e) {
            ScreenshotFeatures.LOGGER.error("Error checking save location for screenshot: ", e);
            ScreenshotFeatures.client.field_1724.method_7353((class_2561)class_2561.method_43471((String)"screenshotfeatures.messages.errorInvalidScreenshotLocation"), false);
            return new File("./screenshots/");
        }
    }

    @ModifyVariable(method={"saveScreenshot(Ljava/io/File;Ljava/lang/String;Lnet/minecraft/client/gl/Framebuffer;ILjava/util/function/Consumer;)V"}, argsOnly=true, at=@At(value="HEAD"), index=1)
    private static String filenameInject(String orig) {
        if (!Configs.ScreenshotSaving.RENAME_SCREENSHOTS.getBooleanValue()) {
            return orig;
        }
        String filename = orig == null ? FileNameTemplateProcessor.format(Configs.ScreenshotSaving.SCREENSHOT_NAMING_SCHEMA.getStringValue()) : orig;
        Object dir = !Configs.ScreenshotSaving.USE_CUSTOM_SCREENSHOT_DIRECTORY.getBooleanValue() ? "./screenshots/" : Configs.ScreenshotSaving.SCREENSHOT_DIRECTORY.getStringValue() + "/";
        int i = 1;
        Object tmp = filename;
        while (true) {
            Path p;
            try {
                p = Path.of((String)dir + (String)tmp + ".png", new String[0]);
            }
            catch (Exception e) {
                ScreenshotFeatures.LOGGER.error("Error checking save file location for screenshot: ", e);
                ScreenshotFeatures.client.field_1724.method_7353((class_2561)class_2561.method_43471((String)"screenshotfeatures.messages.errorInvalidScreenshotLocation"), false);
                return orig;
            }
            if (!Files.exists(p, new LinkOption[0])) break;
            tmp = filename + "_(" + i + ")";
            ++i;
        }
        return (String)tmp + ".png";
    }

    @Inject(method={"method_22691(Lnet/minecraft/client/texture/NativeImage;Ljava/io/File;Ljava/util/function/Consumer;)V"}, at={@At(value="HEAD")}, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
    private static void createDirs(class_1011 _nativeImage, File file, Consumer<class_2561> _consumer, CallbackInfo _ci) {
        file.getParentFile().mkdirs();
    }

    @Inject(method={"method_22691(Lnet/minecraft/client/texture/NativeImage;Ljava/io/File;Ljava/util/function/Consumer;)V"}, at={@At(value="INVOKE", target="Ljava/util/function/Consumer;accept(Ljava/lang/Object;)V", ordinal=0)}, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
    private static void attachMetadata(class_1011 nativeImage, File file, Consumer<class_2561> consumer, CallbackInfo ci) {
        PNGMetadataManipulator.attachMetadata(file, GameMeta.getMetadata(ScreenshotFeatures.client));
    }
}

