/*
 * Decompiled with CFR 0.152.
 */
package io.github.kidofcubes.screenshotfeatures.util;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.NodeList;

public class PNGMetadataManipulator {
    private static void addTextEntry(IIOMetadata metadata, String key, String value) throws IIOInvalidTreeException {
        IIOMetadataNode textEntry = new IIOMetadataNode("TextEntry");
        textEntry.setAttribute("keyword", key);
        textEntry.setAttribute("value", value);
        IIOMetadataNode text = new IIOMetadataNode("Text");
        text.appendChild(textEntry);
        IIOMetadataNode root = new IIOMetadataNode("javax_imageio_1.0");
        root.appendChild(text);
        metadata.mergeTree("javax_imageio_1.0", root);
    }

    private static String getTextEntry(IIOMetadata metadata, String key) {
        IIOMetadataNode root = (IIOMetadataNode)metadata.getAsTree("javax_imageio_1.0");
        NodeList entries = root.getElementsByTagName("TextEntry");
        for (int i = 0; i < entries.getLength(); ++i) {
            IIOMetadataNode node = (IIOMetadataNode)entries.item(i);
            if (!node.getAttribute("keyword").equals(key)) continue;
            return node.getAttribute("value");
        }
        return null;
    }

    private static Map<String, String> getAllTextEntry(IIOMetadata metadata) {
        IIOMetadataNode root = (IIOMetadataNode)metadata.getAsTree("javax_imageio_1.0");
        NodeList entries = root.getElementsByTagName("TextEntry");
        HashMap<String, String> entriesMap = new HashMap<String, String>();
        for (int i = 0; i < entries.getLength(); ++i) {
            IIOMetadataNode node = (IIOMetadataNode)entries.item(i);
            if (!node.hasAttribute("keyword")) continue;
            entriesMap.put(node.getAttribute("keyword"), node.getAttribute("value"));
        }
        return entriesMap;
    }

    private static void removeTextEntry(IIOMetadata metadata, String key) {
        IIOMetadataNode root = (IIOMetadataNode)metadata.getAsTree("javax_imageio_1.0");
        NodeList entries = root.getElementsByTagName("TextEntry");
        for (int i = 0; i < entries.getLength(); ++i) {
            IIOMetadataNode node = (IIOMetadataNode)entries.item(i);
            if (!node.getAttribute("keyword").equals(key)) continue;
            node.getParentNode().removeChild(node);
        }
    }

    public static void attachMetadata(File f, Map<String, String> meta) {
        try {
            ImageInputStream input = ImageIO.createImageInputStream(f);
            Iterator<ImageReader> readers = ImageIO.getImageReaders(input);
            ImageReader reader = readers.next();
            reader.setInput(input);
            IIOImage img = reader.readAll(0, null);
            for (Map.Entry<String, String> entry : meta.entrySet()) {
                PNGMetadataManipulator.addTextEntry(img.getMetadata(), entry.getKey(), entry.getValue());
            }
            input.close();
            ImageOutputStream out = ImageIO.createImageOutputStream(f);
            ImageWriter writer = ImageIO.getImageWriter(reader);
            writer.setOutput(out);
            writer.write(img);
            out.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, String> getMetadata(File f) {
        try {
            ImageInputStream input = ImageIO.createImageInputStream(f);
            Iterator<ImageReader> readers = ImageIO.getImageReaders(input);
            ImageReader reader = readers.next();
            reader.setInput(input);
            IIOImage img = reader.readAll(0, null);
            input.close();
            return PNGMetadataManipulator.getAllTextEntry(img.getMetadata());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

