/*
 * Decompiled with CFR 0.152.
 */
package io.github.kidofcubes.screenshotfeatures;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import fi.dy.masa.malilib.config.ConfigManager;
import fi.dy.masa.malilib.config.IConfigHandler;
import fi.dy.masa.malilib.event.InitializationHandler;
import fi.dy.masa.malilib.event.InputEventHandler;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.hotkeys.IHotkey;
import fi.dy.masa.malilib.hotkeys.IHotkeyCallback;
import fi.dy.masa.malilib.hotkeys.IKeybindManager;
import fi.dy.masa.malilib.hotkeys.IKeybindProvider;
import fi.dy.masa.malilib.hotkeys.IMouseInputHandler;
import fi.dy.masa.malilib.util.GuiUtils;
import io.github.kidofcubes.screenshotfeatures.config.Configs;
import io.github.kidofcubes.screenshotfeatures.config.ConfigsGui;
import io.github.kidofcubes.screenshotfeatures.integrations.FabrishotIntegration;
import io.github.kidofcubes.screenshotfeatures.integrations.OrthoCameraIntegration;
import java.io.File;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_318;
import net.minecraft.class_437;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class ScreenshotFeatures
implements ClientModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger("ScreenshotFeatures");
    public static class_310 client;
    private static final InputHandler inputHandler;
    public static final String MOD_ID = "screenshotfeatures";

    public void onInitializeClient() {
        client = class_310.method_1551();
        this.registerScreenshotCommands();
        InitializationHandler.getInstance().registerInitializationHandler(() -> {
            ConfigManager.getInstance().registerConfigHandler(MOD_ID, (IConfigHandler)new Configs());
            InputEventHandler.getKeybindManager().registerKeybindProvider((IKeybindProvider)inputHandler);
            InputEventHandler.getInputManager().registerMouseInputHandler((IMouseInputHandler)inputHandler);
            IHotkeyCallback valueChange = (keyAction, iKeybind) -> {
                double modifier = iKeybind == Configs.IngameTools.INCREASE_VALUE.getKeybind() ? 1.0 : -1.0;
                return ScreenshotFeatures.changeValue(modifier);
            };
            Configs.IngameTools.INCREASE_VALUE.getKeybind().setCallback(valueChange);
            Configs.IngameTools.DECREASE_VALUE.getKeybind().setCallback(valueChange);
            Configs.IngameTools.CYCLE_WEATHER_OVERRIDE.getKeybind().setCallback((keyAction, iKeybind) -> {
                Configs.IngameTools.WEATHER_OVERRIDE_VALUE.setOptionListValue(Configs.IngameTools.WEATHER_OVERRIDE_VALUE.getOptionListValue().cycle(true));
                return true;
            });
            Configs.IngameTools.OPEN_CONFIG.getKeybind().setCallback((keyAction, iKeybind) -> {
                GuiBase.openGui((class_437)new ConfigsGui());
                return true;
            });
        });
        FabrishotIntegration.register();
        OrthoCameraIntegration.register();
        LOGGER.info("ScreenshotFeatures loaded.");
    }

    public static boolean changeValue(double modifier) {
        if (Configs.IngameTools.LARGE_VALUE_MODIFIER.getKeybind().isKeybindHeld()) {
            modifier *= Configs.IngameTools.LARGE_VALUE_MULTIPLIER.getDoubleValue();
        }
        if (Configs.IngameTools.SMALL_VALUE_MODIFIER.getKeybind().isKeybindHeld()) {
            modifier *= Configs.IngameTools.SMALL_VALUE_MULTIPLIER.getDoubleValue();
        }
        boolean used = false;
        if (Configs.IngameTools.DOF_MODIFIER.getKeybind().isKeybindHeld()) {
            Configs.IngameTools.DOF_OVERRIDE_VALUE.setDoubleValue(Configs.IngameTools.DOF_OVERRIDE_VALUE.getDoubleValue() + modifier * Configs.IngameTools.DOF_STEP.getDoubleValue());
            ScreenshotFeatures.client.field_1724.method_7353((class_2561)class_2561.method_43469((String)"screenshotfeatures.messages.dofOverrideValueChange", (Object[])new Object[]{Configs.IngameTools.DOF_OVERRIDE_VALUE.getDoubleValue()}), true);
            used = true;
        }
        if (Configs.IngameTools.TIME_MODIFIER.getKeybind().isKeybindHeld()) {
            Configs.IngameTools.TIME_OVERRIDE_VALUE.setIntegerValue(Configs.IngameTools.TIME_OVERRIDE_VALUE.getIntegerValue() + (int)Math.round(modifier * (double)Configs.IngameTools.TIME_STEP.getIntegerValue()));
            ScreenshotFeatures.client.field_1724.method_7353((class_2561)class_2561.method_43469((String)"screenshotfeatures.messages.timeOverrideValueChange", (Object[])new Object[]{Configs.IngameTools.TIME_OVERRIDE_VALUE.getIntegerValue()}), true);
            used = true;
        }
        if (Configs.OrthoCameraIntegration.X_SCALE_MODIFIER.getKeybind().isKeybindHeld()) {
            Configs.OrthoCameraIntegration.X_SCALE.setFloatValue(Configs.OrthoCameraIntegration.X_SCALE.getFloatValue() + (float)(modifier * (double)Configs.OrthoCameraIntegration.X_SCALE_STEP.getFloatValue()));
            ScreenshotFeatures.client.field_1724.method_7353((class_2561)class_2561.method_43469((String)"screenshotfeatures.messages.orthoScaleXValueChange", (Object[])new Object[]{Float.valueOf(Configs.OrthoCameraIntegration.X_SCALE.getFloatValue())}), true);
            used = true;
        }
        if (Configs.OrthoCameraIntegration.Y_SCALE_MODIFIER.getKeybind().isKeybindHeld()) {
            Configs.OrthoCameraIntegration.Y_SCALE.setFloatValue(Configs.OrthoCameraIntegration.Y_SCALE.getFloatValue() + (float)(modifier * (double)Configs.OrthoCameraIntegration.Y_SCALE_STEP.getFloatValue()));
            ScreenshotFeatures.client.field_1724.method_7353((class_2561)class_2561.method_43469((String)"screenshotfeatures.messages.orthoScaleYValueChange", (Object[])new Object[]{Float.valueOf(Configs.OrthoCameraIntegration.Y_SCALE.getFloatValue())}), true);
            used = true;
        }
        if (Configs.OrthoCameraIntegration.MIN_DISTANCE_MODIFIER.getKeybind().isKeybindHeld()) {
            Configs.OrthoCameraIntegration.MIN_DISTANCE.setFloatValue(Configs.OrthoCameraIntegration.MIN_DISTANCE.getFloatValue() + (float)(modifier * (double)Configs.OrthoCameraIntegration.MIN_DISTANCE_STEP.getFloatValue()));
            ScreenshotFeatures.client.field_1724.method_7353((class_2561)class_2561.method_43469((String)"screenshotfeatures.messages.orthoMinDistanceValueChange", (Object[])new Object[]{Float.valueOf(Configs.OrthoCameraIntegration.MIN_DISTANCE.getFloatValue())}), true);
            used = true;
        }
        if (Configs.OrthoCameraIntegration.MAX_DISTANCE_MODIFIER.getKeybind().isKeybindHeld()) {
            Configs.OrthoCameraIntegration.MAX_DISTANCE.setFloatValue(Configs.OrthoCameraIntegration.MAX_DISTANCE.getFloatValue() + (float)(modifier * (double)Configs.OrthoCameraIntegration.MAX_DISTANCE_STEP.getFloatValue()));
            ScreenshotFeatures.client.field_1724.method_7353((class_2561)class_2561.method_43469((String)"screenshotfeatures.messages.orthoMaxDistanceValueChange", (Object[])new Object[]{Float.valueOf(Configs.OrthoCameraIntegration.MAX_DISTANCE.getFloatValue())}), true);
            used = true;
        }
        return used;
    }

    private void registerScreenshotCommands() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> this.register((CommandDispatcher<class_2168>)dispatcher));
    }

    private void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"screenshot").executes(this::takeScreenshot)).then(class_2170.method_9244((String)"filename", (ArgumentType)StringArgumentType.string()).executes(context -> this.takeScreenshot((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"filename")))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"ss").executes(this::takeScreenshot)).then(class_2170.method_9244((String)"filename", (ArgumentType)StringArgumentType.string()).executes(context -> this.takeScreenshot((CommandContext<class_2168>)context, StringArgumentType.getString((CommandContext)context, (String)"filename")))));
    }

    private int takeScreenshot(CommandContext<class_2168> context) {
        if (((class_2168)context.getSource()).method_43737()) {
            class_318.method_1659((File)new File("."), (class_276)client.method_1522(), arg_0 -> ((class_2168)((class_2168)context.getSource())).method_45068(arg_0));
        } else {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"This command can only be executed by players!"));
        }
        return 1;
    }

    private int takeScreenshot(CommandContext<class_2168> context, String filename) {
        if (((class_2168)context.getSource()).method_43737()) {
            class_318.method_22690((File)new File("."), (String)filename, (class_276)client.method_1522(), (int)1, arg_0 -> ((class_2168)((class_2168)context.getSource())).method_45068(arg_0));
        } else {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)"This command can only be executed by players!"));
        }
        return 1;
    }

    static {
        inputHandler = new InputHandler();
    }

    static class InputHandler
    implements IKeybindProvider,
    IMouseInputHandler {
        InputHandler() {
        }

        public void addKeysToMap(IKeybindManager manager) {
            for (IHotkey hotkey : Configs.IngameTools.HOTKEYS) {
                manager.addKeybindToMap(hotkey.getKeybind());
            }
            for (IHotkey hotkey : Configs.OrthoCameraIntegration.HOTKEYS) {
                manager.addKeybindToMap(hotkey.getKeybind());
            }
        }

        public void addHotkeys(IKeybindManager manager) {
            manager.addHotkeysForCategory(ScreenshotFeatures.MOD_ID, "screenshotfeatures.hotkeys.category.ingame_hotkeys", Configs.IngameTools.HOTKEYS);
            manager.addHotkeysForCategory(ScreenshotFeatures.MOD_ID, "screenshotfeatures.hotkeys.category.orthocameraintegration_hotkeys", Configs.OrthoCameraIntegration.HOTKEYS);
        }

        public boolean onMouseScroll(double mouseX, double mouseY, double amount) {
            if (GuiUtils.getCurrentScreen() == null && amount != 0.0 && Configs.IngameTools.ALLOW_MWHEEL_CHANGE_VALUE.getBooleanValue()) {
                double modifier = amount * Configs.IngameTools.MWHEEL_MULTIPLIER.getDoubleValue();
                return ScreenshotFeatures.changeValue(modifier);
            }
            return false;
        }
    }
}

