/*
 * Decompiled with CFR 0.152.
 */
package io.github.kidofcubes.screenshotfeatures.config;

import fi.dy.masa.malilib.config.IConfigOptionListEntry;
import fi.dy.masa.malilib.util.StringUtils;
import java.util.Locale;

public class ConfigTypes {

    public static class PrecipitationType
    extends SimpleOptions<PrecipitationType> {
        public static final PrecipitationType RAIN = new PrecipitationType("RAIN", 0);
        public static final PrecipitationType SNOW = new PrecipitationType("SNOW", 1);
        public static final PrecipitationType CLEAR = new PrecipitationType("CLEAR", 2);
        public static final PrecipitationType NO_OP = new PrecipitationType("NO_OP", 3);

        private PrecipitationType(String name, int index) {
            super(name, index);
        }

        public PrecipitationType[] values() {
            return new PrecipitationType[]{RAIN, SNOW, CLEAR, NO_OP};
        }
    }

    public static class WeatherTypes
    extends SimpleOptions<WeatherTypes> {
        public static final WeatherTypes RAIN = new WeatherTypes("RAIN", 0);
        public static final WeatherTypes THUNDER = new WeatherTypes("THUNDER", 1);
        public static final WeatherTypes CLEAR = new WeatherTypes("CLEAR", 2);

        private WeatherTypes(String name, int index) {
            super(name, index);
        }

        public WeatherTypes[] values() {
            return new WeatherTypes[]{RAIN, THUNDER, CLEAR};
        }
    }

    public static class OptionalBoolean
    extends SimpleOptions<OptionalBoolean> {
        public static final OptionalBoolean TRUE = new OptionalBoolean("TRUE", 0);
        public static final OptionalBoolean FALSE = new OptionalBoolean("FALSE", 1);
        public static final OptionalBoolean NO_OP = new OptionalBoolean("NO_OP", 2);

        private OptionalBoolean(String name, int index) {
            super(name, index);
        }

        public OptionalBoolean[] values() {
            return new OptionalBoolean[]{TRUE, FALSE, NO_OP};
        }
    }

    public static abstract class SimpleOptions<T extends SimpleOptions<?>>
    implements IConfigOptionListEntry {
        protected final String name;
        protected final int index;

        public SimpleOptions(String name, int index) {
            this.name = name;
            this.index = index;
        }

        public abstract T[] values();

        public String getStringValue() {
            return this.name.toLowerCase(Locale.ROOT);
        }

        public String getDisplayName() {
            return StringUtils.translate((String)("screenshotfeatures.text.types." + this.getStringValue()), (Object[])new Object[0]);
        }

        public IConfigOptionListEntry cycle(boolean forward) {
            return this.values()[(this.index + (forward ? 1 : -1)) % this.values().length];
        }

        public IConfigOptionListEntry fromString(String name) {
            for (SimpleOptions x : this.values()) {
                if (!x.getStringValue().equalsIgnoreCase(name)) continue;
                return x;
            }
            return this.values()[this.values().length - 1];
        }
    }
}

