/*
 * Decompiled with CFR 0.152.
 */
package io.github.kidofcubes.screenshotfeatures.config;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fi.dy.masa.malilib.config.ConfigUtils;
import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.config.IConfigHandler;
import fi.dy.masa.malilib.config.IConfigOptionListEntry;
import fi.dy.masa.malilib.config.options.ConfigBase;
import fi.dy.masa.malilib.config.options.ConfigBoolean;
import fi.dy.masa.malilib.config.options.ConfigBooleanHotkeyed;
import fi.dy.masa.malilib.config.options.ConfigDouble;
import fi.dy.masa.malilib.config.options.ConfigFloat;
import fi.dy.masa.malilib.config.options.ConfigHotkey;
import fi.dy.masa.malilib.config.options.ConfigInteger;
import fi.dy.masa.malilib.config.options.ConfigOptionList;
import fi.dy.masa.malilib.config.options.ConfigString;
import fi.dy.masa.malilib.hotkeys.IHotkey;
import fi.dy.masa.malilib.hotkeys.KeybindSettings;
import fi.dy.masa.malilib.util.FileUtils;
import fi.dy.masa.malilib.util.JsonUtils;
import io.github.kidofcubes.screenshotfeatures.config.ConfigTypes;
import java.io.File;

public class Configs
implements IConfigHandler {
    private static final String CONFIG_FILE_NAME = "screenshotfeatures.json";

    private static <T extends ConfigBase<?>> T autoCommentAndNameWithGroup(T thing, String group) {
        thing.setComment(String.format("%s.config.%s.comment.%s", "screenshotfeatures", group, thing.getName()));
        thing.setTranslatedName(String.format("%s.config.%s.name.%s", "screenshotfeatures", group, thing.getName()));
        return thing;
    }

    public static void loadFromFile() {
        JsonElement element;
        File configFile = new File(FileUtils.getConfigDirectoryAsPath().toFile(), CONFIG_FILE_NAME);
        if (configFile.exists() && configFile.isFile() && configFile.canRead() && (element = JsonUtils.parseJsonFile((File)configFile)) != null && element.isJsonObject()) {
            JsonObject root = element.getAsJsonObject();
            ConfigUtils.readConfigBase((JsonObject)root, (String)"IngameTools", IngameTools.OPTIONS);
            ConfigUtils.readConfigBase((JsonObject)root, (String)"Metadata", Metadata.OPTIONS);
            ConfigUtils.readConfigBase((JsonObject)root, (String)"ScreenshotSaving", ScreenshotSaving.OPTIONS);
            ConfigUtils.readConfigBase((JsonObject)root, (String)"OrthoCameraIntegration", OrthoCameraIntegration.OPTIONS);
        }
    }

    public static void saveToFile() {
        File dir = FileUtils.getConfigDirectoryAsPath().toFile();
        if (dir.exists() && dir.isDirectory() || dir.mkdirs()) {
            JsonObject root = new JsonObject();
            ConfigUtils.writeConfigBase((JsonObject)root, (String)"IngameTools", IngameTools.OPTIONS);
            ConfigUtils.writeConfigBase((JsonObject)root, (String)"Metadata", Metadata.OPTIONS);
            ConfigUtils.writeConfigBase((JsonObject)root, (String)"ScreenshotSaving", ScreenshotSaving.OPTIONS);
            ConfigUtils.writeConfigBase((JsonObject)root, (String)"OrthoCameraIntegration", OrthoCameraIntegration.OPTIONS);
            JsonUtils.writeJsonToFile((JsonObject)root, (File)new File(dir, CONFIG_FILE_NAME));
        }
    }

    public void load() {
        Configs.loadFromFile();
    }

    public void save() {
        Configs.saveToFile();
    }

    public static class IngameTools {
        private static final ImmutableList.Builder<IConfigBase> OPTIONS_BUILDER = ImmutableList.builder();
        public static final ImmutableList<IConfigBase> OPTIONS;
        private static final ImmutableList.Builder<IHotkey> HOTKEYS_BUILDER;
        public static final ImmutableList<IHotkey> HOTKEYS;
        public static final ConfigHotkey OPEN_CONFIG;
        public static final ConfigBooleanHotkeyed DOF_LOCK;
        public static final ConfigBooleanHotkeyed DOF_OVERRIDE;
        public static final ConfigDouble DOF_OVERRIDE_VALUE;
        public static final ConfigDouble DOF_STEP;
        public static final ConfigHotkey DOF_MODIFIER;
        public static final ConfigBooleanHotkeyed TIME_OVERRIDE;
        public static final ConfigInteger TIME_OVERRIDE_VALUE;
        public static final ConfigInteger TIME_STEP;
        public static final ConfigHotkey TIME_MODIFIER;
        public static final ConfigBooleanHotkeyed WEATHER_OVERRIDE;
        public static final ConfigOptionList WEATHER_OVERRIDE_VALUE;
        public static final ConfigHotkey CYCLE_WEATHER_OVERRIDE;
        public static final ConfigBooleanHotkeyed FORCE_PRECIPITATION;
        public static final ConfigOptionList PRECIPITATION_FORCE_TYPE;
        public static final ConfigOptionList FORCE_RAIN;
        public static final ConfigBoolean ALLOW_MWHEEL_CHANGE_VALUE;
        public static final ConfigDouble MWHEEL_MULTIPLIER;
        public static final ConfigHotkey INCREASE_VALUE;
        public static final ConfigHotkey DECREASE_VALUE;
        public static final ConfigHotkey LARGE_VALUE_MODIFIER;
        public static final ConfigHotkey SMALL_VALUE_MODIFIER;
        public static final ConfigDouble LARGE_VALUE_MULTIPLIER;
        public static final ConfigDouble SMALL_VALUE_MULTIPLIER;
        public static final ConfigBoolean FORCE_SETTINGS;

        private static <T extends ConfigBase<?>> T setupConfig(T thing) {
            Configs.autoCommentAndNameWithGroup(thing, "ingametools");
            OPTIONS_BUILDER.add(thing);
            if (thing instanceof IHotkey) {
                IHotkey iHotkey = (IHotkey)thing;
                HOTKEYS_BUILDER.add((Object)iHotkey);
            }
            return thing;
        }

        static {
            HOTKEYS_BUILDER = ImmutableList.builder();
            OPEN_CONFIG = IngameTools.setupConfig(new ConfigHotkey("openConfig", ""));
            DOF_LOCK = IngameTools.setupConfig(new ConfigBooleanHotkeyed("dofLock", false, ""));
            DOF_OVERRIDE = IngameTools.setupConfig(new ConfigBooleanHotkeyed("dofOverride", false, ""));
            DOF_OVERRIDE_VALUE = IngameTools.setupConfig(new ConfigDouble("dofOverrideValue", 1.0, -1.7976931348623157E308, Double.MAX_VALUE));
            DOF_STEP = IngameTools.setupConfig(new ConfigDouble("dofStep", 1.0, -1.7976931348623157E308, Double.MAX_VALUE));
            DOF_MODIFIER = IngameTools.setupConfig(new ConfigHotkey("dofModifier", "LEFT", KeybindSettings.MODIFIER_INGAME_EMPTY));
            TIME_OVERRIDE = IngameTools.setupConfig(new ConfigBooleanHotkeyed("timeOverride", false, ""));
            TIME_OVERRIDE_VALUE = IngameTools.setupConfig(new ConfigInteger("timeOverrideValue", 0));
            TIME_STEP = IngameTools.setupConfig(new ConfigInteger("timeStep", 50));
            TIME_MODIFIER = IngameTools.setupConfig(new ConfigHotkey("timeModifier", "RIGHT", KeybindSettings.MODIFIER_INGAME_EMPTY));
            WEATHER_OVERRIDE = IngameTools.setupConfig(new ConfigBooleanHotkeyed("weatherOverride", false, ""));
            WEATHER_OVERRIDE_VALUE = IngameTools.setupConfig(new ConfigOptionList("weatherOverrideValue", (IConfigOptionListEntry)ConfigTypes.WeatherTypes.CLEAR));
            CYCLE_WEATHER_OVERRIDE = IngameTools.setupConfig(new ConfigHotkey("weatherOverrideCycle", ""));
            FORCE_PRECIPITATION = IngameTools.setupConfig(new ConfigBooleanHotkeyed("precipitationForce", false, ""));
            PRECIPITATION_FORCE_TYPE = IngameTools.setupConfig(new ConfigOptionList("precipitationForceType", (IConfigOptionListEntry)ConfigTypes.PrecipitationType.NO_OP, ""));
            FORCE_RAIN = IngameTools.setupConfig(new ConfigOptionList("rainForce", (IConfigOptionListEntry)ConfigTypes.OptionalBoolean.NO_OP));
            ALLOW_MWHEEL_CHANGE_VALUE = IngameTools.setupConfig(new ConfigBoolean("allowMWheelChangeValue", true));
            MWHEEL_MULTIPLIER = IngameTools.setupConfig(new ConfigDouble("mWheelMultiplier", 1.0, -1.7976931348623157E308, Double.MAX_VALUE));
            INCREASE_VALUE = IngameTools.setupConfig(new ConfigHotkey("increaseValue", "UP", KeybindSettings.PRESS_ALLOWEXTRA));
            DECREASE_VALUE = IngameTools.setupConfig(new ConfigHotkey("decreaseValue", "DOWN", KeybindSettings.PRESS_ALLOWEXTRA));
            LARGE_VALUE_MODIFIER = IngameTools.setupConfig(new ConfigHotkey("largeValueModifier", "LEFT_CONTROL", KeybindSettings.MODIFIER_INGAME));
            SMALL_VALUE_MODIFIER = IngameTools.setupConfig(new ConfigHotkey("smallValueModifier", "LEFT_SHIFT", KeybindSettings.MODIFIER_INGAME));
            LARGE_VALUE_MULTIPLIER = IngameTools.setupConfig(new ConfigDouble("largeValueMultiplier", 10.0, -1.7976931348623157E308, Double.MAX_VALUE));
            SMALL_VALUE_MULTIPLIER = IngameTools.setupConfig(new ConfigDouble("smallValueMultiplier", 0.1, -1.7976931348623157E308, Double.MAX_VALUE));
            FORCE_SETTINGS = IngameTools.setupConfig(new ConfigBoolean("forceSettings", false));
            OPTIONS = OPTIONS_BUILDER.build();
            HOTKEYS = HOTKEYS_BUILDER.build();
        }
    }

    public static class Metadata {
        private static final ImmutableList.Builder<IConfigBase> OPTIONS_BUILDER = ImmutableList.builder();
        public static final ImmutableList<IConfigBase> OPTIONS;
        public static final ConfigBoolean TAG_SCREENSHOTS;
        public static final ConfigBoolean COORDINATES;
        public static final ConfigBoolean CAMERA_COORDINATES;
        public static final ConfigBoolean TIME;
        public static final ConfigBoolean WORLD_NAME;
        public static final ConfigBoolean SEED;
        public static final ConfigBoolean RESOURCE_PACKS;
        public static final ConfigBoolean SHADER_PACK;
        public static final ConfigBoolean SHADER_PACK_HASH;
        public static final ConfigBoolean SHADER_PACK_COMMIT;
        public static final ConfigBoolean SHADER_PACK_DIFF;
        public static final ConfigBoolean SHADER_PACK_SETTINGS;
        public static final ConfigBoolean MC_VERSION;
        public static final ConfigBoolean DISPLAY_SETTINGS;

        private static <T extends ConfigBase<?>> T setupConfig(T thing) {
            Configs.autoCommentAndNameWithGroup(thing, "metadata");
            OPTIONS_BUILDER.add(thing);
            return thing;
        }

        static {
            TAG_SCREENSHOTS = Metadata.setupConfig(new ConfigBoolean("tagScreenshots", true));
            COORDINATES = Metadata.setupConfig(new ConfigBoolean("coordinates", true));
            CAMERA_COORDINATES = Metadata.setupConfig(new ConfigBoolean("camera_coordinates", true));
            TIME = Metadata.setupConfig(new ConfigBoolean("time", true));
            WORLD_NAME = Metadata.setupConfig(new ConfigBoolean("worldName", true));
            SEED = Metadata.setupConfig(new ConfigBoolean("seed", true));
            RESOURCE_PACKS = Metadata.setupConfig(new ConfigBoolean("resourcePacks", true));
            SHADER_PACK = Metadata.setupConfig(new ConfigBoolean("shaderPack", true));
            SHADER_PACK_HASH = Metadata.setupConfig(new ConfigBoolean("shaderPackHash", true));
            SHADER_PACK_COMMIT = Metadata.setupConfig(new ConfigBoolean("shaderPackCommit", true));
            SHADER_PACK_DIFF = Metadata.setupConfig(new ConfigBoolean("shaderPackDiff", true));
            SHADER_PACK_SETTINGS = Metadata.setupConfig(new ConfigBoolean("shaderPackSettings", true));
            MC_VERSION = Metadata.setupConfig(new ConfigBoolean("mcVersion", true));
            DISPLAY_SETTINGS = Metadata.setupConfig(new ConfigBoolean("displaySettings", true));
            OPTIONS = OPTIONS_BUILDER.build();
        }
    }

    public static class ScreenshotSaving {
        private static final ImmutableList.Builder<IConfigBase> OPTIONS_BUILDER = ImmutableList.builder();
        public static final ImmutableList<IConfigBase> OPTIONS;
        public static final ConfigBoolean USE_CUSTOM_SCREENSHOT_DIRECTORY;
        public static final ConfigString SCREENSHOT_DIRECTORY;
        public static final ConfigBoolean RENAME_SCREENSHOTS;
        public static final ConfigString SCREENSHOT_NAMING_SCHEMA;

        private static <T extends ConfigBase<?>> T setupConfig(T thing) {
            Configs.autoCommentAndNameWithGroup(thing, "screenshotsaving");
            OPTIONS_BUILDER.add(thing);
            return thing;
        }

        static {
            USE_CUSTOM_SCREENSHOT_DIRECTORY = ScreenshotSaving.setupConfig(new ConfigBoolean("useCustomScreenshotDirectory", false));
            SCREENSHOT_DIRECTORY = ScreenshotSaving.setupConfig(new ConfigString("customScreenshotDirectory", "./screenshots/"));
            RENAME_SCREENSHOTS = ScreenshotSaving.setupConfig(new ConfigBoolean("renameScreenshots", true));
            SCREENSHOT_NAMING_SCHEMA = ScreenshotSaving.setupConfig(new ConfigString("screenshotNamingSchema", "<datetime>-tagged"));
            OPTIONS = OPTIONS_BUILDER.build();
        }
    }

    public static class OrthoCameraIntegration {
        private static final ImmutableList.Builder<IConfigBase> OPTIONS_BUILDER = ImmutableList.builder();
        public static final ImmutableList<IConfigBase> OPTIONS;
        private static final ImmutableList.Builder<IHotkey> HOTKEYS_BUILDER;
        public static final ImmutableList<IHotkey> HOTKEYS;
        public static final ConfigBooleanHotkeyed CONFIG_ENABLED;
        public static final ConfigBooleanHotkeyed ORTHO_ENABLED;
        public static final ConfigBooleanHotkeyed FIXED_CAMERA;
        public static final ConfigFloat X_SCALE;
        public static final ConfigHotkey X_SCALE_MODIFIER;
        public static final ConfigFloat X_SCALE_STEP;
        public static final ConfigFloat Y_SCALE;
        public static final ConfigHotkey Y_SCALE_MODIFIER;
        public static final ConfigFloat Y_SCALE_STEP;
        public static final ConfigFloat MIN_DISTANCE;
        public static final ConfigHotkey MIN_DISTANCE_MODIFIER;
        public static final ConfigFloat MIN_DISTANCE_STEP;
        public static final ConfigFloat MAX_DISTANCE;
        public static final ConfigHotkey MAX_DISTANCE_MODIFIER;
        public static final ConfigFloat MAX_DISTANCE_STEP;

        private static <T extends ConfigBase<?>> T setupConfig(T thing) {
            Configs.autoCommentAndNameWithGroup(thing, "orthocameraintegration");
            OPTIONS_BUILDER.add(thing);
            if (thing instanceof IHotkey) {
                IHotkey iHotkey = (IHotkey)thing;
                HOTKEYS_BUILDER.add((Object)iHotkey);
            }
            return thing;
        }

        static {
            HOTKEYS_BUILDER = ImmutableList.builder();
            CONFIG_ENABLED = OrthoCameraIntegration.setupConfig(new ConfigBooleanHotkeyed("configEnabled", false, ""));
            ORTHO_ENABLED = OrthoCameraIntegration.setupConfig(new ConfigBooleanHotkeyed("orthoEnabled", false, ""));
            FIXED_CAMERA = OrthoCameraIntegration.setupConfig(new ConfigBooleanHotkeyed("fixedCamera", false, ""));
            X_SCALE = OrthoCameraIntegration.setupConfig(new ConfigFloat("xScale", 3.0f, ""));
            X_SCALE_MODIFIER = OrthoCameraIntegration.setupConfig(new ConfigHotkey("xScaleModifier", ""));
            X_SCALE_STEP = OrthoCameraIntegration.setupConfig(new ConfigFloat("xScaleStep", 1.0f, -3.4028235E38f, Float.MAX_VALUE, ""));
            Y_SCALE = OrthoCameraIntegration.setupConfig(new ConfigFloat("yScale", 3.0f, ""));
            Y_SCALE_MODIFIER = OrthoCameraIntegration.setupConfig(new ConfigHotkey("yScaleModifier", ""));
            Y_SCALE_STEP = OrthoCameraIntegration.setupConfig(new ConfigFloat("yScaleStep", 1.0f, -3.4028235E38f, Float.MAX_VALUE, ""));
            MIN_DISTANCE = OrthoCameraIntegration.setupConfig(new ConfigFloat("minDistance", -1000.0f, -3.4028235E38f, Float.MAX_VALUE, ""));
            MIN_DISTANCE_MODIFIER = OrthoCameraIntegration.setupConfig(new ConfigHotkey("minDistanceModifier", ""));
            MIN_DISTANCE_STEP = OrthoCameraIntegration.setupConfig(new ConfigFloat("minDistanceStep", 1.0f, -3.4028235E38f, Float.MAX_VALUE, ""));
            MAX_DISTANCE = OrthoCameraIntegration.setupConfig(new ConfigFloat("maxDistance", -1000.0f, -3.4028235E38f, Float.MAX_VALUE, ""));
            MAX_DISTANCE_MODIFIER = OrthoCameraIntegration.setupConfig(new ConfigHotkey("maxDistanceModifier", ""));
            MAX_DISTANCE_STEP = OrthoCameraIntegration.setupConfig(new ConfigFloat("maxDistanceStep", 1.0f, -3.4028235E38f, Float.MAX_VALUE, ""));
            OPTIONS = OPTIONS_BUILDER.build();
            HOTKEYS = HOTKEYS_BUILDER.build();
        }
    }
}

