/*
 * Decompiled with CFR 0.152.
 */
package io.github.kidofcubes.screenshotfeatures.config;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.GuiConfigsBase;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.widgets.WidgetListConfigOptions;
import fi.dy.masa.malilib.util.StringUtils;
import io.github.kidofcubes.screenshotfeatures.GuiScreenshotViewer;
import io.github.kidofcubes.screenshotfeatures.config.Configs;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_437;

public class ConfigsGui
extends GuiConfigsBase {
    public static ConfigGuiTab tab = ConfigGuiTab.INGAMETOOLS;

    public ConfigsGui() {
        super(10, 50, "screenshotfeatures", null, "screenshotfeatures.gui.title.configs", new Object[]{String.format("%s", "version")});
    }

    public void initGui() {
        if (tab == ConfigGuiTab.SCREENSHOTVIEWER) {
            GuiBase.openGui((class_437)new GuiScreenshotViewer());
            return;
        }
        super.initGui();
        this.clearOptions();
        int x = 10;
        int y = 26;
        for (ConfigGuiTab tab : ConfigGuiTab.values()) {
            x += this.createButton(x, y, -1, tab) + 2;
        }
    }

    private int createButton(int x, int y, int width, ConfigGuiTab tab) {
        ButtonGeneric button = new ButtonGeneric(x, y, width, 20, tab.getDisplayName(), new String[0]);
        button.setEnabled(ConfigsGui.tab != tab);
        this.addButton((ButtonBase)button, new ButtonListener(tab, this));
        return button.getWidth();
    }

    public List<GuiConfigsBase.ConfigOptionWrapper> getConfigs() {
        ImmutableList<IConfigBase> configs;
        ConfigGuiTab tab = ConfigsGui.tab;
        if (tab == ConfigGuiTab.INGAMETOOLS) {
            configs = Configs.IngameTools.OPTIONS;
        } else if (tab == ConfigGuiTab.METADATA) {
            configs = Configs.Metadata.OPTIONS;
        } else if (tab == ConfigGuiTab.SCREENSHOTSAVING) {
            configs = Configs.ScreenshotSaving.OPTIONS;
        } else if (tab == ConfigGuiTab.ORTHOCAMERAINTEGRATION) {
            configs = Configs.OrthoCameraIntegration.OPTIONS;
        } else {
            return Collections.emptyList();
        }
        return GuiConfigsBase.ConfigOptionWrapper.createFor(configs);
    }

    public static enum ConfigGuiTab {
        INGAMETOOLS("screenshotfeatures.gui.title.ingametools"),
        METADATA("screenshotfeatures.gui.title.metadata"),
        SCREENSHOTSAVING("screenshotfeatures.gui.title.screenshotsaving"),
        SCREENSHOTVIEWER("screenshotfeatures.gui.title.screenshotviewer"),
        ORTHOCAMERAINTEGRATION("screenshotfeatures.gui.title.orthocameraintegration");

        private final String translationKey;

        private ConfigGuiTab(String translationKey) {
            this.translationKey = translationKey;
        }

        public String getDisplayName() {
            return StringUtils.translate((String)this.translationKey, (Object[])new Object[0]);
        }
    }

    private static class ButtonListener
    implements IButtonActionListener {
        private final ConfigsGui parent;
        private final ConfigGuiTab tab;

        public ButtonListener(ConfigGuiTab tab, ConfigsGui parent) {
            this.tab = tab;
            this.parent = parent;
        }

        public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
            tab = this.tab;
            if (this.tab == ConfigGuiTab.SCREENSHOTVIEWER) {
                GuiBase.openGui((class_437)new GuiScreenshotViewer());
                return;
            }
            this.parent.reCreateListWidget();
            ((WidgetListConfigOptions)this.parent.getListWidget()).resetScrollbarPosition();
            this.parent.initGui();
        }
    }
}

