/*
 * Decompiled with CFR 0.152.
 */
package io.github.kidofcubes.screenshotfeatures.mixin;

import io.github.kidofcubes.screenshotfeatures.util.PNGMetadataManipulator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.api.v0.IrisApi;
import net.irisshaders.iris.gui.element.ShaderPackSelectionList;
import net.irisshaders.iris.gui.screen.ShaderPackScreen;
import net.minecraft.class_2561;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ShaderPackScreen.class}, remap=false)
public abstract class IrisMenuMixin {
    @Shadow
    private ShaderPackSelectionList shaderPackList;
    @Shadow
    private class_2561 notificationDialog;
    @Shadow
    private int notificationDialogTimer;

    @Shadow
    public abstract void refreshForChangedPack();

    @Inject(method={"onPackListFilesDrop(Ljava/util/List;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void onPackListFilesDrop(List<Path> paths, CallbackInfo callbackInfo) {
        if (paths.size() == 1) {
            Path path = paths.get(0);
            if (!path.getFileName().toString().endsWith(".png")) {
                return;
            }
            Map<String, String> metadata = PNGMetadataManipulator.getMetadata(path.toFile());
            if (metadata.containsKey("Shader Pack Settings") && metadata.containsKey("Shader Pack")) {
                Properties properties = new Properties();
                try {
                    properties.load(new ByteArrayInputStream(metadata.get("Shader Pack Settings").getBytes(StandardCharsets.UTF_8)));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                String name = metadata.get("Shader Pack");
                this.shaderPackList.select(name);
                if (this.shaderPackList.method_25334() == null || !((ShaderPackSelectionList.ShaderPackEntry)this.shaderPackList.method_25334()).getPackName().equals(name)) {
                    this.notificationDialog = class_2561.method_30163((String)("Shaderpack " + name + " doesn't exist in your shaderpacks folder!"));
                    this.notificationDialogTimer = 100;
                    callbackInfo.cancel();
                    return;
                }
                Iris.clearShaderPackOptionQueue();
                Iris.queueShaderPackOptionsFromProperties((Properties)properties);
                boolean enabled = this.shaderPackList.getTopButtonRow().shadersEnabled;
                boolean previousShadersEnabled = Iris.getIrisConfig().areShadersEnabled();
                if (enabled != previousShadersEnabled) {
                    IrisApi.getInstance().getConfig().setShadersEnabledAndApply(enabled);
                }
                this.shaderPackList.setApplied((ShaderPackSelectionList.ShaderPackEntry)this.shaderPackList.method_25334());
                Iris.getIrisConfig().setShaderPackName(name);
                IrisApi.getInstance().getConfig().setShadersEnabledAndApply(this.shaderPackList.getTopButtonRow().shadersEnabled);
                this.refreshForChangedPack();
                this.notificationDialog = class_2561.method_30163((String)"Loaded Shaderpack options from screenshot successfully!");
                this.notificationDialogTimer = 100;
            } else {
                this.notificationDialog = class_2561.method_30163((String)"Screenshot doesn't have appropriate metadata! (Did you enable the shaderpack settings and shaderpack metadata options?)");
                this.notificationDialogTimer = 100;
            }
            callbackInfo.cancel();
        }
    }
}

