/*
 * Decompiled with CFR 0.152.
 */
package io.github.kidofcubes.screenshotfeatures.util.getters;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.kidofcubes.screenshotfeatures.ScreenshotFeatures;
import io.github.kidofcubes.screenshotfeatures.config.Configs;
import io.github.kidofcubes.screenshotfeatures.integrations.ShaderIntegration;
import io.github.kidofcubes.screenshotfeatures.mixin.GameRendererMixin;
import java.time.Instant;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.class_1132;
import net.minecraft.class_156;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3262;
import net.minecraft.class_5268;
import net.minecraft.class_642;
import net.minecraft.class_746;

public class GameMeta {
    private static final Gson gson = new GsonBuilder().create();
    public static final String COORDINATES_KEY = "Coordinates";
    public static final String CAMERA_COORDINATES_KEY = "Camera_Coordinates";
    public static final String TIME_KEY = "Time";
    public static final String WORLD_NAME_KEY = "World/Server Name";
    public static final String SEED_KEY = "World Seed";
    public static final String RESOURCE_PACKS_KEY = "Resource Packs";
    public static final String SHADER_PACK_KEY = "Shader Pack";
    public static final String SHADER_PACK_ZIP_HASH_KEY = "Shader Pack Zip Hash";
    public static final String SHADER_PACK_HASH_KEY = "Shader Pack Hash";
    public static final String SHADER_PACK_ALL_SETTINGS_KEY = "Shader Pack Settings";
    public static final String SHADER_PACK_CONFIGURED_SETTINGS_KEY = "Shader Pack Configured Settings";
    public static final String SHADER_PACK_DIFF_KEY = "Shader Pack Git Diff";
    public static final String SHADER_PACK_COMMIT_KEY = "Shader Pack Git Commit";
    public static final String MC_VERSION_KEY = "Minecraft Version";
    public static final String MISC_KEY = "Misc Minecraft Data";

    public static String getMiscMetadata(class_310 client) {
        return String.format("Brightness: %f Fov setting: %d RealFov: %f", client.field_1690.method_42473().method_41753(), client.field_1690.method_41808().method_41753(), Float.valueOf(((GameRendererMixin)client.field_1773).getFovThing(client.field_1773.method_19418(), client.method_61966().method_60637(false), true)));
    }

    public static String getTimeMetadata(class_310 client) {
        try {
            return String.format("GameTimeOfDay:%d GameLunarTime:%d RealTime:%d", client.field_1687.method_8532(), client.field_1687.method_30271(), Instant.now().getEpochSecond());
        }
        catch (Exception e) {
            ScreenshotFeatures.LOGGER.error("Unable to get world time for a screenshot.\n" + String.valueOf(e));
            return "Unable to determine world time.";
        }
    }

    public static String getCoordinatesMetadata(class_310 client) {
        class_746 p = client.field_1724;
        assert (null != p);
        class_243 pos = GameMeta.getCoordinates(p);
        return String.format("X:[%f] Y:[%f] Z:[%f] Yaw:[%f] Pitch:[%f]", pos.field_1352, pos.field_1351, pos.field_1350, Float.valueOf(p.method_36454()), Float.valueOf(p.method_36455()));
    }

    public static String getCameraCoordinatesMetadata(class_310 client) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("x", (Number)client.field_1773.method_19418().method_71156().field_1352);
        jsonObject.addProperty("y", (Number)client.field_1773.method_19418().method_71156().field_1351);
        jsonObject.addProperty("z", (Number)client.field_1773.method_19418().method_71156().field_1350);
        jsonObject.addProperty("yaw", (Number)Float.valueOf(client.field_1773.method_19418().method_71155()));
        jsonObject.addProperty("pitch", (Number)Float.valueOf(client.field_1773.method_19418().method_19329()));
        return gson.toJson((JsonElement)jsonObject);
    }

    public static class_243 getCoordinates(class_746 p) {
        try {
            return p.method_43389().method_60933();
        }
        catch (NullPointerException e) {
            ScreenshotFeatures.LOGGER.error("Unable to get player coordinates. Did you try to take the screenshot before you finished loading in?");
            e.printStackTrace();
            return new class_243(0.0, 0.0, 0.0);
        }
    }

    public static String getPlayerName(class_310 client) {
        return client.method_1548().method_1676();
    }

    private static String getWorldNameSinglePlayer(class_310 client) {
        assert (null != client.method_1576());
        try {
            class_5268 worldProperties = (class_5268)((class_3218)client.method_1576().method_3738().iterator().next()).method_8401();
            return worldProperties.method_150();
        }
        catch (Exception e) {
            ScreenshotFeatures.LOGGER.error("Unable to get world name for a screenshot.\n" + String.valueOf(e));
            return "Unable to determine world name.";
        }
    }

    private static String getWorldNameMultiplayer(class_310 client) {
        try {
            class_642 si = client.method_1558();
            assert (si != null);
            return si.field_3752;
        }
        catch (Exception e) {
            ScreenshotFeatures.LOGGER.error("Unable to get world name for a screenshot.\n" + String.valueOf(e));
            return "Unable to determine world name.";
        }
    }

    public static String getWorldName(class_310 client) {
        if (GameMeta.isSinglePlayer(client)) {
            return GameMeta.getWorldNameSinglePlayer(client);
        }
        return GameMeta.getWorldNameMultiplayer(client);
    }

    public static String getSeed(class_310 client) {
        if (GameMeta.isSinglePlayer(client)) {
            class_1132 server = client.method_1576();
            assert (null != server);
            return Long.toString(((class_3218)server.method_3738().iterator().next()).method_8412());
        }
        return "Screenshot taken in Multiplayer -- Seed Unknown";
    }

    private static boolean isSinglePlayer(class_310 client) {
        return client.method_1542();
    }

    public static String getResourcePacks(class_310 client) {
        StringBuilder base = new StringBuilder("[");
        Iterator resourcePackIterator = client.method_1478().method_29213().iterator();
        while (resourcePackIterator.hasNext()) {
            base.append(String.format("%s", ((class_3262)resourcePackIterator.next()).method_14409()));
            if (!resourcePackIterator.hasNext()) continue;
            base.append(", ");
        }
        base.append("]");
        return base.toString();
    }

    public static String getVersion(class_310 client) {
        return client.method_1515();
    }

    public static String timedate() {
        return class_156.method_44893();
    }

    public static HashMap<String, String> getMetadata(class_310 client) {
        HashMap<String, String> meta = new HashMap<String, String>();
        if (null == client.field_1724 || null == client.field_1687) {
            return meta;
        }
        if (!Configs.Metadata.TAG_SCREENSHOTS.getBooleanValue()) {
            return meta;
        }
        if (Configs.Metadata.COORDINATES.getBooleanValue()) {
            meta.put(COORDINATES_KEY, GameMeta.getCoordinatesMetadata(client));
        }
        if (Configs.Metadata.CAMERA_COORDINATES.getBooleanValue()) {
            meta.put(CAMERA_COORDINATES_KEY, GameMeta.getCameraCoordinatesMetadata(client));
        }
        if (Configs.Metadata.TIME.getBooleanValue()) {
            meta.put(TIME_KEY, GameMeta.getTimeMetadata(client));
        }
        if (Configs.Metadata.WORLD_NAME.getBooleanValue()) {
            meta.put(WORLD_NAME_KEY, GameMeta.getWorldName(client));
        }
        if (Configs.Metadata.SEED.getBooleanValue()) {
            meta.put(SEED_KEY, GameMeta.getSeed(client));
        }
        if (Configs.Metadata.RESOURCE_PACKS.getBooleanValue()) {
            meta.put(RESOURCE_PACKS_KEY, GameMeta.getResourcePacks(client));
        }
        if (Configs.Metadata.SHADER_PACK.getBooleanValue() && ShaderIntegration.irisPresent()) {
            meta.put(SHADER_PACK_KEY, ShaderIntegration.getShaderName());
        }
        if (Configs.Metadata.SHADER_PACK_HASH.getBooleanValue() && ShaderIntegration.irisPresent()) {
            meta.put(SHADER_PACK_HASH_KEY, ShaderIntegration.getShaderHash());
            meta.put(SHADER_PACK_ZIP_HASH_KEY, ShaderIntegration.getShaderZipHash());
        }
        if (Configs.Metadata.SHADER_PACK_COMMIT.getBooleanValue() && ShaderIntegration.irisPresent()) {
            meta.put(SHADER_PACK_COMMIT_KEY, ShaderIntegration.getShaderCommit());
        }
        if (Configs.Metadata.SHADER_PACK_DIFF.getBooleanValue() && ShaderIntegration.irisPresent()) {
            meta.put(SHADER_PACK_DIFF_KEY, ShaderIntegration.getShaderDiff());
        }
        if (Configs.Metadata.SHADER_PACK_SETTINGS.getBooleanValue() && ShaderIntegration.irisPresent()) {
            meta.put(SHADER_PACK_ALL_SETTINGS_KEY, ShaderIntegration.getShaderAllSettings());
            meta.put(SHADER_PACK_CONFIGURED_SETTINGS_KEY, ShaderIntegration.getShaderConfiguredSettings());
        }
        if (Configs.Metadata.MC_VERSION.getBooleanValue()) {
            meta.put(MC_VERSION_KEY, GameMeta.getVersion(client));
        }
        if (Configs.Metadata.DISPLAY_SETTINGS.getBooleanValue()) {
            meta.put(MISC_KEY, GameMeta.getMiscMetadata(client));
        }
        return meta;
    }
}

