/*
 * Decompiled with CFR 0.152.
 */
package io.github.kidofcubes.screenshotfeatures.integrations;

import io.github.kidofcubes.screenshotfeatures.client.ScreenshotFeaturesClient;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.shaderpack.ShaderPack;
import net.irisshaders.iris.shaderpack.option.ShaderPackOptions;
import net.irisshaders.iris.shaderpack.option.values.MutableOptionValues;
import net.irisshaders.iris.shaderpack.option.values.OptionValues;
import org.apache.commons.codec.digest.XXHash32;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.treewalk.FileTreeIterator;

public class ShaderIntegration {
    private static Optional<String> currentShaderPackCommit = Optional.empty();
    private static Optional<String> currentShaderPackDiff = Optional.empty();
    private static Optional<String> currentShaderPackZipHash = Optional.empty();
    private static Optional<String> currentShaderPackHash = Optional.empty();
    private static Optional<String> currentShaderPackSettings = Optional.empty();
    private static Optional<String> currentShaderPackConfiguredSettings = Optional.empty();

    public static boolean irisPresent() {
        return FabricLoader.getInstance().isModLoaded("iris");
    }

    public static String getShaderName() {
        if (ShaderIntegration.irisPresent()) {
            return Iris.getCurrentPackName();
        }
        return "Iris Shaders not found -- could not resolve shader pack";
    }

    public static String getShaderHash() {
        return currentShaderPackHash.orElse("No hash found");
    }

    public static String getShaderCommit() {
        return currentShaderPackCommit.orElse("No commit found");
    }

    public static String getShaderSettings() {
        return currentShaderPackSettings.orElse("No settings found");
    }

    public static String getShaderConfiguredSettings() {
        return currentShaderPackConfiguredSettings.orElse("No configured settings found");
    }

    public static String getShaderDiff() {
        return currentShaderPackDiff.orElse("No diff found");
    }

    public static String getShaderZipHash() {
        return currentShaderPackZipHash.orElse("No zip hash found, shader may be a folder");
    }

    public static void onShaderPackLoad(Path shaderPackRoot, Path shaderPackPath, boolean isZip) {
        try {
            ShaderIntegration.saveShaderHashes(shaderPackRoot, shaderPackPath, isZip);
        }
        catch (IOException e) {
            ScreenshotFeaturesClient.LOGGER.warn("Failed to save shader hashes, defaulting to none", e);
            currentShaderPackHash = Optional.empty();
            currentShaderPackZipHash = Optional.empty();
        }
        try {
            ShaderIntegration.saveGitStatus(shaderPackPath, isZip);
        }
        catch (IOException e) {
            ScreenshotFeaturesClient.LOGGER.warn("Failed to save shader git status, defaulting to none", e);
            currentShaderPackCommit = Optional.empty();
            currentShaderPackDiff = Optional.empty();
        }
        try {
            ShaderIntegration.saveShaderSettings();
        }
        catch (IOException e) {
            ScreenshotFeaturesClient.LOGGER.warn("Failed to save shader settings, defaulting to none", e);
            currentShaderPackSettings = Optional.empty();
            currentShaderPackConfiguredSettings = Optional.empty();
        }
    }

    public static void onShaderPackUnload() {
        currentShaderPackCommit = Optional.empty();
        currentShaderPackDiff = Optional.empty();
        currentShaderPackZipHash = Optional.empty();
        currentShaderPackHash = Optional.empty();
        currentShaderPackSettings = Optional.empty();
        currentShaderPackConfiguredSettings = Optional.empty();
    }

    private static void saveShaderHashes(Path shaderPackRoot, Path shaderPackPath, boolean isZip) throws IOException {
        currentShaderPackHash = Optional.of(ShaderIntegration.calcHashForPath(shaderPackPath));
        if (isZip) {
            XXHash32 hasher = new XXHash32();
            try (InputStream stream = Files.newInputStream(shaderPackRoot, new OpenOption[0]);){
                hasher.update(stream.readAllBytes());
                String hash = String.format("%08x", hasher.getValue());
                currentShaderPackZipHash = Optional.of(hash);
            }
        } else {
            currentShaderPackZipHash = Optional.empty();
        }
    }

    private static void saveGitStatus(Path shaderPackPath, boolean isZip) throws IOException {
        if (isZip) {
            currentShaderPackCommit = Optional.empty();
            currentShaderPackDiff = Optional.empty();
            return;
        }
        RepositoryBuilder builder = (RepositoryBuilder)new RepositoryBuilder().findGitDir(shaderPackPath.toFile());
        if (builder.getGitDir() == null) {
            currentShaderPackCommit = Optional.empty();
            currentShaderPackDiff = Optional.empty();
            return;
        }
        try (Object repo = builder.build();){
            currentShaderPackCommit = Optional.of(((Repository)repo).resolve("HEAD").getName());
            DirCacheIterator dci = new DirCacheIterator(((Repository)repo).readDirCache());
            FileTreeIterator fti = new FileTreeIterator((Repository)repo);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DiffFormatter df = new DiffFormatter(out);
            df.setRepository((Repository)repo);
            df.format(dci, fti);
            df.flush();
            currentShaderPackDiff = Optional.of(out.toString());
        }
    }

    private static void saveShaderSettings() throws IOException {
        ShaderPackOptions options = ((ShaderPack)Iris.getCurrentPack().get()).getShaderPackOptions();
        OptionValues values = options.getOptionValues();
        Properties explicitSettings = new Properties();
        values.getOptionSet().getBooleanOptions().keySet().forEach(key -> explicitSettings.setProperty((String)key, Boolean.toString(values.getBooleanValueOrDefault(key))));
        values.getOptionSet().getStringOptions().keySet().forEach(key -> explicitSettings.setProperty((String)key, values.getStringValueOrDefault(key)));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        explicitSettings.store(stream, null);
        currentShaderPackSettings = Optional.of(stream.toString());
        MutableOptionValues changedConfigsValues = values.mutableCopy();
        Properties configsToSave = new Properties();
        changedConfigsValues.getBooleanValues().forEach((k, v) -> configsToSave.setProperty((String)k, Boolean.toString(v)));
        changedConfigsValues.getStringValues().forEach(configsToSave::setProperty);
        currentShaderPackConfiguredSettings = Optional.of(configsToSave.toString());
    }

    private static String calcHashForPath(Path dirToHash) throws IOException {
        try (Stream<Path> paths = Files.walk(dirToHash, FileVisitOption.FOLLOW_LINKS);){
            String string;
            List<Path> sortedPaths = paths.sorted(Comparator.comparing(path -> {
                String thing = path.toString();
                return thing;
            })).toList();
            ArrayList<InputStream> streams = new ArrayList<InputStream>(sortedPaths.size());
            for (Path path2 : sortedPaths) {
                if (Files.isDirectory(path2, new LinkOption[0])) continue;
                streams.add(Files.newInputStream(path2, new OpenOption[0]));
            }
            try (SequenceInputStream seqStream = new SequenceInputStream(Collections.enumeration(streams));){
                String hash;
                XXHash32 hasher = new XXHash32();
                hasher.update(seqStream.readAllBytes());
                string = hash = String.format("%08x", hasher.getValue());
            }
            return string;
        }
    }

    public static String getShaderNameNoExtension() {
        if (ShaderIntegration.irisPresent()) {
            return FilenameUtils.removeExtension((String)ShaderIntegration.getShaderName());
        }
        return "Unknown Shader";
    }
}

