/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.commitgraph;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.Set;
import org.apache.commons.codec.digest.MurmurHash3;

public class ChangedPathFilter {
    public static final int PATH_HASH_COUNT = 7;
    public static final int BITS_PER_ENTRY = 10;
    private static final int SEED1 = 691726191;
    private static final int SEED2 = 2120511020;
    public static final ChangedPathFilter FULL = new ChangedPathFilter(new byte[]{-1}, 0, 1);
    private static final ChangedPathFilter EMPTY = new ChangedPathFilter(new byte[1], 0, 1);
    private final byte[] data;
    private final int offset;
    private final int length;

    private ChangedPathFilter(byte[] data, int offset, int length) {
        this.data = data;
        this.offset = offset;
        this.length = length;
    }

    public static ChangedPathFilter fromPaths(Set<ByteBuffer> paths) {
        if (paths.isEmpty()) {
            return EMPTY;
        }
        byte[] bloom = new byte[-Math.floorDiv(-paths.size() * 10, 8)];
        for (ByteBuffer path : paths) {
            ChangedPathFilter.add(bloom, path.array(), path.position(), path.limit() - path.position());
        }
        return new ChangedPathFilter(bloom, 0, bloom.length);
    }

    public static ChangedPathFilter fromFile(byte[] data, int offset, int length) {
        return new ChangedPathFilter(data, offset, length);
    }

    private static void add(byte[] changedPathFilterData, byte[] path, int offset, int length) {
        int hash0 = MurmurHash3.hash32x86(path, offset, length, 691726191);
        int hash1 = MurmurHash3.hash32x86(path, offset, length, 2120511020);
        int i = 0;
        while (i < 7) {
            int pos = Integer.remainderUnsigned(hash0 + i * hash1, changedPathFilterData.length * 8);
            int n = pos / 8;
            changedPathFilterData[n] = (byte)(changedPathFilterData[n] | (byte)(1 << pos % 8));
            ++i;
        }
    }

    public boolean maybeContains(byte[] path) {
        int hash0 = MurmurHash3.hash32x86(path, 0, path.length, 691726191);
        int hash1 = MurmurHash3.hash32x86(path, 0, path.length, 2120511020);
        int bloomFilterBits = this.length * 8;
        int i = 0;
        while (i < 7) {
            int pos = Integer.remainderUnsigned(hash0 + i * hash1, bloomFilterBits);
            if ((this.data[this.offset + pos / 8] & (byte)(1 << pos % 8)) == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void writeTo(ByteArrayOutputStream s) {
        s.write(this.data, this.offset, this.length);
    }
}

