/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.ghostblocked;

import jn.willfrydev.ghostblocked.AdminJoinNotifier;
import jn.willfrydev.ghostblocked.GhostBlockerCommand;
import jn.willfrydev.ghostblocked.I18nManager;
import jn.willfrydev.ghostblocked.UpdateChecker;
import jn.willfrydev.ghostblocked.VersionCheckListener;
import jn.willfrydev.ghostblocked.libs.org.bstats.bukkit.Metrics;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class GhostBlocked
extends JavaPlugin {
    private static final int BANNER_WIDTH = 100;
    private static final String[] ASCII_BANNER = new String[]{"\u2590\u2584\u2022 \u2584 \u2584\u2584\u2584\u2584\u00b7 \u2584\u2584\u258c         \u2584\u2584\u00b7 \u2584 \u2022\u2584 \u2584\u2584\u2584 .\u00b7\u2584\u2584\u2584\u2584  ", " \u2588\u258c\u2588\u258c\u25aa\u2590\u2588 \u2580\u2588\u25aa\u2588\u2588\u2022  \u25aa     \u2590\u2588 \u258c\u25aa\u2588\u258c\u2584\u258c\u25aa\u2580\u2584.\u2580\u00b7\u2588\u2588\u25aa \u2588\u2588 ", " \u00b7\u2588\u2588\u00b7 \u2590\u2588\u2580\u2580\u2588\u2584\u2588\u2588\u25aa   \u2584\u2588\u2580\u2584 \u2588\u2588 \u2584\u2584\u2590\u2580\u2580\u2584\u00b7\u2590\u2580\u2580\u25aa\u2584\u2590\u2588\u00b7 \u2590\u2588\u258c", "\u25aa\u2590\u2588\u00b7\u2588\u258c\u2588\u2588\u2584\u25aa\u2590\u2588\u2590\u2588\u258c\u2590\u258c\u2590\u2588\u258c.\u2590\u258c\u2590\u2588\u2588\u2588\u258c\u2590\u2588.\u2588\u258c\u2590\u2588\u2584\u2584\u258c\u2588\u2588. \u2588\u2588 \u258c", "\u2022\u2580\u2580 \u2580\u2580\u00b7\u2580\u2580\u2580\u2580 .\u2580\u2580\u2580  \u2580\u2588\u2584\u2580\u25aa\u00b7\u2580\u2580\u2580 \u00b7\u2580  \u2580 \u2580\u2580\u2580 \u2580\u2580\u2580\u2580\u2580\u2022 "};
    private boolean protocolLibAvailable = false;
    private VersionCheckListener listener;
    private I18nManager i18n;
    private UpdateChecker updateChecker;

    public void onEnable() {
        Plugin plib;
        this.saveDefaultConfig();
        this.i18n = new I18nManager(this);
        if (this.getConfig().getBoolean("bstats.enabled", true)) {
            int id = this.getConfig().getInt("bstats.plugin-id", 0);
            if (id > 0) {
                try {
                    Metrics metrics = new Metrics(this, id);
                    this.getLogger().info("[bStats] M\u00e9tricas habilitadas (id=" + id + ").");
                }
                catch (Throwable t) {
                    this.getLogger().warning("[bStats] No se pudo iniciar: " + t.getMessage());
                }
            } else {
                this.getLogger().warning("[bStats] plugin-id no configurado. M\u00e9tricas deshabilitadas.");
            }
        }
        boolean bl = this.protocolLibAvailable = (plib = this.getServer().getPluginManager().getPlugin("ProtocolLib")) != null && plib.isEnabled();
        if (this.protocolLibAvailable) {
            this.listener = new VersionCheckListener(this);
        } else {
            this.getLogger().warning("ProtocolLib no encontrado o inactivo: xBlocked funcionar\u00e1 en MODO DEGRADADO (solo comandos).");
        }
        GhostBlockerCommand command = new GhostBlockerCommand(this);
        PluginCommand pc = this.getCommand("xblocked");
        if (pc != null) {
            pc.setExecutor((CommandExecutor)command);
            pc.setTabCompleter((TabCompleter)command);
        } else {
            this.getLogger().warning("No se encontr\u00f3 el comando 'xblocked' en plugin.yml");
        }
        if (this.getConfig().getBoolean("updates.modrinth.enabled", true)) {
            this.updateChecker = new UpdateChecker(this);
            this.updateChecker.runCheckAsync();
            long hours = Math.max(1L, this.getConfig().getLong("updates.modrinth.check-interval-hours", 6L));
            long ticks = hours * 60L * 60L * 20L;
            this.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this, () -> {
                try {
                    this.updateChecker.runCheckAsync();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }, ticks, ticks);
            if (this.getConfig().getBoolean("updates.modrinth.notify.admins-on-join", true)) {
                this.getServer().getPluginManager().registerEvents((Listener)new AdminJoinNotifier(this.updateChecker), (Plugin)this);
            }
        }
        this.printBanner(true);
        this.getLogger().info("[xBlocked] Habilitado. ProtocolLib: " + (this.protocolLibAvailable ? "OK" : "NO (modo degradado)"));
    }

    public void onDisable() {
        this.printBanner(false);
        this.getLogger().info("[xBlocked] Deshabilitado.");
    }

    public void applyConfigReload() {
        this.reloadConfig();
        this.i18n = new I18nManager(this);
        if (this.listener != null) {
            this.listener.reloadFromConfig();
        }
        if (this.getConfig().getBoolean("updates.modrinth.enabled", true)) {
            if (this.updateChecker == null) {
                this.updateChecker = new UpdateChecker(this);
            }
            this.updateChecker.runCheckAsync();
        } else {
            this.updateChecker = null;
        }
    }

    public boolean isProtocolLibAvailable() {
        return this.protocolLibAvailable;
    }

    public I18nManager i18n() {
        return this.i18n;
    }

    private void printBanner(boolean enabling) {
        ConsoleCommandSender console = this.getServer().getConsoleSender();
        int maxLine = 0;
        for (String line : ASCII_BANNER) {
            if (line.length() <= maxLine) continue;
            maxLine = line.length();
        }
        int width = Math.max(100, maxLine);
        console.sendMessage("");
        for (String line : ASCII_BANNER) {
            console.sendMessage(this.center(line, width));
        }
        String state = enabling ? "iniciado" : "detenido";
        String info = String.valueOf(ChatColor.RED) + "xBlocked v" + this.getDescription().getVersion() + String.valueOf(ChatColor.RED) + " \u2014 Plugin " + state + String.valueOf(ChatColor.RED) + " \u00b7 Autor: Willfrydev" + String.valueOf(ChatColor.RED) + " \u00b7 Contributor: Leexito" + String.valueOf(ChatColor.RED) + " \u00b7 ProtocolLib: " + (this.protocolLibAvailable ? "presente" : "NO instalado (modo degradado)");
        console.sendMessage(this.center(info, width));
        console.sendMessage("");
    }

    private String center(String text, int width) {
        int len;
        String plain = ChatColor.stripColor((String)text);
        int n = len = plain != null ? plain.length() : text.length();
        if (len >= width) {
            return text;
        }
        int pad = (width - len) / 2;
        return " ".repeat(Math.max(0, pad)) + text;
    }
}

